/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.hints.RubyHints;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RailsDeprecations
extends RubyAstRule {
    private static final String ACTIVE_RECORD_BASE = "ActiveRecord::Base";
    private static final String ACTION_CONTROLLER_BASE = "ActionController::Base";
    private static final String APPLICATION_CONTROLLER = "ApplicationController";
    static Set<String> deprecatedFields = new HashSet<String>();
    static Map<String, String> deprecatedMethods = new HashMap<String, String>();

    public boolean appliesTo(RuleContext context) {
        ParserResult info = context.parserResult;
        return RubyHints.isInRailsProject(RubyUtils.getFileObject((Parser.Result)info));
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ROOTNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node root = context.node;
        ParserResult info = context.parserResult;
        AstPath path = context.path;
        if (root == null) {
            return;
        }
        assert (path.leaf() == root);
        this.scan(info, root, result);
    }

    public void cancel() {
    }

    public String getId() {
        return "Rails_Deprecations";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"RailsDeprecation");
    }

    public String getDescription() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"RailsDeprecationDesc");
    }

    private void scan(ParserResult info, Node node, List<Hint> result) {
        String message;
        String name;
        if (node.getNodeType() == NodeType.INSTVARNODE || node.getNodeType() == NodeType.INSTASGNNODE) {
            name = ((INameNode)node).getName();
            if (deprecatedFields.contains(name) && !RubyUtils.getFileObject((Parser.Result)info).getName().endsWith("_test") && RailsDeprecations.inActionController(info, node, this)) {
                message = NbBundle.getMessage(RailsDeprecations.class, (String)"DeprecatedRailsField", (Object)name, (Object)name.substring(1));
                RailsDeprecations.addFix(this, info, node, result, message);
            }
        } else if (AstUtilities.isCall((Node)node) && deprecatedMethods.containsKey(name = ((INameNode)node).getName())) {
            Node receiver;
            if ("render_template".equals(name) && RubyUtils.getFileObject((Parser.Result)info).getName().endsWith("_spec")) {
                return;
            }
            if (name.startsWith("find_") && node.getNodeType() == NodeType.CALLNODE && (receiver = ((CallNode)node).getReceiverNode()).getNodeType() != NodeType.CONSTNODE && receiver.getNodeType() != NodeType.COLON2NODE) {
                return;
            }
            message = NbBundle.getMessage(RailsDeprecations.class, (String)"DeprecatedRailsMethodUse", (Object)name, (Object)deprecatedMethods.get(name));
            RailsDeprecations.addFix(this, info, node, result, message);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.scan(info, child, result);
        }
    }

    static boolean inActionController(ParserResult info, Node node, RubyAstRule rule) {
        FileObject fo = RubyUtils.getFileObject((Parser.Result)info);
        if (!fo.getPath().contains("/app/controllers")) {
            return false;
        }
        return RailsDeprecations.isChildOf(info, node, rule, ACTION_CONTROLLER_BASE, APPLICATION_CONTROLLER);
    }

    static boolean inActiveRecordModel(ParserResult info, Node node, RubyAstRule rule) {
        FileObject fo = RubyUtils.getFileObject((Parser.Result)info);
        if (!fo.getPath().contains("/app/models")) {
            return false;
        }
        return RailsDeprecations.isChildOf(info, node, rule, ACTIVE_RECORD_BASE);
    }

    private static boolean isChildOf(ParserResult info, Node node, RubyAstRule rule, String ... superClassNames) {
        Node root = AstUtilities.getRoot((Parser.Result)info);
        if (root == null) {
            return false;
        }
        AstPath path = new AstPath(root, node);
        IScopingNode clazz = AstUtilities.findClassOrModule((AstPath)path);
        if (clazz == null) {
            return false;
        }
        if (clazz instanceof ClassNode) {
            String superClass = AstUtilities.getSuperclass((ClassNode)((ClassNode)clazz));
            if (superClass == null) {
                return false;
            }
            for (String each : superClassNames) {
                if (!each.equals(superClass)) continue;
                return true;
            }
        }
        String className = AstUtilities.getClassOrModuleName((IScopingNode)clazz);
        RubyIndex index = rule.getIndex(info);
        List superClasses = index.getSuperClasses(className);
        for (IndexedClass superClass : superClasses) {
            for (String each : superClassNames) {
                if (!each.equals(superClass.getName())) continue;
                return true;
            }
        }
        return false;
    }

    static void addFix(RubyAstRule rule, ParserResult info, Node node, List<Hint> result, String displayName) {
        OffsetRange range = AstUtilities.getNameRange((Node)node);
        if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) != OffsetRange.NONE) {
            Hint desc = new Hint((Rule)rule, displayName, RubyUtils.getFileObject((Parser.Result)info), range, Collections.emptyList(), 100);
            result.add(desc);
        }
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    static {
        deprecatedFields.add("@params");
        deprecatedFields.add("@session");
        deprecatedFields.add("@flash");
        deprecatedFields.add("@request");
        deprecatedFields.add("@cookies");
        deprecatedFields.add("@headers");
        deprecatedFields.add("@response");
        deprecatedMethods.put("find_first", "find :first");
        deprecatedMethods.put("find_all", "find :all");
        deprecatedMethods.put("push_with_attributes", "has_many :through");
        deprecatedMethods.put("redirect_to_path", "redirect_to");
        deprecatedMethods.put("redirect_to_url", "redirect_to");
        deprecatedMethods.put("start_form_tag", "form_tag with a block");
        deprecatedMethods.put("end_form_tag", "form_tag with a block");
        deprecatedMethods.put("update_element_function", "RJS");
        deprecatedMethods.put("link_to_image", "link_to(image_tag(..), url)");
        deprecatedMethods.put("link_image_to", "link_to(image_tag(..), url)");
        deprecatedMethods.put("human_size", "number_to_human_size");
        deprecatedMethods.put("post_format", "respond_to or request.format");
        deprecatedMethods.put("formatted_post?", "respond_to or request.format");
        deprecatedMethods.put("xml_post?", "respond_to or request.format");
        deprecatedMethods.put("yaml_post?", "respond_to or request.format");
        deprecatedMethods.put("render_text", "render :text => ...");
        deprecatedMethods.put("render_template", "render :template => ...");
    }
}

