/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.ruby.DiffElement;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.ruby.plugins.RubyRefactoringPlugin;
import org.netbeans.modules.refactoring.ruby.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RenameRefactoringPlugin
extends RubyRefactoringPlugin {
    private RubyElementCtx treePathHandle;
    private final Collection<IndexedMethod> overriddenByMethods = new ArrayList<IndexedMethod>();
    private final Collection<IndexedMethod> overridesMethods = new ArrayList<IndexedMethod>();
    private RenameRefactoring refactoring;
    private RubyBaseProject project;
    private Set<RubyElementCtx> allMethods;

    public RenameRefactoringPlugin(RenameRefactoring rename) {
        Project p;
        this.refactoring = rename;
        RubyElementCtx tph = (RubyElementCtx)rename.getRefactoringSource().lookup(RubyElementCtx.class);
        if (tph != null) {
            this.treePathHandle = tph;
        } else {
            Source source = Source.create((FileObject)((FileObject)rename.getRefactoringSource().lookup(FileObject.class)));
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator co) throws Exception {
                        RubyStructureAnalyzer.AnalysisResult ar;
                        List els;
                        RubyParseResult parserResult;
                        Node root;
                        if (co.getSnapshot().getMimeType().equals("text/x-ruby") && (root = (parserResult = AstUtilities.getParseResult((Parser.Result)co.getParserResult())).getRootNode()) != null && (els = (ar = parserResult.getStructure()).getElements()).size() > 0) {
                            AstElement element = (AstElement)els.get(0);
                            Node node = element.getNode();
                            RenameRefactoringPlugin.this.treePathHandle = new RubyElementCtx(root, node, (Element)element, RubyUtils.getFileObject((Parser.Result)parserResult), (ParserResult)parserResult);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)co);
                        }
                    }
                });
            }
            catch (ParseException e) {
                Logger.getLogger(RenameRefactoringPlugin.class.getName()).log(Level.WARNING, null, e);
            }
        }
        if (this.treePathHandle != null && (p = FileOwnerQuery.getOwner((FileObject)this.treePathHandle.getFileObject())) instanceof RubyBaseProject) {
            this.project = (RubyBaseProject)p;
        }
    }

    public Problem fastCheckParameters() {
        boolean nameNotChanged;
        Problem fastCheckProblem = null;
        ElementKind kind = this.treePathHandle.getKind();
        String newName = this.refactoring.getNewName();
        String oldName = this.treePathHandle.getSimpleName();
        if (oldName == null) {
            return new Problem(true, "Cannot determine target name. Please file a bug with detailed information on how to reproduce (preferably including the current source file and the cursor position)");
        }
        if (oldName.equals(newName) && (nameNotChanged = true)) {
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return fastCheckProblem;
        }
        if (kind == ElementKind.CLASS && !RubyUtils.isValidConstantFQN((String)newName)) {
            String s = RenameRefactoringPlugin.getString("ERR_InvalidClassName");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        if (kind == ElementKind.METHOD && !RubyUtils.isValidRubyMethodName((String)newName)) {
            String s = RenameRefactoringPlugin.getString("ERR_InvalidMethodName");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        if (!RubyUtils.isValidRubyIdentifier((String)newName)) {
            String s = RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        String msg = this.getWarningMsg(kind, newName);
        if (msg != null) {
            fastCheckProblem = RenameRefactoringPlugin.createProblem(fastCheckProblem, false, msg);
        }
        return fastCheckProblem;
    }

    private Set<String> asNames(Collection<? extends IndexedElement> elems) {
        HashSet<String> names = new HashSet<String>(elems.size());
        for (IndexedElement indexedElement : elems) {
            names.add(indexedElement.getName());
        }
        return names;
    }

    public Problem checkParameters() {
        Problem checkProblem = null;
        int steps = 0;
        if (AstUtilities.isCall((Node)this.treePathHandle.getNode()) || this.treePathHandle.getKind() == ElementKind.METHOD) {
            RubyIndex index = RubyIndex.get((Parser.Result)this.treePathHandle.getInfo());
            String className = this.treePathHandle.getDefClass();
            String methodName = AstUtilities.getName((Node)this.treePathHandle.getNode());
            Set methodsInSameTree = index.getAllOverridingMethodsInHierachy(methodName, className);
            this.overridesMethods.addAll(methodsInSameTree);
            if (this.overridesMethods.size() > 1) {
                Set<String> superClassNames = this.asNames(index.getSuperClasses(className));
                boolean overridesFromSources = false;
                boolean classesInOtherBranch = false;
                for (IndexedMethod method : this.overridesMethods) {
                    if (!this.isUnderSourceRoot(method.getFileObject())) {
                        checkProblem = RenameRefactoringPlugin.createProblem(checkProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_Overrides_Method", (Object)(method.getIn() + "#" + method.getName()), (Object)method.getFileObject().getPath()));
                    } else if (!method.getFileObject().equals(this.treePathHandle.getFileObject())) {
                        overridesFromSources = true;
                    }
                    if (classesInOtherBranch || className.equals(method.getIn()) || superClassNames.contains(method.getIn())) continue;
                    classesInOtherBranch = true;
                }
                if (overridesFromSources) {
                    checkProblem = RenameRefactoringPlugin.createProblem(checkProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_Overrides"));
                }
                if (classesInOtherBranch) {
                    checkProblem = RenameRefactoringPlugin.createProblem(checkProblem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_Overrides_tree"));
                }
            }
        }
        steps += this.overriddenByMethods.size();
        this.fireProgressListenerStart(2, 8 + 3 * (steps += this.overridesMethods.size()));
        this.fireProgressListenerStep();
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return checkProblem;
    }

    private boolean isUnderSourceRoot(FileObject fo) {
        if (this.project == null) {
            return false;
        }
        for (FileObject root : this.project.getSourceRootFiles()) {
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            return true;
        }
        for (FileObject root : this.project.getTestSourceRootFiles()) {
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public Problem preCheck() {
        if (this.treePathHandle == null || this.treePathHandle.getFileObject() == null || !this.treePathHandle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        if (this.treePathHandle.getKind() == ElementKind.VARIABLE || this.treePathHandle.getKind() == ElementKind.PARAMETER) {
            return Collections.singleton(this.treePathHandle.getFileObject());
        }
        return RetoucheUtils.getRubyFilesInProject(this.treePathHandle.getFileObject());
    }

    public Problem prepare(RefactoringElementsBag elements) {
        if (this.treePathHandle == null) {
            return null;
        }
        Problem problem = null;
        Set<FileObject> files = this.getRelevantFiles();
        this.fireProgressListenerStart(1, files.size());
        if (!files.isEmpty()) {
            RubyRefactoringPlugin.TransformTask transform = new RubyRefactoringPlugin.TransformTask(){

                @Override
                protected Collection<ModificationResult> process(ParserResult parserResult) {
                    RenameTransformer rt = new RenameTransformer(RenameRefactoringPlugin.this.refactoring.getNewName(), RenameRefactoringPlugin.this.allMethods);
                    rt.setWorkingCopy(parserResult);
                    rt.scan();
                    ModificationResult mr = new ModificationResult();
                    mr.addDifferences(parserResult.getSnapshot().getSource().getFileObject(), rt.diffs);
                    return Collections.singleton(mr);
                }
            };
            Collection<ModificationResult> results = this.processFiles(files, transform);
            elements.registerTransaction((Transaction)new RetoucheCommit(results));
            for (ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference diff : result.getDifferences(jfo)) {
                        String old = diff.getOldText();
                        if (old == null) continue;
                        elements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, jfo, result));
                    }
                }
            }
        }
        if (this.refactoring.getRefactoringSource().lookup(FileObject.class) != null) {
            String newName = RubyUtils.camelToUnderlinedName((String)this.refactoring.getNewName());
            this.refactoring.setNewName(newName);
        }
        this.fireProgressListenerStop();
        return problem;
    }

    private static final String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)key);
    }

    private String getWarningMsg(ElementKind kind, String newName) {
        String msg = null;
        if (ElementKind.CLASS == kind) {
            String each;
            String[] arr$ = newName.split("::");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (msg = RubyUtils.getIdentifierWarning((String)(each = arr$[i$]), (int)0)) == null; ++i$) {
            }
        } else {
            msg = RubyUtils.getIdentifierWarning((String)newName, (int)0);
        }
        return msg;
    }

    public class RenameTransformer
    extends SearchVisitor {
        private final Set<RubyElementCtx> allMethods;
        private final String newName;
        private final String oldName;
        private CloneableEditorSupport ces;
        private List<ModificationResult.Difference> diffs;

        @Override
        public void setWorkingCopy(ParserResult workingCopy) {
            this.ces = null;
            this.diffs = null;
            super.setWorkingCopy(workingCopy);
        }

        public RenameTransformer(String newName, Set<RubyElementCtx> am) {
            this.newName = newName;
            this.oldName = RenameRefactoringPlugin.this.treePathHandle.getSimpleName();
            this.allMethods = am;
        }

        @Override
        public void scan() {
            BaseDocument doc;
            this.diffs = new ArrayList<ModificationResult.Difference>();
            RubyElementCtx searchCtx = RenameRefactoringPlugin.this.treePathHandle;
            Error error = null;
            Node root = AstUtilities.getRoot((Parser.Result)this.workingCopy);
            FileObject workingCopyFileObject = RubyUtils.getFileObject((Parser.Result)this.workingCopy);
            if (root != null) {
                AstPath path;
                AstElement element = AstElement.create((ParserResult)this.workingCopy, (Node)root);
                Node node = searchCtx.getNode();
                RubyElementCtx fileCtx = new RubyElementCtx(root, node, (Element)element, workingCopyFileObject, this.workingCopy);
                Node method = null;
                if (node instanceof ArgumentNode) {
                    path = searchCtx.getPath();
                    assert (path.leaf() == node);
                    Node parent = path.leafParent();
                    if (!(parent instanceof MethodDefNode)) {
                        method = AstUtilities.findLocalScope((Node)node, (AstPath)path);
                    }
                } else if (node instanceof LocalVarNode || node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof DVarNode) {
                    path = searchCtx.getPath();
                    method = AstUtilities.findLocalScope((Node)node, (AstPath)path);
                }
                if (method != null) {
                    this.findLocal(searchCtx, fileCtx, method, this.oldName);
                } else {
                    path = new AstPath();
                    path.descend(root);
                    this.find(path, searchCtx, fileCtx, root, this.oldName, Character.isUpperCase(this.oldName.charAt(0)));
                    path.ascend();
                }
            } else {
                String workingCopyText = ((Object)this.workingCopy.getSnapshot().getText()).toString();
                if (workingCopyText.indexOf(this.oldName) != -1) {
                    if (this.ces == null) {
                        this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
                    }
                    int start = 0;
                    int end = 0;
                    String desc = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ParseErrorFile", (Object)this.oldName);
                    List errors = this.workingCopy.getDiagnostics();
                    if (errors.size() > 0) {
                        String errorMsg;
                        for (Error e : errors) {
                            if (e.getSeverity() != Severity.ERROR) continue;
                            error = e;
                            break;
                        }
                        if (error == null) {
                            error = (Error)errors.get(0);
                        }
                        if ((errorMsg = error.getDisplayName()).length() > 80) {
                            errorMsg = errorMsg.substring(0, 77) + "...";
                        }
                        desc = desc + "; " + errorMsg;
                        start = error.getStartPosition();
                        if ((start = LexUtilities.getLexerOffset((Parser.Result)this.workingCopy, (int)start)) == -1) {
                            start = 0;
                        }
                        end = start;
                    }
                    PositionRef startPos = this.ces.createPositionRef(start, Position.Bias.Forward);
                    PositionRef endPos = this.ces.createPositionRef(end, Position.Bias.Forward);
                    ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, "", "", desc);
                    this.diffs.add(diff);
                }
            }
            if (error == null && RenameRefactoringPlugin.this.refactoring.isSearchInComments() && (doc = RetoucheUtils.getDocument(this.workingCopy, RubyUtils.getFileObject((Parser.Result)this.workingCopy))) != null) {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(0);
                this.searchTokenSequence(ts);
            }
            this.ces = null;
        }

        private void searchTokenSequence(TokenSequence<?> ts) {
            if (ts.moveNext()) {
                do {
                    Token token;
                    TokenId id;
                    String primaryCategory;
                    if ("comment".equals(primaryCategory = (id = (token = ts.token()).id()).primaryCategory()) || "block-comment".equals(primaryCategory)) {
                        int index;
                        CharSequence tokenText = token.text();
                        if (tokenText == null || this.oldName == null || (index = TokenUtilities.indexOf((CharSequence)tokenText, (CharSequence)this.oldName)) == -1) continue;
                        String text = ((Object)tokenText).toString();
                        if (index != 0 && Character.isLetterOrDigit(text.charAt(index - 1)) || index + this.oldName.length() < text.length() && Character.isLetterOrDigit(text.charAt(index + this.oldName.length()))) continue;
                        int start = ts.offset() + index;
                        int end = start + this.oldName.length();
                        if (this.ces == null) {
                            this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
                        }
                        PositionRef startPos = this.ces.createPositionRef(start, Position.Bias.Forward);
                        PositionRef endPos = this.ces.createPositionRef(end, Position.Bias.Forward);
                        String desc = RenameRefactoringPlugin.getString("ChangeComment");
                        ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, this.oldName, this.newName, desc);
                        this.diffs.add(diff);
                        continue;
                    }
                    TokenSequence embedded = ts.embedded();
                    if (embedded == null) continue;
                    this.searchTokenSequence(embedded);
                } while (ts.moveNext());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rename(Node node, String oldCode, String newCode, String desc) {
            OffsetRange range = AstUtilities.getNameRange((Node)node);
            assert (range != OffsetRange.NONE);
            int pos = range.getStart();
            if (desc == null) {
                desc = node instanceof MethodDefNode ? RenameRefactoringPlugin.getString("UpdateMethodDef") : (AstUtilities.isCall((Node)node) ? RenameRefactoringPlugin.getString("UpdateCall") : (node instanceof SymbolNode ? RenameRefactoringPlugin.getString("UpdateSymbol") : (node instanceof ClassNode || node instanceof SClassNode ? RenameRefactoringPlugin.getString("UpdateClassDef") : (node instanceof ModuleNode ? RenameRefactoringPlugin.getString("UpdateModule") : (node instanceof LocalVarNode || node instanceof LocalAsgnNode || node instanceof DVarNode || node instanceof DAsgnNode ? RenameRefactoringPlugin.getString("UpdateLocalvar") : (node instanceof GlobalVarNode || node instanceof GlobalAsgnNode ? RenameRefactoringPlugin.getString("UpdateGlobal") : (node instanceof InstVarNode || node instanceof InstAsgnNode ? RenameRefactoringPlugin.getString("UpdateInstance") : (node instanceof ClassVarNode || node instanceof ClassVarDeclNode || node instanceof ClassVarAsgnNode ? RenameRefactoringPlugin.getString("UpdateClassvar") : NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"UpdateRef", (Object)oldCode)))))))));
            }
            if (this.ces == null) {
                this.ces = RetoucheUtils.findCloneableEditorSupport(this.workingCopy);
            }
            if ((pos = LexUtilities.getLexerOffset((Parser.Result)this.workingCopy, (int)pos)) == -1) {
                return;
            }
            int start = pos;
            int end = pos + oldCode.length();
            BaseDocument doc = null;
            try {
                doc = (BaseDocument)this.ces.openDocument();
                doc.readLock();
                if (start > doc.getLength()) {
                    start = end = doc.getLength();
                }
                if (end > doc.getLength()) {
                    end = doc.getLength();
                }
                if (!oldCode.equals(doc.getText(start, end - start))) {
                    int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)start);
                    int lineEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)start) + 1;
                    if (lineStart == -1 || lineEnd == -1) {
                        System.out.println("Empty line entry in " + FileUtil.getFileDisplayName((FileObject)RubyUtils.getFileObject((Parser.Result)this.workingCopy)) + "; no match for " + oldCode + " in line " + start + " referenced by node " + node + " of type " + node.getClass().getName());
                        return;
                    }
                    if (lineStart < 0 || lineEnd - lineStart < 0) {
                        return;
                    }
                    String line = doc.getText(lineStart, lineEnd - lineStart);
                    if (line.indexOf(oldCode) == -1) {
                        System.out.println("Skipping entry in " + FileUtil.getFileDisplayName((FileObject)RubyUtils.getFileObject((Parser.Result)this.workingCopy)) + "; no match for " + oldCode + " in line " + line + " referenced by node " + node + " of type " + node.getClass().getName());
                    } else {
                        int lineOffset = start - lineStart;
                        int newOffset = -1;
                        for (int distance = 1; distance < line.length(); ++distance) {
                            if (lineOffset + distance + oldCode.length() <= line.length() && oldCode.equals(line.substring(lineOffset + distance, lineOffset + distance + oldCode.length()))) {
                                newOffset = lineOffset + distance;
                                break;
                            }
                            if (lineOffset - distance < 0 || lineOffset - distance + oldCode.length() > line.length() || !oldCode.equals(line.substring(lineOffset - distance, lineOffset - distance + oldCode.length()))) continue;
                            newOffset = lineOffset - distance;
                            break;
                        }
                        if (newOffset != -1) {
                            start = newOffset + lineStart;
                            end = start + oldCode.length();
                        }
                    }
                }
            }
            catch (IOException ie) {
                Exceptions.printStackTrace((Throwable)ie);
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            finally {
                if (doc != null) {
                    doc.readUnlock();
                }
            }
            if (newCode == null) {
                newCode = RenameRefactoringPlugin.this.refactoring.getNewName();
            }
            PositionRef startPos = this.ces.createPositionRef(start, Position.Bias.Forward);
            PositionRef endPos = this.ces.createPositionRef(end, Position.Bias.Forward);
            ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, oldCode, newCode, desc);
            this.diffs.add(diff);
        }

        private void findLocal(RubyElementCtx searchCtx, RubyElementCtx fileCtx, Node node, String name) {
            switch (node.getNodeType()) {
                case ARGUMENTNODE: {
                    if (!((ArgumentNode)node).getName().equals(name)) break;
                    this.rename(node, name, null, RenameRefactoringPlugin.getString("RenameParam"));
                    break;
                }
                case LOCALVARNODE: 
                case LOCALASGNNODE: {
                    if (!((INameNode)node).getName().equals(name)) break;
                    this.rename(node, name, null, RenameRefactoringPlugin.getString("UpdateLocalvar"));
                    break;
                }
                case DVARNODE: 
                case DASGNNODE: {
                    if (!((INameNode)node).getName().equals(name)) break;
                    this.rename(node, name, null, RenameRefactoringPlugin.getString("UpdateDynvar"));
                    break;
                }
                case SYMBOLNODE: {
                    if (!((SymbolNode)node).getName().equals(name)) break;
                    this.rename(node, name, null, RenameRefactoringPlugin.getString("UpdateSymbol"));
                }
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible()) continue;
                this.findLocal(searchCtx, fileCtx, child, name);
            }
        }

        private void find(AstPath path, RubyElementCtx searchCtx, RubyElementCtx fileCtx, Node node, String name, boolean upperCase) {
            block20: {
                block19: {
                    if (upperCase) break block19;
                    switch (node.getNodeType()) {
                        case DEFNNODE: 
                        case DEFSNODE: {
                            if (!((MethodDefNode)node).getName().equals(name)) break;
                            boolean skip = false;
                            String fqn = AstUtilities.getFqnName((AstPath)path);
                            if (fqn == null || fqn.length() == 0) {
                                fqn = "Object";
                            }
                            if (!fqn.equals(searchCtx.getDefClass())) {
                                boolean inherited = false;
                                for (IndexedMethod method : RenameRefactoringPlugin.this.overridesMethods) {
                                    if (!method.getIn().equals(fqn)) continue;
                                    inherited = true;
                                    break;
                                }
                                boolean bl = skip = !inherited;
                            }
                            if (!skip && AstUtilities.isCall((Node)searchCtx.getNode()) && !AstUtilities.isCallFor((Node)searchCtx.getNode(), (Arity)searchCtx.getArity(), (Node)node)) {
                                skip = true;
                            }
                            if (!skip) {
                                node = AstUtilities.getDefNameNode((MethodDefNode)((MethodDefNode)node));
                                this.rename(node, name, null, RenameRefactoringPlugin.getString("UpdateMethodDef"));
                                break;
                            }
                            break block20;
                        }
                        case FCALLNODE: {
                            if (AstUtilities.isAttr((Node)node)) {
                                SymbolNode[] symbols;
                                for (SymbolNode symbol : symbols = AstUtilities.getAttrSymbols((Node)node)) {
                                    if (!symbol.getName().equals(name)) continue;
                                    this.rename(node, name, null, null);
                                }
                            }
                        }
                        case VCALLNODE: 
                        case CALLNODE: {
                            if (!((INameNode)node).getName().equals(name)) break;
                            this.rename(node, name, null, null);
                            break;
                        }
                        case SYMBOLNODE: {
                            if (!((SymbolNode)node).getName().equals(name)) break;
                            this.rename(node, name, null, null);
                            break;
                        }
                        case GLOBALVARNODE: 
                        case GLOBALASGNNODE: 
                        case INSTVARNODE: 
                        case INSTASGNNODE: 
                        case CLASSVARNODE: 
                        case CLASSVARASGNNODE: 
                        case CLASSVARDECLNODE: {
                            if (!((INameNode)node).getName().equals(name)) break;
                            this.rename(node, name, null, null);
                        }
                    }
                    break block20;
                }
                switch (node.getNodeType()) {
                    case COLON2NODE: {
                        Colon2Node c2n = (Colon2Node)node;
                        if (!c2n.getName().equals(name)) break;
                        this.rename(node, name, null, null);
                        break;
                    }
                    case CONSTNODE: 
                    case CONSTDECLNODE: {
                        if (!((INameNode)node).getName().equals(name)) break;
                        this.rename(node, name, null, null);
                    }
                }
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible()) continue;
                path.descend(child);
                this.find(path, searchCtx, fileCtx, child, name, upperCase);
                path.ascend();
            }
        }
    }
}

