/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;

public abstract class ElementTransformation<S extends PhpElement> {
    public abstract S transform(PhpElement var1);

    public final <T extends PhpElement> Set<S> transform(Set<T> original) {
        HashSet<S> retval = new HashSet<S>();
        for (PhpElement baseElement : original) {
            S transformed = this.transform(baseElement);
            if (transformed == null) continue;
            retval.add(transformed);
        }
        return Collections.unmodifiableSet(retval);
    }

    public static ElementTransformation<TypeElement> toMemberTypes() {
        return new ElementTransformation<TypeElement>(){

            @Override
            public TypeElement transform(PhpElement element) {
                if (element instanceof TypeMemberElement) {
                    TypeMemberElement typeMemberElement = (TypeMemberElement)element;
                    return typeMemberElement.getType();
                }
                return null;
            }
        };
    }
}

