/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.Properties;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.palette.PaletteItemDataLoader;
import org.netbeans.modules.vmd.palette.PaletteItemDataNode;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class PaletteItemDataObject
extends MultiDataObject
implements FileChangeListener {
    private String producerID;
    private String displayName;
    private String toolTip;
    private String icon;
    private String bigIcon;

    public PaletteItemDataObject(FileObject fileObject, PaletteItemDataLoader loader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)loader);
        FileChangeListener fileChangeListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fileObject);
        fileObject.addFileChangeListener(fileChangeListener);
        this.readProperties(fileObject);
    }

    protected Node createNodeDelegate() {
        return new PaletteItemDataNode(this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readProperties(FileObject pf) throws IOException {
        Properties props;
        block7: {
            props = new Properties();
            InputStream is = null;
            try {
                is = pf.getInputStream();
                props.load(is);
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Debug.warning((Object[])new Object[]{e.toString()});
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                Debug.warning((Object[])new Object[]{e.toString()});
            }
        }
        this.producerID = props.getProperty("producerID");
        this.displayName = props.getProperty("displayName");
        this.toolTip = props.getProperty("toolTip");
        this.icon = props.getProperty("icon");
        if (this.icon != null && this.icon.length() == 0) {
            this.icon = null;
        }
        this.bigIcon = props.getProperty("bigIcon");
        if (this.bigIcon == null) return;
        if (this.bigIcon.length() != 0) return;
        this.bigIcon = null;
    }

    String getProducerID() {
        return this.producerID;
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getToolTip() {
        return this.toolTip;
    }

    String getIcon() {
        return this.icon;
    }

    String getBigIcon() {
        return this.bigIcon;
    }

    String getProjectType() {
        String path = this.getPrimaryFile().getPath();
        return path.substring(0, path.indexOf(47));
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        try {
            this.readProperties(fe.getFile());
        }
        catch (IOException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }
}

