/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLCommandDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class WLDatasourceManager
implements DatasourceManager {
    private static final Logger LOGGER = Logger.getLogger(WLDatasourceManager.class.getName());
    private final WLDeploymentManager manager;

    public WLDatasourceManager(WLDeploymentManager wLDeploymentManager) {
        this.manager = wLDeploymentManager;
    }

    public void deployDatasources(Set<Datasource> set) throws ConfigurationException, DatasourceAlreadyExistsException {
        Object object;
        Datasource datasource2;
        Set<Datasource> set2 = this.getDatasources();
        Map<String, Datasource> map = this.createMap(set2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LinkedList<Datasource> linkedList = new LinkedList<Datasource>();
        for (Datasource datasource2 : set) {
            if (!(datasource2 instanceof WLDatasource)) {
                LOGGER.log(Level.INFO, "Unable to deploy {0}", datasource2);
                continue;
            }
            object = (WLDatasource)datasource2;
            String string = ((WLDatasource)object).getJndiName();
            if (map.keySet().contains(string)) {
                Datasource datasource3 = map.get(string);
                if (map.get(string).equals(object)) continue;
                if (!((WLDatasource)datasource3).isSystem() && !((WLDatasource)object).isSystem()) {
                    hashMap.put(string, object);
                    continue;
                }
                linkedList.add(map.get(string));
                continue;
            }
            if (string != null) {
                hashMap.put(string, object);
                continue;
            }
            LOGGER.log(Level.INFO, "JNDI name was null for {0}", datasource2);
        }
        if (!linkedList.isEmpty()) {
            throw new DatasourceAlreadyExistsException(linkedList);
        }
        WLCommandDeployer wLCommandDeployer = new WLCommandDeployer(WLDeploymentFactory.getInstance(), this.manager.getInstanceProperties());
        datasource2 = wLCommandDeployer.deployDatasource(hashMap.values());
        this.waitFor((ProgressObject)datasource2);
        if (datasource2.getDeploymentStatus().isFailed()) {
            object = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_FailedToDeployDatasource");
            throw new ConfigurationException((String)object);
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        String string = this.manager.getInstanceProperties().getProperty("domainRoot");
        File file = FileUtil.normalizeFile((File)new File(string));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileObject fileObject2 = null;
        if (fileObject != null) {
            fileObject2 = fileObject.getFileObject("config/config.xml");
        }
        return new HashSet<Datasource>(WLDatasourceSupport.getDatasources(file, fileObject2, true));
    }

    private Map<String, Datasource> createMap(Set<Datasource> set) {
        if (set.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Datasource> hashMap = new HashMap<String, Datasource>();
        for (Datasource datasource : set) {
            hashMap.put(datasource.getJndiName(), datasource);
        }
        return hashMap;
    }

    private void waitFor(ProgressObject progressObject) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        progressObject.addProgressListener(new ProgressListener(){

            public void handleProgressEvent(ProgressEvent progressEvent) {
                if (progressEvent.getDeploymentStatus().isCompleted() || progressEvent.getDeploymentStatus().isFailed()) {
                    countDownLatch.countDown();
                }
            }
        });
        try {
            countDownLatch.await(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

