/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcDataSource;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcDataSourceParamsType;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcDriverParamsType;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcPropertiesType;
import org.netbeans.modules.j2ee.weblogic9.config.gen.JdbcPropertyType;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WLDatasourceSupport {
    private static final String JDBC_FILE = "-jdbc.xml";
    private static final String NAME_PATTERN = "datasource-";
    private static final FileFilter JDBC_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().endsWith(WLDatasourceSupport.JDBC_FILE);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(WLDatasourceSupport.class.getName());
    private File resourceDir;

    public WLDatasourceSupport(File file) {
        assert (file != null) : "Resource directory can't be null";
        this.resourceDir = FileUtil.normalizeFile((File)file);
    }

    static Set<WLDatasource> getDatasources(File file, FileObject fileObject, boolean bl) throws ConfigurationException {
        if (fileObject == null || !fileObject.isValid() || !fileObject.canRead()) {
            if (LOGGER.isLoggable(Level.INFO) && fileObject != null) {
                LOGGER.log(Level.INFO, NbBundle.getMessage(WLDatasourceManager.class, (String)"ERR_WRONG_CONFIG_DIR", (Object)fileObject));
            }
            return Collections.emptySet();
        }
        if (fileObject.isData() && fileObject.hasExt("xml")) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                JdbcHandler jdbcHandler = new JdbcHandler(file);
                sAXParser.parse((InputStream)new BufferedInputStream(fileObject.getInputStream()), (DefaultHandler)jdbcHandler);
                HashMap<File, Boolean> hashMap = new HashMap<File, Boolean>();
                HashSet<String> hashSet = new HashSet<String>();
                for (JdbcResource object2 : jdbcHandler.getResources()) {
                    if (object2.getFile() != null) {
                        File file2 = object2.resolveFile();
                        if (file2 == null) continue;
                        hashMap.put(file2, object2.isSystem());
                        continue;
                    }
                    if (object2.getName() == null || !object2.isSystem()) continue;
                    hashSet.add(object2.getName());
                }
                HashSet hashSet2 = new HashSet();
                hashSet2.addAll(WLDatasourceSupport.getDatasources(hashMap));
                if (!hashSet.isEmpty()) {
                    Set<WLDatasource> set = WLDatasourceSupport.getDatasources(file, fileObject.getParent().getFileObject("jdbc"), true);
                    for (WLDatasource wLDatasource : set) {
                        if (!hashSet.contains(wLDatasource.getName())) continue;
                        hashSet2.add(wLDatasource);
                    }
                }
                return hashSet2;
            }
            catch (IOException iOException) {
                return Collections.emptySet();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return Collections.emptySet();
            }
            catch (SAXException sAXException) {
                return Collections.emptySet();
            }
        }
        if (fileObject.isFolder()) {
            File file2 = FileUtil.toFile((FileObject)fileObject);
            HashMap<File, Boolean> hashMap = new HashMap<File, Boolean>();
            for (File file3 : file2.listFiles(JDBC_FILE_FILTER)) {
                hashMap.put(file3, bl);
            }
            if (hashMap.isEmpty()) {
                return Collections.emptySet();
            }
            return WLDatasourceSupport.getDatasources(hashMap);
        }
        return Collections.emptySet();
    }

    private static Set<WLDatasource> getDatasources(Map<File, Boolean> map) throws ConfigurationException {
        HashSet<WLDatasource> hashSet = new HashSet<WLDatasource>();
        for (Map.Entry<File, Boolean> entry : map.entrySet()) {
            String[] stringArray;
            File file = entry.getKey();
            try {
                String string;
                JdbcDataSource jdbcDataSource = null;
                try {
                    jdbcDataSource = JdbcDataSource.createGraph(file);
                }
                catch (RuntimeException runtimeException) {
                    string = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)file.getAbsolutePath());
                    LOGGER.log(Level.INFO, string);
                    continue;
                }
                stringArray = WLDatasourceSupport.getJndiNames(jdbcDataSource);
                if (stringArray == null) continue;
                string = WLDatasourceSupport.getName(jdbcDataSource);
                String string2 = WLDatasourceSupport.getConnectionUrl(jdbcDataSource);
                String string3 = WLDatasourceSupport.getUserName(jdbcDataSource);
                String string4 = WLDatasourceSupport.getDriverClass(jdbcDataSource);
                String string5 = WLDatasourceSupport.getPassword(jdbcDataSource);
                for (String string6 : stringArray) {
                    hashSet.add(new WLDatasource(string, string2, string6, string3, string5, string4, file, entry.getValue()));
                }
            }
            catch (IOException iOException) {
                stringArray = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_CannotReadDatasources", (Object)file.getAbsolutePath());
                LOGGER.log(Level.FINE, null, iOException);
                throw new ConfigurationException((String)stringArray, (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                stringArray = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)file.getAbsolutePath());
                LOGGER.log(Level.FINE, null, runtimeException);
                throw new ConfigurationException((String)stringArray, (Throwable)runtimeException);
            }
        }
        return hashSet;
    }

    public Set<WLDatasource> getDatasources() throws ConfigurationException {
        FileObject fileObject = FileUtil.toFileObject((File)this.resourceDir);
        return WLDatasourceSupport.getDatasources(null, fileObject, false);
    }

    public Datasource createDatasource(final String string, final String string2, final String string3, final String string4, final String string5) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException {
        WLDatasource wLDatasource = this.modifyDatasource(new DatasourceModifier(){

            @Override
            public ModifiedDatasource modify(Set<JdbcDataSource> set) throws DatasourceAlreadyExistsException {
                File file;
                Object object;
                for (JdbcDataSource jdbcDataSource : set) {
                    object = WLDatasourceSupport.getJndiNames(jdbcDataSource);
                    if (object == null) continue;
                    for (String string6 : object) {
                        if (!string6.equals(string)) continue;
                        WLDatasource wLDatasource = new WLDatasource(WLDatasourceSupport.getName(jdbcDataSource), WLDatasourceSupport.getConnectionUrl(jdbcDataSource), string6, WLDatasourceSupport.getUserName(jdbcDataSource), WLDatasourceSupport.getPassword(jdbcDataSource), WLDatasourceSupport.getDriverClass(jdbcDataSource), null, false);
                        throw new DatasourceAlreadyExistsException((Datasource)wLDatasource);
                    }
                }
                WLDatasourceSupport.this.ensureResourceDirExists();
                int n = 1;
                do {
                    file = new File(WLDatasourceSupport.this.resourceDir, WLDatasourceSupport.NAME_PATTERN + n + WLDatasourceSupport.JDBC_FILE);
                    ++n;
                } while (file.exists());
                object = new JdbcDataSource();
                WLDatasourceSupport.setName((JdbcDataSource)((Object)object), string);
                WLDatasourceSupport.setConnectionUrl((JdbcDataSource)((Object)object), string2);
                WLDatasourceSupport.addJndiName((JdbcDataSource)((Object)object), string);
                WLDatasourceSupport.setUserName((JdbcDataSource)((Object)object), string3);
                WLDatasourceSupport.setPassword((JdbcDataSource)((Object)object), string4);
                WLDatasourceSupport.setDriverClass((JdbcDataSource)((Object)object), string5);
                try {
                    WLDatasourceSupport.this.writeFile(file, (BaseBean)object);
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
                return new ModifiedDatasource(file, (JdbcDataSource)((Object)object));
            }
        });
        return wLDatasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WLDatasource modifyDatasource(DatasourceModifier datasourceModifier) throws ConfigurationException, DatasourceAlreadyExistsException {
        try {
            String[] stringArray;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object52;
            this.ensureResourceDirExists();
            FileObject fileObject = FileUtil.toFileObject((File)this.resourceDir);
            assert (fileObject != null);
            LinkedHashMap<JdbcDataSource, DataObject> linkedHashMap = new LinkedHashMap<JdbcDataSource, DataObject>();
            for (Object object52 : fileObject.getChildren()) {
                if (!object52.isData() || !object52.getNameExt().endsWith(JDBC_FILE)) continue;
                object4 = DataObject.find((FileObject)object52);
                object3 = (EditorCookie)object4.getCookie(EditorCookie.class);
                object2 = object3.getDocument();
                if (object2 == null) {
                    object2 = object3.openDocument();
                }
                object = null;
                try {
                    byte[] byArray = object2.getText(0, object2.getLength()).getBytes();
                    object = JdbcDataSource.createGraph(new ByteArrayInputStream(byArray));
                }
                catch (RuntimeException runtimeException) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(object52.getInputStream());
                    try {
                        object = JdbcDataSource.createGraph(bufferedInputStream);
                    }
                    finally {
                        ((InputStream)bufferedInputStream).close();
                    }
                    if (object == null) {
                        throw new ConfigurationException(NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_datasourcesXmlCannotParse", (Object)object52.getNameExt()));
                    }
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_datasourcesXmlNotValid", (Object)object52.getNameExt()), 0);
                    Object object6 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object6 == NotifyDescriptor.NO_OPTION) {
                        return null;
                    }
                    linkedHashMap.put((JdbcDataSource)((Object)object), (DataObject)object4);
                }
            }
            ModifiedDatasource modifiedDatasource = datasourceModifier.modify(linkedHashMap.keySet());
            DataObject dataObject = (DataObject)linkedHashMap.get((Object)modifiedDatasource.getDatasource());
            if (dataObject != null) {
                int n = dataObject.isModified() ? 1 : 0;
                object52 = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                object4 = object52.getDocument();
                if (object4 == null) {
                    object4 = object52.openDocument();
                }
                this.replaceDocument((StyledDocument)object4, modifiedDatasource.getDatasource());
                if (n == 0) {
                    object3 = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    object3.save();
                }
            }
            if ((stringArray = WLDatasourceSupport.getJndiNames(modifiedDatasource.getDatasource())) != null && stringArray.length > 0) {
                object52 = WLDatasourceSupport.getName(modifiedDatasource.getDatasource());
                object4 = WLDatasourceSupport.getConnectionUrl(modifiedDatasource.getDatasource());
                object3 = WLDatasourceSupport.getUserName(modifiedDatasource.getDatasource());
                object2 = WLDatasourceSupport.getDriverClass(modifiedDatasource.getDatasource());
                object = WLDatasourceSupport.getPassword(modifiedDatasource.getDatasource());
                return new WLDatasource((String)object52, (String)object4, stringArray[0], (String)object3, (String)object, (String)object2, modifiedDatasource.getFile(), false);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_CannotUpdateFile");
            throw new ConfigurationException(string, (Throwable)iOException);
        }
        return null;
    }

    private void writeFile(final File file, final BaseBean baseBean) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(NbBundle.getMessage(WLDatasourceSupport.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            final FileObject fileObject2 = fileObject;
            FileSystem fileSystem = fileObject2.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        String string = file.getName();
                        FileObject fileObject = fileObject2.getFileObject(string);
                        if (fileObject == null) {
                            fileObject = fileObject2.createData(string);
                        }
                        fileLock = fileObject.lock();
                        outputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock), 4086);
                        if (baseBean != null) {
                            baseBean.write(outputStream);
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.FINE, null, iOException);
                            }
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
            FileUtil.refreshFor((File[])new File[]{file});
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getLocalizedMessage());
        }
    }

    private void replaceDocument(final StyledDocument styledDocument, BaseBean baseBean) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            baseBean.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                    styledDocument.insertString(0, byteArrayOutputStream.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }

    private void ensureResourceDirExists() {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
            FileUtil.refreshFor((File[])new File[]{this.resourceDir});
        }
    }

    private static String getName(JdbcDataSource jdbcDataSource) {
        return jdbcDataSource.getName();
    }

    private static void setName(JdbcDataSource jdbcDataSource, String string) {
        jdbcDataSource.setName(string);
    }

    private static String[] getJndiNames(JdbcDataSource jdbcDataSource) {
        JdbcDataSourceParamsType jdbcDataSourceParamsType = jdbcDataSource.getJdbcDataSourceParams();
        if (jdbcDataSourceParamsType != null) {
            return jdbcDataSourceParamsType.getJndiName();
        }
        return null;
    }

    private static void addJndiName(JdbcDataSource jdbcDataSource, String string) {
        String[] stringArray;
        JdbcDataSourceParamsType jdbcDataSourceParamsType = jdbcDataSource.getJdbcDataSourceParams();
        if (jdbcDataSourceParamsType == null) {
            jdbcDataSourceParamsType = new JdbcDataSourceParamsType();
            jdbcDataSource.setJdbcDataSourceParams(jdbcDataSourceParamsType);
        }
        if ((stringArray = jdbcDataSourceParamsType.getJndiName()) != null) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray2.length - 1] = string;
            jdbcDataSourceParamsType.setJndiName(stringArray2);
        } else {
            jdbcDataSourceParamsType.setJndiName(new String[]{string});
        }
    }

    private static String getConnectionUrl(JdbcDataSource jdbcDataSource) {
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType != null) {
            return jdbcDriverParamsType.getUrl();
        }
        return null;
    }

    private static void setConnectionUrl(JdbcDataSource jdbcDataSource, String string) {
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType == null) {
            jdbcDriverParamsType = new JdbcDriverParamsType();
            jdbcDataSource.setJdbcDriverParams(jdbcDriverParamsType);
        }
        jdbcDriverParamsType.setUrl(string);
    }

    private static String getDriverClass(JdbcDataSource jdbcDataSource) {
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType != null) {
            return jdbcDriverParamsType.getDriverName();
        }
        return null;
    }

    private static void setDriverClass(JdbcDataSource jdbcDataSource, String string) {
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType == null) {
            jdbcDriverParamsType = new JdbcDriverParamsType();
            jdbcDataSource.setJdbcDriverParams(jdbcDriverParamsType);
        }
        jdbcDriverParamsType.setDriverName(string);
    }

    private static String getUserName(JdbcDataSource jdbcDataSource) {
        JdbcPropertiesType jdbcPropertiesType;
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType != null && (jdbcPropertiesType = jdbcDriverParamsType.getProperties()) != null) {
            for (JdbcPropertyType jdbcPropertyType : jdbcPropertiesType.getProperty2()) {
                if (!"user".equals(jdbcPropertyType.getName())) continue;
                return jdbcPropertyType.getValue();
            }
        }
        return null;
    }

    private static void setUserName(JdbcDataSource jdbcDataSource, String string) {
        WLDatasourceSupport.setProperty(jdbcDataSource, "user", string);
    }

    private static String getPassword(JdbcDataSource jdbcDataSource) {
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType != null) {
            String string = jdbcDriverParamsType.getPasswordEncrypted();
            if (string != null) {
                return "";
            }
            JdbcPropertiesType jdbcPropertiesType = jdbcDriverParamsType.getProperties();
            if (jdbcPropertiesType != null) {
                for (JdbcPropertyType jdbcPropertyType : jdbcPropertiesType.getProperty2()) {
                    if (!"password".equals(jdbcPropertyType.getName())) continue;
                    return jdbcPropertyType.getValue();
                }
            }
        }
        return null;
    }

    private static void setPassword(JdbcDataSource jdbcDataSource, String string) {
        WLDatasourceSupport.setProperty(jdbcDataSource, "password", string);
    }

    private static void setProperty(JdbcDataSource jdbcDataSource, String string, String string2) {
        JdbcPropertiesType jdbcPropertiesType;
        JdbcDriverParamsType jdbcDriverParamsType = jdbcDataSource.getJdbcDriverParams();
        if (jdbcDriverParamsType == null) {
            jdbcDriverParamsType = new JdbcDriverParamsType();
            jdbcDataSource.setJdbcDriverParams(jdbcDriverParamsType);
        }
        if ((jdbcPropertiesType = jdbcDriverParamsType.getProperties()) == null) {
            jdbcPropertiesType = new JdbcPropertiesType();
            jdbcDriverParamsType.setProperties(jdbcPropertiesType);
        }
        for (JdbcPropertyType jdbcPropertyType : jdbcPropertiesType.getProperty2()) {
            if (!string.equals(jdbcPropertyType.getName())) continue;
            jdbcPropertyType.setValue(string2);
            return;
        }
        JdbcPropertyType jdbcPropertyType = new JdbcPropertyType();
        jdbcPropertyType.setName(string);
        jdbcPropertyType.setValue(string2);
        jdbcPropertiesType.addProperty2(jdbcPropertyType);
    }

    private static class JdbcResource {
        private final File baseFile;
        private final boolean system;
        private String name;
        private String target;
        private String file;

        public JdbcResource(File file, boolean bl) {
            this.baseFile = file;
            this.system = bl;
        }

        @CheckForNull
        public File resolveFile() {
            if (this.file == null) {
                return null;
            }
            File file = new File(this.file);
            if (!file.isAbsolute()) {
                if (this.baseFile != null) {
                    file = new File(this.baseFile, this.file);
                } else {
                    return null;
                }
            }
            if (file.exists() && file.isFile() && file.canRead()) {
                return file;
            }
            return null;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String string) {
            this.file = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String string) {
            this.target = string;
        }

        public boolean isSystem() {
            return this.system;
        }
    }

    private static class JdbcHandler
    extends DefaultHandler {
        private final JdbcSystemResourceHandler system;
        private final JdbcApplicationHandler application;

        public JdbcHandler(File file) {
            File file2 = file != null ? new File(file, "config") : null;
            this.system = new JdbcSystemResourceHandler(file2);
            this.application = new JdbcApplicationHandler(file);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.system.startElement(string, string2, string3, attributes);
            this.application.startElement(string, string2, string3, attributes);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.system.endElement(string, string2, string3);
            this.application.endElement(string, string2, string3);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.system.characters(cArray, n, n2);
            this.application.characters(cArray, n, n2);
        }

        public List<JdbcResource> getResources() {
            ArrayList<JdbcResource> arrayList = new ArrayList<JdbcResource>();
            arrayList.addAll(this.system.getResources());
            arrayList.addAll(this.application.getResources());
            return arrayList;
        }
    }

    private static class JdbcApplicationHandler
    extends DefaultHandler {
        private final List<JdbcResource> resources = new ArrayList<JdbcResource>();
        private final File domainDir;
        private JdbcResource resource;
        private String value;
        private boolean isJdbc;

        public JdbcApplicationHandler(File file) {
            this.domainDir = file;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.value = null;
            if ("app-deployment".equals(string3)) {
                this.resource = new JdbcResource(this.domainDir, false);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (this.resource == null) {
                return;
            }
            if ("app-deployment".equals(string3)) {
                if (this.isJdbc) {
                    this.resources.add(this.resource);
                }
                this.isJdbc = false;
                this.resource = null;
            } else if ("name".equals(string3)) {
                this.resource.setName(this.value);
            } else if ("taget".equals(string3)) {
                this.resource.setTarget(this.value);
            } else if ("source-path".equals(string3)) {
                this.resource.setFile(this.value);
            } else if ("module-type".equals(string3) && "jdbc".equals(this.value)) {
                this.isJdbc = true;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.value = new String(cArray, n, n2);
        }

        public List<JdbcResource> getResources() {
            return this.resources;
        }
    }

    private static class JdbcSystemResourceHandler
    extends DefaultHandler {
        private final List<JdbcResource> resources = new ArrayList<JdbcResource>();
        private final File configDir;
        private JdbcResource resource;
        private String value;

        public JdbcSystemResourceHandler(File file) {
            this.configDir = file;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.value = null;
            if ("jdbc-system-resource".equals(string3)) {
                this.resource = new JdbcResource(this.configDir, true);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (this.resource == null) {
                return;
            }
            if ("jdbc-system-resource".equals(string3)) {
                this.resources.add(this.resource);
                this.resource = null;
            } else if ("name".equals(string3)) {
                this.resource.setName(this.value);
            } else if ("taget".equals(string3)) {
                this.resource.setTarget(this.value);
            } else if ("descriptor-file-name".equals(string3)) {
                this.resource.setFile(this.value);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.value = new String(cArray, n, n2);
        }

        public List<JdbcResource> getResources() {
            return this.resources;
        }
    }

    private static class ModifiedDatasource {
        private final File file;
        private final JdbcDataSource datasource;

        public ModifiedDatasource(File file, JdbcDataSource jdbcDataSource) {
            this.file = file;
            this.datasource = jdbcDataSource;
        }

        public JdbcDataSource getDatasource() {
            return this.datasource;
        }

        public File getFile() {
            return this.file;
        }
    }

    private static interface DatasourceModifier {
        @NonNull
        public ModifiedDatasource modify(Set<JdbcDataSource> var1) throws DatasourceAlreadyExistsException;
    }
}

