/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.awt.event.ActionEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class GoToSourceAction
extends AbstractAction {
    private final FunctionCall functionCall;
    private final Future<SourceFileInfoProvider.SourceFileInfo> sourceFileInfoTask;
    private boolean isEnabled = false;
    private boolean gotTheInfo = false;
    private final GoToSourceActionReadnessListener listener;

    GoToSourceAction(final SourceFileInfoDataProvider dataProvider, FunctionCall funcCall, GoToSourceActionReadnessListener listener) {
        super(NbBundle.getMessage(GoToSourceAction.class, (String)"GoToSourceActionName"));
        this.functionCall = funcCall;
        this.listener = listener;
        this.sourceFileInfoTask = DLightExecutorService.submit((Callable)new Callable<SourceFileInfoProvider.SourceFileInfo>(){

            @Override
            public SourceFileInfoProvider.SourceFileInfo call() {
                if (dataProvider == null) {
                    return null;
                }
                return dataProvider.getSourceFileInfo(GoToSourceAction.this.functionCall);
            }
        }, (String)"SourceFileInfo getting info from Call Stack UI");
        this.waitForSourceFileInfo();
    }

    private void waitForSourceFileInfo() {
        DLightExecutorService.submit((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object sourceFileInfo = (SourceFileInfoProvider.SourceFileInfo)GoToSourceAction.this.sourceFileInfoTask.get();
                    GoToSourceAction.this.isEnabled = sourceFileInfo != null && sourceFileInfo.isSourceKnown();
                }
                catch (InterruptedException ex) {
                    GoToSourceAction.this.isEnabled = false;
                }
                catch (ExecutionException ex) {
                    GoToSourceAction.this.isEnabled = false;
                }
                finally {
                    GoToSourceAction ex = GoToSourceAction.this;
                    synchronized (ex) {
                        GoToSourceAction.this.gotTheInfo = true;
                    }
                    GoToSourceAction.this.setEnabled(GoToSourceAction.this.isEnabled);
                    GoToSourceAction.this.listener.ready();
                }
            }
        }, (String)"Wait For the SourceFileInfo in Call Stack UI");
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                SourceFileInfoProvider.SourceFileInfo sourceFileInfo = null;
                try {
                    sourceFileInfo = (SourceFileInfoProvider.SourceFileInfo)GoToSourceAction.this.sourceFileInfoTask.get();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (sourceFileInfo == null) {
                    return;
                }
                SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);
                sourceSupportProvider.showSource(sourceFileInfo);
            }
        }, (String)"GoToSource from Call Stack UI");
    }

    static interface GoToSourceActionReadnessListener {
        public void ready();
    }
}

