/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingPresenter;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionController;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionPresenter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;

public class DesignComponentInspectorFolder
extends InspectorFolder {
    private String displayName;
    private Image icon;
    private boolean canRename;
    private String name;
    private List<InspectorOrderingController> ocs;
    private DesignComponent component;

    public DesignComponentInspectorFolder(boolean canRename, DesignComponent component) {
        assert (component != null);
        this.component = component;
        this.canRename = canRename;
    }

    @Override
    public TypeID getTypeID() {
        return this.getComponent().getType();
    }

    @Override
    public Long getComponentID() {
        return this.getComponent().getComponentID();
    }

    @Override
    public Image getIcon() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                InfoPresenter presenter = (InfoPresenter)DesignComponentInspectorFolder.this.getComponent().getPresenter(InfoPresenter.class);
                if (presenter == null) {
                    throw new IllegalStateException("No InfoPresenter for this component");
                }
                DesignComponentInspectorFolder.this.icon = presenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
            }
        });
        return this.icon;
    }

    @Override
    public String getDisplayName() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                if (DesignComponentInspectorFolder.this.getComponent().getParentComponent() != null) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                } else if (DesignComponentInspectorFolder.this.getComponent() == DesignComponentInspectorFolder.this.getComponent().getDocument().getRootComponent()) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                }
            }
        });
        return this.displayName;
    }

    @Override
    public String getHtmlDisplayName() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                if (DesignComponentInspectorFolder.this.getComponent().getParentComponent() != null) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getHtmlDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                } else if (DesignComponentInspectorFolder.this.getComponent() == DesignComponentInspectorFolder.this.getComponent().getDocument().getRootComponent()) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getHtmlDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                }
            }
        });
        return this.displayName;
    }

    @Override
    public boolean isInside(InspectorFolderPath path, InspectorFolder folder, DesignComponent component) {
        for (InspectorPositionPresenter presenter : this.getComponent().getPresenters(InspectorPositionPresenter.class)) {
            for (InspectorPositionController pc : presenter.getFolderPositionControllers()) {
                if (pc == null || !pc.isInside(path, folder, this.getComponent())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Action[] getActions() {
        return ActionsSupport.createActionsArray((DesignComponent)this.getComponent());
    }

    @Override
    public boolean canRename() {
        return this.canRename;
    }

    @Override
    public String getName() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                InfoPresenter presenter = (InfoPresenter)DesignComponentInspectorFolder.this.getComponent().getPresenter(InfoPresenter.class);
                if (presenter != null) {
                    if (presenter.isEditable()) {
                        DesignComponentInspectorFolder.this.name = presenter.getEditableName();
                    }
                } else {
                    Debug.warning((Object[])new Object[]{"No info presenter for component :" + DesignComponentInspectorFolder.this.getComponent()});
                }
            }
        });
        return this.name;
    }

    @Override
    public InspectorOrderingController[] getOrderingControllers() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                Collection presenters = DesignComponentInspectorFolder.this.getComponent().getPresenters(InspectorOrderingPresenter.class);
                if (presenters == null || presenters.isEmpty()) {
                    DesignComponentInspectorFolder.this.ocs = null;
                    return;
                }
                DesignComponentInspectorFolder.this.ocs = new ArrayList();
                for (InspectorOrderingPresenter presenter : presenters) {
                    DesignComponentInspectorFolder.this.ocs.addAll(Arrays.asList(presenter.getFolderOrderingControllers()));
                }
            }
        });
        if (this.ocs == null) {
            return null;
        }
        return this.ocs.toArray(new InspectorOrderingController[this.ocs.size()]);
    }

    protected DesignEventFilter getEventFilter() {
        return null;
    }

    protected DesignComponent getComponent() {
        return this.component;
    }
}

