/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.inspector.InspectorRegistry;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.inspector.InspectorPanel;
import org.netbeans.modules.vmd.inspector.InspectorUI;
import org.netbeans.modules.vmd.inspector.InspectorWrapperTree;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class InspectorManagerView
implements DesignDocumentAwareness,
ActiveDocumentSupport.Listener,
DesignListener {
    private static final Map<DataObjectContext, InspectorManagerView> INSTANCES = new WeakHashMap<DataObjectContext, InspectorManagerView>();
    private static final JLabel emptyPanel = new JLabel(NbBundle.getMessage(InspectorManagerView.class, (String)"LBL_emptyPanel"), 0);
    private DesignDocument document;
    private InspectorWrapperTree folderWrapperTree;
    private InspectorUI ui;
    private DataObjectContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(DataObjectContext context) {
        assert (context != null);
        Map<DataObjectContext, InspectorManagerView> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.get(context) == null) {
                INSTANCES.put(context, new InspectorManagerView(context));
            }
        }
    }

    private InspectorManagerView(DataObjectContext context) {
        this.context = context;
        context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public void setDesignDocument(DesignDocument document) {
        if (document != null) {
            this.document = document;
            this.ui = new InspectorUI(document);
            this.folderWrapperTree = new InspectorWrapperTree(document, this.ui);
            ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            document.getListenerManager().addDesignListener((DesignListener)this, new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true));
            IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (InspectorManagerView.this.folderWrapperTree == null) {
                        return;
                    }
                    InspectorManagerView.this.folderWrapperTree.buildTree(null);
                    if (InspectorManagerView.this.ui == null || InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder() == null || InspectorManagerView.this.ui.getExplorerManager() == null) {
                        return;
                    }
                    InspectorManagerView.this.ui.getExplorerManager().setRootContext((Node)InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode());
                }
            });
        } else if (this.document != null && document == null) {
            ActiveDocumentSupport.getDefault().removeActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
            if (this.folderWrapperTree != null) {
                this.folderWrapperTree.terminate();
            }
            this.ui = null;
            this.folderWrapperTree = null;
            this.document = null;
            if (INSTANCES != null) {
                INSTANCES.remove(this.context);
            }
            this.context = null;
        }
    }

    private void notifyUIContentChanged(final DesignEvent event) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InspectorManagerView.this.folderWrapperTree.isLocked()) {
                    Debug.warning((Object[])new Object[]{"Access to the Navigator is locked"});
                }
                InspectorManagerView.this.folderWrapperTree.buildTree(event);
                InspectorManagerView.this.ui.setRootNode((Node)InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode());
            }
        });
    }

    private void notifyUISelectionChanged() {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Collection<Node> selectedNodes;
                if (InspectorManagerView.this.folderWrapperTree.isLocked()) {
                    Debug.warning((Object[])new Object[]{"Access to the Navigator is locked"});
                }
                if (InspectorManagerView.this.document == null || InspectorManagerView.this.document.getListenerManager() == null) {
                    return;
                }
                if (InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode() != null && (selectedNodes = InspectorManagerView.this.folderWrapperTree.getSelectedNodes()) != null) {
                    try {
                        if (!selectedNodes.isEmpty() && !InspectorManagerView.this.folderWrapperTree.isLocked()) {
                            InspectorManagerView.this.ui.getExplorerManager().setSelectedNodes(selectedNodes.toArray(new Node[selectedNodes.size()]));
                        }
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
                if (InspectorManagerView.this.folderWrapperTree.getRootWrapperFolder().getNode() == null) {
                    InspectorManagerView.this.ui.setRootNode(Node.EMPTY);
                }
            }
        };
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                InspectorManagerView.this.document.getTransactionManager().readAccess(runnable);
            }
        });
    }

    public synchronized void activeDocumentChanged(DesignDocument deactivatedDocument, DesignDocument activatedDocument) {
        if (deactivatedDocument == this.document && activatedDocument == null) {
            IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

                @Override
                public void run() {
                    JComponent panel = InspectorPanel.getInstance().getComponent();
                    panel.removeAll();
                    panel.add((Component)emptyPanel, "Center");
                    panel.revalidate();
                    panel.repaint();
                }
            });
            return;
        }
        if (activatedDocument == this.document) {
            IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (InspectorPanel.getInstance() == null) {
                        return;
                    }
                    JComponent panel = InspectorPanel.getInstance().getComponent();
                    panel.removeAll();
                    if (InspectorManagerView.this.ui != null) {
                        panel.add((Component)((Object)InspectorManagerView.this.ui), "Center");
                    } else {
                        panel.add((Component)emptyPanel, "Center");
                    }
                    panel.revalidate();
                    panel.repaint();
                }
            });
        }
    }

    public void activeComponentsChanged(Collection<DesignComponent> activeComponents) {
    }

    public void designChanged(DesignEvent event) {
        if (this.document.getRootComponent() == null) {
            return;
        }
        if (event.isStructureChanged()) {
            this.notifyUIContentChanged(event);
        }
        if (event.isSelectionChanged()) {
            this.notifyUISelectionChanged();
        }
        InspectorRegistry.getInstance(this.document).cleanUpRegistry();
        this.ui.getExplorerManager();
    }

    ExplorerManager getUIExplorerManager() {
        if (this.ui != null) {
            return this.ui.getExplorerManager();
        }
        return null;
    }

    public static ExplorerManager getExplorerManager(DataObjectContext context) {
        for (DataObjectContext context_ : INSTANCES.keySet()) {
            if (context_.getDataObject() != context.getDataObject()) continue;
            return INSTANCES.get(context_).getUIExplorerManager();
        }
        return null;
    }
}

