/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

public final class RubyVariableInfo {
    private static final String NIL_VALUE = "nil";
    private static final String NIL_CLASS = "NilClass";
    private final String name;
    private final String kind;
    private final String value;
    private final String type;
    private final boolean hasChildren;
    private final String objectId;

    public RubyVariableInfo(String name, String kind) {
        this(name, kind, null, null, false, null);
    }

    public RubyVariableInfo(String name, String kind, String value, String type, boolean hasChildren, String objectId) {
        this.name = name;
        this.kind = kind;
        this.value = value == null ? NIL_VALUE : value;
        this.type = type == null ? NIL_CLASS : type;
        this.hasChildren = hasChildren;
        this.objectId = objectId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    boolean isNil() {
        return NIL_VALUE.equals(this.getValue());
    }

    public String toString() {
        return "[" + this.getClass().getName() + '@' + System.identityHashCode(this) + "] kind = " + this.kind + ", value = " + this.value + ", type = " + this.type + ", hasChildren = " + this.hasChildren + ", objectId = " + this.objectId;
    }
}

