/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.utils;

import java.io.File;
import java.util.Collection;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class FileSystemsProvider {
    private static final DefaultProvider DEFAULT = new DefaultProvider();

    private static DefaultProvider getDefault() {
        return DEFAULT;
    }

    public static String getCaseInsensitivePath(CharSequence path) {
        return FileSystemsProvider.getDefault().getCaseInsensitivePathImpl(path);
    }

    public static CharSequence lowerPathCaseIfNeeded(CharSequence path) {
        return FileSystemsProvider.getDefault().lowerPathCaseIfNeededImpl(path);
    }

    public static Data get(File file) {
        return FileSystemsProvider.getDefault().getImpl(file);
    }

    public static Data get(CharSequence path) {
        return FileSystemsProvider.getDefault().getImpl(path);
    }

    protected abstract Data getImpl(File var1);

    protected abstract Data getImpl(CharSequence var1);

    protected abstract String getCaseInsensitivePathImpl(CharSequence var1);

    protected abstract boolean isMine(CharSequence var1);

    private static class DefaultProvider
    extends FileSystemsProvider {
        private FileSystemsProvider[] cache;

        DefaultProvider() {
            Collection instances = Lookup.getDefault().lookupAll(FileSystemsProvider.class);
            this.cache = instances.toArray(new FileSystemsProvider[instances.size()]);
        }

        @Override
        public Data getImpl(File file) {
            for (FileSystemsProvider provider : this.cache) {
                Data data = provider.getImpl(file);
                if (data == null) continue;
                return data;
            }
            return null;
        }

        @Override
        public Data getImpl(CharSequence path) {
            for (FileSystemsProvider provider : this.cache) {
                Data data = provider.getImpl(path);
                if (data == null) continue;
                return data;
            }
            return null;
        }

        @Override
        public String getCaseInsensitivePathImpl(CharSequence path) {
            for (FileSystemsProvider provider : this.cache) {
                String data = provider.getCaseInsensitivePathImpl(path);
                if (data == null) continue;
                return data;
            }
            return ((Object)path).toString();
        }

        protected CharSequence lowerPathCaseIfNeededImpl(CharSequence path) {
            if (CndFileUtils.isSystemCaseSensitive()) {
                return path;
            }
            for (FileSystemsProvider provider : this.cache) {
                if (!provider.isMine(path)) continue;
                return path;
            }
            return ((Object)path).toString().toLowerCase();
        }

        @Override
        protected boolean isMine(CharSequence path) {
            for (FileSystemsProvider provider : this.cache) {
                if (!provider.isMine(path)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Data {
        public final FileSystem fileSystem;
        public final String path;

        public Data(FileSystem fileSystem, String path) {
            this.fileSystem = fileSystem;
            this.path = path;
        }

        public String toString() {
            return this.fileSystem.getDisplayName() + ":" + this.path;
        }
    }
}

