/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class PauseAction
extends ProfilingAwareAction {
    private static final int[] ENABLED_STATES = new int[]{4, 8};
    private boolean suspended = false;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(PauseAction.class, (String)"LBL_PauseAction");
    }

    public void performAction() {
        try {
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            if (this.suspended) {
                runner.suspendTargetAppIfRunning();
                this.suspended = false;
                this.setIcon(null);
                this.firePropertyChange("icon", null, null);
            } else {
                runner.resumeTargetAppIfSuspended();
                this.suspended = true;
                this.setIcon(null);
                this.firePropertyChange("icon", null, null);
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            Profiler.getDefault().displayError(e.getMessage());
            ProfilerLogger.log((Exception)((Object)e));
        }
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    protected String iconResource() {
        if (this.suspended) {
            return "org/netbeans/modules/profiler/actions/resources/resume.png";
        }
        return "org/netbeans/modules/profiler/actions/resources/pause.png";
    }
}

