/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class HeapWalkerManager {
    private static final String CANNOT_OPEN_HEAPWALKER_MSG = NbBundle.getMessage(HeapWalkerManager.class, (String)"HeapWalkerManager_CannotOpenHeapWalkerMsg");
    private static final String CANNOT_DELETE_HEAPDUMP_MSG = NbBundle.getMessage(HeapWalkerManager.class, (String)"HeapWalkerManager_CannotDeleteHeapDumpMsg");
    private static HeapWalkerManager defaultInstance;
    private Set dumpsBeingDeleted = new HashSet();
    private List<File> heapDumps = new ArrayList<File>();
    private List<HeapWalker> heapWalkers = new ArrayList<HeapWalker>();
    private List<TopComponent> topComponents = new ArrayList<TopComponent>();
    private final RequestProcessor heapwalkerRp = new RequestProcessor(HeapWalkerManager.class);

    private HeapWalkerManager() {
    }

    public static HeapWalkerManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new HeapWalkerManager();
        }
        return defaultInstance;
    }

    public boolean isHeapWalkerOpened(File file) {
        return this.getHeapWalker(file) != null;
    }

    public synchronized void closeAllHeapWalkers() {
        HeapWalker[] heapWalkerArr;
        for (HeapWalker hw : heapWalkerArr = this.heapWalkers.toArray(new HeapWalker[this.heapWalkers.size()])) {
            this.closeHeapWalker(hw);
        }
    }

    public synchronized void closeHeapWalker(final HeapWalker hw) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent tc = HeapWalkerManager.this.getTopComponent(hw);
                if (tc == null) {
                    ErrorManager.getDefault().log("Cannot resolve TopComponent for HeapWalker [" + hw.getHeapDumpFile() + "]");
                    return;
                }
                tc.close();
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            }
        });
    }

    public void deleteHeapDump(File file) {
        HeapWalker hw = this.getHeapWalker(file);
        if (hw != null) {
            this.dumpsBeingDeleted.add(file);
            this.closeHeapWalker(hw);
        } else {
            this.deleteHeapDumpImpl(file, 15);
        }
    }

    public synchronized void heapWalkerClosed(HeapWalker hw) {
        TopComponent tc = this.getTopComponent(hw);
        if (tc == null) {
            return;
        }
        final File file = hw.getHeapDumpFile();
        this.heapDumps.remove(file);
        this.heapWalkers.remove(hw);
        this.topComponents.remove(tc);
        if (this.dumpsBeingDeleted.remove(file)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    HeapWalkerManager.this.deleteHeapDumpImpl(file, 15);
                }
            });
        }
    }

    public synchronized void openHeapWalker(File heapDump) {
        HeapWalker hw = this.getHeapWalker(heapDump);
        if (hw == null) {
            try {
                hw = new HeapWalker(heapDump);
            }
            catch (Exception e) {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_OPEN_HEAPWALKER_MSG, e.getLocalizedMessage()));
            }
        }
        if (hw != null) {
            this.openHeapWalker(hw);
        } else {
            ProfilerLogger.severe((String)("Cannot create HeapWalker [" + heapDump + "]"));
        }
    }

    public synchronized void openHeapWalker(final HeapWalker hw) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent tc;
                if (!HeapWalkerManager.this.heapWalkers.contains(hw)) {
                    HeapWalkerManager.this.heapDumps.add(hw.getHeapDumpFile());
                    HeapWalkerManager.this.heapWalkers.add(hw);
                    HeapWalkerManager.this.topComponents.add(hw.getTopComponent());
                }
                if ((tc = HeapWalkerManager.this.getTopComponent(hw)) == null) {
                    ProfilerLogger.severe((String)("Cannot resolve TopComponent for HeapWalker [" + hw.getHeapDumpFile() + "]"));
                    return;
                }
                tc.open();
                tc.requestVisible();
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            }
        });
    }

    public void openHeapWalkers(File[] heapDumps) {
        for (File heapDump : heapDumps) {
            this.openHeapWalker(heapDump);
        }
    }

    private HeapWalker getHeapWalker(File heapDump) {
        int hdIndex = this.heapDumps.indexOf(heapDump);
        return hdIndex == -1 ? null : this.heapWalkers.get(hdIndex);
    }

    private HeapWalker getHeapWalker(TopComponent tc) {
        int tcIndex = this.topComponents.indexOf(tc);
        return tcIndex == -1 ? null : this.heapWalkers.get(tcIndex);
    }

    private TopComponent getTopComponent(HeapWalker hw) {
        int hwIndex = this.heapWalkers.indexOf(hw);
        return hwIndex == -1 ? null : this.topComponents.get(hwIndex);
    }

    private void deleteHeapDumpImpl(final File file, final int retries) {
        this.heapwalkerRp.post(new Runnable(){

            @Override
            public void run() {
                if (!file.delete()) {
                    if (retries > 0 && Platform.isWindows()) {
                        System.gc();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        HeapWalkerManager.this.deleteHeapDumpImpl(file, retries - 1);
                    } else {
                        NetBeansProfiler.getDefaultNB().displayError(CANNOT_DELETE_HEAPDUMP_MSG);
                    }
                } else {
                    ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                }
            }
        });
    }
}

