/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Acceptors {
    private static Acceptors INSTANCE;
    private Map<String, CssPropertyValueAcceptor> acceptors;

    public static synchronized Acceptors instance() {
        if (INSTANCE == null) {
            INSTANCE = new Acceptors("org/netbeans/modules/css/editor/properties/acceptors");
        }
        return INSTANCE;
    }

    private Acceptors(String sourcePath) {
        this.parseSource(sourcePath);
    }

    public CssPropertyValueAcceptor getAcceptor(String name) {
        return this.acceptors.get(name.toLowerCase());
    }

    private void parseSource(String sourcePath) {
        ResourceBundle bundle = NbBundle.getBundle((String)sourcePath);
        this.acceptors = new HashMap<String, CssPropertyValueAcceptor>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            try {
                String id = keys.nextElement();
                String instanceName = bundle.getString(id);
                Class<?> clazz = Class.forName(instanceName);
                CssPropertyValueAcceptor instance = (CssPropertyValueAcceptor)clazz.newInstance();
                this.acceptors.put(id, instance);
            }
            catch (InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

