/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.refactoring.java.api.MemberInfo;

public final class UIUtilities {
    private UIUtilities() {
    }

    public static String getColumnName(String string) {
        return string == null || string.length() == 0 ? " " : string;
    }

    public static void initColumnWidth(JTable jTable, int n, Object object, int n2) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n3 = component.getPreferredSize().width;
        component = jTable.getDefaultRenderer(jTable.getModel().getColumnClass(n)).getTableCellRendererComponent(jTable, object, false, false, 0, n);
        n3 = Math.max(n3, component.getPreferredSize().width) + 2 * n2;
        tableColumn.setPreferredWidth(n3);
        if (object instanceof Boolean) {
            tableColumn.setMaxWidth(n3);
        }
    }

    public static class BooleanTableCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer checkbox;
        private final TableCellRenderer label;

        public BooleanTableCellRenderer(JTable jTable) {
            this(jTable.getDefaultRenderer(String.class), jTable.getDefaultRenderer(Boolean.class));
        }

        private BooleanTableCellRenderer(TableCellRenderer tableCellRenderer, TableCellRenderer tableCellRenderer2) {
            this.checkbox = tableCellRenderer2;
            this.label = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableCellRenderer tableCellRenderer = object == null || !jTable.getModel().isCellEditable(n, n2) ? this.label : this.checkbox;
            object = object != null && tableCellRenderer == this.label ? null : object;
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return component;
        }
    }

    public static class JavaElementListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, this.extractText(object), n, bl, bl2);
            if (object instanceof MemberInfo) {
                Icon icon = ((MemberInfo)object).getIcon();
                this.setIcon(icon);
            }
            return this;
        }

        protected String extractText(Object object) {
            if (object instanceof MemberInfo) {
                return ((MemberInfo)object).getHtmlText();
            }
            return object.toString();
        }
    }

    public static class JavaElementTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, this.extractText(object), bl, bl2, n, n2);
            if (object instanceof MemberInfo) {
                Icon icon = ((MemberInfo)object).getIcon();
                this.setIcon(icon);
            } else {
                this.setIcon(null);
            }
            return this;
        }

        protected String extractText(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof MemberInfo) {
                return ((MemberInfo)object).getHtmlText();
            }
            return object.toString();
        }
    }
}

