/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring.plugins;

import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.beans.refactoring.ModificationTransaction;
import org.netbeans.modules.spring.beans.refactoring.Modifications;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactoringElement;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SpringRenamePlugin
implements RefactoringPlugin {
    private final RenameRefactoring refactoring;

    public SpringRenamePlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null && treePathHandle.getKind() == Tree.Kind.METHOD) {
            return this.prepareMethodRefactoring(refactoringElementsBag, treePathHandle);
        }
        return this.prepareClassRefactoring(refactoringElementsBag, treePathHandle);
    }

    private Problem prepareClassRefactoring(RefactoringElementsBag refactoringElementsBag, TreePathHandle treePathHandle) {
        SpringScope springScope;
        FileObject fileObject = null;
        if (treePathHandle != null && treePathHandle.getKind() == Tree.Kind.CLASS) {
            fileObject = treePathHandle.getFileObject();
        }
        if (fileObject == null) {
            fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
        boolean bl = true;
        if (fileObject == null && (springScope = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)) != null) {
            bl = false;
            fileObject = springScope.getFolder();
        }
        if (fileObject == null) {
            return null;
        }
        springScope = SpringScope.getSpringScope(fileObject);
        if (springScope == null) {
            return null;
        }
        try {
            if (treePathHandle != null) {
                SpringRefactorings.RenamedClassName renamedClassName = null;
                JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                if (javaSource != null) {
                    renamedClassName = SpringRefactorings.getRenamedClassName(treePathHandle, javaSource, this.refactoring.getNewName());
                }
                if (renamedClassName != null) {
                    String string = renamedClassName.getOldBinaryName();
                    String string2 = renamedClassName.getNewBinaryName();
                    if (string != null && string2 != null) {
                        Modifications modifications = new Modifications();
                        for (Occurrences.Occurrence occurrence : Occurrences.getJavaClassOccurrences(string, springScope)) {
                            refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, modifications, renamedClassName.getOldSimpleName(), string2));
                        }
                        refactoringElementsBag.registerTransaction((Transaction)new ModificationTransaction(modifications));
                    }
                }
            } else if (fileObject.isFolder()) {
                String string;
                String string3 = SpringRefactorings.getPackageName(fileObject);
                String string4 = string = bl ? SpringRefactorings.getRenamedPackageName(fileObject, this.refactoring.getNewName()) : this.refactoring.getNewName();
                if (string3 != null && string != null) {
                    Modifications modifications = new Modifications();
                    for (Occurrences.Occurrence occurrence : Occurrences.getJavaPackageOccurrences(string3, bl, springScope)) {
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createJavaElementRefModification(occurrence, modifications, null, string));
                    }
                    refactoringElementsBag.registerTransaction((Transaction)new ModificationTransaction(modifications));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private Problem prepareMethodRefactoring(RefactoringElementsBag refactoringElementsBag, TreePathHandle treePathHandle) {
        FileObject fileObject = treePathHandle.getFileObject();
        try {
            SpringScope springScope;
            SpringRefactorings.RenamedProperty renamedProperty = null;
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource != null) {
                renamedProperty = SpringRefactorings.getRenamedProperty(treePathHandle, javaSource, this.refactoring.getNewName());
            }
            if ((springScope = SpringScope.getSpringScope(fileObject)) == null) {
                return null;
            }
            if (renamedProperty != null) {
                String string = renamedProperty.getNewName();
                String string2 = renamedProperty.getOldName();
                if (string != null && string2 != null) {
                    Modifications modifications = new Modifications();
                    for (Occurrences.Occurrence occurrence : Occurrences.getPropertyOccurrences(renamedProperty, javaSource, springScope)) {
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)SpringRefactoringElement.createPropertyRefModification(occurrence, modifications, renamedProperty.getOldName(), renamedProperty.getNewName()));
                    }
                    refactoringElementsBag.registerTransaction((Transaction)new ModificationTransaction(modifications));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

