/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.debug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class Utils {
    private Utils() {
    }

    public static File[] convertStringsToNormalizedFiles(Collection<String> collection) {
        File[] fileArray = new File[collection.size()];
        int n = 0;
        for (String string : collection) {
            File file = new File(string);
            fileArray[n] = file = FileUtil.normalizeFile((File)file);
            ++n;
        }
        return fileArray;
    }

    static ClassPath createSourcePath(Project project) {
        GrailsProject grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class);
        HashSet<URL> hashSet = new HashSet<URL>();
        hashSet.addAll(grailsProject.getSourceRoots().getRootURLs());
        hashSet.addAll(grailsProject.getTestSourceRoots().getRootURLs());
        return ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
    }

    static ClassPath createJDKSourcePath(Project project) {
        GrailsProjectConfig grailsProjectConfig = (GrailsProjectConfig)project.getLookup().lookup(GrailsProjectConfig.class);
        JavaPlatform javaPlatform = grailsProjectConfig.getJavaPlatform();
        if (javaPlatform == null) {
            javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        }
        if (javaPlatform != null) {
            return javaPlatform.getSourceFolders();
        }
        return ClassPathSupport.createClassPath((URL[])new URL[0]);
    }

    private static ClassPath convertToClassPath(File[] fileArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL = Utils.fileToURL(fileArray[i]);
            arrayList.add(uRL);
        }
        URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        return ClassPathSupport.createClassPath((URL[])uRLArray);
    }

    private static ClassPath convertToSourcePath(File[] fileArray) {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        HashSet<URL> hashSet = new HashSet<URL>();
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL = Utils.fileToURL(fileArray[i]);
            try {
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                for (int j = 0; j < fileObjectArray.length; ++j) {
                    block8: {
                        if (FileUtil.isArchiveFile((FileObject)fileObjectArray[j])) {
                            fileObjectArray[j] = FileUtil.getArchiveRoot((FileObject)fileObjectArray[j]);
                        }
                        try {
                            uRL = fileObjectArray[j].getURL();
                            if (uRL.toExternalForm().endsWith("/")) break block8;
                            uRL = new URL(uRL.toExternalForm() + "/");
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            ErrorManager.getDefault().notify(4096, (Throwable)fileStateInvalidException);
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify(4096, (Throwable)malformedURLException);
                            continue;
                        }
                    }
                    if (uRL == null || hashSet.contains(uRL)) continue;
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    hashSet.add(uRL);
                }
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    static URL fileToURL(File file) {
        try {
            URL uRL = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            }
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(4096, (Throwable)malformedURLException);
            return null;
        }
    }
}

