/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class CDCMainClassHelper
implements AntProjectListener,
FileChangeListener {
    private final AntProjectHelper helper;
    private String mainClass;
    private FileObject lastMain = null;

    public CDCMainClassHelper(AntProjectHelper helper) {
        this.helper = helper;
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        this.mainClass = ep.getProperty("main.class");
        if (this.mainClass != null) {
            this.setUp(this.mainClass);
        }
        helper.addAntProjectListener((AntProjectListener)this);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    public void propertiesChanged(AntProjectEvent ev) {
        String newMC = this.helper.getProperties("nbproject/project.properties").getProperty("main.class");
        if (newMC != null && !newMC.equals(this.mainClass)) {
            this.setUp(newMC);
            this.mainClass = newMC;
        }
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject o = (FileObject)fe.getSource();
        this.mainClass = this.mainClass.substring(0, this.mainClass.lastIndexOf(46) + 1) + o.getName();
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        ep.setProperty("main.class", this.mainClass);
        this.helper.putProperties("nbproject/project.properties", ep);
        try {
            Project project = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private synchronized void setUp(final String str) {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                FileObject root = CDCMainClassHelper.this.helper.getProjectDirectory().getFileObject(CDCMainClassHelper.this.helper.getProperties("nbproject/project.properties").getProperty("src.dir"));
                if (root != null) {
                    ClassPath path1 = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
                    ClassPath path2 = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
                    ClassPath path = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{path1, path2});
                    FileObject o = path.findResource(str.replace('.', '/') + ".java");
                    if (CDCMainClassHelper.this.lastMain != null) {
                        CDCMainClassHelper.this.lastMain.removeFileChangeListener((FileChangeListener)CDCMainClassHelper.this);
                    }
                    if (o != null) {
                        o.addFileChangeListener((FileChangeListener)CDCMainClassHelper.this);
                    }
                    CDCMainClassHelper.this.lastMain = o;
                }
            }
        });
    }
}

