/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.pojson.PojsonLoad;
import org.codeviation.pojson.PojsonSave;
import org.netbeans.modules.kenai.AuthenticationData;
import org.netbeans.modules.kenai.CheckNameData;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.KenaiImpl;
import org.netbeans.modules.kenai.LicensesListData;
import org.netbeans.modules.kenai.ListData;
import org.netbeans.modules.kenai.MemberData;
import org.netbeans.modules.kenai.MembersListData;
import org.netbeans.modules.kenai.ProjectCreateData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.ProjectFeatureCreateData;
import org.netbeans.modules.kenai.ProjectsListData;
import org.netbeans.modules.kenai.RestConnection;
import org.netbeans.modules.kenai.RestResponse;
import org.netbeans.modules.kenai.ServicesListData;
import org.netbeans.modules.kenai.UserData;
import org.netbeans.modules.kenai.api.KenaiException;

public class KenaiREST
extends KenaiImpl {
    private URL baseURL;
    private static final Logger TIMER = Logger.getLogger("TIMER.kenai");

    @Override
    public URL getUrl() {
        return this.baseURL;
    }

    public KenaiREST(URL baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public boolean isAuthorized(String projectName, String feature, String activity, PasswordAuthentication pa) throws KenaiException {
        String[][] params = new String[][]{{"feature_id", feature}, {"activity_id", activity}, {"person_id", pa.getUserName()}, {"project_id", projectName}};
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/login/authorize", params, pa);
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Loading page " + this.baseURL.toString() + "/api/login/authorize");
        }
        RestResponse resp = null;
        try {
            resp = conn.get(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Page " + this.baseURL.toString() + "/api/login/authorize loaded in " + (System.currentTimeMillis() - start) + " ms");
        }
        return resp.getResponseCode() == 200;
    }

    @Override
    public ProjectData getProject(String name, PasswordAuthentication pa) throws KenaiException {
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/projects/" + name + ".json", pa);
        RestResponse resp = null;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Loading project " + name);
        }
        try {
            resp = conn.get(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Project " + name + " loaded in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 200) {
            throw new KenaiException(name + ": " + resp.getResponseMessage(), resp.getDataAsString());
        }
        String sss = resp.getDataAsString();
        PojsonLoad pload = PojsonLoad.create();
        return pload.load(sss, ProjectData.class);
    }

    @Override
    public Collection<ProjectData> searchProjects(String pattern, PasswordAuthentication pa) throws KenaiException {
        try {
            String m = "/api/projects.json?full=true";
            if (pattern.length() > 0) {
                m = pattern.startsWith("&") ? m + pattern : m + "&q=" + URLEncoder.encode(pattern, "UTF-8");
            }
            ProjectsListData pld = KenaiREST.loadPage(this.baseURL.toString() + m, ProjectsListData.class, null);
            return new LazyList(this, (ListData)pld, ProjectsListData.class, pa);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Collection<ProjectData> getMyProjects(PasswordAuthentication pa) throws KenaiException {
        ProjectsListData pld = KenaiREST.loadPage(this.baseURL.toString() + "/api/projects/mine.json?full=true", ProjectsListData.class, pa);
        return new LazyList(this, (ListData)pld, ProjectsListData.class, pa);
    }

    private static <T> T loadPage(String url, Class<T> clazz, PasswordAuthentication pa) throws KenaiException {
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Loading page " + url);
        }
        if (url == null) {
            System.out.println("");
        }
        RestConnection conn = new RestConnection(url, pa);
        RestResponse resp = null;
        try {
            resp = conn.get(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Page " + url + " loaded in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 200) {
            throw new KenaiException(resp.getResponseMessage(), resp.getDataAsString());
        }
        String responseString = resp.getDataAsString();
        PojsonLoad pload = PojsonLoad.create();
        T data = pload.load(responseString, clazz);
        return data;
    }

    @Override
    public Collection<LicensesListData.LicensesListItem> getLicenses() throws KenaiException {
        LicensesListData pld = KenaiREST.loadPage(this.baseURL.toString() + "/api/licenses.json", LicensesListData.class, null);
        return new LazyList(this, (ListData)pld, LicensesListData.class, null);
    }

    @Override
    public Collection<ServicesListData.ServicesListItem> getServices() throws KenaiException {
        ServicesListData pld = KenaiREST.loadPage(this.baseURL.toString() + "/api/services.json", ServicesListData.class, null);
        return new LazyList(this, (ListData)pld, ServicesListData.class, null);
    }

    @Override
    public String checkName(String name) throws KenaiException {
        CheckNameData cnd = KenaiREST.loadPage(this.baseURL.toString() + "/api/projects/check_unique.json?name=" + name, CheckNameData.class, null);
        return cnd.is_unique ? null : cnd.message;
    }

    @Override
    public Collection<UserData> getProjectMembers(String name, PasswordAuthentication pa) throws KenaiException {
        MembersListData members = KenaiREST.loadPage(this.baseURL.toString() + "/api/projects/" + name + "/members.json", MembersListData.class, pa);
        return new LazyList(this, (ListData)members, MembersListData.class, pa);
    }

    @Override
    public MemberData addMember(String project, String user, String role, PasswordAuthentication pa) throws KenaiException {
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/projects/" + project + "/members.json", pa);
        RestResponse resp = null;
        PojsonSave<MemberData> save = PojsonSave.create(MemberData.class);
        MemberData mdata = new MemberData();
        mdata.member.username = user;
        mdata.member.role = role;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Add member " + user + " to project " + project);
        }
        try {
            resp = conn.post((String[][])null, save.asString(mdata));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("User " + user + " add in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 200) {
            throw new KenaiException(resp.getResponseMessage(), resp.getDataAsString());
        }
        String response = resp.getDataAsString();
        PojsonLoad pload = PojsonLoad.create();
        return pload.load(response, MemberData.class);
    }

    @Override
    public void deleteMember(String project, long member_id, PasswordAuthentication pa) throws KenaiException {
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/projects/" + project + "/members/" + member_id + ".json", pa);
        RestResponse resp = null;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Removing member " + member_id + " from project " + project);
        }
        try {
            resp = conn.delete(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("User " + member_id + " removed in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 200) {
            throw new KenaiException(resp.getResponseMessage(), resp.getDataAsString());
        }
    }

    @Override
    public void deleteProject(String project, PasswordAuthentication pa) throws KenaiException {
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/projects/" + project + ".json", pa);
        RestResponse resp = null;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Removing project " + project);
        }
        try {
            resp = conn.delete(null);
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("project " + project + " removed in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 200) {
            throw new KenaiException(resp.getResponseMessage(), resp.getDataAsString());
        }
    }

    @Override
    public ProjectData createProject(String name, String displayName, String description, String[] licenses, String tags, PasswordAuthentication pa) throws KenaiException {
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/projects.json", pa);
        RestResponse resp = null;
        PojsonSave<ProjectCreateData> save = PojsonSave.create(ProjectCreateData.class);
        ProjectCreateData prdata = new ProjectCreateData();
        prdata.project.name = name;
        prdata.project.display_name = displayName;
        prdata.project.description = description;
        prdata.project.licenses = licenses;
        prdata.project.tags = tags;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Create project " + name);
        }
        try {
            resp = conn.post((String[][])null, save.asString(prdata));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Project " + name + " created in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 201) {
            throw new KenaiException(resp.getResponseMessage(), resp.getDataAsString());
        }
        String response = resp.getDataAsString();
        PojsonLoad pload = PojsonLoad.create();
        return pload.load(response, ProjectData.class);
    }

    @Override
    public FeatureData createProjectFeature(String projectName, String name, String display_name, String description, String url, String repository_url, String browse_url, String service, PasswordAuthentication pa) throws KenaiException {
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/projects/" + projectName + "/features.json", pa);
        RestResponse resp = null;
        PojsonSave<ProjectFeatureCreateData> save = PojsonSave.create(ProjectFeatureCreateData.class);
        ProjectFeatureCreateData fdata = new ProjectFeatureCreateData();
        fdata.feature.name = name;
        fdata.feature.display_name = display_name;
        fdata.feature.description = description;
        fdata.feature.service = service;
        fdata.feature.url = url;
        fdata.feature.repository_url = repository_url;
        fdata.feature.browse_url = browse_url;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Creating feature " + name);
        }
        try {
            resp = conn.post((String[][])null, save.asString(fdata));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Feature " + name + " created in " + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 201) {
            throw new KenaiException(resp.getResponseMessage(), resp.getDataAsString());
        }
        String response = resp.getDataAsString();
        PojsonLoad pload = PojsonLoad.create();
        return pload.load(response, FeatureData.class);
    }

    @Override
    public void register(String username, char[] password) throws KenaiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String verify(String username, char[] password) throws KenaiException {
        AuthenticationData auth = new AuthenticationData();
        auth.username = username;
        auth.password = new String(password);
        PojsonSave<AuthenticationData> save = PojsonSave.create(AuthenticationData.class);
        RestConnection conn = new RestConnection(this.baseURL.toString() + "/api/login/authenticate.json", null);
        RestResponse resp = null;
        long start = 0L;
        if (TIMER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
            System.err.println("Loading page " + this.baseURL.toString() + "/api/login/authenticate.json");
        }
        try {
            resp = conn.post((String[][])null, save.asString(auth));
        }
        catch (IOException iOException) {
            throw new KenaiException(iOException);
        }
        if (TIMER.isLoggable(Level.FINE)) {
            System.err.println("Page " + this.baseURL.toString() + "/api/login/authenticate.json loaded in" + (System.currentTimeMillis() - start) + " ms");
        }
        if (resp.getResponseCode() != 200) {
            throw new KenaiException(ResourceBundle.getBundle("org.netbeans.modules.kenai.Bundle").getString("LBL_AuthenticationFailed"), resp.getDataAsString());
        }
        try {
            String shortName = (String)((HashMap)PojsonLoad.create().toCollections(resp.getDataAsString())).get("username");
            if (shortName == null || shortName.length() == 0) {
                throw new KenaiException(ResourceBundle.getBundle("org.netbeans.modules.kenai.Bundle").getString("LBL_AuthenticationFailed"));
            }
            return shortName;
        }
        catch (IOException ex) {
            throw new KenaiException(ex);
        }
    }

    private static class LazyIterator<COLLECTION extends ListData, ITEM>
    implements Iterator<ITEM> {
        private COLLECTION col;
        private int currentIndex = 0;
        private Class<COLLECTION> clazz;
        private PasswordAuthentication pa;
        final /* synthetic */ KenaiREST this$0;

        public LazyIterator(COLLECTION col, Class<COLLECTION> clazz, PasswordAuthentication pa) {
            this.this$0 = var1_1;
            this.col = col;
            this.clazz = clazz;
            this.pa = pa;
        }

        @Override
        public boolean hasNext() {
            if (((ListData)this.col).size() > this.currentIndex) {
                return true;
            }
            return ((ListData)this.col).next != null;
        }

        @Override
        public ITEM next() {
            if (this.currentIndex == ((ListData)this.col).size()) {
                this.currentIndex -= ((ListData)this.col).size();
                try {
                    this.col = (ListData)KenaiREST.loadPage(((ListData)this.col).next, this.clazz, this.pa);
                }
                catch (KenaiException ex) {
                    throw new RuntimeException("Error loading " + ((ListData)this.col).next, ex);
                }
            }
            return this.colToItem(this.currentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove items");
        }

        private ITEM colToItem(int index) {
            if (this.col instanceof ProjectsListData) {
                return (ITEM)((ProjectsListData)this.col).projects[index];
            }
            if (this.col instanceof ServicesListData) {
                return (ITEM)((ServicesListData)this.col).services[index];
            }
            if (this.col instanceof LicensesListData) {
                return (ITEM)((LicensesListData)this.col).licenses[index];
            }
            if (this.col instanceof MembersListData) {
                return (ITEM)((MembersListData)this.col).members[index];
            }
            throw new IllegalStateException();
        }
    }

    private static class LazyList<COLLECTION extends ListData, ITEM>
    extends AbstractCollection<ITEM> {
        private COLLECTION col;
        private Class<COLLECTION> clazz;
        private PasswordAuthentication pa;
        final /* synthetic */ KenaiREST this$0;

        public LazyList(COLLECTION col, Class<COLLECTION> clazz, PasswordAuthentication pa) {
            this.this$0 = var1_1;
            this.col = col;
            this.clazz = clazz;
            this.pa = pa;
        }

        @Override
        public Iterator<ITEM> iterator() {
            return new LazyIterator(this.this$0, this.col, this.clazz, this.pa);
        }

        @Override
        public int size() {
            return ((ListData)this.col).total;
        }
    }
}

