/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager
implements UndoableEditListener,
DocumentListener {
    public CompoundEdit compoundEdit;
    private JTextComponent editor;
    private int lastOffset;
    private int lastLength;

    public CompoundUndoManager(JTextComponent editor) {
        this.editor = editor;
        editor.getDocument().addUndoableEditListener(this);
    }

    @Override
    public void undo() {
        this.editor.getDocument().addDocumentListener(this);
        super.undo();
        this.editor.getDocument().removeDocumentListener(this);
    }

    @Override
    public void redo() {
        this.editor.getDocument().addDocumentListener(this);
        super.redo();
        this.editor.getDocument().removeDocumentListener(this);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            this.lastLength = this.editor.getDocument().getLength();
            return;
        }
        AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
        if (event.getType().equals(DocumentEvent.EventType.CHANGE)) {
            this.compoundEdit.addEdit(e.getEdit());
            return;
        }
        int offsetChange = this.editor.getCaretPosition() - this.lastOffset;
        int lengthChange = this.editor.getDocument().getLength() - this.lastLength;
        if (Math.abs(offsetChange) == 1 && Math.abs(lengthChange) == 1) {
            this.compoundEdit.addEdit(e.getEdit());
            this.lastOffset = this.editor.getCaretPosition();
            this.lastLength = this.editor.getDocument().getLength();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    public void startNewCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.compoundEdit = null;
        }
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.lastLength = this.editor.getDocument().getLength();
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    @Override
    public void insertUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int offset = e.getOffset() + e.getLength();
                offset = Math.min(offset, CompoundUndoManager.this.editor.getDocument().getLength());
                CompoundUndoManager.this.editor.setCaretPosition(offset);
            }
        });
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.editor.setCaretPosition(e.getOffset());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (CompoundUndoManager.this.compoundEdit != null) {
                CompoundUndoManager.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoManager.this.compoundEdit = null;
        }
    }
}

