/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.mozilla.nb.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.StrictWarning;
import org.netbeans.modules.javascript.hints.infrastructure.JsErrorRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsRuleContext;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.NbBundle;

public class AccidentalAssignment
extends JsErrorRule {
    @Override
    public Set<String> getCodes() {
        return Collections.singleton("msg.equal.as.assign");
    }

    @Override
    public void run(JsRuleContext jsRuleContext, Error error, List<Hint> list) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)jsRuleContext.parserResult);
        BaseDocument baseDocument = jsRuleContext.doc;
        Node node = (Node)error.getParameters()[0];
        int n = error.getStartPosition();
        OffsetRange offsetRange = AstUtilities.getRange((Node)node);
        OffsetRange offsetRange2 = LexUtilities.getLexerOffsets((JsParseResult)jsParseResult, (OffsetRange)offsetRange);
        if (offsetRange2 != OffsetRange.NONE) {
            offsetRange2 = StrictWarning.limitErrorToLine(baseDocument, offsetRange2, n);
            ArrayList<ConvertAssignmentFix> arrayList = new ArrayList<ConvertAssignmentFix>(2);
            arrayList.add(new ConvertAssignmentFix(jsRuleContext, node, error, false));
            arrayList.add(new ConvertAssignmentFix(jsRuleContext, node, error, true));
            Hint hint = new Hint((Rule)this, this.getDisplayName(), jsParseResult.getSnapshot().getSource().getFileObject(), offsetRange2, arrayList, 500);
            list.add(hint);
        }
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignment");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "AccidentalAssignment";
    }

    public String getDescription() {
        return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class ConvertAssignmentFix
    implements PreviewableFix {
        private final JsRuleContext context;
        private final Node assignment;
        private final Error error;
        private final boolean ignore;

        public ConvertAssignmentFix(JsRuleContext jsRuleContext, Node node, Error error, boolean bl) {
            this.context = jsRuleContext;
            this.assignment = node;
            this.error = error;
            this.ignore = bl;
        }

        public String getDescription() {
            return this.ignore ? NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentIgnore") : NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentFix");
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)this.context.parserResult);
            EditList editList = new EditList(baseDocument);
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)this.assignment);
            OffsetRange offsetRange2 = LexUtilities.getLexerOffsets((JsParseResult)jsParseResult, (OffsetRange)offsetRange);
            if (offsetRange2 == OffsetRange.NONE) {
                return editList;
            }
            if (this.ignore) {
                editList.replace(offsetRange2.getStart(), 0, "(", false, 0);
                editList.replace(offsetRange2.getEnd(), 0, ")", false, 0);
            } else {
                int n;
                int n2 = offsetRange2.getStart();
                String string = baseDocument.getText(n2, (n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2)) - n2);
                int n3 = string.indexOf(61);
                if (n3 == -1) {
                    int n4 = this.error.getStartPosition();
                    int n5 = LexUtilities.getLexerOffset((JsParseResult)jsParseResult, (int)n4);
                    if (n5 == -1) {
                        return editList;
                    }
                    n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n5);
                    n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
                    string = baseDocument.getText(n2, n - n2);
                    n3 = string.indexOf(61);
                }
                if (n3 != -1) {
                    editList.replace(n2 + n3, 0, "=", false, 0);
                }
            }
            return editList;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

