/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.extras.api.support.CollectorRunner;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.impl.LLDataCollectorConfigurationAccessor;
import org.netbeans.modules.dlight.tools.impl.NativeToolsUtil;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.NbBundle;

public class LLDataCollector
extends IndicatorDataProvider<LLDataCollectorConfiguration>
implements DataCollector<LLDataCollectorConfiguration>,
DLightTarget.ExecutionEnvVariablesProvider {
    private static final boolean ALLOW_ON_MACOSX = Boolean.getBoolean("cnd.tools.prof_agent.allow_on_macos");
    private final Object lock = LLDataCollector.class.getName();
    private final EnumSet<LLDataCollectorConfiguration.CollectedData> collectedData;
    private final Set<ValidationListener> validationListeners;
    private final String name;
    private DLightTarget target;
    private ValidationStatus validationStatus;
    private CollectorRunner profRunner;
    private final List<DataCollectorListener> listeners = new ArrayList<DataCollectorListener>();

    public LLDataCollector(LLDataCollectorConfiguration configuration) {
        this.collectedData = EnumSet.of(LLDataCollectorConfigurationAccessor.getDefault().getCollectedData(configuration));
        this.name = LLDataCollectorConfigurationAccessor.getDefault().getName();
        this.validationStatus = ValidationStatus.initialStatus();
        this.validationListeners = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDataCollectorListener(DataCollectorListener listener) {
        if (listener == null) {
            return;
        }
        LLDataCollector lLDataCollector = this;
        synchronized (lLDataCollector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDataCollectorListener(DataCollectorListener listener) {
        LLDataCollector lLDataCollector = this;
        synchronized (lLDataCollector) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DataCollector.CollectorState state) {
        DataCollectorListener[] ll;
        LLDataCollector lLDataCollector = this;
        synchronized (lLDataCollector) {
            ll = this.listeners.toArray(new DataCollectorListener[0]);
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final DataCollectorListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.collectorStateChanged((DataCollector)LLDataCollector.this, state);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(LLDataCollectorConfiguration configuration) {
        Object object = this.lock;
        synchronized (object) {
            this.collectedData.add(LLDataCollectorConfigurationAccessor.getDefault().getCollectedData(configuration));
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> tables = new ArrayList<DataTableMetadata>();
        Object object = this.lock;
        synchronized (object) {
            if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.CPU)) {
                tables.add(LLDataCollectorConfiguration.CPU_TABLE);
            }
            if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.MEM)) {
                tables.add(LLDataCollectorConfiguration.MEM_TABLE);
            }
            if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.SYNC)) {
                tables.add(LLDataCollectorConfiguration.SYNC_TABLE);
            }
        }
        return tables;
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        ExecutionEnvironment env = target.getExecEnv();
        if (!env.isLocal()) {
            for (Map.Entry<String, File> entry : this.locateProfAgents(env).entrySet()) {
                this.upload(env, entry.getValue(), this.getRemoteDir(env, entry.getValue(), entry.getKey()), 420);
            }
            Iterator<Map.Entry<String, File>> i$ = this.locateProfMonitors(env).entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<String, File> entry;
                entry = i$.next();
                this.upload(env, entry.getValue(), this.getRemoteDir(env, entry.getValue(), entry.getKey()), 493);
            }
        }
        if (!NativeToolsUtil.isMacOSX(env)) {
            this.collectedData.remove((Object)LLDataCollectorConfiguration.CollectedData.CPU);
        }
        Object object = this.lock;
        synchronized (object) {
            this.target = target;
        }
    }

    private void upload(ExecutionEnvironment execEnv, File localFile, String remoteDir, int mode) {
        try {
            CommonTasksSupport.mkDir((ExecutionEnvironment)execEnv, (String)remoteDir, null).get();
            CommonTasksSupport.uploadFile((String)localFile.getAbsolutePath(), (ExecutionEnvironment)execEnv, (String)(remoteDir + "/" + localFile.getName()), (int)mode, null, (boolean)true).get();
        }
        catch (InterruptedException ex) {
            DLightLogger.instance.log(Level.WARNING, null, ex);
        }
        catch (ExecutionException ex) {
            DLightLogger.instance.log(Level.WARNING, null, ex);
        }
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        return null;
    }

    public String[] getArgs() {
        return null;
    }

    public void setupEnvironment(DLightTarget target, MacroMap env) throws ConnectException {
        ExecutionEnvironment execEnv = target.getExecEnv();
        boolean isMac = NativeToolsUtil.isMacOSX(execEnv);
        Map<String, File> agentLibrariesLocal = this.locateProfAgents(execEnv);
        if (!agentLibrariesLocal.isEmpty()) {
            if (isMac) {
                Map.Entry<String, File> entry = agentLibrariesLocal.entrySet().iterator().next();
                env.appendPathVariable("DYLD_INSERT_LIBRARIES", this.getRemoteDir(execEnv, entry.getValue(), entry.getKey()) + '/' + entry.getValue().getName());
            } else {
                String agentFilename = null;
                for (Map.Entry<String, File> entry : agentLibrariesLocal.entrySet()) {
                    if (agentFilename == null) {
                        agentFilename = entry.getValue().getName();
                    }
                    env.appendPathVariable("LD_LIBRARY_PATH", this.getRemoteDir(execEnv, entry.getValue(), entry.getKey()));
                }
                env.appendPathVariable("LD_PRELOAD", agentFilename);
            }
        }
    }

    private String getRemoteDir(ExecutionEnvironment env, File localFile, String dirname) {
        String tmpDir;
        if (env.isLocal()) {
            return localFile.getParentFile().getAbsolutePath();
        }
        try {
            tmpDir = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getTempDir();
        }
        catch (Throwable ex) {
            tmpDir = "/var/tmp";
        }
        return tmpDir + "/tools/" + dirname;
    }

    private Map<String, File> locateProfAgents(ExecutionEnvironment env) {
        return NativeToolsUtil.getCompatibleBinaries(env, "prof_agent.${soext}");
    }

    private Map<String, File> locateProfMonitors(ExecutionEnvironment env) {
        return NativeToolsUtil.getCompatibleBinaries(env, "prof_monitor");
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.startMonitor();
                break;
            }
            case DONE: 
            case FAILED: 
            case STOPPED: 
            case TERMINATED: {
                this.stopMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor() {
        Object cdata;
        ExecutionEnvironment env;
        AttachableTarget at;
        Object object = this.lock;
        synchronized (object) {
            at = (AttachableTarget)this.target;
            env = this.target.getExecEnv();
            cdata = this.collectedData.clone();
        }
        NativeProcessBuilder npb = null;
        Iterator<Map.Entry<String, File>> i$ = this.locateProfMonitors(env).entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, File> entry = i$.next();
            npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
            npb.setExecutable(this.getRemoteDir(env, entry.getValue(), entry.getKey()) + "/" + entry.getValue().getName());
        }
        if (npb == null) {
            DLightLogger.instance.severe("Failed to find prof_monitor");
            return;
        }
        StringBuilder flags = new StringBuilder("-");
        if (((AbstractCollection)cdata).contains((Object)LLDataCollectorConfiguration.CollectedData.CPU)) {
            flags.append('c');
        }
        if (((AbstractCollection)cdata).contains((Object)LLDataCollectorConfiguration.CollectedData.MEM)) {
            flags.append('m');
        }
        if (((AbstractCollection)cdata).contains((Object)LLDataCollectorConfiguration.CollectedData.SYNC)) {
            flags.append('s');
        }
        npb = npb.setArguments(new String[]{flags.toString(), String.valueOf(at.getPID())});
        CollectorRunner newProfRunner = new CollectorRunner((IndicatorNotificationsListener)new FakeIndicatorNotificationListener(), npb, (LineProcessor)new MonitorOutputProcessor(), "__EOF__", "prof_monitor");
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.profRunner != null) {
                this.profRunner.shutdown();
            }
            this.profRunner = newProfRunner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        CollectorRunner collectorToStop;
        Object object = this.lock;
        synchronized (object) {
            collectorToStop = this.profRunner;
            this.profRunner = null;
        }
        if (collectorToStop != null) {
            collectorToStop.shutdown();
        }
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus validate(DLightTarget objectToValidate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.validationStatus.isValid()) {
                return this.validationStatus;
            }
            ValidationStatus oldStatus = this.validationStatus;
            ValidationStatus newStatus = this.doValidation(objectToValidate);
            this.notifyStatusChanged(oldStatus, newStatus);
            this.validationStatus = newStatus;
            return newStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.validationStatus = ValidationStatus.initialStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus getValidationStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.validationStatus;
        }
    }

    private ValidationStatus doValidation(DLightTarget target) {
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment env = target.getExecEnv();
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            AsynchronousAction connectAction = ConnectionManager.getInstance().getConnectToAction(env, new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            });
            return ValidationStatus.unknownStatus((String)LLDataCollector.getMessage("ValidationStatus.HostNotConnected"), (AsynchronousAction)connectAction);
        }
        HostInfo.OSFamily osFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            osFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily();
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        if (!(osFamily == HostInfo.OSFamily.LINUX || ALLOW_ON_MACOSX && osFamily == HostInfo.OSFamily.MACOSX)) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.ProfAgent.OSNotSupported"));
        }
        Map<String, File> profAgentsLocal = this.locateProfAgents(env);
        if (profAgentsLocal.isEmpty()) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.AgentNotFound"));
        }
        Map<String, File> profMonitorsLocal = this.locateProfMonitors(env);
        if (profMonitorsLocal.isEmpty()) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.MonitorNotFound"));
        }
        return ValidationStatus.validStatus();
    }

    private void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (!oldStatus.equals((Object)newStatus)) {
            for (ValidationListener vl : this.validationListeners.toArray(new ValidationListener[0])) {
                vl.validationStateChanged((Validateable)this, oldStatus, newStatus);
            }
        }
    }

    public void addValidationListener(ValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(LLDataCollector.class, (String)key);
    }

    private class MonitorOutputProcessor
    implements LineProcessor {
        private float syncPrev = Float.NaN;

        private MonitorOutputProcessor() {
        }

        public void processLine(String line) {
            DataRow row = null;
            if (line.startsWith("cpu:")) {
                String[] times = line.substring(5).split("\t");
                row = new DataRow(LLDataCollectorConfiguration.CPU_TABLE.getColumnNames(), Arrays.asList(Float.valueOf(times[0]), Float.valueOf(times[1])));
            } else if (line.startsWith("mem:")) {
                row = new DataRow(LLDataCollectorConfiguration.MEM_TABLE.getColumnNames(), Arrays.asList(Integer.valueOf(line.substring(5))));
            } else if (line.startsWith("sync:")) {
                String[] fields = line.substring(6).split("\t");
                float syncCurr = Float.parseFloat(fields[0]);
                if (!Float.isNaN(this.syncPrev)) {
                    int threads = Integer.parseInt(fields[1]);
                    row = new DataRow(LLDataCollectorConfiguration.SYNC_TABLE.getColumnNames(), Arrays.asList(Float.valueOf((syncCurr - this.syncPrev) * 100.0f / (float)threads), threads));
                }
                this.syncPrev = syncCurr;
            }
            if (row != null) {
                LLDataCollector.this.notifyIndicators(Collections.singletonList(row));
                LLDataCollector.this.suggestIndicatorsRepaint();
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }

    private class FakeIndicatorNotificationListener
    implements IndicatorNotificationsListener {
        private FakeIndicatorNotificationListener() {
        }

        public void reset() {
            LLDataCollector.this.resetIndicators();
        }

        public void suggestRepaint() {
            LLDataCollector.this.suggestIndicatorsRepaint();
        }

        public void updated(List<DataRow> data) {
            LLDataCollector.this.notifyIndicators(data);
        }
    }
}

