/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.server.http.ServletEndpointContextImpl;
import com.sun.xml.rpc.server.http.ea.ImplementorFactory;
import com.sun.xml.rpc.server.http.ea.WSDLPublisher;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.ServletSecondDelegate;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class JAXRPCServletDelegate
implements ServletDelegate {
    private ServletConfig _servletConfig;
    private ServletContext _servletContext;
    private ImplementorFactory _implementorFactory;
    private WSDLPublisher _wsdlPublisher;
    private Localizer _localizer;
    private Map _localizerMap;
    private LocalizableMessageFactory _messageFactory;
    private static final String CONFIG_FILE_PROPERTY = "configuration.file";
    private static final String WSDL_QUERY_STRING = "WSDL";
    private static final String FAULT_STRING_MISSING_PORT = "Missing port information";
    private static final String FAULT_STRING_PORT_NOT_FOUND = "Port not found";
    private static final String FAULT_STRING_INTERNAL_SERVER_ERROR = "Internal Server Error";
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.webservices.rpc.server.http");

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this._servletConfig = servletConfig;
            this._servletContext = servletConfig.getServletContext();
            this._localizer = new Localizer();
            this._localizerMap = new HashMap();
            this._localizerMap.put(this._localizer.getLocale(), this._localizer);
            this._messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info(this._localizer.localize(this._messageFactory.getMessage("info.servlet.initializing")));
            }
            this._implementorFactory = new ImplementorFactory(servletConfig, this.getConfigFile(servletConfig));
            this._wsdlPublisher = new WSDLPublisher(servletConfig, this.getConfigFile(servletConfig));
        }
        catch (JAXRPCServletException e) {
            String message = this._localizer.localize(e);
            throw new ServletException(message);
        }
        catch (Throwable e) {
            String message = this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowable", new Object[]{e}));
            throw new ServletException(message);
        }
    }

    protected InputStream getConfigFile(ServletConfig servletConfig) {
        String configFilePath = servletConfig.getInitParameter(CONFIG_FILE_PROPERTY);
        if (configFilePath == null) {
            throw new JAXRPCServletException("error.servlet.init.config.parameter.missing", new Object[]{CONFIG_FILE_PROPERTY});
        }
        InputStream configFile = this._servletContext.getResourceAsStream(configFilePath);
        if (configFile == null) {
            throw new JAXRPCServletException("error.servlet.init.config.fileNotFound", new Object[]{configFilePath});
        }
        return configFile;
    }

    public void destroy() {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info(this._localizer.localize(this._messageFactory.getMessage("info.servlet.destroying")));
        }
        if (this._implementorFactory != null) {
            this._implementorFactory.destroy();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            MimeHeaders headers = JAXRPCServletDelegate.getHeaders(req);
            ServletInputStream is = req.getInputStream();
            byte[] bytes = JAXRPCServletDelegate.readFully((InputStream)is);
            int length = req.getContentLength() == -1 ? bytes.length : req.getContentLength();
            ByteInputStream in = new ByteInputStream(bytes, length);
            SOAPMessageContext messageContext = new SOAPMessageContext();
            SOAPMessage message = messageContext.createMessage(headers, in);
            if (message == null) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.info(this._localizer.localize(this._messageFactory.getMessage("info.servlet.gotEmptyRequestMessage")));
                }
                messageContext.writeInternalServerErrorResponse();
            } else {
                messageContext.setMessage(message);
                String pathInfo = req.getPathInfo();
                if (pathInfo != null && pathInfo.length() > 1) {
                    Implementor implementor;
                    String name;
                    String string2 = name = pathInfo.charAt(0) == '/' ? pathInfo.substring(1) : pathInfo;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest(this._localizer.localize(this._messageFactory.getMessage("trace.servlet.requestForPortNamed", name)));
                    }
                    if ((implementor = this._implementorFactory.getImplementorFor(name)) == null) {
                        _logger.severe(this._localizer.localize(this._messageFactory.getMessage("error.servlet.noImplementorForPort", name)));
                        messageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, "Port not found(\"" + name + "\")");
                    } else {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest(this._localizer.localize(this._messageFactory.getMessage("trace.servlet.handingRequestOverToImplementor", implementor.toString())));
                        }
                        ServletEndpointContextImpl endpointContext = implementor.getContext();
                        try {
                            endpointContext.setMessageContext(messageContext);
                            endpointContext.setHttpServletRequest(req);
                            messageContext.setProperty("com.sun.xml.rpc.server.http.ServletContext", this._servletContext);
                            messageContext.setProperty("com.sun.xml.rpc.server.http.HttpServletRequest", req);
                            messageContext.setProperty("com.sun.xml.rpc.server.http.HttpServletResponse", resp);
                            messageContext.setProperty("com.sun.xml.rpc.server.http.Implementor", implementor);
                            implementor.getTie().handle(messageContext);
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        finally {
                            endpointContext.clear();
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest(this._localizer.localize(this._messageFactory.getMessage("trace.servlet.gotResponseFromImplementor", implementor.toString())));
                        }
                        this._implementorFactory.releaseImplementor(name, implementor);
                    }
                } else {
                    _logger.severe(this._localizer.localize(this._messageFactory.getMessage("error.servlet.noPortSpecified")));
                    messageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, FAULT_STRING_MISSING_PORT);
                }
            }
            SOAPMessage reply = messageContext.getMessage();
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            this.writeReply(resp, messageContext);
        }
        catch (JAXRPCExceptionBase e) {
            _logger.log(Level.SEVERE, this._localizer.localize(e), e);
            resp.setStatus(500);
            try {
                SOAPMessageContext messageContext = new SOAPMessageContext();
                messageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, "Internal Server Error (" + this._localizer.localize(e) + ")");
                this.writeReply(resp, messageContext);
            }
            catch (Throwable e2) {
                _logger.log(Level.SEVERE, this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowableWhileRecovering", new Object[]{e2})), e2);
            }
        }
        catch (Throwable e) {
            if (e instanceof Localizable) {
                _logger.log(Level.SEVERE, this._localizer.localize((Localizable)((Object)e)), e);
            } else {
                _logger.log(Level.SEVERE, this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowable", new Object[]{e})), e);
            }
            resp.setStatus(500);
            try {
                SOAPMessageContext messageContext = new SOAPMessageContext();
                messageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, "Internal Server Error (" + e.toString() + ")");
                this.writeReply(resp, messageContext);
            }
            catch (Throwable e2) {
                _logger.log(Level.SEVERE, this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowableWhileRecovering", new Object[]{e2})), e2);
            }
        }
    }

    protected void writeReply(HttpServletResponse resp, SOAPMessageContext messageContext) throws SOAPException, IOException {
        SOAPMessage reply = messageContext.getMessage();
        if (messageContext.isFailure()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this._localizer.localize(this._messageFactory.getMessage("trace.servlet.writingFaultResponse")));
            }
            resp.setStatus(500);
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this._localizer.localize(this._messageFactory.getMessage("trace.servlet.writingSuccessResponse")));
            }
            resp.setStatus(200);
        }
        ServletOutputStream os = resp.getOutputStream();
        String[] headers = reply.getMimeHeaders().getHeader("Content-Type");
        if (headers != null && headers.length > 0) {
            resp.setContentType(headers[0]);
        } else {
            resp.setContentType("text/xml");
        }
        JAXRPCServletDelegate.putHeaders(reply.getMimeHeaders(), resp);
        reply.writeTo((OutputStream)os);
        os.flush();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Localizer localizer = this.getLocalizerFor((ServletRequest)request);
        try {
            if (request.getPathInfo() != null) {
                response.setContentType("text/html");
                response.setStatus(200);
                PrintWriter httpOut = response.getWriter();
                httpOut.println("<html>");
                httpOut.println("<head><title>");
                httpOut.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.title")));
                httpOut.println("</title></head><body>");
                httpOut.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body1")));
                String requestURI = request.getRequestURI();
                int i = requestURI.lastIndexOf(request.getPathInfo());
                if (i == -1) {
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body2")));
                } else {
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body3a")));
                    httpOut.println(requestURI.substring(0, i));
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body3b")));
                }
                httpOut.println("</body></html>");
            } else if (request.getQueryString() != null && request.getQueryString().equals(WSDL_QUERY_STRING)) {
                if (this._wsdlPublisher.hasDocument()) {
                    this._wsdlPublisher.publish(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI() + "/", response);
                } else {
                    response.setContentType("text/html");
                    response.setStatus(200);
                    PrintWriter httpOut = response.getWriter();
                    httpOut.println("<html>");
                    httpOut.println("<head><title>");
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.wsdlPage.title")));
                    httpOut.println("</title></head><body>");
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.wsdlPage.noWsdl")));
                    httpOut.println("</body></html>");
                }
            } else {
                response.setContentType("text/html");
                response.setStatus(200);
                PrintWriter httpOut = response.getWriter();
                httpOut.println("<html>");
                httpOut.println("<head><title>");
                httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.title")));
                httpOut.println("</title></head><body>");
                httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body1")));
                if (this._implementorFactory != null) {
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body2a")));
                    Iterator iterator = this._implementorFactory.names();
                    if (!iterator.hasNext()) {
                        httpOut.print("NONE");
                    } else {
                        boolean first = true;
                        while (iterator.hasNext()) {
                            String portName = (String)iterator.next();
                            if (!first) {
                                httpOut.print(", ");
                            }
                            httpOut.print('\"');
                            httpOut.print(portName);
                            String portURI = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI() + "/" + portName;
                            httpOut.print('\"');
                            httpOut.print(" (");
                            httpOut.print(portURI);
                            httpOut.print(')');
                            first = false;
                        }
                    }
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body2b")));
                    if (this._wsdlPublisher.hasDocument()) {
                        httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body3a")));
                        httpOut.println(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI() + "?WSDL");
                        httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body3b")));
                    }
                } else {
                    httpOut.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body4")));
                }
                httpOut.println("</body></html>");
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Localizer getLocalizerFor(ServletRequest request) {
        Locale locale = request.getLocale();
        if (locale.equals(this._localizer.getLocale())) {
            return this._localizer;
        }
        Map map = this._localizerMap;
        synchronized (map) {
            Localizer localizer = (Localizer)this._localizerMap.get(locale);
            if (localizer == null) {
                localizer = new Localizer(locale);
                this._localizerMap.put(locale, localizer);
            }
            return localizer;
        }
    }

    protected static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration enums = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enums.hasMoreElements()) {
            String headerName = (String)enums.nextElement();
            String headerValue = req.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    protected static void putHeaders(MimeHeaders headers, HttpServletResponse res) {
        headers.removeHeader("Content-Type");
        headers.removeHeader("Content-Length");
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            res.setHeader(header.getName(), header.getValue());
        }
    }

    protected static byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }

    public void registerEndpointUrlPattern(RuntimeEndpointInfo info) {
        throw new UnsupportedOperationException();
    }

    public void setSecondDelegate(ServletSecondDelegate delegate) {
        throw new UnsupportedOperationException();
    }

    public void setSystemHandlerDelegate(SystemHandlerDelegate systemHandlerDelegate) {
        throw new UnsupportedOperationException();
    }
}

