/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public class RemoteUtil {
    private static final Map<ExecutionEnvironment, String> homeDirs = new LinkedHashMap<ExecutionEnvironment, String>();
    public static final Logger LOGGER = Logger.getLogger("cnd.remote.logger");

    private RemoteUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHomeDirectory(ExecutionEnvironment execEnv) {
        CndUtils.assertNonUiThread();
        String dir = null;
        Map<ExecutionEnvironment, String> map = homeDirs;
        synchronized (map) {
            if (homeDirs.containsKey(execEnv)) {
                return homeDirs.get(execEnv);
            }
        }
        try {
            String s;
            if (Boolean.getBoolean("cnd.emulate.null.home.dir")) {
                return null;
            }
            ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)"sh", (String[])new String[]{"-c", "cd; /bin/pwd"});
            if (res.isOK() && HostInfoProvider.fileExists((ExecutionEnvironment)execEnv, (String)(s = res.output))) {
                dir = s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map = homeDirs;
        synchronized (map) {
            homeDirs.put(execEnv, dir);
        }
        return dir;
    }

    public static boolean isForeign(ExecutionEnvironment execEnv) {
        String protocolSeparator;
        if (execEnv == null) {
            return false;
        }
        String id = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv);
        if (id.indexOf(protocolSeparator = "://") < 0) {
            return false;
        }
        return !id.startsWith("ssh" + protocolSeparator);
    }

    public static String getDisplayName(ExecutionEnvironment execEnv) {
        ServerRecord rec = ServerList.get((ExecutionEnvironment)execEnv);
        if (rec == null) {
            return execEnv.getDisplayName();
        }
        return rec.getDisplayName();
    }

    public static void checkSetupAfterConnection(ExecutionEnvironment env) {
        RemoteServerRecord record = (RemoteServerRecord)ServerList.get((ExecutionEnvironment)env);
        if (!record.isOnline()) {
            record.resetOfflineState();
            record.init(null);
            if (record.isOnline()) {
                ToolsCacheManager cacheManager = ToolsCacheManager.createInstance((boolean)true);
                CompilerSetManager csm = cacheManager.getCompilerSetManagerCopy(record.getExecutionEnvironment(), false);
                csm.initialize(false, true, null);
                cacheManager.applyChanges();
            }
        }
    }

    public static class PrefixedLogger {
        private final String prefix;

        public PrefixedLogger(String prefix) {
            this.prefix = prefix;
        }

        public void log(Level level, String format, Object ... args) {
            if (LOGGER.isLoggable(level)) {
                String text = String.format(format, args);
                text = this.prefix + ": " + text;
                LOGGER.log(level, text);
            }
        }
    }
}

