/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.NameCache;
import org.netbeans.modules.cnd.classview.PersistentKey;
import org.netbeans.modules.cnd.classview.SmartChangeEvent;
import org.netbeans.modules.cnd.classview.UpdatebleHost;

public class ChildrenUpdater {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.key-events");
    private Map<CsmProject, Map<PersistentKey, UpdatebleHost>> map = new HashMap<CsmProject, Map<PersistentKey, UpdatebleHost>>();

    public Object getLock(CsmProject project) {
        Map<PersistentKey, UpdatebleHost> lock = this.map.get(project);
        if (lock == null) {
            return this;
        }
        return lock;
    }

    public void register(CsmProject project, PersistentKey host, UpdatebleHost children) {
        Map<PersistentKey, UpdatebleHost> p = this.map.get(project);
        if (p == null) {
            p = new HashMap<PersistentKey, UpdatebleHost>();
            this.map.put(project, p);
        }
        p.put(host, children);
        if (traceEvents) {
            System.out.println("Register Children Updater on key " + host.toString());
        }
    }

    public void unregister() {
        if (traceEvents) {
            System.out.println("Clean Children Updater");
        }
        this.map.clear();
        NameCache.getManager().dispose();
    }

    public void unregister(CsmProject project) {
        if (traceEvents) {
            System.out.println("Clean Children Updater on project " + project.getName());
        }
        this.map.remove(project);
    }

    public void unregister(CsmProject project, PersistentKey host) {
        Map<PersistentKey, UpdatebleHost> p = this.map.get(project);
        if (p != null) {
            if (traceEvents) {
                System.out.println("Clean Children Updater on key " + host.toString());
            }
            p.remove(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SmartChangeEvent e) {
        if (this.map.size() == 0) {
            return;
        }
        for (Map.Entry<CsmProject, SmartChangeEvent.Storage> entry : e.getChangedProjects().entrySet()) {
            CsmProject project = entry.getKey();
            try {
                if (!this.map.containsKey(project) || !project.isValid()) continue;
                Object object = this.getLock(project);
                synchronized (object) {
                    SmartChangeEvent.Storage storage = entry.getValue();
                    this.update(project, storage);
                }
            }
            catch (AssertionError ex) {
                ((Throwable)((Object)ex)).printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void update(CsmProject project, SmartChangeEvent.Storage e) {
        UpdatebleHost keys;
        HashSet<UpdatebleHost> toFlush = new HashSet<UpdatebleHost>();
        for (CsmNamespace ns : e.getNewNamespaces()) {
            keys = this.findHost(project, ns);
            if (keys == null || !keys.newNamespsce(ns)) continue;
            toFlush.add(keys);
        }
        for (CsmNamespace ns : e.getRemovedNamespaces()) {
            keys = this.findHost(project, ns);
            if (keys == null || !keys.removeNamespsce(ns)) continue;
            toFlush.add(keys);
        }
        for (CsmOffsetableDeclaration decl : e.getNewDeclarations()) {
            for (UpdatebleHost updatebleHost : this.findHost(project, decl)) {
                if (!updatebleHost.newDeclaration(decl)) continue;
                toFlush.add(updatebleHost);
            }
        }
        for (CsmOffsetableDeclaration decl : e.getRemovedDeclarations()) {
            for (UpdatebleHost updatebleHost : this.findHost(project, decl)) {
                if (!updatebleHost.removeDeclaration(decl)) continue;
                toFlush.add(updatebleHost);
            }
        }
        ArrayList<CsmOffsetableDeclaration> recursive = new ArrayList<CsmOffsetableDeclaration>();
        ArrayList<Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>> change = new ArrayList<Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>>(this.packChangedDeclarations(e.getChangedDeclarations()));
        for (Map.Entry entry : change) {
            for (UpdatebleHost keys3 : this.findHost(project, (CsmOffsetableDeclaration)entry.getKey())) {
                if (!keys3.changeDeclaration((CsmOffsetableDeclaration)entry.getKey(), (CsmOffsetableDeclaration)entry.getValue())) continue;
                toFlush.add(keys3);
            }
            UpdatebleHost keys4 = this.findNode(project, (CsmOffsetableDeclaration)entry.getValue());
            if (keys4 == null || !keys4.reset((CsmOffsetableDeclaration)entry.getValue(), recursive)) continue;
            toFlush.add(keys4);
        }
        while (recursive.size() > 0) {
            ArrayList list = new ArrayList(recursive);
            recursive.clear();
            for (CsmOffsetableDeclaration decl : list) {
                UpdatebleHost keys2 = this.findNode(project, decl);
                if (keys2 == null || !keys2.reset(decl, recursive)) continue;
                toFlush.add(keys2);
            }
        }
        if (toFlush.size() > 0) {
            for (UpdatebleHost updatebleHost : toFlush) {
                updatebleHost.flush();
            }
        }
    }

    private Collection<Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>> packChangedDeclarations(Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> changed) {
        HashMap<PersistentKey, Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>> packed = new HashMap<PersistentKey, Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>>();
        for (Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration> decl : changed.entrySet()) {
            packed.put(PersistentKey.createKey(decl.getKey()), decl);
        }
        return packed.values();
    }

    private UpdatebleHost findHost(CsmProject project, CsmNamespace ns) {
        if (!project.isValid()) {
            return null;
        }
        Map<PersistentKey, UpdatebleHost> hosts = this.map.get(project);
        if (hosts == null) {
            return null;
        }
        CsmNamespace parent = ns.getParent();
        if (parent != null) {
            return hosts.get(PersistentKey.createKey(parent));
        }
        return null;
    }

    private UpdatebleHost findNode(CsmProject project, CsmOffsetableDeclaration decl) {
        CsmFile file;
        CsmCompoundClassifier cls;
        CsmClassifier classifier;
        CsmTypedef def;
        if (!project.isValid()) {
            return null;
        }
        Map<PersistentKey, UpdatebleHost> hosts = this.map.get(project);
        if (hosts == null) {
            return null;
        }
        if (CsmKindUtilities.isClass((CsmObject)decl)) {
            CsmFile file2;
            CsmClass cls2 = (CsmClass)decl;
            if (cls2.isValid() && (file2 = cls2.getContainingFile()) != null && file2.isValid()) {
                return hosts.get(PersistentKey.createKey(cls2));
            }
        } else if (CsmKindUtilities.isEnum((CsmObject)decl)) {
            CsmFile file3;
            CsmEnum cls3 = (CsmEnum)decl;
            if (cls3.isValid() && (file3 = cls3.getContainingFile()) != null && file3.isValid()) {
                return hosts.get(PersistentKey.createKey(cls3));
            }
        } else if (CsmKindUtilities.isTypedef((CsmObject)decl) && (def = (CsmTypedef)decl).isTypeUnnamed() && (classifier = def.getType().getClassifier()) instanceof CsmCompoundClassifier && (cls = (CsmCompoundClassifier)classifier).isValid() && cls.getName().length() == 0 && (file = cls.getContainingFile()) != null && file.isValid()) {
            return hosts.get(PersistentKey.createKey(def));
        }
        return null;
    }

    private List<UpdatebleHost> findHost(CsmProject project, CsmOffsetableDeclaration decl) {
        CsmFile file;
        CsmClass cls;
        CsmScope scope;
        UpdatebleHost host;
        CsmFile file2;
        CsmClass cls2;
        ArrayList<UpdatebleHost> res = new ArrayList<UpdatebleHost>();
        if (!project.isValid()) {
            return res;
        }
        Map<PersistentKey, UpdatebleHost> hosts = this.map.get(project);
        if (hosts == null) {
            return res;
        }
        if (CsmKindUtilities.isFriendMethod((CsmObject)decl) && (cls2 = ((CsmFriendFunction)decl).getContainingClass()) != null && cls2.isValid() && (file2 = cls2.getContainingFile()) != null && file2.isValid() && (host = hosts.get(PersistentKey.createKey(cls2))) != null) {
            res.add(host);
        }
        if (CsmKindUtilities.isClass((CsmObject)(scope = decl.getScope()))) {
            UpdatebleHost host2;
            cls = (CsmClass)scope;
            if (cls.isValid() && (file = cls.getContainingFile()) != null && file.isValid() && (host2 = hosts.get(PersistentKey.createKey(cls))) != null) {
                res.add(host2);
            }
        } else if (CsmKindUtilities.isEnum((CsmObject)scope)) {
            UpdatebleHost host3;
            cls = (CsmEnum)scope;
            if (cls.isValid() && (file = cls.getContainingFile()) != null && file.isValid() && (host3 = hosts.get(PersistentKey.createKey(cls))) != null) {
                res.add(host3);
            }
        } else if (CsmKindUtilities.isNamespace((Object)scope)) {
            cls = (CsmNamespace)scope;
            host = hosts.get(PersistentKey.createKey(cls));
            if (host != null) {
                res.add(host);
            }
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
            UpdatebleHost host4;
            cls = (CsmNamespaceDefinition)scope;
            file = cls.getContainingFile();
            if (file != null && file.isValid() && (host4 = hosts.get(PersistentKey.createKey(cls.getNamespace()))) != null) {
                res.add(host4);
            }
        } else if (CsmKindUtilities.isFile((CsmObject)scope) && (cls = (CsmFile)scope).isValid() && (host = hosts.get(PersistentKey.createKey(project.getGlobalNamespace()))) != null) {
            res.add(host);
        }
        return res;
    }
}

