/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.ui.options.general.AdvancedProxyPanel;
import org.netbeans.core.ui.options.general.GeneralOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private GeneralOptionsModel model;
    private HtmlBrowser.FactoryEditor editor;
    private AdvancedProxyPanel advancedPanel;
    private boolean valid = true;
    private JButton bMoreProxy;
    private JComboBox cbWebBrowser;
    private JButton editBrowserButton;
    private JLabel errorLabel;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JCheckBox jUsageCheck;
    private JLabel lProxyHost;
    private JLabel lProxyPort;
    private JLabel lUsage;
    private JLabel lWebBrowser;
    private JLabel lWebProxy;
    private JLabel lblLearnMore;
    private JLabel lblUsageInfo;
    private JRadioButton rbHTTPProxy;
    private JRadioButton rbNoProxy;
    private JRadioButton rbUseSystemProxy;
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;

    public GeneralOptionsPanel() {
        this.initComponents();
        Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (nbErrorForeground == null) {
            nbErrorForeground = new Color(255, 0, 0);
        }
        this.errorLabel.setForeground(nbErrorForeground);
        Image img = ImageUtilities.loadImage((String)"org/netbeans/core/ui/resources/error.gif");
        this.errorLabel.setIcon(new ImageIcon(img));
        this.errorLabel.setVisible(false);
        GeneralOptionsPanel.loc(this.lWebBrowser, "Web_Browser");
        GeneralOptionsPanel.loc(this.lWebProxy, "Web_Proxy");
        GeneralOptionsPanel.loc(this.lProxyHost, "Proxy_Host");
        GeneralOptionsPanel.loc(this.lProxyPort, "Proxy_Port");
        this.cbWebBrowser.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Web_Browser", new String[0]));
        this.cbWebBrowser.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Web_Browser", new String[0]));
        this.tfProxyHost.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Host", new String[0]));
        this.tfProxyHost.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Host", new String[0]));
        this.tfProxyPort.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Port", new String[0]));
        this.tfProxyPort.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Port", new String[0]));
        this.rbNoProxy.addActionListener(this);
        this.rbUseSystemProxy.addActionListener(this);
        this.rbHTTPProxy.addActionListener(this);
        this.cbWebBrowser.addActionListener(this);
        this.tfProxyHost.addActionListener(this);
        this.tfProxyPort.addActionListener(this);
        this.tfProxyPort.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GeneralOptionsPanel.this.validatePortValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GeneralOptionsPanel.this.validatePortValue();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GeneralOptionsPanel.this.validatePortValue();
            }
        });
        ButtonGroup bgProxy = new ButtonGroup();
        bgProxy.add(this.rbNoProxy);
        bgProxy.add(this.rbUseSystemProxy);
        bgProxy.add(this.rbHTTPProxy);
        GeneralOptionsPanel.loc(this.rbNoProxy, "No_Proxy");
        GeneralOptionsPanel.loc(this.rbUseSystemProxy, "Use_System_Proxy_Settings");
        GeneralOptionsPanel.loc(this.rbHTTPProxy, "Use_HTTP_Proxy");
        GeneralOptionsPanel.loc(this.lUsage, "Usage_Statistics");
        this.lUsage.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Statistics", new String[0]));
        this.lUsage.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Statistics", new String[0]));
        GeneralOptionsPanel.loc(this.jUsageCheck, "Usage_Check");
        this.jUsageCheck.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Check", new String[0]));
        this.jUsageCheck.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Check", new String[0]));
        this.lblUsageInfo.setText(GeneralOptionsPanel.loc("CTL_Usage_Info", new String[0]));
        this.lblUsageInfo.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Info", new String[0]));
        this.lblUsageInfo.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Info", new String[0]));
        this.lblLearnMore.setText(GeneralOptionsPanel.loc("CTL_Learn_More", new String[0]));
        this.lblLearnMore.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Learn_More", new String[0]));
        this.lblLearnMore.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Learn_More", new String[0]));
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
        if (System.getProperty("nb.show.statistics.ui") == null) {
            this.jSeparator3.setVisible(false);
            this.lUsage.setVisible(false);
            this.jUsageCheck.setVisible(false);
            this.lblUsageInfo.setVisible(false);
            this.lblLearnMore.setVisible(false);
        }
    }

    private void initComponents() {
        this.lWebBrowser = new JLabel();
        this.cbWebBrowser = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.lWebProxy = new JLabel();
        this.rbNoProxy = new JRadioButton();
        this.rbUseSystemProxy = new JRadioButton();
        this.rbHTTPProxy = new JRadioButton();
        this.lProxyHost = new JLabel();
        this.tfProxyHost = new JTextField();
        this.lProxyPort = new JLabel();
        this.tfProxyPort = new JTextField();
        this.bMoreProxy = new JButton();
        this.editBrowserButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.lUsage = new JLabel();
        this.jUsageCheck = new JCheckBox();
        this.lblUsageInfo = new JLabel();
        this.lblLearnMore = new JLabel();
        this.errorLabel = new JLabel();
        this.lWebBrowser.setLabelFor(this.cbWebBrowser);
        Mnemonics.setLocalizedText((JLabel)this.lWebBrowser, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.lWebBrowser.text"));
        Mnemonics.setLocalizedText((JLabel)this.lWebProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_lWebProxy"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbNoProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbNoProxy.text"));
        this.rbNoProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbUseSystemProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbUseSystemProxy.text"));
        this.rbUseSystemProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbHTTPProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Use_HTTP_Proxy", (Object[])new Object[0]));
        this.rbHTTPProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lProxyHost.setLabelFor(this.tfProxyHost);
        Mnemonics.setLocalizedText((JLabel)this.lProxyHost, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Host", (Object[])new Object[0]));
        this.tfProxyHost.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GeneralOptionsPanel.this.tfProxyHostFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GeneralOptionsPanel.this.tfProxyHostFocusLost(evt);
            }
        });
        this.lProxyPort.setLabelFor(this.tfProxyPort);
        Mnemonics.setLocalizedText((JLabel)this.lProxyPort, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Port", (Object[])new Object[0]));
        this.tfProxyPort.setColumns(4);
        this.tfProxyPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GeneralOptionsPanel.this.tfProxyPortFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GeneralOptionsPanel.this.tfProxyPortFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bMoreProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy"));
        this.bMoreProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralOptionsPanel.this.bMoreProxyActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editBrowserButton, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.text"));
        this.editBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralOptionsPanel.this.editBrowserButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lUsage, (String)"Usage Statistics:");
        Mnemonics.setLocalizedText((AbstractButton)this.jUsageCheck, (String)"Help us improve the NetBeans IDE by providing anonymous usage data");
        Mnemonics.setLocalizedText((JLabel)this.lblUsageInfo, (String)"<html>The usage statistics help us better understand user\nrequirements and prioritize improvements in future releases. We will never\nreverse-engineer the collected data to find specific details about your projects.</html>");
        this.lblUsageInfo.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.lblLearnMore, (String)"<html><font color=\"#0000FF\" <u>Learn more</u></font></html>");
        this.lblLearnMore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GeneralOptionsPanel.this.lblLearnMoreMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                GeneralOptionsPanel.this.lblLearnMoreMousePressed(evt);
            }
        });
        this.errorLabel.setHorizontalAlignment(4);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lWebBrowser).addGap(18, 18, 18).addComponent(this.cbWebBrowser, 0, 1294, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editBrowserButton)).addComponent(this.jSeparator2, -1, 1494, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lWebProxy).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbNoProxy).addComponent(this.rbUseSystemProxy).addComponent(this.rbHTTPProxy).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bMoreProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel, -1, 1254, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lProxyHost).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfProxyHost, -1, 1137, Short.MAX_VALUE).addGap(12, 12, 12).addComponent(this.lProxyPort).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfProxyPort, -2, -1, -2)))))).addComponent(this.jSeparator3, -1, 1494, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lUsage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblUsageInfo, -1, 1365, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jUsageCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 838, Short.MAX_VALUE)).addComponent(this.lblLearnMore, -2, -1, -2)))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lWebBrowser).addComponent(this.cbWebBrowser, -2, -1, -2).addComponent(this.editBrowserButton)).addGap(18, 18, 18).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.rbNoProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbUseSystemProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbHTTPProxy)).addComponent(this.lWebProxy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lProxyHost).addComponent(this.tfProxyPort, -2, -1, -2).addComponent(this.tfProxyHost, -2, -1, -2).addComponent(this.lProxyPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bMoreProxy).addComponent(this.errorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lUsage).addComponent(this.jUsageCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblUsageInfo, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLearnMore, -2, -1, -2).addContainerGap(24, Short.MAX_VALUE)));
        this.bMoreProxy.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy.AN"));
        this.bMoreProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy.AD"));
        this.editBrowserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.AN"));
        this.editBrowserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.AD"));
    }

    private void editBrowserButtonActionPerformed(ActionEvent evt) {
        final WebBrowsersOptionsModel wbModel = new WebBrowsersOptionsModel();
        WebBrowsersOptionsPanel wbPanel = new WebBrowsersOptionsPanel(wbModel, this.cbWebBrowser.getSelectedItem().toString());
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)wbPanel, GeneralOptionsPanel.loc("LBL_WebBrowsersPanel_Title", new String[0]), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogDescriptor.OK_OPTION.equals(e.getSource())) {
                    wbModel.applyChanges();
                } else {
                    wbModel.discardChanges();
                }
            }
        });
        DialogDisplayer.getDefault().createDialog(dialogDesc).setVisible(true);
        if (dialogDesc.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.updateWebBrowsers();
            int items = this.cbWebBrowser.getItemCount();
            for (int i = 0; i < items; ++i) {
                Object item = this.cbWebBrowser.getItemAt(i);
                if (!item.equals(wbModel.getSelectedValue())) continue;
                this.cbWebBrowser.setSelectedItem(item);
                break;
            }
        }
    }

    private void bMoreProxyActionPerformed(ActionEvent evt) {
        assert (this.model != null) : "Model found when AdvancedProxyPanel is created";
        if (this.advancedPanel == null) {
            this.advancedPanel = new AdvancedProxyPanel(this.model);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)this.advancedPanel, GeneralOptionsPanel.loc("LBL_AdvancedProxyPanel_Title", new String[0]));
        this.advancedPanel.setDialogDescriptor(dd);
        dd.createNotificationLineSupport();
        this.advancedPanel.update(this.tfProxyHost.getText(), this.tfProxyPort.getText());
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dd.getValue())) {
            this.advancedPanel.applyChanges();
            this.tfProxyHost.setText(this.model.getHttpProxyHost());
            this.tfProxyPort.setText(this.model.getHttpProxyPort());
            this.isChanged();
        }
    }

    private void tfProxyPortFocusLost(FocusEvent evt) {
        this.tfProxyPort.select(0, 0);
    }

    private void tfProxyHostFocusLost(FocusEvent evt) {
        this.tfProxyHost.select(0, 0);
    }

    private void tfProxyPortFocusGained(FocusEvent evt) {
        this.tfProxyPort.setCaretPosition(0);
        this.tfProxyPort.selectAll();
    }

    private void tfProxyHostFocusGained(FocusEvent evt) {
        this.tfProxyHost.setCaretPosition(0);
        this.tfProxyHost.selectAll();
    }

    private void lblLearnMoreMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void lblLearnMoreMousePressed(MouseEvent evt) {
        URL u = null;
        try {
            u = new URL(GeneralOptionsPanel.loc("METRICS_INFO_URL", new String[0]));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (u != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(u);
        }
    }

    private void validatePortValue() {
        this.clearError();
        boolean oldValid = this.valid;
        this.valid = this.isPortValid();
        if (!this.valid) {
            this.showError(GeneralOptionsPanel.loc("LBL_GeneralOptionsPanel_PortError", new String[0]));
        }
        if (oldValid != this.valid) {
            this.firePropertyChange("valid", oldValid, this.valid);
        }
    }

    private boolean isPortValid() {
        String port = this.tfProxyPort.getText();
        boolean portStatus = true;
        if (port != null && port.length() > 0) {
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException nfex) {
                portStatus = false;
            }
        }
        return portStatus;
    }

    private void showError(String message) {
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(message);
    }

    private void clearError() {
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(GeneralOptionsPanel.class, (String)key, (Object[])params);
    }

    private String getUseSystemProxyToolTip() {
        if (this.rbUseSystemProxy.isSelected()) {
            String toolTip;
            String sHost = System.getProperty("http.proxyHost");
            if (sHost == null || sHost.trim().length() == 0) {
                toolTip = GeneralOptionsPanel.loc("GeneralOptionsPanel_rbUseSystemProxy_Direct", new String[0]);
            } else {
                String sPort = System.getProperty("http.proxyPort");
                toolTip = GeneralOptionsPanel.loc("GeneralOptionsPanel_rbUseSystemProxy_Format", sHost, sPort);
            }
            return toolTip;
        }
        return null;
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_" + key, new String[0]));
            c.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_" + key, new String[0]));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)GeneralOptionsPanel.loc("CTL_" + key, new String[0]));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)GeneralOptionsPanel.loc("CTL_" + key, new String[0]));
        }
    }

    void update() {
        this.model = new GeneralOptionsModel();
        switch (this.model.getProxyType()) {
            case 0: {
                this.rbNoProxy.setSelected(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            case 1: {
                this.rbUseSystemProxy.setSelected(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            default: {
                this.rbHTTPProxy.setSelected(true);
                this.tfProxyHost.setEnabled(true);
                this.tfProxyPort.setEnabled(true);
                this.bMoreProxy.setEnabled(true);
            }
        }
        this.tfProxyHost.setText(this.model.getHttpProxyHost());
        this.tfProxyPort.setText(this.model.getHttpProxyPort());
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
        this.jUsageCheck.setSelected(this.model.getUsageStatistics());
        this.updateWebBrowsers();
        this.changed = false;
    }

    private void updateWebBrowsers() {
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.cbWebBrowser.removeAllItems();
        String[] tags = this.editor.getTags();
        if (tags.length > 0) {
            for (String tag : tags) {
                this.cbWebBrowser.addItem(tag);
            }
            this.cbWebBrowser.setSelectedItem(this.editor.getAsText());
            this.lWebBrowser.setVisible(true);
            this.cbWebBrowser.setVisible(true);
            this.editBrowserButton.setVisible(true);
            this.jSeparator2.setVisible(true);
        } else {
            this.lWebBrowser.setVisible(false);
            this.cbWebBrowser.setVisible(false);
            this.editBrowserButton.setVisible(false);
            this.jSeparator2.setVisible(false);
        }
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        if (this.rbNoProxy.isSelected()) {
            this.model.setProxyType(0);
        } else if (this.rbUseSystemProxy.isSelected()) {
            this.model.setProxyType(1);
        } else {
            this.model.setProxyType(2);
        }
        this.model.setHttpProxyHost(this.tfProxyHost.getText());
        this.model.setHttpProxyPort(this.tfProxyPort.getText());
        if (this.model.useProxyAllProtocols()) {
            this.model.setHttpsProxyHost(this.tfProxyHost.getText());
            this.model.setHttpsProxyPort(this.tfProxyPort.getText());
            this.model.setSocksHost(this.tfProxyHost.getText());
            this.model.setSocksPort(this.tfProxyPort.getText());
        }
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.editor.setAsText((String)this.cbWebBrowser.getSelectedItem());
        this.model.setUsageStatistics(this.jUsageCheck.isSelected());
    }

    void cancel() {
    }

    boolean dataValid() {
        return this.isPortValid();
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        if (!this.tfProxyHost.getText().equals(this.model.getHttpProxyHost())) {
            return true;
        }
        if (!this.tfProxyPort.getText().equals(this.model.getHttpProxyPort())) {
            return true;
        }
        return this.changed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.changed = true;
        this.tfProxyHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfProxyPort.setEnabled(this.rbHTTPProxy.isSelected());
        this.bMoreProxy.setEnabled(this.rbHTTPProxy.isSelected());
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
    }
}

