/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RefactoringInfo {
    private AbstractRefactoring refactoring;
    private ChangeType changeType;
    private FileObject[] origFiles;
    private Map<FileObject, String> originalFiles;
    private Map<FileObject, FormRefactoringUpdate> fileToUpdateMap = new HashMap<FileObject, FormRefactoringUpdate>();

    RefactoringInfo(AbstractRefactoring refactoring, ChangeType changeType, FileObject[] files, String[] oldNames) {
        this.refactoring = refactoring;
        this.changeType = changeType;
        HashMap<FileObject, String> fileMap = new HashMap<FileObject, String>();
        for (int i = 0; i < files.length; ++i) {
            fileMap.put(files[i], oldNames[i]);
        }
        this.originalFiles = Collections.unmodifiableMap(fileMap);
        this.origFiles = new FileObject[files.length];
        System.arraycopy(files, 0, this.origFiles, 0, files.length);
    }

    AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public boolean containsOriginalFile(FileObject file) {
        return this.originalFiles.containsKey(file);
    }

    public FileObject[] getOriginalFiles() {
        return this.origFiles;
    }

    String getOldName(FileObject file) {
        return this.originalFiles.get(file);
    }

    String getNewName() {
        return this.getNewName(null);
    }

    String getNewName(FileObject file) {
        if (this.refactoring instanceof RenameRefactoring) {
            return ((RenameRefactoring)this.refactoring).getNewName();
        }
        if (this.refactoring instanceof MoveRefactoring && file != null && this.containsOriginalFile(file)) {
            return this.getTargetName((MoveRefactoring)this.refactoring, file.getName());
        }
        return null;
    }

    private String getTargetName(MoveRefactoring refactoring, String fileName) {
        ClassPath cp;
        FileObject targetFolder;
        URL targetURL = (URL)refactoring.getTarget().lookup(URL.class);
        File f = null;
        try {
            if (targetURL != null) {
                f = FileUtil.normalizeFile((File)new File(targetURL.toURI()));
            }
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        LinkedList<String> nonExisting = null;
        while (f != null && !f.exists()) {
            if (nonExisting == null) {
                nonExisting = new LinkedList<String>();
            }
            nonExisting.addFirst(f.getName());
            f = f.getParentFile();
        }
        FileObject fileObject = targetFolder = f != null ? FileUtil.toFileObject((File)f) : null;
        if (targetFolder != null && targetFolder.isFolder() && (cp = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/source")) != null) {
            String pkg = cp.getResourceName(targetFolder, '.', false);
            StringBuilder buf = new StringBuilder();
            if (pkg != null) {
                buf.append(pkg);
                if (buf.length() > 0) {
                    buf.append('.');
                }
            }
            if (nonExisting != null && !nonExisting.isEmpty()) {
                for (String s : nonExisting) {
                    buf.append(s);
                    buf.append('.');
                }
            }
            buf.append(fileName);
            return buf.toString();
        }
        return null;
    }

    public FormRefactoringUpdate getUpdateForFile(FileObject fo) {
        FormRefactoringUpdate update = this.fileToUpdateMap.get(fo);
        if (update == null) {
            assert (RefactoringInfo.isJavaFileOfForm(fo));
            update = new FormRefactoringUpdate(this, fo);
            this.fileToUpdateMap.put(fo, update);
        }
        return update;
    }

    static boolean isJavaFile(FileObject fo) {
        return "text/x-java".equals(fo.getMIMEType());
    }

    static boolean isJavaFileOfForm(FileObject fo) {
        return RefactoringInfo.isJavaFile(fo) && fo.existsExt("form");
    }

    public static enum ChangeType {
        VARIABLE_RENAME,
        CLASS_RENAME,
        CLASS_MOVE,
        CLASS_COPY,
        CLASS_DELETE,
        PACKAGE_RENAME,
        FOLDER_RENAME,
        EVENT_HANDLER_RENAME,
        OTHER_FORM_CHANGE;

    }
}

