/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Glyph;
import org.w3c.dom.DOMException;

public class HKern
extends ElementNode {
    static final String[] REQUIRED_TRAITS = new String[]{"k"};
    protected int[][] u1;
    protected int[][] u2;
    protected String[] g1;
    protected String[] g2;
    protected float k;
    protected HKern nextHKern;

    public HKern(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "hkern";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new HKern(doc);
    }

    public void setU1(int[][] u1) {
        if (u1 != null) {
            for (int i = 0; i < u1.length; ++i) {
                if (u1[i] != null && u1[i].length == 2) continue;
                throw new IllegalArgumentException();
            }
        }
        if (HKern.equal(u1, this.u1)) {
            return;
        }
        this.modifyingNode();
        this.u1 = u1;
        this.modifiedNode();
    }

    public void setU2(int[][] u2) {
        if (u2 != null) {
            for (int i = 0; i < u2.length; ++i) {
                if (u2[i] != null && u2[i].length == 2) continue;
                throw new IllegalArgumentException();
            }
        }
        if (HKern.equal(u2, this.u2)) {
            return;
        }
        this.modifyingNode();
        this.u2 = u2;
        this.modifiedNode();
    }

    public void setG1(String[] g1) {
        if (HKern.equal(g1, this.g1)) {
            return;
        }
        this.modifyingNode();
        this.g1 = g1;
        this.modifiedNode();
    }

    public void setG2(String[] g2) {
        if (HKern.equal(g2, this.g2)) {
            return;
        }
        this.modifyingNode();
        this.g2 = g2;
        this.modifiedNode();
    }

    public void setK(float k) {
        if (this.k == k) {
            return;
        }
        this.modifyingNode();
        this.k = k;
        this.modifiedNode();
    }

    public float getK() {
        return this.k;
    }

    public int[][] getU1() {
        return this.u1;
    }

    public int[][] getU2() {
        return this.u2;
    }

    public String[] getG1() {
        return this.g1;
    }

    public String[] getG2() {
        return this.g2;
    }

    public boolean matchesFirst(Glyph g) {
        return this.matches(g, this.u1, this.g1);
    }

    public boolean matchesSecond(Glyph g) {
        return this.matches(g, this.u2, this.g2);
    }

    boolean matches(Glyph glyph, int[][] u, String[] g) {
        String gu = glyph.getUnicode();
        String[] gg = glyph.getGlyphName();
        if (u != null && gu != null && gu.length() == 1) {
            char c = gu.charAt(0);
            for (int i = 0; i < u.length; ++i) {
                if (c < u[i][0] || c > u[i][1]) continue;
                return true;
            }
        }
        if (gg != null && g != null) {
            for (int i = 0; i < gg.length; ++i) {
                String gn = gg[i];
                for (int j = 0; j < g.length; ++j) {
                    if (!g[j].equals(gn)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean supportsTrait(String traitName) {
        if ("u1" == traitName || "u2" == traitName || "g1" == traitName || "g2" == traitName || "k" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("u1" == name) {
            return this.unicodeRangeToStringTrait(this.u1);
        }
        if ("u2" == name) {
            return this.unicodeRangeToStringTrait(this.u2);
        }
        if ("g1" == name) {
            return this.toStringTrait(this.g1);
        }
        if ("g2" == name) {
            return this.toStringTrait(this.g2);
        }
        if ("k" == name) {
            return Float.toString(this.k);
        }
        return super.getTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("u1" == name) {
            this.checkWriteLoading(name);
            this.setU1(this.parseUnicodeRangeTrait(name, value));
        } else if ("u2" == name) {
            this.checkWriteLoading(name);
            this.setU2(this.parseUnicodeRangeTrait(name, value));
        } else if ("g1" == name) {
            this.checkWriteLoading(name);
            this.setG1(this.parseStringArrayTrait(name, value, ","));
        } else if ("g2" == name) {
            this.checkWriteLoading(name);
            this.setG2(this.parseStringArrayTrait(name, value, ","));
        } else if ("k" == name) {
            this.checkWriteLoading(name);
            this.setK(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }
}

