/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import org.netbeans.installer.utils.exceptions.UnrecognizedObjectException;

public class Text {
    private String text = "";
    private ContentType contentType = ContentType.PLAIN_TEXT;

    public Text() {
    }

    public Text(String text, ContentType contentType) {
        this.text = text;
        this.contentType = contentType;
    }

    public String getText() {
        return this.text;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        PLAIN_TEXT,
        HTML;


        public static ContentType parseContentType(String string) throws UnrecognizedObjectException {
            if (string.equals("text/plain")) {
                return PLAIN_TEXT;
            }
            if (string.equals("text/html")) {
                return HTML;
            }
            throw new UnrecognizedObjectException("Cannot recognize content type");
        }

        public String getExtension() {
            switch (this) {
                case PLAIN_TEXT: {
                    return ".txt";
                }
                case HTML: {
                    return ".html";
                }
            }
            return "";
        }

        public String toString() {
            switch (this) {
                case PLAIN_TEXT: {
                    return "text/plain";
                }
                case HTML: {
                    return "text/html";
                }
            }
            return "";
        }
    }
}

