/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class OperationsImpl
implements DeleteOperationImplementation,
MoveOperationImplementation,
CopyOperationImplementation {
    protected final NbMavenProjectImpl project;
    private ProjectState state;

    public OperationsImpl(NbMavenProjectImpl proj, ProjectState state) {
        this.project = proj;
        this.state = state;
    }

    protected static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        OperationsImpl.addFile(projectDirectory, "pom.xml", files);
        OperationsImpl.addFile(projectDirectory, "profiles.xml", files);
        OperationsImpl.addFile(projectDirectory, "nbactions.xml", files);
        OperationsImpl.addFile(projectDirectory, "nb-configuration.xml", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        OperationsImpl.addFile(this.project.getProjectDirectory(), "src", files);
        return files;
    }

    public void notifyDeleting() throws IOException {
        BeanRunConfig config = new BeanRunConfig();
        config.setExecutionDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        config.setGoals(Collections.singletonList("clean"));
        config.setRecursive(false);
        config.setProject(this.project);
        config.setExecutionName(NbBundle.getMessage(OperationsImpl.class, (String)"NotifyDeleting.execute"));
        config.setUpdateSnapshots(false);
        config.setTaskDisplayName(NbBundle.getMessage(OperationsImpl.class, (String)"NotifyDeleting.execute"));
        ExecutorTask task = RunUtils.executeMaven(config);
        task.result();
        this.checkParentProject(this.project.getProjectDirectory(), true, null, null);
        config.setProject(null);
    }

    public void notifyDeleted() throws IOException {
        this.state.notifyDeleted();
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalLoc, final String newName) throws IOException {
        if (original == null) {
            this.state.notifyDeleted();
            return;
        }
        if (original.getProjectDirectory().equals(this.project.getProjectDirectory())) {
            FileObject pomFO = this.project.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    model.getProject().setName(newName);
                }
            };
            Utilities.performPOMModelOperations((FileObject)pomFO, Collections.singletonList(operation));
            NbMavenProject.fireMavenProjectReload(this.project);
        }
        this.checkParentProject(this.project.getProjectDirectory(), false, newName, originalLoc.getName());
    }

    public void notifyCopying() throws IOException {
    }

    public void notifyCopied(Project original, File originalLoc, String newName) throws IOException {
        if (original != null) {
            this.checkParentProject(this.project.getProjectDirectory(), false, newName, originalLoc.getName());
        }
    }

    private void checkParentProject(FileObject projectDir, final boolean delete, final String newName, final String oldName) throws IOException {
        NbMavenProjectImpl par;
        final String prjLoc = projectDir.getNameExt();
        FileObject fo = projectDir.getParent();
        Project possibleParent = ProjectManager.getDefault().findProject(fo);
        if (possibleParent != null && (par = (NbMavenProjectImpl)possibleParent.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            FileObject pomFO = par.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    MavenProject prj = par.getOriginalMavenProject();
                    if ((prj.getModules() != null && prj.getModules().contains(prjLoc)) == delete) {
                        if (delete) {
                            model.getProject().removeModule(prjLoc);
                        } else {
                            model.getProject().addModule(prjLoc);
                        }
                    }
                    if (newName != null && oldName != null && oldName.equals(model.getProject().getArtifactId())) {
                        model.getProject().setArtifactId(newName);
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)pomFO, Collections.singletonList(operation));
        }
    }
}

