/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.validation.ModelValidationResult;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.embedder.NbArtifact;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ProblemReporterImpl
implements ProblemReporter,
Comparator<ProblemReport> {
    private static final String MISSINGJ2EE = "MISSINGJ2EE";
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final Set<ProblemReport> reports;
    private final NbMavenProjectImpl nbproject;
    private ModuleInfo j2eeInfo;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProblemReport rep;
            if ("enabled".equals(evt.getPropertyName()) && (rep = ProblemReporterImpl.this.getReportWithId(ProblemReporterImpl.MISSINGJ2EE)) != null) {
                boolean hasj2ee;
                boolean bl = hasj2ee = ProblemReporterImpl.this.j2eeInfo != null && ProblemReporterImpl.this.j2eeInfo.isEnabled();
                if (hasj2ee) {
                    ProblemReporterImpl.this.removeReport(rep);
                    ProblemReporterImpl.this.j2eeInfo.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    };

    public ProblemReporterImpl(NbMavenProjectImpl proj) {
        this.reports = new TreeSet<ProblemReport>(this);
        this.nbproject = proj;
    }

    public void addChangeListener(ChangeListener list) {
        this.listeners.add(list);
    }

    public void removeChangeListener(ChangeListener list) {
        this.listeners.remove(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReport(ProblemReport report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.add(report);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReports(ProblemReport[] report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (int i = 0; i < report.length; ++i) {
                assert (report[i] != null);
                this.reports.add(report[i]);
            }
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReport(ProblemReport report) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.remove(report);
        }
        this.fireChange();
    }

    private void fireChange() {
        for (ChangeListener list : this.listeners) {
            list.stateChanged(new ChangeEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProblemReport> getReports() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new ArrayList<ProblemReport>(this.reports);
        }
    }

    public boolean hasReportWithId(String id) {
        return this.getReportWithId(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProblemReport getReportWithId(String id) {
        assert (id != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport rep : this.reports) {
                if (!id.equals(rep.getId())) continue;
                return rep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReports() {
        boolean hasAny;
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            hasAny = !this.reports.isEmpty();
            this.reports.clear();
        }
        if (hasAny) {
            this.fireChange();
        }
    }

    @Override
    public int compare(ProblemReport o1, ProblemReport o2) {
        int ret = new Integer(o1.getSeverityLevel()).compareTo(new Integer(o2.getSeverityLevel()));
        if (ret != 0) {
            return ret;
        }
        return o1.hashCode() > o2.hashCode() ? 1 : (o1.hashCode() < o2.hashCode() ? -1 : 0);
    }

    public void addValidatorReports(InvalidProjectModelException exc) {
        ModelValidationResult res = exc.getValidationResult();
        if (res == null) {
            return;
        }
        List messages = exc.getValidationResult().getMessages();
        if (messages != null && messages.size() > 0) {
            ProblemReport report = new ProblemReport(0, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_Project_validation"), exc.getValidationResult().render("\n"), new OpenPomAction(this.nbproject));
            this.addReport(report);
        }
    }

    private ModuleInfo findJ2eeModule() {
        Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo info : infos) {
            if (!"org.netbeans.modules.maven.j2ee".equals(info.getCodeNameBase())) continue;
            return info;
        }
        return null;
    }

    public void doBaseProblemChecks(MavenProject project) {
        String packaging = this.nbproject.getProjectWatcher().getPackagingType();
        if ("war".equals(packaging) || "ear".equals(packaging) || "ejb".equals(packaging)) {
            boolean foundJ2ee;
            if (this.j2eeInfo == null) {
                this.j2eeInfo = this.findJ2eeModule();
            }
            boolean bl = foundJ2ee = this.j2eeInfo != null && this.j2eeInfo.isEnabled();
            if (!foundJ2ee) {
                if (!this.hasReportWithId(MISSINGJ2EE)) {
                    ProblemReport report = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_MissingJ2eeModule"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_MissingJ2eeModule"), null);
                    report.setId(MISSINGJ2EE);
                    this.addReport(report);
                    if (this.j2eeInfo != null) {
                        this.j2eeInfo.addPropertyChangeListener(this.listener);
                    }
                }
            } else if (this.j2eeInfo != null) {
                this.j2eeInfo.removePropertyChangeListener(this.listener);
            }
        } else if ("nbm".equals(packaging)) {
            Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
            boolean foundApisupport = false;
            for (ModuleInfo info : infos) {
                if (!"org.netbeans.modules.maven.apisupport".equals(info.getCodeNameBase()) || !info.isEnabled()) continue;
                foundApisupport = true;
                break;
            }
            if (!foundApisupport) {
                ProblemReport report = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_MissingApisupportModule"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_MissingApisupportModule"), null);
                this.addReport(report);
            }
        }
        if (project != null) {
            for (MavenProject parent = project; parent != null; parent = parent.getParent()) {
                this.checkParent(parent);
            }
            List compileArts = project.getTestArtifacts();
            if (compileArts != null) {
                ArrayList<NbArtifact> missingJars = new ArrayList<NbArtifact>();
                for (NbArtifact art : compileArts) {
                    if (art.getFile() != null && art.isFakedSystemDependency()) {
                        ProblemReport report = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_SystemScope"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_SystemScope"), new OpenPomAction(this.nbproject));
                        this.addReport(report);
                        continue;
                    }
                    if (art.getFile() != null && art.getFile().exists()) continue;
                    missingJars.add(art);
                }
                if (missingJars.size() > 0) {
                    Iterator it2 = missingJars.iterator();
                    String mess = "";
                    while (it2.hasNext()) {
                        Artifact ar = (Artifact)it2.next();
                        mess = mess + ar.getId() + "\n";
                    }
                    DependenciesNode.ResolveDepsAction act = new DependenciesNode.ResolveDepsAction(this.nbproject);
                    act.putValue("Name", NbBundle.getMessage(ProblemReporterImpl.class, (String)"ACT_DownloadDeps"));
                    ProblemReport report = new ProblemReport(5, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_NonLocal"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_NonLocal", (Object)mess), act);
                    this.addReport(report);
                }
            }
        }
    }

    private void checkParent(MavenProject project) {
        Artifact art = project.getParentArtifact();
        if (art != null && art instanceof NbArtifact) {
            File parent = project.getParent().getFile();
            if (parent != null && parent.exists()) {
                return;
            }
            NbArtifact nbart = (NbArtifact)art;
            nbart.getFile();
            if (nbart.getNonFakedFile() != null && !nbart.getNonFakedFile().exists()) {
                ProblemReport report = new ProblemReport(0, NbBundle.getMessage(ProblemReporterImpl.class, (String)"ERR_NoParent"), NbBundle.getMessage(ProblemReporterImpl.class, (String)"MSG_NoParent", (Object)nbart.getId()), new OpenPomAction(this.nbproject));
                this.addReport(report);
            }
        }
    }

    static class OpenPomAction
    extends AbstractAction {
        private NbMavenProjectImpl project;
        private String filepath;

        OpenPomAction(NbMavenProjectImpl proj) {
            this.putValue("Name", NbBundle.getMessage(ProblemReporterImpl.class, (String)"ACT_OpenPom"));
            this.project = proj;
        }

        OpenPomAction(NbMavenProjectImpl project, String filePath) {
            this(project);
            this.filepath = filePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject fo = null;
            fo = this.filepath != null ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.filepath))) : FileUtil.toFileObject((File)this.project.getPOMFile());
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    EditCookie edit = (EditCookie)dobj.getCookie(EditCookie.class);
                    edit.edit();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

