/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class MavenFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private final NbMavenProjectImpl project;
    private static final String ENCODING_PARAM = "encoding";

    public MavenFileEncodingQueryImpl(NbMavenProjectImpl proj) {
        this.project = proj;
    }

    public Charset getEncoding(FileObject file) {
        MavenProject mp = this.project.getOriginalMavenProject();
        if (mp == null) {
            return Charset.defaultCharset();
        }
        try {
            FileObject testsrc;
            String defEnc = mp.getProperties().getProperty("project.build.sourceEncoding");
            FileObject src = FileUtilities.convertStringToFileObject(mp.getBuild().getSourceDirectory());
            if (src != null && (src.equals(file) || FileUtil.isParentOf((FileObject)src, (FileObject)file))) {
                String compileEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "compile");
                if (compileEnc != null && compileEnc.indexOf("${") == -1) {
                    return Charset.forName(compileEnc);
                }
                if (defEnc != null) {
                    return Charset.forName(defEnc);
                }
            }
            if ((testsrc = FileUtilities.convertStringToFileObject(mp.getBuild().getTestSourceDirectory())) != null && (testsrc.equals(file) || FileUtil.isParentOf((FileObject)testsrc, (FileObject)file))) {
                String testcompileEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "testCompile");
                if (testcompileEnc != null && testcompileEnc.indexOf("${") == -1) {
                    return Charset.forName(testcompileEnc);
                }
                if (defEnc != null) {
                    return Charset.forName(defEnc);
                }
            }
            try {
                if (this.isWithin(this.project.getResources(false), file)) {
                    String resourceEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "resources");
                    if (resourceEnc != null && resourceEnc.indexOf("${") == -1) {
                        return Charset.forName(resourceEnc);
                    }
                    if (defEnc != null) {
                        return Charset.forName(defEnc);
                    }
                }
            }
            catch (MalformedURLException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            try {
                if (this.isWithin(this.project.getResources(true), file)) {
                    String testresourceEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "testResources");
                    if (testresourceEnc != null && testresourceEnc.indexOf("${") == -1) {
                        return Charset.forName(testresourceEnc);
                    }
                    if (defEnc != null) {
                        return Charset.forName(defEnc);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            try {
                if (this.isWithin(new URI[]{this.project.getSiteDirectory()}, file)) {
                    String siteEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-site-plugin", "inputEncoding", "site");
                    if (siteEnc != null && siteEnc.indexOf("${") == -1) {
                        return Charset.forName(siteEnc);
                    }
                    if (defEnc != null) {
                        return Charset.forName(defEnc);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            if (defEnc != null) {
                return Charset.forName(defEnc);
            }
        }
        catch (UnsupportedCharsetException uce) {
            Logger.getLogger(MavenFileEncodingQueryImpl.class.getName()).log(Level.FINE, uce.getMessage(), uce);
        }
        catch (IllegalCharsetNameException icne) {
            Logger.getLogger(MavenFileEncodingQueryImpl.class.getName()).log(Level.FINE, icne.getMessage(), icne);
        }
        return Charset.defaultCharset();
    }

    private boolean isWithin(URI[] res, FileObject file) throws MalformedURLException {
        for (URI ur : res) {
            FileObject fo = URLMapper.findFileObject((URL)ur.toURL());
            if (fo == null || !fo.equals(file) && !FileUtil.isParentOf((FileObject)fo, (FileObject)file)) continue;
            return true;
        }
        return false;
    }
}

