/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.versioning.diff.FilesModifiedConfirmation;
import org.netbeans.modules.versioning.diff.ScrollableMessagesList;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ExpandableMessage
extends JPanel
implements ActionListener {
    private final JLabel lblTopMsg;
    private final JLabel lblBotMsg;
    private final Collection<String> messages;
    private final JButton toggleButton;
    private boolean showingMore = false;
    private JComponent extraInfo;

    ExpandableMessage(String topMsgKey, Collection<String> messages, String bottomMsgKey, JButton toggleButton) {
        super(null);
        this.messages = messages;
        this.toggleButton = toggleButton;
        this.lblTopMsg = new JLabel(ExpandableMessage.getMessage(topMsgKey, new Object[0]));
        this.lblBotMsg = bottomMsgKey != null ? new JLabel(ExpandableMessage.getMessage(bottomMsgKey, new Object[0])) : null;
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.lblTopMsg);
        this.lblTopMsg.setAlignmentX(0.0f);
        if (this.lblBotMsg != null) {
            this.add(ExpandableMessage.makeVerticalStrut(this.lblTopMsg, this.lblBotMsg));
            this.add(this.lblBotMsg);
            this.lblBotMsg.setAlignmentX(0.0f);
        }
        Mnemonics.setLocalizedText((AbstractButton)toggleButton, (String)ExpandableMessage.getMessage("LBL_ShowMoreInformation", new Object[0]));
        toggleButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.showingMore) {
            this.showLess();
        } else {
            this.showMore();
        }
    }

    private void showMore() {
        if (this.extraInfo == null) {
            this.extraInfo = ExpandableMessage.makeMessagesComponent(this.messages);
            this.extraInfo.setAlignmentX(0.0f);
        }
        if (this.lblBotMsg != null) {
            this.remove(1);
        }
        this.add(ExpandableMessage.makeVerticalStrut(this.lblTopMsg, this.extraInfo), 1);
        this.add((Component)this.extraInfo, 2);
        if (this.lblBotMsg != null) {
            this.add(ExpandableMessage.makeVerticalStrut(this.extraInfo, this.lblBotMsg), 3);
        }
        Mnemonics.setLocalizedText((AbstractButton)this.toggleButton, (String)ExpandableMessage.getMessage("LBL_ShowLessInformation", new Object[0]));
        this.showingMore = true;
        SwingUtilities.getWindowAncestor(this).pack();
    }

    private void showLess() {
        if (this.lblBotMsg != null) {
            this.remove(3);
        }
        this.remove(2);
        this.remove(1);
        if (this.lblBotMsg != null) {
            this.add(ExpandableMessage.makeVerticalStrut(this.lblTopMsg, this.lblBotMsg), 1);
        }
        Mnemonics.setLocalizedText((AbstractButton)this.toggleButton, (String)ExpandableMessage.getMessage("LBL_ShowMoreInformation", new Object[0]));
        this.showingMore = false;
        SwingUtilities.getWindowAncestor(this).pack();
    }

    private static JComponent makeMessagesComponent(Collection<String> messages) {
        if (messages == null) {
            throw new IllegalArgumentException("null");
        }
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("empty");
        }
        return new JScrollPane(new ScrollableMessagesList(messages));
    }

    private static Component makeVerticalStrut(JComponent compA, JComponent compB) {
        LayoutStyle layoutStyle = LayoutStyle.getSharedInstance();
        return Box.createVerticalStrut(layoutStyle.getPreferredGap(compA, compB, 1, 5, compA.getParent()));
    }

    private static String getMessage(String msgKey, Object ... params) {
        return NbBundle.getMessage(FilesModifiedConfirmation.class, (String)msgKey, (Object[])params);
    }
}

