/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.util.Exceptions;

public final class JavaReference {
    CharSequence fqn;
    CharSequence member;
    CharSequence tag;
    int begin = -1;
    int end = -1;
    private int tagEndPosition;
    private String paramsText;

    private JavaReference() {
    }

    public String toString() {
        return String.format("fqn: %1$s, member: %2$s, [%3$d, %4$d]", this.fqn, this.member, this.begin, this.end);
    }

    public static JavaReference resolve(TokenSequence<JavadocTokenId> tokenSequence, int n, int n2) {
        JavaReference javaReference = new JavaReference();
        javaReference.tagEndPosition = n2;
        tokenSequence.move(n);
        javaReference.insideFQN(tokenSequence);
        return javaReference;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element getReferencedElement(CompilationInfo compilationInfo, TypeElement typeElement) {
        void var7_16;
        void var3_7;
        Object object;
        String[] stringArray;
        if (!this.isReference()) {
            return null;
        }
        Object var3_3 = null;
        TypeElement typeElement2 = null;
        if (this.fqn != null && this.fqn.length() > 0) {
            stringArray = compilationInfo.getTreeUtilities().parseType(((Object)this.fqn).toString(), typeElement);
            if (stringArray == null || stringArray.getKind() != TypeKind.DECLARED) return null;
            object = (DeclaredType)stringArray;
            TypeElement typeElement3 = typeElement2 = (TypeElement)object.asElement();
        } else {
            typeElement2 = typeElement;
        }
        if (typeElement2 == null || this.member == null || this.member.length() <= 0) return var3_7;
        object = ((Object)this.member).toString();
        ClassDoc classDoc = (ClassDoc)compilationInfo.getElementUtilities().javaDocFor((Element)typeElement2);
        if (this.paramsText != null) {
            stringArray = new ParameterParseMachine(this.paramsText).parseParameters();
            if (stringArray != null) {
                MemberDoc memberDoc = this.findExecutableMember((String)object, stringArray, classDoc);
            } else {
                Object var7_13 = null;
            }
        } else {
            MemberDoc memberDoc = this.findExecutableMember((String)object, null, classDoc);
            FieldDoc fieldDoc = this.findField(classDoc, (String)object);
            if (memberDoc == null || fieldDoc != null && fieldDoc.containingClass().subclassOf(memberDoc.containingClass())) {
                FieldDoc fieldDoc2 = fieldDoc;
            }
        }
        if (var7_16 == null) return var3_7;
        Element element = compilationInfo.getElementUtilities().elementFor((Doc)var7_16);
        return var3_7;
    }

    boolean isReference() {
        return this.begin > 0;
    }

    private void insideMember(TokenSequence<JavadocTokenId> tokenSequence) {
        CharSequence charSequence;
        Token token;
        if (!tokenSequence.moveNext() || JavadocTokenId.IDENT != (token = tokenSequence.token()).id()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.member = stringBuilder;
        stringBuilder.append(token.text());
        this.end = tokenSequence.offset() + token.length();
        if (!tokenSequence.moveNext() || JavadocTokenId.OTHER_TEXT != (token = tokenSequence.token()).id() || (charSequence = token.text()).length() == 0 || charSequence.charAt(0) != '(') {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        while (tokenSequence.offset() < this.tagEndPosition) {
            int n = this.tagEndPosition - tokenSequence.offset();
            charSequence = n > 0 ? token.text() : token.text().subSequence(0, n);
            stringBuilder2.append(charSequence);
            if (!tokenSequence.moveNext()) break;
            token = tokenSequence.token();
        }
        this.paramsText = this.parseParamString(stringBuilder2);
    }

    private void insideFQN(TokenSequence<JavadocTokenId> tokenSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        block5: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            switch ((JavadocTokenId)token.id()) {
                case IDENT: {
                    stringBuilder.append(token.text());
                    if (this.begin < 0) {
                        this.begin = tokenSequence.offset();
                    }
                    this.end = tokenSequence.offset() + token.length();
                    continue block5;
                }
                case HASH: {
                    if (this.begin < 0) {
                        this.begin = tokenSequence.offset();
                    }
                    this.end = tokenSequence.offset() + token.length();
                    this.insideMember(tokenSequence);
                    break;
                }
                case DOT: {
                    if (stringBuilder.length() == 0) break block5;
                    if ('.' == stringBuilder.charAt(stringBuilder.length() - 1)) break;
                    stringBuilder.append('.');
                    this.end = tokenSequence.offset() + token.length();
                    continue block5;
                }
            }
            break;
        }
        if (stringBuilder.length() > 0) {
            this.fqn = stringBuilder;
        }
    }

    private String parseParamString(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = charSequence.length();
        if (n3 == 0 || charSequence.charAt(0) != '(') {
            return null;
        }
        int n4 = 0;
        int n5 = 0;
        block7: for (int i = n = 0; i < n3; i += Character.charCount(n2)) {
            n2 = Character.codePointAt(charSequence, i);
            switch (n2) {
                case 40: {
                    ++n4;
                    continue block7;
                }
                case 41: {
                    --n4;
                    continue block7;
                }
                case 35: 
                case 46: 
                case 91: 
                case 93: {
                    continue block7;
                }
                case 44: {
                    if (n4 > 0) continue block7;
                    return null;
                }
                case 9: 
                case 10: 
                case 32: {
                    if (n4 != 0) continue block7;
                    n5 = i;
                    i = n3;
                    continue block7;
                }
            }
        }
        if (n4 != 0) {
            return null;
        }
        String string = n5 > 0 ? ((Object)charSequence.subSequence(n, n5)).toString() : ((Object)charSequence).toString();
        return string;
    }

    private MemberDoc findReferencedMethod(String string, String[] stringArray, ClassDoc classDoc) {
        MemberDoc memberDoc = this.findExecutableMember(string, stringArray, classDoc);
        ClassDoc[] classDocArray = classDoc.innerClasses();
        if (memberDoc == null) {
            for (int i = 0; i < classDocArray.length; ++i) {
                memberDoc = this.findReferencedMethod(string, stringArray, classDocArray[i]);
                if (memberDoc == null) continue;
                return memberDoc;
            }
        }
        return null;
    }

    private MemberDoc findExecutableMember(String string, String[] stringArray, ClassDoc classDoc) {
        if (string.equals(classDoc.name())) {
            return JavaReference.findConstructor(classDoc, string, stringArray);
        }
        return JavaReference.findMethod(classDoc, string, stringArray);
    }

    private static MethodDoc findMethod(ClassDoc classDoc, String string, String[] stringArray) {
        try {
            Method method = classDoc.getClass().getMethod("findMethod", String.class, String[].class);
            Object object = method.invoke((Object)classDoc, string, stringArray);
            return object instanceof MethodDoc ? (MethodDoc)object : null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        return null;
    }

    private static ConstructorDoc findConstructor(ClassDoc classDoc, String string, String[] stringArray) {
        try {
            Method method = classDoc.getClass().getMethod("findConstructor", String.class, String[].class);
            Object object = method.invoke((Object)classDoc, string, stringArray);
            return object instanceof ConstructorDoc ? (ConstructorDoc)object : null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        return null;
    }

    private FieldDoc findField(ClassDoc classDoc, String string) {
        try {
            Method method = classDoc.getClass().getMethod("findField", String.class);
            Object object = method.invoke((Object)classDoc, string);
            return object instanceof FieldDoc ? (FieldDoc)object : null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        return null;
    }

    private static final class ParameterParseMachine {
        final int START = 0;
        final int TYPE = 1;
        final int NAME = 2;
        final int TNSPACE = 3;
        final int ARRAYDECORATION = 4;
        final int ARRAYSPACE = 5;
        String parameters;
        StringBuilder typeId;
        List<String> paramList;

        ParameterParseMachine(String string) {
            this.parameters = string;
            this.paramList = new ArrayList<String>();
            this.typeId = new StringBuilder();
        }

        public String[] parseParameters() {
            int n;
            if (this.parameters.equals("()")) {
                return new String[0];
            }
            int n2 = 0;
            int n3 = 0;
            this.parameters = this.parameters.substring(1, this.parameters.length() - 1);
            block7: for (int i = 0; i < this.parameters.length(); i += Character.charCount(n)) {
                n = this.parameters.codePointAt(i);
                switch (n2) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(n)) {
                            this.typeId.append(Character.toChars(n));
                            n2 = 1;
                        }
                        n3 = 0;
                        continue block7;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(n) || n == 46) {
                            this.typeId.append(Character.toChars(n));
                        } else if (n == 91) {
                            this.typeId.append('[');
                            n2 = 4;
                        } else if (Character.isWhitespace(n)) {
                            n2 = 3;
                        } else if (n == 44) {
                            this.addTypeToParamList();
                            n2 = 0;
                        }
                        n3 = 1;
                        continue block7;
                    }
                    case 3: {
                        if (Character.isJavaIdentifierStart(n)) {
                            if (n3 == 4) {
                                return null;
                            }
                            this.addTypeToParamList();
                            n2 = 2;
                        } else if (n == 91) {
                            this.typeId.append('[');
                            n2 = 4;
                        } else if (n == 44) {
                            this.addTypeToParamList();
                            n2 = 0;
                        }
                        n3 = 3;
                        continue block7;
                    }
                    case 4: {
                        if (n == 93) {
                            this.typeId.append(']');
                            n2 = 3;
                        } else if (!Character.isWhitespace(n)) {
                            return null;
                        }
                        n3 = 4;
                        continue block7;
                    }
                    case 2: {
                        if (n == 44) {
                            n2 = 0;
                        }
                        n3 = 2;
                    }
                }
            }
            if (n2 == 4 || n2 != 0 || n3 == 3) {
                // empty if block
            }
            if (this.typeId.length() > 0) {
                this.paramList.add(this.typeId.toString());
            }
            return this.paramList.toArray(new String[this.paramList.size()]);
        }

        void addTypeToParamList() {
            if (this.typeId.length() > 0) {
                this.paramList.add(this.typeId.toString());
                this.typeId.setLength(0);
            }
        }
    }
}

