/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Exceptions;

public class SQLTableDataProvider
implements TableDataProvider {
    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private SQLDataStorage storage;
    private ServiceInfoDataStorage serviceInfoStorage;

    @Override
    public final void attachTo(DataStorage storage) {
        this.storage = (SQLDataStorage)storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends DataFilter> Collection<T> getDataFilters(Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        Lock lock = this.lock;
        synchronized (lock) {
            for (DataFilter f : this.filters) {
                if (f.getClass() != clazz) continue;
                result.add(clazz.cast(f));
            }
        }
        return result;
    }

    @Override
    public List<DataRow> queryData(DataTableMetadata tableMetadata) {
        if (tableMetadata == null) {
            return null;
        }
        List<DataTableMetadata.Column> columns = tableMetadata.getColumns();
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        Collection<TimeIntervalDataFilter> timeFilters = this.getDataFilters(TimeIntervalDataFilter.class);
        ArrayList<DataTableMetadataFilter> tableFilters = new ArrayList<DataTableMetadataFilter>();
        DataTableMetadataFilterSupport filtersSupport = DataTableMetadataFilterSupport.getInstance();
        for (TimeIntervalDataFilter timeFilter : timeFilters) {
            tableFilters.addAll(filtersSupport.createFilters(tableMetadata, timeFilter));
        }
        try {
            ResultSet rs = this.storage.select(tableMetadata, tableFilters);
            if (rs == null) {
                return Collections.emptyList();
            }
            List<String> colnames = tableMetadata.getColumnNames();
            while (rs.next()) {
                ArrayList<Object> data = new ArrayList<Object>(columns.size());
                for (DataTableMetadata.Column c : columns) {
                    data.add(rs.getObject(c.getColumnName()));
                }
                DataRow dataRow = new DataRow(colnames, data);
                result.add(dataRow);
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    @Override
    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoStorage = serviceInfoDataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        if (isAdjusting) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.filters.addAll(newSet);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

