/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.spi.indicator.TickerListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;

final class IndicatorTickerService {
    private static final IndicatorTickerService instance = new IndicatorTickerService();
    private Future tickerService;
    private boolean started = false;
    private final Object lock = new Lock();
    private final Object listenersLock = new Object();
    private final List<TickerListener> listeners = new ArrayList<TickerListener>();

    private IndicatorTickerService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IndicatorTickerService getInstance() {
        Object object = IndicatorTickerService.instance.lock;
        synchronized (object) {
            if (!IndicatorTickerService.instance.started) {
                instance.startIfNeed();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners() {
        TickerListener[] ll;
        Object object = this.listenersLock;
        synchronized (object) {
            ll = this.listeners.toArray(new TickerListener[0]);
            if (ll.length == 0) {
                return;
            }
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final TickerListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.tick();
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIfNeed() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.tickerService = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IndicatorTickerService.this.notifyListeners();
                    }
                }, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"IndicatorTickerService");
                this.started = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subsribe(TickerListener l) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribe(TickerListener l) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.started) {
                        this.tickerService.cancel(true);
                        this.started = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                this.tickerService.cancel(true);
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

