/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.zend.ZendPhpFrameworkProvider;
import org.netbeans.modules.php.zend.commands.ZendCommand;
import org.netbeans.modules.php.zend.commands.ZendCommandSupport;
import org.netbeans.modules.php.zend.ui.options.ZendOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class ZendScript
extends PhpProgram {
    public static final String SCRIPT_NAME;
    public static final String OPTIONS_SUB_PATH = "Zend";
    public static final String ENV_INCLUDE_PATH_PREPEND = "ZEND_TOOL_INCLUDE_PATH_PREPEND";
    public static final String CMD_INIT_PROJECT = "create";
    public static final String[] CMD_INIT_PROJECT_ARGS;
    public static final String[] CMD_INIT_PROJECT_ARGS_TITLE;
    private static final String[] CMD_CREATE_CONFIG;
    private static final String[] CMD_ENABLE_CONFIG;

    public ZendScript(String command) {
        super(command);
    }

    public static ZendScript getDefault() throws PhpProgram.InvalidPhpProgramException {
        return ZendScript.getCustom(ZendOptions.getInstance().getZend());
    }

    private static ZendScript getCustom(String command) throws PhpProgram.InvalidPhpProgramException {
        String error = ZendScript.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new ZendScript(command);
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/" + ZendScript.getOptionsSubPath();
    }

    public static String getOptionsSubPath() {
        return OPTIONS_SUB_PATH;
    }

    public static String getHelp(PhpModule phpModule, ZendCommand zendCommand) {
        assert (phpModule != null);
        assert (zendCommand != null);
        ZendCommandSupport commandSupport = ZendPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder processBuilder = commandSupport.createSilentCommand(zendCommand.getCommands(), new String[]{"?"});
        assert (processBuilder != null);
        final HelpLineProcessor lineProcessor = new HelpLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)InputProcessors.bridge((LineProcessor)lineProcessor));
            }
        });
        ZendScript.runService(processBuilder, executionDescriptor, "getting help for: " + zendCommand.getPreview(), true);
        return lineProcessor.getHelp();
    }

    public String validate() {
        if (!StringUtils.hasText((String)this.getProgram())) {
            return NbBundle.getMessage(ZendScript.class, (String)"MSG_NoZend");
        }
        File file = new File(this.getProgram());
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(ZendScript.class, (String)"MSG_ZendNotAbsolutePath");
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(ZendScript.class, (String)"MSG_ZendNotFile");
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(ZendScript.class, (String)"MSG_ZendCannotRead");
        }
        return null;
    }

    public static String validate(String command) {
        return new ZendScript(command).validate();
    }

    public static void registerNetBeansProvider() {
        ZendScript.registerNetBeansProvider(null);
    }

    public static void registerNetBeansProvider(String command) {
        try {
            ZendScript zendScript = command != null ? ZendScript.getCustom(command) : ZendScript.getDefault();
            ExecutionDescriptor executionDescriptor = ZendScript.getExecutionDescriptor().outProcessorFactory(ANSI_STRIPPING_FACTORY).errProcessorFactory(ANSI_STRIPPING_FACTORY).optionsPath(ZendScript.getOptionsPath());
            ExternalProcessBuilder processBuilder = ZendCommandSupport.registerIncludePathPrepend(zendScript.getProcessBuilder());
            for (String arg : CMD_CREATE_CONFIG) {
                processBuilder = processBuilder.addArgument(arg);
            }
            ZendScript.executeAndWait((ExternalProcessBuilder)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)StringUtils.implode(Arrays.asList(CMD_CREATE_CONFIG), (String)" "));
            processBuilder = ZendCommandSupport.registerIncludePathPrepend(zendScript.getProcessBuilder());
            for (String arg : CMD_ENABLE_CONFIG) {
                processBuilder = processBuilder.addArgument(arg);
            }
            ZendScript.executeAndWait((ExternalProcessBuilder)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)StringUtils.implode(Arrays.asList(CMD_ENABLE_CONFIG), (String)" "));
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ZendScript.class, (String)"MSG_ProviderRegistrationInfo"), 1));
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)ZendScript.getOptionsSubPath());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage(), (String)ZendScript.getOptionsSubPath());
        }
    }

    public boolean initProject(PhpModule phpModule) {
        ZendCommandSupport commandSupport = ZendPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder processBuilder = commandSupport.createSilentCommand(CMD_INIT_PROJECT, CMD_INIT_PROJECT_ARGS);
        if (processBuilder == null) {
            return false;
        }
        ExecutionDescriptor executionDescriptor = commandSupport.getDescriptor();
        ZendScript.runService(processBuilder, executionDescriptor, commandSupport.getOutputTitle(CMD_INIT_PROJECT, CMD_INIT_PROJECT_ARGS_TITLE), false);
        return ZendPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
    }

    private static void runService(ExternalProcessBuilder processBuilder, ExecutionDescriptor executionDescriptor, String title, boolean warnUser) {
        try {
            ZendScript.executeAndWait((ExternalProcessBuilder)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)title);
        }
        catch (ExecutionException ex) {
            if (warnUser) {
                UiUtils.processExecutionException((ExecutionException)ex, (String)ZendScript.getOptionsSubPath());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        CMD_INIT_PROJECT_ARGS = new String[]{"project", "."};
        CMD_INIT_PROJECT_ARGS_TITLE = new String[]{"project"};
        CMD_CREATE_CONFIG = new String[]{CMD_INIT_PROJECT, "config"};
        CMD_ENABLE_CONFIG = new String[]{"enable", "config.provider", "NetBeansCommandsProvider"};
        String scriptName = null;
        scriptName = Utilities.isWindows() ? "zf.bat" : "zf.sh";
        SCRIPT_NAME = scriptName;
    }

    static class HelpLineProcessor
    implements LineProcessor {
        private final StringBuilder buffer = new StringBuilder(2000);

        HelpLineProcessor() {
        }

        public void processLine(String line) {
            this.buffer.append(line);
            this.buffer.append("\n");
        }

        public void reset() {
        }

        public void close() {
        }

        public String getHelp() {
            return this.buffer.toString().trim() + "\n";
        }
    }
}

