/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend.ui.options;

import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.zend.ZendScript;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class ZendOptions {
    private static final String PREFERENCES_PATH = "zend";
    private static final ZendOptions INSTANCE = new ZendOptions();
    private static final String ZEND = "zend";
    private static final String PARAMS_FOR_PROJECT = "default.params.project";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile boolean zendSearched = false;

    private ZendOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                ZendOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static ZendOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public synchronized String getZend() {
        String zend = this.getPreferences().get("zend", null);
        if (zend == null && !this.zendSearched) {
            this.zendSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String)ZendScript.SCRIPT_NAME);
            if (!scripts.isEmpty()) {
                zend = (String)scripts.get(0);
                this.setZend(zend);
            }
        }
        return zend;
    }

    public void setZend(String zend) {
        this.getPreferences().put("zend", zend);
    }

    public String getDefaultParamsForProject() {
        return this.getPreferences().get(PARAMS_FOR_PROJECT, "");
    }

    public void setDefaultParamsForProject(String params) {
        this.getPreferences().put(PARAMS_FOR_PROJECT, params);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ZendOptions.class).node("zend");
    }
}

