/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.web.beans.impl.model.RuntimeAnnotationChecker;

public class StereotypeChecker
extends RuntimeAnnotationChecker {
    static final String STEREOTYPE = "javax.enterprise.inject.Stereotype";

    public StereotypeChecker(AnnotationModelHelper annotationModelHelper) {
        this.init(null, annotationModelHelper);
    }

    public void init(TypeElement typeElement) {
        assert (this.getElement() == null);
        super.init(typeElement, this.getHelper());
    }

    public void clean() {
        this.init(null, this.getHelper());
    }

    @Override
    protected boolean checkTarget(Map<String, ? extends AnnotationMirror> map) {
        boolean bl = false;
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        final HashSet hashSet = new HashSet();
        annotationParser.expectEnumConstantArray("value", this.getHelper().resolveType(ElementType.class.getCanonicalName()), new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> list) {
                for (AnnotationValue annotationValue : list) {
                    String string = annotationValue.getValue().toString();
                    hashSet.add(string);
                }
                return null;
            }
        }, null);
        annotationParser.parse(map.get(Target.class.getCanonicalName()));
        if (hashSet.contains(ElementType.METHOD.toString()) && hashSet.contains(ElementType.FIELD.toString()) && hashSet.contains(ElementType.TYPE.toString()) && hashSet.size() == 3) {
            bl = true;
        } else if (hashSet.size() == 2 && hashSet.contains(ElementType.METHOD.toString()) && hashSet.contains(ElementType.FIELD.toString())) {
            bl = true;
        } else if (hashSet.size() == 1) {
            bl = hashSet.contains(ElementType.METHOD.toString()) || hashSet.contains(ElementType.FIELD.toString()) || hashSet.contains(ElementType.TYPE.toString());
        } else {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Qualifier but has wrong target values." + " Correct target values are {METHOD, FIELD, TYPE} or" + "{METHOD, FIELD} or TYPE or METHOD or FIELD");
        }
        return bl;
    }

    @Override
    protected String getAnnotation() {
        return STEREOTYPE;
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(StereotypeChecker.class.getName());
    }
}

