/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.Locator;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.testrunner.ui.BaseTestMethodNodeAction;
import org.netbeans.modules.ruby.testrunner.ui.JumpToCallStackAction;
import org.netbeans.modules.ruby.testrunner.ui.JumpToTestAction;
import org.netbeans.modules.ruby.testrunner.ui.RunTestMethodAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class RubyTestMethodNode
extends TestMethodNode {
    private static final Logger LOGGER = Logger.getLogger(RubyTestMethodNode.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private FutureTask<String> stackTraceLocationHolder;

    public RubyTestMethodNode(Testcase testcase, Project project) {
        super(testcase, project, Lookups.singleton((Object)new Locator(){

            public void jumpToSource(Node node) {
                node.getPreferredAction().actionPerformed(null);
            }
        }));
    }

    public Action getPreferredAction() {
        if (this.stackTraceLocationHolder == null) {
            this.stackTraceLocationHolder = this.getTestCaseLineFromStackTrace(this.testcase);
        }
        String testLocation = this.testcase.getLocation();
        String stackTraceLocation = null;
        try {
            stackTraceLocation = this.stackTraceLocationHolder.get(300L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        String jumpToLocation = stackTraceLocation != null ? stackTraceLocation : testLocation;
        return jumpToLocation == null ? new JumpToTestAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_GoToSource"), false) : new JumpToCallStackAction((Node)this, jumpToLocation);
    }

    private FutureTask<String> getTestCaseLineFromStackTrace(final Testcase testcase) {
        FutureTask<String> result = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String candidateLine;
                Thread.sleep(9000L);
                if (testcase.getTrouble() == null) {
                    return null;
                }
                String[] stacktrace = testcase.getTrouble().getStackTrace();
                if (stacktrace == null || stacktrace.length <= 1) {
                    return null;
                }
                if (stacktrace.length > 2 && (candidateLine = RubyTestMethodNode.findLocationLine(stacktrace, testcase.getName(), RubyTestMethodNode.this.getFileName(testcase))) != null) {
                    return candidateLine;
                }
                return stacktrace[1];
            }
        });
        EXECUTOR.execute(result);
        return result;
    }

    static final String findLocationLine(String[] stacktrace, String testName, String fileName) {
        String candidateLine = null;
        for (int i = 0; i < stacktrace.length; ++i) {
            if (!stacktrace[i].contains(fileName)) continue;
            if (stacktrace[i].contains(testName)) {
                candidateLine = stacktrace[i];
                break;
            }
            if (candidateLine != null) continue;
            candidateLine = stacktrace[i];
        }
        if (candidateLine != null) {
            return candidateLine;
        }
        return null;
    }

    private String getFileName(Testcase testcase) {
        String testName;
        FileObject testRoot = BaseTestMethodNodeAction.getTestSourceRoot(this.project);
        DeclarationFinder.DeclarationLocation location = RubyDeclarationFinder.getTestDeclaration((FileObject)testRoot, (String)(testName = BaseTestMethodNodeAction.getTestMethod(testcase)), (boolean)true, (boolean)true);
        FileObject testFile = location.getFileObject();
        if (testFile != null) {
            return testFile.getNameExt();
        }
        return RubyUtils.camelToUnderlinedName((String)testcase.getClassName());
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return new Action[0];
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(this.getPreferredAction());
        actions.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_RerunTest"), false));
        actions.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_DebugTest"), true));
        actions.add(new DiffViewAction(this.testcase));
        return actions.toArray(new Action[actions.size()]);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTOR.shutdown();
            }
        });
    }
}

