/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.JUnit3TestGenerator;
import org.netbeans.modules.junit.JUnit4TestGenerator;
import org.netbeans.modules.junit.JUnitVersion;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class TestCreator
implements TestabilityJudge {
    static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private final TestGeneratorSetup setup;
    private final JUnitVersion junitVersion;

    TestCreator(boolean bl, JUnitVersion jUnitVersion) {
        this.setup = new TestGeneratorSetup(bl);
        this.junitVersion = jUnitVersion;
    }

    TestCreator(Map<JUnitPlugin.CreateTestParam, Object> map, JUnitVersion jUnitVersion) {
        this.setup = new TestGeneratorSetup(map);
        this.junitVersion = jUnitVersion;
    }

    public void createEmptyTest(FileObject fileObject) throws IOException {
        AbstractTestGenerator abstractTestGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                abstractTestGenerator = new JUnit3TestGenerator(this.setup, TestUtil.getSourceLevel(fileObject));
                break;
            }
            case JUNIT4: {
                abstractTestGenerator = new JUnit4TestGenerator(this.setup);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(fileObject, abstractTestGenerator);
    }

    public void createSimpleTest(ElementHandle<TypeElement> elementHandle, FileObject fileObject, boolean bl) throws IOException {
        AbstractTestGenerator abstractTestGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                abstractTestGenerator = new JUnit3TestGenerator(this.setup, Collections.singletonList(elementHandle), null, bl, TestUtil.getSourceLevel(fileObject));
                break;
            }
            case JUNIT4: {
                abstractTestGenerator = new JUnit4TestGenerator(this.setup, Collections.singletonList(elementHandle), null, bl);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(fileObject, abstractTestGenerator);
    }

    public List<String> createTestSuite(List<String> list, FileObject fileObject, boolean bl) throws IOException {
        AbstractTestGenerator abstractTestGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                abstractTestGenerator = new JUnit3TestGenerator(this.setup, null, list, bl, TestUtil.getSourceLevel(fileObject));
                break;
            }
            case JUNIT4: {
                abstractTestGenerator = new JUnit4TestGenerator(this.setup, null, list, bl);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(fileObject, abstractTestGenerator);
        return abstractTestGenerator.getProcessedClassNames();
    }

    private void doModifications(FileObject fileObject, final AbstractTestGenerator abstractTestGenerator) throws IOException {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        Future future = javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                ModificationResult modificationResult = javaSource.runModificationTask((Task)abstractTestGenerator);
                modificationResult.commit();
            }
        }, true);
        try {
            future.get();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
            }
            Exceptions.printStackTrace((Throwable)executionException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compilationInfo, TypeElement typeElement, long l) {
        return this.setup.isClassTestable(compilationInfo, typeElement, l);
    }

    @Override
    public boolean isMethodTestable(ExecutableElement executableElement) {
        return this.setup.isMethodTestable(executableElement);
    }
}

