/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.PyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssistOverride
implements IAssistProps {
    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File file, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException, MisconfigurationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        String sel = PyAction.getLineWithoutComments(ps);
        String indentation = PyAction.getStaticIndentationString(edit);
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        String indStart = "";
        int j = sel.indexOf("def ");
        int i = 0;
        while (i < j) {
            indStart = new StringBuffer(String.valueOf(indStart)).append(" ").toString();
            ++i;
        }
        String start = sel.substring(0, j + 4);
        String[] strs = PySelection.getActivationTokenAndQual((IDocument)ps.getDoc(), (int)ps.getAbsoluteCursorOffset(), (boolean)false);
        String tok = strs[1];
        CompletionState state = new CompletionState(ps.getStartLineIndex(), ps.getAbsoluteCursorOffset() - ps.getStartLine().getOffset(), null, nature, "");
        CompletionRequest request = new CompletionRequest(file, nature, ps.getDoc(), "self", ps.getAbsoluteCursorOffset(), 0, new PyCodeCompletion(), "");
        ArrayList selfCompletions = new ArrayList();
        PyCodeCompletion.getSelfOrClsCompletions(request, selfCompletions, state, true, false, "self");
        FastStringBuffer buffer = new FastStringBuffer();
        for (IToken token : selfCompletions) {
            String rep = token.getRepresentation();
            if (!rep.startsWith(tok)) continue;
            buffer.clear();
            buffer.append(start);
            buffer.append(rep);
            String args = token.getArgs();
            if (args.equals("()")) {
                args = "( self )";
            }
            buffer.append(args);
            buffer.append(":");
            buffer.append(delimiter);
            buffer.append(indStart);
            buffer.append(indentation);
            buffer.append("'''");
            buffer.append(delimiter);
            buffer.append(indStart);
            buffer.append(indentation);
            buffer.append(new StringBuffer("@see super method: ").append(rep).toString());
            buffer.append(delimiter);
            buffer.append(indStart);
            buffer.append(indentation);
            buffer.append("'''");
            buffer.append(delimiter);
            buffer.append(indStart);
            buffer.append(indentation);
            String comp = buffer.toString();
            l.add(new PyCompletionProposal(comp, ps.getStartLine().getOffset(), ps.getStartLine().getLength(), comp.length(), imageCache.get("icons/class_obj.gif"), new StringBuffer(String.valueOf(rep)).append(" (Override)").toString(), null, null, 10));
        }
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return sel.indexOf("def ") != -1;
    }
}

