# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{sequel_pg}
  s.version = "1.1.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeremy Evans"]
  s.date = %q{2011-06-01}
  s.description = %q{sequel_pg overwrites the inner loop of the Sequel postgres
adapter row fetching code with a C version.  The C version
is significantly faster (2-6x) than the pure ruby version
that Sequel uses by default.
}
  s.email = %q{code@jeremyevans.net}
  s.extensions = ["ext/sequel_pg/extconf.rb"]
  s.extra_rdoc_files = ["README.rdoc", "CHANGELOG", "MIT-LICENSE"]
  s.files = ["MIT-LICENSE", "CHANGELOG", "README.rdoc", "Rakefile", "ext/sequel_pg/extconf.rb", "ext/sequel_pg/sequel_pg.c"]
  s.homepage = %q{http://github.com/jeremyevans/sequel_pg}
  s.rdoc_options = ["--quiet", "--line-numbers", "--inline-source", "--title", "sequel_pg: Faster SELECTs when using Sequel with pg", "--main", "README.rdoc"]
  s.require_paths = ["lib"]
  s.required_ruby_version = Gem::Requirement.new(">= 1.8.6")
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{Faster SELECTs when using Sequel with pg}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<pg>, [">= 0.8.0"])
      s.add_runtime_dependency(%q<sequel>, [">= 3.24.0"])
    else
      s.add_dependency(%q<pg>, [">= 0.8.0"])
      s.add_dependency(%q<sequel>, [">= 3.24.0"])
    end
  else
    s.add_dependency(%q<pg>, [">= 0.8.0"])
    s.add_dependency(%q<sequel>, [">= 3.24.0"])
  end
end
