/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project.chooser;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.ItemList;
import tr.model.project.Project;
import tr.view.project.chooser.ProjectTreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsPanel
extends JPanel {
    private static final Class CLASS = ProjectsPanel.class;
    private Vector<ActionListener> actionListeners;
    private Map<Integer, Boolean> mapProjectSorts;
    private Map<Integer, Boolean> mapFutureSorts;
    private JPanel futurePanel;
    private JScrollPane futureScrollPane;
    private JToolBar futureToolBar;
    private JTree futureTree;
    private JPanel projectsPanel;
    private JScrollPane projectsScrollPane;
    private JToolBar projectsToolBar;
    private JTree projectsTree;
    private JTabbedPane tabbedPane;

    public ProjectsPanel() {
        this.initComponents();
        this.mapProjectSorts = new HashMap<Integer, Boolean>();
        this.mapFutureSorts = new HashMap<Integer, Boolean>();
    }

    private JToolBar getProjectsToolbar() {
        ToolBarButton expandButton = new ToolBarButton((Icon)Icons.ZoomIn);
        expandButton.setPreferredSize(new Dimension(18, 18));
        expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.expand(ProjectsPanel.this.projectsTree);
            }
        });
        ToolBarButton collapseButton = new ToolBarButton((Icon)Icons.ZoomOut);
        collapseButton.setPreferredSize(new Dimension(18, 18));
        collapseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.collapse(ProjectsPanel.this.projectsTree);
            }
        });
        ToolBarButton sortAZButton = new ToolBarButton((Icon)Icons.SortAZ);
        sortAZButton.setPreferredSize(new Dimension(18, 18));
        sortAZButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.sortAlphabetic(ProjectsPanel.this.projectsTree, true, ProjectsPanel.this.mapProjectSorts);
            }
        });
        ToolBarButton sortZAButton = new ToolBarButton((Icon)Icons.SortZA);
        sortZAButton.setPreferredSize(new Dimension(18, 18));
        sortZAButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.sortAlphabetic(ProjectsPanel.this.projectsTree, false, ProjectsPanel.this.mapProjectSorts);
            }
        });
        sortAZButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"sort.ascending"));
        sortZAButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"sort.descending"));
        if (Utilities.isMac()) {
            expandButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"expand.tooltip") + " (\u2318E)");
            collapseButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"collapse.tooltip") + " (\u2303\u2318E)");
        } else {
            expandButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"expand.tooltip") + " (Ctrl+E)");
            collapseButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"collapse.tooltip") + " (Shift+Ctrl+E)");
        }
        JToolBar tb = new JToolBar();
        tb.add(expandButton);
        tb.add(collapseButton);
        tb.add(sortAZButton);
        tb.add(sortZAButton);
        return tb;
    }

    private JToolBar getFutureToolbar() {
        ToolBarButton expandButton = new ToolBarButton((Icon)Icons.ZoomIn);
        expandButton.setPreferredSize(new Dimension(18, 18));
        expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.expand(ProjectsPanel.this.futureTree);
            }
        });
        ToolBarButton collapseButton = new ToolBarButton((Icon)Icons.ZoomOut);
        collapseButton.setPreferredSize(new Dimension(18, 18));
        collapseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.collapse(ProjectsPanel.this.futureTree);
            }
        });
        ToolBarButton sortAZButton = new ToolBarButton((Icon)Icons.SortAZ);
        sortAZButton.setPreferredSize(new Dimension(18, 18));
        sortAZButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.sortAlphabetic(ProjectsPanel.this.futureTree, true, ProjectsPanel.this.mapFutureSorts);
            }
        });
        ToolBarButton sortZAButton = new ToolBarButton((Icon)Icons.SortZA);
        sortZAButton.setPreferredSize(new Dimension(18, 18));
        sortZAButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProjectsPanel.this.sortAlphabetic(ProjectsPanel.this.futureTree, false, ProjectsPanel.this.mapFutureSorts);
            }
        });
        sortAZButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"sort.ascending"));
        sortZAButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"sort.descending"));
        if (Utilities.isMac()) {
            expandButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"expand.tooltip") + " (\u2318E)");
            collapseButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"collapse.tooltip") + " (\u2303\u2318E)");
        } else {
            expandButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"expand.tooltip") + " (Ctrl+E)");
            collapseButton.setToolTipText(NbBundle.getMessage((Class)CLASS, (String)"collapse.tooltip") + " (Shift+Ctrl+E)");
        }
        JToolBar tb = new JToolBar();
        tb.add(expandButton);
        tb.add(collapseButton);
        tb.add(sortAZButton);
        tb.add(sortZAButton);
        return tb;
    }

    private void sortAlphabetic(JTree tree, boolean ascending, Map<Integer, Boolean> sortsMap) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.sortAlphabetic(tree, node, ascending);
        ((DefaultTreeModel)tree.getModel()).reload(node);
        tree.setSelectionPath(new TreePath(node.getPath()));
        Object object = node.getUserObject();
        if (object instanceof Project) {
            Project project = (Project)object;
            sortsMap.put(project.getID(), ascending);
        } else {
            sortsMap.put(0, ascending);
        }
    }

    private void sortAlphabetic(JTree tree, DefaultMutableTreeNode node, boolean ascending) {
        Vector<DefaultMutableTreeNode> list = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            list.add((DefaultMutableTreeNode)e.nextElement());
        }
        Collections.sort(list, new NodeComparator(ascending));
        node.removeAllChildren();
        for (DefaultMutableTreeNode n : list) {
            node.add(n);
        }
    }

    private void expand(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.expand(node, tree);
    }

    private void expand(DefaultMutableTreeNode node, JTree tree) {
        tree.expandPath(new TreePath(node.getPath()));
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            this.expand((DefaultMutableTreeNode)e.nextElement(), tree);
        }
    }

    private void collapse(JTree tree) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.collapse(node, tree);
    }

    private void collapse(DefaultMutableTreeNode node, JTree tree) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            this.collapse((DefaultMutableTreeNode)e.nextElement(), tree);
        }
        tree.collapsePath(new TreePath(node.getPath()));
    }

    public void refreshModel() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.projectsTree.getModel().getRoot();
        top.removeAllChildren();
        this.createNodes(top, data.getRootProjects());
        this.refreshSorts(this.mapProjectSorts, this.projectsTree);
        ((DefaultTreeModel)this.projectsTree.getModel()).reload(top);
        top = (DefaultMutableTreeNode)this.futureTree.getModel().getRoot();
        top.removeAllChildren();
        this.createNodes(top, data.getRootFutures());
        this.refreshSorts(this.mapFutureSorts, this.futureTree);
        ((DefaultTreeModel)this.futureTree.getModel()).reload(top);
    }

    private void refreshSorts(Map<Integer, Boolean> map, JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        for (Integer id : map.keySet()) {
            if (id == 0) {
                this.sortAlphabetic(tree, root, map.get(id));
                continue;
            }
            DefaultMutableTreeNode node = this.findNode(id, root);
            if (node == null) continue;
            this.sortAlphabetic(tree, node, map.get(id));
        }
    }

    private JTree getProjectsTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(NbBundle.getMessage((Class)CLASS, (String)"projects"));
        final JTree tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer(new ProjectTreeCellRenderer((Icon)Icons.Project, Icons.ProjectOpen));
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        tree.setToggleClickCount(-1);
        tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ProjectsPanel.this.getSelected() != null) {
                    ProjectsPanel.this.fireSelectedAction();
                    return;
                }
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 69) {
                    if (Utilities.isMac() ? !e.isMetaDown() : !e.isControlDown()) {
                        return;
                    }
                    if (e.isShiftDown()) {
                        ProjectsPanel.this.collapse(tree);
                    } else {
                        ProjectsPanel.this.expand(tree);
                    }
                }
            }
        });
        return tree;
    }

    private JTree getFutureProjectsTree() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return null;
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(NbBundle.getMessage((Class)CLASS, (String)"future.projects"));
        this.createNodes(top, data.getRootFutures());
        final JTree tree = new JTree(top);
        tree.setCellRenderer(new ProjectTreeCellRenderer((Icon)Icons.ProjectFuture, Icons.ProjectFutureOpen));
        tree.setRootVisible(true);
        tree.setShowsRootHandles(true);
        tree.setToggleClickCount(-1);
        tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ProjectsPanel.this.getSelected() != null) {
                    ProjectsPanel.this.fireSelectedAction();
                    return;
                }
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 69) {
                    if (Utilities.isMac() ? !e.isMetaDown() : !e.isControlDown()) {
                        return;
                    }
                    if (e.isShiftDown()) {
                        ProjectsPanel.this.collapse(tree);
                    } else {
                        ProjectsPanel.this.expand(tree);
                    }
                }
            }
        });
        return tree;
    }

    private void createNodes(DefaultMutableTreeNode node, Project project) {
        for (Project subProject : project.getChildren(Project.class)) {
            if (subProject.isDone()) continue;
            DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(subProject);
            this.createNodes(subNode, subProject);
            node.add(subNode);
        }
    }

    public void setSelected(Project project) {
        JTree tree;
        if (project == null) {
            this.tabbedPane.setSelectedIndex(0);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.projectsTree.getModel().getRoot();
            this.projectsTree.setSelectionPath(new TreePath(root.getPath()));
            this.projectsTree.requestFocusInWindow();
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        if (project.isWithin((ItemList)data.getRootProjects())) {
            tree = this.projectsTree;
            this.tabbedPane.setSelectedIndex(0);
        } else if (project.isWithin((ItemList)data.getRootFutures())) {
            tree = this.futureTree;
            this.tabbedPane.setSelectedIndex(1);
        } else {
            return;
        }
        DefaultMutableTreeNode node = this.findNode(project.getID(), (DefaultMutableTreeNode)tree.getModel().getRoot());
        if (node == null) {
            return;
        }
        tree.setSelectionPath(new TreePath(node.getPath()));
    }

    private DefaultMutableTreeNode findNode(int projectID, DefaultMutableTreeNode node) {
        Project project;
        Object object = node.getUserObject();
        if (object instanceof Project && (project = (Project)object).getID() == projectID) {
            return node;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = this.findNode(projectID, (DefaultMutableTreeNode)e.nextElement());
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public Project getSelected() {
        JTree tree;
        if (this.tabbedPane.getSelectedIndex() == 0) {
            tree = this.projectsTree;
        } else if (this.tabbedPane.getSelectedIndex() == 1) {
            tree = this.futureTree;
        } else {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object object = node.getUserObject();
        if (object instanceof Project) {
            return (Project)object;
        }
        return null;
    }

    public void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        if (this.actionListeners.contains(listener)) {
            return;
        }
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.remove(listener);
    }

    public void fireSelectedAction() {
        ActionEvent event = new ActionEvent(this, 0, "selected");
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(event);
        }
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.projectsPanel = new JPanel();
        this.projectsToolBar = this.getProjectsToolbar();
        this.projectsScrollPane = new JScrollPane();
        this.projectsTree = this.getProjectsTree();
        this.futurePanel = new JPanel();
        this.futureToolBar = this.getFutureToolbar();
        this.futureScrollPane = new JScrollPane();
        this.futureTree = this.getFutureProjectsTree();
        this.setPreferredSize(new Dimension(400, 600));
        this.setLayout(new BorderLayout());
        this.tabbedPane.setName("");
        this.projectsPanel.setLayout(new BorderLayout());
        this.projectsToolBar.setFloatable(false);
        this.projectsToolBar.setRollover(true);
        this.projectsToolBar.setPreferredSize(new Dimension(100, 32));
        this.projectsPanel.add((Component)this.projectsToolBar, "First");
        this.projectsScrollPane.setViewportView(this.projectsTree);
        this.projectsPanel.add((Component)this.projectsScrollPane, "Center");
        this.tabbedPane.addTab(NbBundle.getMessage(ProjectsPanel.class, (String)"ProjectsPanel.projectsPanel.TabConstraints.tabTitle"), this.projectsPanel);
        this.futurePanel.setLayout(new BorderLayout());
        this.futureToolBar.setFloatable(false);
        this.futureToolBar.setRollover(true);
        this.futureToolBar.setMinimumSize(new Dimension(24, 40));
        this.futureToolBar.setPreferredSize(new Dimension(100, 32));
        this.futurePanel.add((Component)this.futureToolBar, "First");
        this.futureScrollPane.setViewportView(this.futureTree);
        this.futurePanel.add((Component)this.futureScrollPane, "Center");
        this.tabbedPane.addTab(NbBundle.getMessage(ProjectsPanel.class, (String)"ProjectsPanel.futurePanel.TabConstraints.tabTitle"), this.futurePanel);
        this.add((Component)this.tabbedPane, "Center");
    }

    private class ToolBarButton
    extends JButton {
        public ToolBarButton(Icon icon) {
            super(icon);
            this.setMargin(new Insets(2, 2, 2, 2));
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }

        public ToolBarButton(String imageFile) {
            this((Icon)new ImageIcon(imageFile));
        }

        public ToolBarButton(String imageFile, String text) {
            this((Icon)new ImageIcon(imageFile));
            this.setText(text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private final boolean ascending;

        public NodeComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            Project p1 = (Project)n1.getUserObject();
            Project p2 = (Project)n2.getUserObject();
            if (this.ascending) {
                return p1.getDescription().compareToIgnoreCase(p2.getDescription());
            }
            return p2.getDescription().compareToIgnoreCase(p1.getDescription());
        }
    }
}

