from MAPICore import *
from MAPI.Defs import *
import MAPI

if MAPI.unicode:
    PT_TSTRING		= PT_UNICODE;
    PT_MV_TSTRING	= PT_MV_UNICODE;
else:
    PT_TSTRING		= PT_STRING8;
    PT_MV_TSTRING	= PT_MV_STRING8;

# Default properties
PR_ACKNOWLEDGEMENT_MODE = PROP_TAG( PT_LONG,      0x0001)
PR_ALTERNATE_RECIPIENT_ALLOWED = PROP_TAG( PT_BOOLEAN,   0x0002)
PR_AUTHORIZING_USERS = PROP_TAG( PT_BINARY,    0x0003)
PR_AUTO_FORWARD_COMMENT = PROP_TAG( PT_TSTRING,   0x0004)
PR_AUTO_FORWARD_COMMENT_W = PROP_TAG( PT_UNICODE,   0x0004)
PR_AUTO_FORWARD_COMMENT_A = PROP_TAG( PT_STRING8,   0x0004)
PR_AUTO_FORWARDED = PROP_TAG( PT_BOOLEAN,   0x0005)
PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID = PROP_TAG( PT_BINARY,    0x0006)
PR_CONTENT_CORRELATOR = PROP_TAG( PT_BINARY,    0x0007)
PR_CONTENT_IDENTIFIER = PROP_TAG( PT_TSTRING,   0x0008)
PR_CONTENT_IDENTIFIER_W = PROP_TAG( PT_UNICODE,   0x0008)
PR_CONTENT_IDENTIFIER_A = PROP_TAG( PT_STRING8,   0x0008)
PR_CONTENT_LENGTH = PROP_TAG( PT_LONG,      0x0009)
PR_CONTENT_RETURN_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x000A)
PR_CONVERSATION_KEY = PROP_TAG( PT_BINARY,    0x000B)
PR_CONVERSION_EITS = PROP_TAG( PT_BINARY,    0x000C)
PR_CONVERSION_WITH_LOSS_PROHIBITED = PROP_TAG( PT_BOOLEAN,   0x000D)
PR_CONVERTED_EITS = PROP_TAG( PT_BINARY,    0x000E)
PR_DEFERRED_DELIVERY_TIME = PROP_TAG( PT_SYSTIME,   0x000F)
PR_DELIVER_TIME = PROP_TAG( PT_SYSTIME,   0x0010)
PR_DISCARD_REASON = PROP_TAG( PT_LONG,      0x0011)
PR_DISCLOSURE_OF_RECIPIENTS = PROP_TAG( PT_BOOLEAN,   0x0012)
PR_DL_EXPANSION_HISTORY = PROP_TAG( PT_BINARY,    0x0013)
PR_DL_EXPANSION_PROHIBITED = PROP_TAG( PT_BOOLEAN,   0x0014)
PR_EXPIRY_TIME = PROP_TAG( PT_SYSTIME,   0x0015)
PR_IMPLICIT_CONVERSION_PROHIBITED = PROP_TAG( PT_BOOLEAN,   0x0016)
PR_IMPORTANCE = PROP_TAG( PT_LONG,      0x0017)
PR_IPM_ID = PROP_TAG( PT_BINARY,    0x0018)
PR_LATEST_DELIVERY_TIME = PROP_TAG( PT_SYSTIME,   0x0019)
PR_MESSAGE_CLASS = PROP_TAG( PT_TSTRING,   0x001A)
PR_MESSAGE_CLASS_W = PROP_TAG( PT_UNICODE,   0x001A)
PR_MESSAGE_CLASS_A = PROP_TAG( PT_STRING8,   0x001A)
PR_MESSAGE_DELIVERY_ID = PROP_TAG( PT_BINARY,    0x001B)
PR_MESSAGE_SECURITY_LABEL = PROP_TAG( PT_BINARY,    0x001E)
PR_OBSOLETED_IPMS = PROP_TAG( PT_BINARY,    0x001F)
PR_ORIGINALLY_INTENDED_RECIPIENT_NAME = PROP_TAG( PT_BINARY,    0x0020)
PR_ORIGINAL_EITS = PROP_TAG( PT_BINARY,    0x0021)
PR_ORIGINATOR_CERTIFICATE = PROP_TAG( PT_BINARY,    0x0022)
PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0023)
PR_ORIGINATOR_RETURN_ADDRESS = PROP_TAG( PT_BINARY,    0x0024)
PR_PARENT_KEY = PROP_TAG( PT_BINARY,    0x0025)
PR_PRIORITY = PROP_TAG( PT_LONG,      0x0026)
PR_ORIGIN_CHECK = PROP_TAG( PT_BINARY,    0x0027)
PR_PROOF_OF_SUBMISSION_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0028)
PR_READ_RECEIPT_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0029)
PR_RECEIPT_TIME = PROP_TAG( PT_SYSTIME,   0x002A)
PR_RECIPIENT_REASSIGNMENT_PROHIBITED = PROP_TAG( PT_BOOLEAN,   0x002B)
PR_REDIRECTION_HISTORY = PROP_TAG( PT_BINARY,    0x002C)
PR_RELATED_IPMS = PROP_TAG( PT_BINARY,    0x002D)
PR_ORIGINAL_SENSITIVITY = PROP_TAG( PT_LONG,      0x002E)
PR_LANGUAGES = PROP_TAG( PT_TSTRING,   0x002F)
PR_LANGUAGES_W = PROP_TAG( PT_UNICODE,   0x002F)
PR_LANGUAGES_A = PROP_TAG( PT_STRING8,   0x002F)
PR_REPLY_TIME = PROP_TAG( PT_SYSTIME,   0x0030)
PR_REPORT_TAG = PROP_TAG( PT_BINARY,    0x0031)
PR_REPORT_TIME = PROP_TAG( PT_SYSTIME,   0x0032)
PR_RETURNED_IPM = PROP_TAG( PT_BOOLEAN,   0x0033)
PR_SECURITY = PROP_TAG( PT_LONG,      0x0034)
PR_INCOMPLETE_COPY = PROP_TAG( PT_BOOLEAN,   0x0035)
PR_SENSITIVITY = PROP_TAG( PT_LONG,      0x0036)
PR_SUBJECT = PROP_TAG( PT_TSTRING,   0x0037)
PR_SUBJECT_W = PROP_TAG( PT_UNICODE,   0x0037)
PR_SUBJECT_A = PROP_TAG( PT_STRING8,   0x0037)
PR_SUBJECT_IPM = PROP_TAG( PT_BINARY,    0x0038)
PR_CLIENT_SUBMIT_TIME = PROP_TAG( PT_SYSTIME,   0x0039)
PR_REPORT_NAME = PROP_TAG( PT_TSTRING,   0x003A)
PR_REPORT_NAME_W = PROP_TAG( PT_UNICODE,   0x003A)
PR_REPORT_NAME_A = PROP_TAG( PT_STRING8,   0x003A)
PR_SENT_REPRESENTING_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x003B)
PR_X400_CONTENT_TYPE = PROP_TAG( PT_BINARY,    0x003C)
PR_SUBJECT_PREFIX = PROP_TAG( PT_TSTRING,   0x003D)
PR_SUBJECT_PREFIX_W = PROP_TAG( PT_UNICODE,   0x003D)
PR_SUBJECT_PREFIX_A = PROP_TAG( PT_STRING8,   0x003D)
PR_NON_RECEIPT_REASON = PROP_TAG( PT_LONG,      0x003E)
PR_RECEIVED_BY_ENTRYID = PROP_TAG( PT_BINARY,    0x003F)
PR_RECEIVED_BY_NAME = PROP_TAG( PT_TSTRING,   0x0040)
PR_RECEIVED_BY_NAME_W = PROP_TAG( PT_UNICODE,   0x0040)
PR_RECEIVED_BY_NAME_A = PROP_TAG( PT_STRING8,   0x0040)
PR_SENT_REPRESENTING_ENTRYID = PROP_TAG( PT_BINARY,    0x0041)
PR_SENT_REPRESENTING_NAME = PROP_TAG( PT_TSTRING,   0x0042)
PR_SENT_REPRESENTING_NAME_W = PROP_TAG( PT_UNICODE,   0x0042)
PR_SENT_REPRESENTING_NAME_A = PROP_TAG( PT_STRING8,   0x0042)
PR_RCVD_REPRESENTING_ENTRYID = PROP_TAG( PT_BINARY,    0x0043)
PR_RCVD_REPRESENTING_NAME = PROP_TAG( PT_TSTRING,   0x0044)
PR_RCVD_REPRESENTING_NAME_W = PROP_TAG( PT_UNICODE,   0x0044)
PR_RCVD_REPRESENTING_NAME_A = PROP_TAG( PT_STRING8,   0x0044)
PR_REPORT_ENTRYID = PROP_TAG( PT_BINARY,    0x0045)
PR_READ_RECEIPT_ENTRYID = PROP_TAG( PT_BINARY,    0x0046)
PR_MESSAGE_SUBMISSION_ID = PROP_TAG( PT_BINARY,    0x0047)
PR_PROVIDER_SUBMIT_TIME = PROP_TAG( PT_SYSTIME,   0x0048)
PR_ORIGINAL_SUBJECT = PROP_TAG( PT_TSTRING,   0x0049)
PR_ORIGINAL_SUBJECT_W = PROP_TAG( PT_UNICODE,   0x0049)
PR_ORIGINAL_SUBJECT_A = PROP_TAG( PT_STRING8,   0x0049)
PR_DISC_VAL = PROP_TAG( PT_BOOLEAN,   0x004A)
PR_ORIG_MESSAGE_CLASS = PROP_TAG( PT_TSTRING,   0x004B)
PR_ORIG_MESSAGE_CLASS_W = PROP_TAG( PT_UNICODE,   0x004B)
PR_ORIG_MESSAGE_CLASS_A = PROP_TAG( PT_STRING8,   0x004B)
PR_ORIGINAL_AUTHOR_ENTRYID = PROP_TAG( PT_BINARY,    0x004C)
PR_ORIGINAL_AUTHOR_NAME = PROP_TAG( PT_TSTRING,   0x004D)
PR_ORIGINAL_AUTHOR_NAME_W = PROP_TAG( PT_UNICODE,   0x004D)
PR_ORIGINAL_AUTHOR_NAME_A = PROP_TAG( PT_STRING8,   0x004D)
PR_ORIGINAL_SUBMIT_TIME = PROP_TAG( PT_SYSTIME,   0x004E)
PR_REPLY_RECIPIENT_ENTRIES = PROP_TAG( PT_BINARY,    0x004F)
PR_REPLY_RECIPIENT_NAMES = PROP_TAG( PT_TSTRING,   0x0050)
PR_REPLY_RECIPIENT_NAMES_W = PROP_TAG( PT_UNICODE,   0x0050)
PR_REPLY_RECIPIENT_NAMES_A = PROP_TAG( PT_STRING8,   0x0050)
PR_RECEIVED_BY_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x0051)
PR_RCVD_REPRESENTING_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x0052)
PR_READ_RECEIPT_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x0053)
PR_REPORT_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x0054)
PR_ORIGINAL_DELIVERY_TIME = PROP_TAG( PT_SYSTIME,   0x0055)
PR_ORIGINAL_AUTHOR_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x0056)
PR_MESSAGE_TO_ME = PROP_TAG( PT_BOOLEAN,   0x0057)
PR_MESSAGE_CC_ME = PROP_TAG( PT_BOOLEAN,   0x0058)
PR_MESSAGE_RECIP_ME = PROP_TAG( PT_BOOLEAN,   0x0059)
PR_ORIGINAL_SENDER_NAME = PROP_TAG( PT_TSTRING,   0x005A)
PR_ORIGINAL_SENDER_NAME_W = PROP_TAG( PT_UNICODE,   0x005A)
PR_ORIGINAL_SENDER_NAME_A = PROP_TAG( PT_STRING8,   0x005A)
PR_ORIGINAL_SENDER_ENTRYID = PROP_TAG( PT_BINARY,    0x005B)
PR_ORIGINAL_SENDER_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x005C)
PR_ORIGINAL_SENT_REPRESENTING_NAME = PROP_TAG( PT_TSTRING,   0x005D)
PR_ORIGINAL_SENT_REPRESENTING_NAME_W = PROP_TAG( PT_UNICODE,   0x005D)
PR_ORIGINAL_SENT_REPRESENTING_NAME_A = PROP_TAG( PT_STRING8,   0x005D)
PR_ORIGINAL_SENT_REPRESENTING_ENTRYID = PROP_TAG( PT_BINARY,    0x005E)
PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x005F)
PR_START_DATE = PROP_TAG( PT_SYSTIME,   0x0060)
PR_END_DATE = PROP_TAG( PT_SYSTIME,   0x0061)
PR_OWNER_APPT_ID = PROP_TAG( PT_LONG,      0x0062)
PR_RESPONSE_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0063)
PR_SENT_REPRESENTING_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0064)
PR_SENT_REPRESENTING_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0064)
PR_SENT_REPRESENTING_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0064)
PR_SENT_REPRESENTING_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0065)
PR_SENT_REPRESENTING_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x0065)
PR_SENT_REPRESENTING_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x0065)
PR_ORIGINAL_SENDER_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0066)
PR_ORIGINAL_SENDER_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0066)
PR_ORIGINAL_SENDER_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0066)
PR_ORIGINAL_SENDER_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0067)
PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x0067)
PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x0067)
PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0068)
PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0068)
PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0068)
PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0069)
PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x0069)
PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x0069)
PR_CONVERSATION_TOPIC = PROP_TAG( PT_TSTRING,   0x0070)
PR_CONVERSATION_TOPIC_W = PROP_TAG( PT_UNICODE,   0x0070)
PR_CONVERSATION_TOPIC_A = PROP_TAG( PT_STRING8,   0x0070)
PR_CONVERSATION_INDEX = PROP_TAG( PT_BINARY,    0x0071)
PR_ORIGINAL_DISPLAY_BCC = PROP_TAG( PT_TSTRING,   0x0072)
PR_ORIGINAL_DISPLAY_BCC_W = PROP_TAG( PT_UNICODE,   0x0072)
PR_ORIGINAL_DISPLAY_BCC_A = PROP_TAG( PT_STRING8,   0x0072)
PR_ORIGINAL_DISPLAY_CC = PROP_TAG( PT_TSTRING,   0x0073)
PR_ORIGINAL_DISPLAY_CC_W = PROP_TAG( PT_UNICODE,   0x0073)
PR_ORIGINAL_DISPLAY_CC_A = PROP_TAG( PT_STRING8,   0x0073)
PR_ORIGINAL_DISPLAY_TO = PROP_TAG( PT_TSTRING,   0x0074)
PR_ORIGINAL_DISPLAY_TO_W = PROP_TAG( PT_UNICODE,   0x0074)
PR_ORIGINAL_DISPLAY_TO_A = PROP_TAG( PT_STRING8,   0x0074)
PR_RECEIVED_BY_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0075)
PR_RECEIVED_BY_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0075)
PR_RECEIVED_BY_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0075)
PR_RECEIVED_BY_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0076)
PR_RECEIVED_BY_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x0076)
PR_RECEIVED_BY_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x0076)
PR_RCVD_REPRESENTING_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0077)
PR_RCVD_REPRESENTING_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0077)
PR_RCVD_REPRESENTING_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0077)
PR_RCVD_REPRESENTING_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0078)
PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x0078)
PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x0078)
PR_ORIGINAL_AUTHOR_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0079)
PR_ORIGINAL_AUTHOR_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0079)
PR_ORIGINAL_AUTHOR_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0079)
PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x007A)
PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x007A)
PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x007A)
PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x007B)
PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x007B)
PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x007B)
PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x007C)
PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x007C)
PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x007C)
PR_TRANSPORT_MESSAGE_HEADERS = PROP_TAG(PT_TSTRING,    0x007D)
PR_TRANSPORT_MESSAGE_HEADERS_W = PROP_TAG(PT_UNICODE,    0x007D)
PR_TRANSPORT_MESSAGE_HEADERS_A = PROP_TAG(PT_STRING8,    0x007D)
PR_DELEGATION = PROP_TAG(PT_BINARY,     0x007E)
PR_TNEF_CORRELATION_KEY = PROP_TAG(PT_BINARY,     0x007F)
PR_BODY = PROP_TAG( PT_TSTRING,   0x1000)
PR_BODY_W = PROP_TAG( PT_UNICODE,   0x1000)
PR_BODY_A = PROP_TAG( PT_STRING8,   0x1000)
PR_REPORT_TEXT = PROP_TAG( PT_TSTRING,   0x1001)
PR_REPORT_TEXT_W = PROP_TAG( PT_UNICODE,   0x1001)
PR_REPORT_TEXT_A = PROP_TAG( PT_STRING8,   0x1001)
PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY = PROP_TAG( PT_BINARY,    0x1002)
PR_REPORTING_DL_NAME = PROP_TAG( PT_BINARY,    0x1003)
PR_REPORTING_MTA_CERTIFICATE = PROP_TAG( PT_BINARY,    0x1004)
PR_RTF_SYNC_BODY_CRC = PROP_TAG( PT_LONG,      0x1006)
PR_RTF_SYNC_BODY_COUNT = PROP_TAG( PT_LONG,      0x1007)
PR_RTF_SYNC_BODY_TAG = PROP_TAG( PT_TSTRING,   0x1008)
PR_RTF_SYNC_BODY_TAG_W = PROP_TAG( PT_UNICODE,   0x1008)
PR_RTF_SYNC_BODY_TAG_A = PROP_TAG( PT_STRING8,   0x1008)
PR_RTF_COMPRESSED = PROP_TAG( PT_BINARY,    0x1009)
PR_RTF_SYNC_PREFIX_COUNT = PROP_TAG( PT_LONG,      0x1010)
PR_RTF_SYNC_TRAILING_COUNT = PROP_TAG( PT_LONG,      0x1011)
PR_ORIGINALLY_INTENDED_RECIP_ENTRYID = PROP_TAG( PT_BINARY,    0x1012)
PR_CONTENT_INTEGRITY_CHECK = PROP_TAG( PT_BINARY,    0x0C00)
PR_EXPLICIT_CONVERSION = PROP_TAG( PT_LONG,      0x0C01)
PR_IPM_RETURN_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C02)
PR_MESSAGE_TOKEN = PROP_TAG( PT_BINARY,    0x0C03)
PR_NDR_REASON_CODE = PROP_TAG( PT_LONG,      0x0C04)
PR_NDR_DIAG_CODE = PROP_TAG( PT_LONG,      0x0C05)
PR_NON_RECEIPT_NOTIFICATION_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C06)
PR_DELIVERY_POINT = PROP_TAG( PT_LONG,      0x0C07)
PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C08)
PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT = PROP_TAG( PT_BINARY,    0x0C09)
PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY = PROP_TAG( PT_BOOLEAN,   0x0C0A)
PR_PHYSICAL_DELIVERY_MODE = PROP_TAG( PT_LONG,      0x0C0B)
PR_PHYSICAL_DELIVERY_REPORT_REQUEST = PROP_TAG( PT_LONG,      0x0C0C)
PR_PHYSICAL_FORWARDING_ADDRESS = PROP_TAG( PT_BINARY,    0x0C0D)
PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C0E)
PR_PHYSICAL_FORWARDING_PROHIBITED = PROP_TAG( PT_BOOLEAN,   0x0C0F)
PR_PHYSICAL_RENDITION_ATTRIBUTES = PROP_TAG( PT_BINARY,    0x0C10)
PR_PROOF_OF_DELIVERY = PROP_TAG( PT_BINARY,    0x0C11)
PR_PROOF_OF_DELIVERY_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C12)
PR_RECIPIENT_CERTIFICATE = PROP_TAG( PT_BINARY,    0x0C13)
PR_RECIPIENT_NUMBER_FOR_ADVICE = PROP_TAG( PT_TSTRING,   0x0C14)
PR_RECIPIENT_NUMBER_FOR_ADVICE_W = PROP_TAG( PT_UNICODE,   0x0C14)
PR_RECIPIENT_NUMBER_FOR_ADVICE_A = PROP_TAG( PT_STRING8,   0x0C14)
PR_RECIPIENT_TYPE = PROP_TAG( PT_LONG,      0x0C15)
PR_REGISTERED_MAIL_TYPE = PROP_TAG( PT_LONG,      0x0C16)
PR_REPLY_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C17)
PR_REQUESTED_DELIVERY_METHOD = PROP_TAG( PT_LONG,      0x0C18)
PR_SENDER_ENTRYID = PROP_TAG( PT_BINARY,    0x0C19)
PR_SENDER_NAME = PROP_TAG( PT_TSTRING,   0x0C1A)
PR_SENDER_NAME_W = PROP_TAG( PT_UNICODE,   0x0C1A)
PR_SENDER_NAME_A = PROP_TAG( PT_STRING8,   0x0C1A)
PR_SUPPLEMENTARY_INFO = PROP_TAG( PT_TSTRING,   0x0C1B)
PR_SUPPLEMENTARY_INFO_W = PROP_TAG( PT_UNICODE,   0x0C1B)
PR_SUPPLEMENTARY_INFO_A = PROP_TAG( PT_STRING8,   0x0C1B)
PR_TYPE_OF_MTS_USER = PROP_TAG( PT_LONG,      0x0C1C)
PR_SENDER_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x0C1D)
PR_SENDER_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x0C1E)
PR_SENDER_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x0C1E)
PR_SENDER_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x0C1E)
PR_SENDER_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0C1F)
PR_SENDER_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x0C1F)
PR_SENDER_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x0C1F)
PR_CURRENT_VERSION = PROP_TAG( PT_I8,        0x0E00)
PR_DELETE_AFTER_SUBMIT = PROP_TAG( PT_BOOLEAN,   0x0E01)
PR_DISPLAY_BCC = PROP_TAG( PT_TSTRING,   0x0E02)
PR_DISPLAY_BCC_W = PROP_TAG( PT_UNICODE,   0x0E02)
PR_DISPLAY_BCC_A = PROP_TAG( PT_STRING8,   0x0E02)
PR_DISPLAY_CC = PROP_TAG( PT_TSTRING,   0x0E03)
PR_DISPLAY_CC_W = PROP_TAG( PT_UNICODE,   0x0E03)
PR_DISPLAY_CC_A = PROP_TAG( PT_STRING8,   0x0E03)
PR_DISPLAY_TO = PROP_TAG( PT_TSTRING,   0x0E04)
PR_DISPLAY_TO_W = PROP_TAG( PT_UNICODE,   0x0E04)
PR_DISPLAY_TO_A = PROP_TAG( PT_STRING8,   0x0E04)
PR_PARENT_DISPLAY = PROP_TAG( PT_TSTRING,   0x0E05)
PR_PARENT_DISPLAY_W = PROP_TAG( PT_UNICODE,   0x0E05)
PR_PARENT_DISPLAY_A = PROP_TAG( PT_STRING8,   0x0E05)
PR_MESSAGE_DELIVERY_TIME = PROP_TAG( PT_SYSTIME,   0x0E06)
PR_MESSAGE_FLAGS = PROP_TAG( PT_LONG,      0x0E07)
PR_MESSAGE_SIZE = PROP_TAG( PT_LONG,      0x0E08)
PR_PARENT_ENTRYID = PROP_TAG( PT_BINARY,    0x0E09)
PR_SENTMAIL_ENTRYID = PROP_TAG( PT_BINARY,    0x0E0A)
PR_CORRELATE = PROP_TAG( PT_BOOLEAN,   0x0E0C)
PR_CORRELATE_MTSID = PROP_TAG( PT_BINARY,    0x0E0D)
PR_DISCRETE_VALUES = PROP_TAG( PT_BOOLEAN,   0x0E0E)
PR_RESPONSIBILITY = PROP_TAG( PT_BOOLEAN,   0x0E0F)
PR_SPOOLER_STATUS = PROP_TAG( PT_LONG,      0x0E10)
PR_TRANSPORT_STATUS = PROP_TAG( PT_LONG,      0x0E11)
PR_MESSAGE_RECIPIENTS = PROP_TAG( PT_OBJECT,    0x0E12)
PR_MESSAGE_ATTACHMENTS = PROP_TAG( PT_OBJECT,    0x0E13)
PR_SUBMIT_FLAGS = PROP_TAG( PT_LONG,      0x0E14)
PR_RECIPIENT_STATUS = PROP_TAG( PT_LONG,      0x0E15)
PR_TRANSPORT_KEY = PROP_TAG( PT_LONG,      0x0E16)
PR_MSG_STATUS = PROP_TAG( PT_LONG,      0x0E17)
PR_MESSAGE_DOWNLOAD_TIME = PROP_TAG( PT_LONG,      0x0E18)
PR_CREATION_VERSION = PROP_TAG( PT_I8,        0x0E19)
PR_MODIFY_VERSION = PROP_TAG( PT_I8,        0x0E1A)
PR_HASATTACH = PROP_TAG( PT_BOOLEAN,   0x0E1B)
PR_BODY_CRC = PROP_TAG( PT_LONG,      0x0E1C)
PR_NORMALIZED_SUBJECT = PROP_TAG( PT_TSTRING,   0x0E1D)
PR_NORMALIZED_SUBJECT_W = PROP_TAG( PT_UNICODE,   0x0E1D)
PR_NORMALIZED_SUBJECT_A = PROP_TAG( PT_STRING8,   0x0E1D)
PR_RTF_IN_SYNC = PROP_TAG( PT_BOOLEAN,   0x0E1F)
PR_ATTACH_SIZE = PROP_TAG( PT_LONG,      0x0E20)
PR_ATTACH_NUM = PROP_TAG( PT_LONG,      0x0E21)
PR_PREPROCESS = PROP_TAG( PT_BOOLEAN,   0x0E22)
PR_ORIGINATING_MTA_CERTIFICATE = PROP_TAG( PT_BINARY,    0x0E25)
PR_PROOF_OF_SUBMISSION = PROP_TAG( PT_BINARY,    0x0E26)
PR_ENTRYID = PROP_TAG( PT_BINARY,    0x0FFF)
PR_OBJECT_TYPE = PROP_TAG( PT_LONG,      0x0FFE)
PR_ICON = PROP_TAG( PT_BINARY,    0x0FFD)
PR_MINI_ICON = PROP_TAG( PT_BINARY,    0x0FFC)
PR_STORE_ENTRYID = PROP_TAG( PT_BINARY,    0x0FFB)
PR_STORE_RECORD_KEY = PROP_TAG( PT_BINARY,    0x0FFA)
PR_RECORD_KEY = PROP_TAG( PT_BINARY,    0x0FF9)
PR_MAPPING_SIGNATURE = PROP_TAG( PT_BINARY,    0x0FF8)
PR_ACCESS_LEVEL = PROP_TAG( PT_LONG,      0x0FF7)
PR_INSTANCE_KEY = PROP_TAG( PT_BINARY,    0x0FF6)
PR_ROW_TYPE = PROP_TAG( PT_LONG,      0x0FF5)
PR_ACCESS = PROP_TAG( PT_LONG,      0x0FF4)
PR_ROWID = PROP_TAG( PT_LONG,      0x3000)
PR_DISPLAY_NAME = PROP_TAG( PT_TSTRING,   0x3001)
PR_DISPLAY_NAME_W = PROP_TAG( PT_UNICODE,   0x3001)
PR_DISPLAY_NAME_A = PROP_TAG( PT_STRING8,   0x3001)
PR_ADDRTYPE = PROP_TAG( PT_TSTRING,   0x3002)
PR_ADDRTYPE_W = PROP_TAG( PT_UNICODE,   0x3002)
PR_ADDRTYPE_A = PROP_TAG( PT_STRING8,   0x3002)
PR_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x3003)
PR_EMAIL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x3003)
PR_EMAIL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x3003)
PR_COMMENT = PROP_TAG( PT_TSTRING,   0x3004)
PR_COMMENT_W = PROP_TAG( PT_UNICODE,   0x3004)
PR_COMMENT_A = PROP_TAG( PT_STRING8,   0x3004)
PR_DEPTH = PROP_TAG( PT_LONG,      0x3005)
PR_PROVIDER_DISPLAY = PROP_TAG( PT_TSTRING,   0x3006)
PR_PROVIDER_DISPLAY_W = PROP_TAG( PT_UNICODE,   0x3006)
PR_PROVIDER_DISPLAY_A = PROP_TAG( PT_STRING8,   0x3006)
PR_CREATION_TIME = PROP_TAG( PT_SYSTIME,   0x3007)
PR_LAST_MODIFICATION_TIME = PROP_TAG( PT_SYSTIME,   0x3008)
PR_RESOURCE_FLAGS = PROP_TAG( PT_LONG,      0x3009)
PR_PROVIDER_DLL_NAME = PROP_TAG( PT_TSTRING,   0x300A)
PR_PROVIDER_DLL_NAME_W = PROP_TAG( PT_UNICODE,   0x300A)
PR_PROVIDER_DLL_NAME_A = PROP_TAG( PT_STRING8,   0x300A)
PR_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x300B)
PR_PROVIDER_UID = PROP_TAG( PT_BINARY,    0x300C)
PR_PROVIDER_ORDINAL = PROP_TAG( PT_LONG,      0x300D)
PR_FORM_VERSION = PROP_TAG(PT_TSTRING,    0x3301)
PR_FORM_VERSION_W = PROP_TAG(PT_UNICODE,    0x3301)
PR_FORM_VERSION_A = PROP_TAG(PT_STRING8,    0x3301)
PR_FORM_CLSID = PROP_TAG(PT_CLSID,      0x3302)
PR_FORM_CONTACT_NAME = PROP_TAG(PT_TSTRING,    0x3303)
PR_FORM_CONTACT_NAME_W = PROP_TAG(PT_UNICODE,    0x3303)
PR_FORM_CONTACT_NAME_A = PROP_TAG(PT_STRING8,    0x3303)
PR_FORM_CATEGORY = PROP_TAG(PT_TSTRING,    0x3304)
PR_FORM_CATEGORY_W = PROP_TAG(PT_UNICODE,    0x3304)
PR_FORM_CATEGORY_A = PROP_TAG(PT_STRING8,    0x3304)
PR_FORM_CATEGORY_SUB = PROP_TAG(PT_TSTRING,    0x3305)
PR_FORM_CATEGORY_SUB_W = PROP_TAG(PT_UNICODE,    0x3305)
PR_FORM_CATEGORY_SUB_A = PROP_TAG(PT_STRING8,    0x3305)
PR_FORM_HOST_MAP = PROP_TAG(PT_MV_LONG,    0x3306)
PR_FORM_HIDDEN = PROP_TAG(PT_BOOLEAN,    0x3307)
PR_FORM_DESIGNER_NAME = PROP_TAG(PT_TSTRING,    0x3308)
PR_FORM_DESIGNER_NAME_W = PROP_TAG(PT_UNICODE,    0x3308)
PR_FORM_DESIGNER_NAME_A = PROP_TAG(PT_STRING8,    0x3308)
PR_FORM_DESIGNER_GUID = PROP_TAG(PT_CLSID,      0x3309)
PR_FORM_MESSAGE_BEHAVIOR = PROP_TAG(PT_LONG,       0x330A)
PR_DEFAULT_STORE = PROP_TAG( PT_BOOLEAN,   0x3400)
PR_STORE_SUPPORT_MASK = PROP_TAG( PT_LONG,      0x340D)
PR_STORE_STATE = PROP_TAG( PT_LONG,      0x340E)
PR_IPM_SUBTREE_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x3410)
PR_IPM_OUTBOX_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x3411)
PR_IPM_WASTEBASKET_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x3412)
PR_IPM_SENTMAIL_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x3413)
PR_MDB_PROVIDER = PROP_TAG( PT_BINARY,    0x3414)
PR_RECEIVE_FOLDER_SETTINGS = PROP_TAG( PT_OBJECT,    0x3415)
PR_VALID_FOLDER_MASK = PROP_TAG( PT_LONG,      0x35DF)
PR_IPM_SUBTREE_ENTRYID = PROP_TAG( PT_BINARY,    0x35E0)
PR_IPM_OUTBOX_ENTRYID = PROP_TAG( PT_BINARY,    0x35E2)
PR_IPM_WASTEBASKET_ENTRYID = PROP_TAG( PT_BINARY,    0x35E3)
PR_IPM_SENTMAIL_ENTRYID = PROP_TAG( PT_BINARY,    0x35E4)
PR_VIEWS_ENTRYID = PROP_TAG( PT_BINARY,    0x35E5)
PR_COMMON_VIEWS_ENTRYID = PROP_TAG( PT_BINARY,    0x35E6)
PR_FINDER_ENTRYID = PROP_TAG( PT_BINARY,    0x35E7)
PR_CONTAINER_FLAGS = PROP_TAG( PT_LONG,      0x3600)
PR_FOLDER_TYPE = PROP_TAG( PT_LONG,      0x3601)
PR_CONTENT_COUNT = PROP_TAG( PT_LONG,      0x3602)
PR_CONTENT_UNREAD = PROP_TAG( PT_LONG,      0x3603)
PR_CREATE_TEMPLATES = PROP_TAG( PT_OBJECT,    0x3604)
PR_DETAILS_TABLE = PROP_TAG( PT_OBJECT,    0x3605)
PR_SEARCH = PROP_TAG( PT_OBJECT,    0x3607)
PR_SELECTABLE = PROP_TAG( PT_BOOLEAN,   0x3609)
PR_SUBFOLDERS = PROP_TAG( PT_BOOLEAN,   0x360A)
PR_STATUS = PROP_TAG( PT_LONG,      0x360B)
PR_ANR = PROP_TAG( PT_TSTRING,   0x360C)
PR_ANR_W = PROP_TAG( PT_UNICODE,   0x360C)
PR_ANR_A = PROP_TAG( PT_STRING8,   0x360C)
PR_CONTENTS_SORT_ORDER = PROP_TAG( PT_MV_LONG,   0x360D)
PR_CONTAINER_HIERARCHY = PROP_TAG( PT_OBJECT,    0x360E)
PR_CONTAINER_CONTENTS = PROP_TAG( PT_OBJECT,    0x360F)
PR_FOLDER_ASSOCIATED_CONTENTS = PROP_TAG( PT_OBJECT,    0x3610)
PR_DEF_CREATE_DL = PROP_TAG( PT_BINARY,    0x3611)
PR_DEF_CREATE_MAILUSER = PROP_TAG( PT_BINARY,    0x3612)
PR_CONTAINER_CLASS = PROP_TAG( PT_TSTRING,   0x3613)
PR_CONTAINER_CLASS_W = PROP_TAG( PT_UNICODE,   0x3613)
PR_CONTAINER_CLASS_A = PROP_TAG( PT_STRING8,   0x3613)
PR_CONTAINER_MODIFY_VERSION = PROP_TAG( PT_I8,        0x3614)
PR_AB_PROVIDER_ID = PROP_TAG( PT_BINARY,    0x3615)
PR_DEFAULT_VIEW_ENTRYID = PROP_TAG( PT_BINARY,    0x3616)
PR_ASSOC_CONTENT_COUNT = PROP_TAG( PT_LONG,      0x3617)
PR_ATTACHMENT_X400_PARAMETERS = PROP_TAG( PT_BINARY,    0x3700)
PR_ATTACH_DATA_OBJ = PROP_TAG( PT_OBJECT,    0x3701)
PR_ATTACH_DATA_BIN = PROP_TAG( PT_BINARY,    0x3701)
PR_ATTACH_ENCODING = PROP_TAG( PT_BINARY,    0x3702)
PR_ATTACH_EXTENSION = PROP_TAG( PT_TSTRING,   0x3703)
PR_ATTACH_EXTENSION_W = PROP_TAG( PT_UNICODE,   0x3703)
PR_ATTACH_EXTENSION_A = PROP_TAG( PT_STRING8,   0x3703)
PR_ATTACH_FILENAME = PROP_TAG( PT_TSTRING,   0x3704)
PR_ATTACH_FILENAME_W = PROP_TAG( PT_UNICODE,   0x3704)
PR_ATTACH_FILENAME_A = PROP_TAG( PT_STRING8,   0x3704)
PR_ATTACH_METHOD = PROP_TAG( PT_LONG,      0x3705)
PR_ATTACH_LONG_FILENAME = PROP_TAG( PT_TSTRING,   0x3707)
PR_ATTACH_LONG_FILENAME_W = PROP_TAG( PT_UNICODE,   0x3707)
PR_ATTACH_LONG_FILENAME_A = PROP_TAG( PT_STRING8,   0x3707)
PR_ATTACH_PATHNAME = PROP_TAG( PT_TSTRING,   0x3708)
PR_ATTACH_PATHNAME_W = PROP_TAG( PT_UNICODE,   0x3708)
PR_ATTACH_PATHNAME_A = PROP_TAG( PT_STRING8,   0x3708)
PR_ATTACH_RENDERING = PROP_TAG( PT_BINARY,    0x3709)
PR_ATTACH_TAG = PROP_TAG( PT_BINARY,    0x370A)
PR_RENDERING_POSITION = PROP_TAG( PT_LONG,      0x370B)
PR_ATTACH_TRANSPORT_NAME = PROP_TAG( PT_TSTRING,   0x370C)
PR_ATTACH_TRANSPORT_NAME_W = PROP_TAG( PT_UNICODE,   0x370C)
PR_ATTACH_TRANSPORT_NAME_A = PROP_TAG( PT_STRING8,   0x370C)
PR_ATTACH_LONG_PATHNAME = PROP_TAG( PT_TSTRING,   0x370D)
PR_ATTACH_LONG_PATHNAME_W = PROP_TAG( PT_UNICODE,   0x370D)
PR_ATTACH_LONG_PATHNAME_A = PROP_TAG( PT_STRING8,   0x370D)
PR_ATTACH_MIME_TAG = PROP_TAG( PT_TSTRING,   0x370E)
PR_ATTACH_MIME_TAG_W = PROP_TAG( PT_UNICODE,   0x370E)
PR_ATTACH_MIME_TAG_A = PROP_TAG( PT_STRING8,   0x370E)
PR_ATTACH_ADDITIONAL_INFO = PROP_TAG( PT_BINARY,    0x370F)
PR_DISPLAY_TYPE = PROP_TAG( PT_LONG,      0x3900)
PR_TEMPLATEID = PROP_TAG( PT_BINARY,    0x3902)
PR_PRIMARY_CAPABILITY = PROP_TAG( PT_BINARY,    0x3904)
PR_7BIT_DISPLAY_NAME = PROP_TAG( PT_STRING8,   0x39FF)
PR_ACCOUNT = PROP_TAG( PT_TSTRING,   0x3A00)
PR_ACCOUNT_W = PROP_TAG( PT_UNICODE,   0x3A00)
PR_ACCOUNT_A = PROP_TAG( PT_STRING8,   0x3A00)
PR_ALTERNATE_RECIPIENT = PROP_TAG( PT_BINARY,    0x3A01)
PR_CALLBACK_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A02)
PR_CALLBACK_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A02)
PR_CALLBACK_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A02)
PR_CONVERSION_PROHIBITED = PROP_TAG( PT_BOOLEAN,   0x3A03)
PR_DISCLOSE_RECIPIENTS = PROP_TAG( PT_BOOLEAN,   0x3A04)
PR_GENERATION = PROP_TAG( PT_TSTRING,   0x3A05)
PR_GENERATION_W = PROP_TAG( PT_UNICODE,   0x3A05)
PR_GENERATION_A = PROP_TAG( PT_STRING8,   0x3A05)
PR_GIVEN_NAME = PROP_TAG( PT_TSTRING,   0x3A06)
PR_GIVEN_NAME_W = PROP_TAG( PT_UNICODE,   0x3A06)
PR_GIVEN_NAME_A = PROP_TAG( PT_STRING8,   0x3A06)
PR_GOVERNMENT_ID_NUMBER = PROP_TAG( PT_TSTRING,   0x3A07)
PR_GOVERNMENT_ID_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A07)
PR_GOVERNMENT_ID_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A07)
PR_BUSINESS_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A08)
PR_BUSINESS_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A08)
PR_BUSINESS_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A08)
PR_HOME_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A09)
PR_HOME_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A09)
PR_HOME_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A09)
PR_INITIALS = PROP_TAG( PT_TSTRING,   0x3A0A)
PR_INITIALS_W = PROP_TAG( PT_UNICODE,   0x3A0A)
PR_INITIALS_A = PROP_TAG( PT_STRING8,   0x3A0A)
PR_KEYWORD = PROP_TAG( PT_TSTRING,   0x3A0B)
PR_KEYWORD_W = PROP_TAG( PT_UNICODE,   0x3A0B)
PR_KEYWORD_A = PROP_TAG( PT_STRING8,   0x3A0B)
PR_LANGUAGE = PROP_TAG( PT_TSTRING,   0x3A0C)
PR_LANGUAGE_W = PROP_TAG( PT_UNICODE,   0x3A0C)
PR_LANGUAGE_A = PROP_TAG( PT_STRING8,   0x3A0C)
PR_LOCATION = PROP_TAG( PT_TSTRING,   0x3A0D)
PR_LOCATION_W = PROP_TAG( PT_UNICODE,   0x3A0D)
PR_LOCATION_A = PROP_TAG( PT_STRING8,   0x3A0D)
PR_MAIL_PERMISSION = PROP_TAG( PT_BOOLEAN,   0x3A0E)
PR_MHS_COMMON_NAME = PROP_TAG( PT_TSTRING,   0x3A0F)
PR_MHS_COMMON_NAME_W = PROP_TAG( PT_UNICODE,   0x3A0F)
PR_MHS_COMMON_NAME_A = PROP_TAG( PT_STRING8,   0x3A0F)
PR_ORGANIZATIONAL_ID_NUMBER = PROP_TAG( PT_TSTRING,   0x3A10)
PR_ORGANIZATIONAL_ID_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A10)
PR_ORGANIZATIONAL_ID_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A10)
PR_SURNAME = PROP_TAG( PT_TSTRING,   0x3A11)
PR_SURNAME_W = PROP_TAG( PT_UNICODE,   0x3A11)
PR_SURNAME_A = PROP_TAG( PT_STRING8,   0x3A11)
PR_ORIGINAL_ENTRYID = PROP_TAG( PT_BINARY,    0x3A12)
PR_ORIGINAL_DISPLAY_NAME = PROP_TAG( PT_TSTRING,   0x3A13)
PR_ORIGINAL_DISPLAY_NAME_W = PROP_TAG( PT_UNICODE,   0x3A13)
PR_ORIGINAL_DISPLAY_NAME_A = PROP_TAG( PT_STRING8,   0x3A13)
PR_ORIGINAL_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x3A14)
PR_POSTAL_ADDRESS = PROP_TAG( PT_TSTRING,   0x3A15)
PR_POSTAL_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x3A15)
PR_POSTAL_ADDRESS_A = PROP_TAG( PT_STRING8,   0x3A15)
PR_COMPANY_NAME = PROP_TAG( PT_TSTRING,   0x3A16)
PR_COMPANY_NAME_W = PROP_TAG( PT_UNICODE,   0x3A16)
PR_COMPANY_NAME_A = PROP_TAG( PT_STRING8,   0x3A16)
PR_TITLE = PROP_TAG( PT_TSTRING,   0x3A17)
PR_TITLE_W = PROP_TAG( PT_UNICODE,   0x3A17)
PR_TITLE_A = PROP_TAG( PT_STRING8,   0x3A17)
PR_DEPARTMENT_NAME = PROP_TAG( PT_TSTRING,   0x3A18)
PR_DEPARTMENT_NAME_W = PROP_TAG( PT_UNICODE,   0x3A18)
PR_DEPARTMENT_NAME_A = PROP_TAG( PT_STRING8,   0x3A18)
PR_OFFICE_LOCATION = PROP_TAG( PT_TSTRING,   0x3A19)
PR_OFFICE_LOCATION_W = PROP_TAG( PT_UNICODE,   0x3A19)
PR_OFFICE_LOCATION_A = PROP_TAG( PT_STRING8,   0x3A19)
PR_PRIMARY_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A1A)
PR_PRIMARY_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A1A)
PR_PRIMARY_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A1A)
PR_BUSINESS2_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A1B)
PR_BUSINESS2_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A1B)
PR_BUSINESS2_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A1B)
PR_MOBILE_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A1C)
PR_MOBILE_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A1C)
PR_MOBILE_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A1C)
PR_RADIO_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A1D)
PR_RADIO_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A1D)
PR_RADIO_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A1D)
PR_CAR_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A1E)
PR_CAR_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A1E)
PR_CAR_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A1E)
PR_OTHER_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A1F)
PR_OTHER_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A1F)
PR_OTHER_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A1F)
PR_TRANSMITABLE_DISPLAY_NAME = PROP_TAG( PT_TSTRING,   0x3A20)
PR_TRANSMITABLE_DISPLAY_NAME_W = PROP_TAG( PT_UNICODE,   0x3A20)
PR_TRANSMITABLE_DISPLAY_NAME_A = PROP_TAG( PT_STRING8,   0x3A20)
PR_PAGER_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A21)
PR_PAGER_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A21)
PR_PAGER_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A21)
PR_USER_CERTIFICATE = PROP_TAG( PT_BINARY,    0x3A22)
PR_PRIMARY_FAX_NUMBER = PROP_TAG( PT_TSTRING,   0x3A23)
PR_PRIMARY_FAX_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A23)
PR_PRIMARY_FAX_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A23)
PR_BUSINESS_FAX_NUMBER = PROP_TAG( PT_TSTRING,   0x3A24)
PR_BUSINESS_FAX_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A24)
PR_BUSINESS_FAX_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A24)
PR_HOME_FAX_NUMBER = PROP_TAG( PT_TSTRING,   0x3A25)
PR_HOME_FAX_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A25)
PR_HOME_FAX_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A25)
PR_COUNTRY = PROP_TAG( PT_TSTRING,   0x3A26)
PR_COUNTRY_W = PROP_TAG( PT_UNICODE,   0x3A26)
PR_COUNTRY_A = PROP_TAG( PT_STRING8,   0x3A26)
PR_LOCALITY = PROP_TAG( PT_TSTRING,   0x3A27)
PR_LOCALITY_W = PROP_TAG( PT_UNICODE,   0x3A27)
PR_LOCALITY_A = PROP_TAG( PT_STRING8,   0x3A27)
PR_STATE_OR_PROVINCE = PROP_TAG( PT_TSTRING,   0x3A28)
PR_STATE_OR_PROVINCE_W = PROP_TAG( PT_UNICODE,   0x3A28)
PR_STATE_OR_PROVINCE_A = PROP_TAG( PT_STRING8,   0x3A28)
PR_STREET_ADDRESS = PROP_TAG( PT_TSTRING,   0x3A29)
PR_STREET_ADDRESS_W = PROP_TAG( PT_UNICODE,   0x3A29)
PR_STREET_ADDRESS_A = PROP_TAG( PT_STRING8,   0x3A29)
PR_POSTAL_CODE = PROP_TAG( PT_TSTRING,   0x3A2A)
PR_POSTAL_CODE_W = PROP_TAG( PT_UNICODE,   0x3A2A)
PR_POSTAL_CODE_A = PROP_TAG( PT_STRING8,   0x3A2A)
PR_POST_OFFICE_BOX = PROP_TAG( PT_TSTRING,   0x3A2B)
PR_POST_OFFICE_BOX_W = PROP_TAG( PT_UNICODE,   0x3A2B)
PR_POST_OFFICE_BOX_A = PROP_TAG( PT_STRING8,   0x3A2B)
PR_TELEX_NUMBER = PROP_TAG( PT_TSTRING,   0x3A2C)
PR_TELEX_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A2C)
PR_TELEX_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A2C)
PR_ISDN_NUMBER = PROP_TAG( PT_TSTRING,   0x3A2D)
PR_ISDN_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A2D)
PR_ISDN_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A2D)
PR_ASSISTANT_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A2E)
PR_ASSISTANT_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A2E)
PR_ASSISTANT_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A2E)
PR_HOME2_TELEPHONE_NUMBER = PROP_TAG( PT_TSTRING,   0x3A2F)
PR_HOME2_TELEPHONE_NUMBER_W = PROP_TAG( PT_UNICODE,   0x3A2F)
PR_HOME2_TELEPHONE_NUMBER_A = PROP_TAG( PT_STRING8,   0x3A2F)
PR_ASSISTANT = PROP_TAG( PT_TSTRING,   0x3A30)
PR_ASSISTANT_W = PROP_TAG( PT_UNICODE,   0x3A30)
PR_ASSISTANT_A = PROP_TAG( PT_STRING8,   0x3A30)
PR_SEND_RICH_INFO = PROP_TAG( PT_BOOLEAN,   0x3A40)
PR_WEDDING_ANNIVERSARY = PROP_TAG( PT_SYSTIME, 0x3A41)
PR_BIRTHDAY = PROP_TAG( PT_SYSTIME, 0x3A42)
PR_HOBBIES = PROP_TAG( PT_TSTRING, 0x3A43)
PR_HOBBIES_W = PROP_TAG( PT_UNICODE, 0x3A43)
PR_HOBBIES_A = PROP_TAG( PT_STRING8, 0x3A43)
PR_MIDDLE_NAME = PROP_TAG( PT_TSTRING, 0x3A44)
PR_MIDDLE_NAME_W = PROP_TAG( PT_UNICODE, 0x3A44)
PR_MIDDLE_NAME_A = PROP_TAG( PT_STRING8, 0x3A44)
PR_DISPLAY_NAME_PREFIX = PROP_TAG( PT_TSTRING, 0x3A45)
PR_DISPLAY_NAME_PREFIX_W = PROP_TAG( PT_UNICODE, 0x3A45)
PR_DISPLAY_NAME_PREFIX_A = PROP_TAG( PT_STRING8, 0x3A45)
PR_PROFESSION = PROP_TAG( PT_TSTRING, 0x3A46)
PR_PROFESSION_W = PROP_TAG( PT_UNICODE, 0x3A46)
PR_PROFESSION_A = PROP_TAG( PT_STRING8, 0x3A46)
PR_PREFERRED_BY_NAME = PROP_TAG( PT_TSTRING, 0x3A47)
PR_PREFERRED_BY_NAME_W = PROP_TAG( PT_UNICODE, 0x3A47)
PR_PREFERRED_BY_NAME_A = PROP_TAG( PT_STRING8, 0x3A47)
PR_SPOUSE_NAME = PROP_TAG( PT_TSTRING, 0x3A48)
PR_SPOUSE_NAME_W = PROP_TAG( PT_UNICODE, 0x3A48)
PR_SPOUSE_NAME_A = PROP_TAG( PT_STRING8, 0x3A48)
PR_COMPUTER_NETWORK_NAME = PROP_TAG( PT_TSTRING, 0x3A49)
PR_COMPUTER_NETWORK_NAME_W = PROP_TAG( PT_UNICODE, 0x3A49)
PR_COMPUTER_NETWORK_NAME_A = PROP_TAG( PT_STRING8, 0x3A49)
PR_CUSTOMER_ID = PROP_TAG( PT_TSTRING, 0x3A4A)
PR_CUSTOMER_ID_W = PROP_TAG( PT_UNICODE, 0x3A4A)
PR_CUSTOMER_ID_A = PROP_TAG( PT_STRING8, 0x3A4A)
PR_TTYTDD_PHONE_NUMBER = PROP_TAG( PT_TSTRING, 0x3A4B)
PR_TTYTDD_PHONE_NUMBER_W = PROP_TAG( PT_UNICODE, 0x3A4B)
PR_TTYTDD_PHONE_NUMBER_A = PROP_TAG( PT_STRING8, 0x3A4B)
PR_FTP_SITE = PROP_TAG( PT_TSTRING, 0x3A4C)
PR_FTP_SITE_W = PROP_TAG( PT_UNICODE, 0x3A4C)
PR_FTP_SITE_A = PROP_TAG( PT_STRING8, 0x3A4C)
PR_GENDER = PROP_TAG( PT_SHORT, 0x3A4D)
PR_MANAGER_NAME = PROP_TAG( PT_TSTRING, 0x3A4E)
PR_MANAGER_NAME_W = PROP_TAG( PT_UNICODE, 0x3A4E)
PR_MANAGER_NAME_A = PROP_TAG( PT_STRING8, 0x3A4E)
PR_NICKNAME = PROP_TAG( PT_TSTRING, 0x3A4F)
PR_NICKNAME_W = PROP_TAG( PT_UNICODE, 0x3A4F)
PR_NICKNAME_A = PROP_TAG( PT_STRING8, 0x3A4F)
PR_PERSONAL_HOME_PAGE = PROP_TAG( PT_TSTRING, 0x3A50)
PR_PERSONAL_HOME_PAGE_W = PROP_TAG( PT_UNICODE, 0x3A50)
PR_PERSONAL_HOME_PAGE_A = PROP_TAG( PT_STRING8, 0x3A50)
PR_BUSINESS_HOME_PAGE = PROP_TAG( PT_TSTRING, 0x3A51)
PR_BUSINESS_HOME_PAGE_W = PROP_TAG( PT_UNICODE, 0x3A51)
PR_BUSINESS_HOME_PAGE_A = PROP_TAG( PT_STRING8, 0x3A51)
PR_CONTACT_VERSION = PROP_TAG( PT_CLSID, 0x3A52)
PR_CONTACT_ENTRYIDS = PROP_TAG( PT_MV_BINARY, 0x3A53)
PR_CONTACT_ADDRTYPES = PROP_TAG( PT_MV_TSTRING, 0x3A54)
PR_CONTACT_ADDRTYPES_W = PROP_TAG( PT_MV_UNICODE, 0x3A54)
PR_CONTACT_ADDRTYPES_A = PROP_TAG( PT_MV_STRING8, 0x3A54)
PR_CONTACT_DEFAULT_ADDRESS_INDEX = PROP_TAG( PT_LONG, 0x3A55)
PR_CONTACT_EMAIL_ADDRESSES = PROP_TAG( PT_MV_TSTRING, 0x3A56)
PR_CONTACT_EMAIL_ADDRESSES_W = PROP_TAG( PT_MV_UNICODE, 0x3A56)
PR_CONTACT_EMAIL_ADDRESSES_A = PROP_TAG( PT_MV_STRING8, 0x3A56)
PR_COMPANY_MAIN_PHONE_NUMBER = PROP_TAG( PT_TSTRING, 0x3A57)
PR_COMPANY_MAIN_PHONE_NUMBER_W = PROP_TAG( PT_UNICODE, 0x3A57)
PR_COMPANY_MAIN_PHONE_NUMBER_A = PROP_TAG( PT_STRING8, 0x3A57)
PR_CHILDRENS_NAMES = PROP_TAG( PT_MV_TSTRING, 0x3A58)
PR_CHILDRENS_NAMES_W = PROP_TAG( PT_MV_UNICODE, 0x3A58)
PR_CHILDRENS_NAMES_A = PROP_TAG( PT_MV_STRING8, 0x3A58)
PR_HOME_ADDRESS_CITY = PROP_TAG( PT_TSTRING, 0x3A59)
PR_HOME_ADDRESS_CITY_W = PROP_TAG( PT_UNICODE, 0x3A59)
PR_HOME_ADDRESS_CITY_A = PROP_TAG( PT_STRING8, 0x3A59)
PR_HOME_ADDRESS_COUNTRY = PROP_TAG( PT_TSTRING, 0x3A5A)
PR_HOME_ADDRESS_COUNTRY_W = PROP_TAG( PT_UNICODE, 0x3A5A)
PR_HOME_ADDRESS_COUNTRY_A = PROP_TAG( PT_STRING8, 0x3A5A)
PR_HOME_ADDRESS_POSTAL_CODE = PROP_TAG( PT_TSTRING, 0x3A5B)
PR_HOME_ADDRESS_POSTAL_CODE_W = PROP_TAG( PT_UNICODE, 0x3A5B)
PR_HOME_ADDRESS_POSTAL_CODE_A = PROP_TAG( PT_STRING8, 0x3A5B)
PR_HOME_ADDRESS_STATE_OR_PROVINCE = PROP_TAG( PT_TSTRING, 0x3A5C)
PR_HOME_ADDRESS_STATE_OR_PROVINCE_W = PROP_TAG( PT_UNICODE, 0x3A5C)
PR_HOME_ADDRESS_STATE_OR_PROVINCE_A = PROP_TAG( PT_STRING8, 0x3A5C)
PR_HOME_ADDRESS_STREET = PROP_TAG( PT_TSTRING, 0x3A5D)
PR_HOME_ADDRESS_STREET_W = PROP_TAG( PT_UNICODE, 0x3A5D)
PR_HOME_ADDRESS_STREET_A = PROP_TAG( PT_STRING8, 0x3A5D)
PR_HOME_ADDRESS_POST_OFFICE_BOX = PROP_TAG( PT_TSTRING, 0x3A5E)
PR_HOME_ADDRESS_POST_OFFICE_BOX_W = PROP_TAG( PT_UNICODE, 0x3A5E)
PR_HOME_ADDRESS_POST_OFFICE_BOX_A = PROP_TAG( PT_STRING8, 0x3A5E)
PR_OTHER_ADDRESS_CITY = PROP_TAG( PT_TSTRING, 0x3A5F)
PR_OTHER_ADDRESS_CITY_W = PROP_TAG( PT_UNICODE, 0x3A5F)
PR_OTHER_ADDRESS_CITY_A = PROP_TAG( PT_STRING8, 0x3A5F)
PR_OTHER_ADDRESS_COUNTRY = PROP_TAG( PT_TSTRING, 0x3A60)
PR_OTHER_ADDRESS_COUNTRY_W = PROP_TAG( PT_UNICODE, 0x3A60)
PR_OTHER_ADDRESS_COUNTRY_A = PROP_TAG( PT_STRING8, 0x3A60)
PR_OTHER_ADDRESS_POSTAL_CODE = PROP_TAG( PT_TSTRING, 0x3A61)
PR_OTHER_ADDRESS_POSTAL_CODE_W = PROP_TAG( PT_UNICODE, 0x3A61)
PR_OTHER_ADDRESS_POSTAL_CODE_A = PROP_TAG( PT_STRING8, 0x3A61)
PR_OTHER_ADDRESS_STATE_OR_PROVINCE = PROP_TAG( PT_TSTRING, 0x3A62)
PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W = PROP_TAG( PT_UNICODE, 0x3A62)
PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A = PROP_TAG( PT_STRING8, 0x3A62)
PR_OTHER_ADDRESS_STREET = PROP_TAG( PT_TSTRING, 0x3A63)
PR_OTHER_ADDRESS_STREET_W = PROP_TAG( PT_UNICODE, 0x3A63)
PR_OTHER_ADDRESS_STREET_A = PROP_TAG( PT_STRING8, 0x3A63)
PR_OTHER_ADDRESS_POST_OFFICE_BOX = PROP_TAG( PT_TSTRING, 0x3A64)
PR_OTHER_ADDRESS_POST_OFFICE_BOX_W = PROP_TAG( PT_UNICODE, 0x3A64)
PR_OTHER_ADDRESS_POST_OFFICE_BOX_A = PROP_TAG( PT_STRING8, 0x3A64)
PR_STORE_PROVIDERS = PROP_TAG( PT_BINARY,    0x3D00)
PR_AB_PROVIDERS = PROP_TAG( PT_BINARY,    0x3D01)
PR_TRANSPORT_PROVIDERS = PROP_TAG( PT_BINARY,    0x3D02)
PR_DEFAULT_PROFILE = PROP_TAG( PT_BOOLEAN,   0x3D04)
PR_AB_SEARCH_PATH = PROP_TAG( PT_MV_BINARY, 0x3D05)
PR_AB_DEFAULT_DIR = PROP_TAG( PT_BINARY,    0x3D06)
PR_AB_DEFAULT_PAB = PROP_TAG( PT_BINARY,    0x3D07)
PR_FILTERING_HOOKS = PROP_TAG( PT_BINARY,    0x3D08)
PR_SERVICE_NAME = PROP_TAG( PT_TSTRING,   0x3D09)
PR_SERVICE_NAME_W = PROP_TAG( PT_UNICODE,   0x3D09)
PR_SERVICE_NAME_A = PROP_TAG( PT_STRING8,   0x3D09)
PR_SERVICE_DLL_NAME = PROP_TAG( PT_TSTRING,   0x3D0A)
PR_SERVICE_DLL_NAME_W = PROP_TAG( PT_UNICODE,   0x3D0A)
PR_SERVICE_DLL_NAME_A = PROP_TAG( PT_STRING8,   0x3D0A)
PR_SERVICE_ENTRY_NAME = PROP_TAG( PT_STRING8,   0x3D0B)
PR_SERVICE_UID = PROP_TAG( PT_BINARY,    0x3D0C)
PR_SERVICE_EXTRA_UIDS = PROP_TAG( PT_BINARY,    0x3D0D)
PR_SERVICES = PROP_TAG( PT_BINARY,    0x3D0E)
PR_SERVICE_SUPPORT_FILES = PROP_TAG( PT_MV_TSTRING, 0x3D0F)
PR_SERVICE_SUPPORT_FILES_W = PROP_TAG( PT_MV_UNICODE, 0x3D0F)
PR_SERVICE_SUPPORT_FILES_A = PROP_TAG( PT_MV_STRING8, 0x3D0F)
PR_SERVICE_DELETE_FILES = PROP_TAG( PT_MV_TSTRING, 0x3D10)
PR_SERVICE_DELETE_FILES_W = PROP_TAG( PT_MV_UNICODE, 0x3D10)
PR_SERVICE_DELETE_FILES_A = PROP_TAG( PT_MV_STRING8, 0x3D10)
PR_AB_SEARCH_PATH_UPDATE = PROP_TAG( PT_BINARY,     0x3D11)
PR_PROFILE_NAME = PROP_TAG( PT_TSTRING,   0x3D12)
PR_PROFILE_NAME_A = PROP_TAG( PT_STRING8,   0x3D12)
PR_PROFILE_NAME_W = PROP_TAG( PT_UNICODE,   0x3D12)
PR_IDENTITY_DISPLAY = PROP_TAG( PT_TSTRING,   0x3E00)
PR_IDENTITY_DISPLAY_W = PROP_TAG( PT_UNICODE,   0x3E00)
PR_IDENTITY_DISPLAY_A = PROP_TAG( PT_STRING8,   0x3E00)
PR_IDENTITY_ENTRYID = PROP_TAG( PT_BINARY,    0x3E01)
PR_RESOURCE_METHODS = PROP_TAG( PT_LONG,      0x3E02)
PR_RESOURCE_TYPE = PROP_TAG( PT_LONG,      0x3E03)
PR_STATUS_CODE = PROP_TAG( PT_LONG,      0x3E04)
PR_IDENTITY_SEARCH_KEY = PROP_TAG( PT_BINARY,    0x3E05)
PR_OWN_STORE_ENTRYID = PROP_TAG( PT_BINARY,    0x3E06)
PR_RESOURCE_PATH = PROP_TAG( PT_TSTRING,   0x3E07)
PR_RESOURCE_PATH_W = PROP_TAG( PT_UNICODE,   0x3E07)
PR_RESOURCE_PATH_A = PROP_TAG( PT_STRING8,   0x3E07)
PR_STATUS_STRING = PROP_TAG( PT_TSTRING,   0x3E08)
PR_STATUS_STRING_W = PROP_TAG( PT_UNICODE,   0x3E08)
PR_STATUS_STRING_A = PROP_TAG( PT_STRING8,   0x3E08)
PR_X400_DEFERRED_DELIVERY_CANCEL = PROP_TAG( PT_BOOLEAN,   0x3E09)
PR_HEADER_FOLDER_ENTRYID = PROP_TAG( PT_BINARY,    0x3E0A)
PR_REMOTE_PROGRESS = PROP_TAG( PT_LONG,      0x3E0B)
PR_REMOTE_PROGRESS_TEXT = PROP_TAG( PT_TSTRING,   0x3E0C)
PR_REMOTE_PROGRESS_TEXT_W = PROP_TAG( PT_UNICODE,   0x3E0C)
PR_REMOTE_PROGRESS_TEXT_A = PROP_TAG( PT_STRING8,   0x3E0C)
PR_REMOTE_VALIDATE_OK = PROP_TAG( PT_BOOLEAN,   0x3E0D)
PR_CONTROL_FLAGS = PROP_TAG( PT_LONG,      0x3F00)
PR_CONTROL_STRUCTURE = PROP_TAG( PT_BINARY,    0x3F01)
PR_CONTROL_TYPE = PROP_TAG( PT_LONG,      0x3F02)
PR_DELTAX = PROP_TAG( PT_LONG,      0x3F03)
PR_DELTAY = PROP_TAG( PT_LONG,      0x3F04)
PR_XPOS = PROP_TAG( PT_LONG,      0x3F05)
PR_YPOS = PROP_TAG( PT_LONG,      0x3F06)
PR_CONTROL_ID = PROP_TAG( PT_BINARY,    0x3F07)
PR_INITIAL_DETAILS_PANE = PROP_TAG( PT_LONG,      0x3F08)

PROP_ID_SECURE_MIN	= 0x67F0
PT_FILE_HANDLE		= 0x0103
PT_FILE_EA			= 0x0104
PT_SRESTRICTION		= 0x00FD
PT_ACTIONS			= 0x00FE

pidStoreNonTransMin				= 0x0E40
pidExchangeXmitReservedMin		= 0x3FE0
pidExchangeNonXmitReservedMin	= 0x65E0
pidProfileMin					= 0x6600
pidStoreMin						= 0x6618
pidFolderMin					= 0x6638
pidMessageReadOnlyMin			= 0x6640
pidMessageWriteableMin			= 0x6658
pidAttachReadOnlyMin			= 0x666C
pidSpecialMin					= 0x6670
pidAdminMin						= 0x6690
pidSecureProfileMin				= PROP_ID_SECURE_MIN
pidRenMsgFldMin					= 0x1080
pidLocalStoreInternalMin		= 0x6500
pidLocalStoreInternalMax		= 0x65C0

pidLISMsgFolderPropMin			= 0x65a0
pidLISMsgFolderPropMax			= 0x65c0

# Exchange properties
PR_PROFILE_VERSION = PROP_TAG( PT_LONG, pidProfileMin+0x00)
PR_PROFILE_CONFIG_FLAGS = PROP_TAG( PT_LONG, pidProfileMin+0x01)
PR_PROFILE_HOME_SERVER = PROP_TAG( PT_STRING8, pidProfileMin+0x02)
PR_PROFILE_HOME_SERVER_DN = PROP_TAG( PT_STRING8, pidProfileMin+0x12)
PR_PROFILE_HOME_SERVER_ADDRS = PROP_TAG( PT_MV_STRING8, pidProfileMin+0x13)
PR_PROFILE_USER = PROP_TAG( PT_STRING8, pidProfileMin+0x03)
PR_PROFILE_CONNECT_FLAGS = PROP_TAG( PT_LONG, pidProfileMin+0x04)
PR_PROFILE_TRANSPORT_FLAGS = PROP_TAG( PT_LONG, pidProfileMin+0x05)
PR_PROFILE_UI_STATE = PROP_TAG( PT_LONG, pidProfileMin+0x06)
PR_PROFILE_UNRESOLVED_NAME = PROP_TAG( PT_STRING8, pidProfileMin+0x07)
PR_PROFILE_UNRESOLVED_SERVER = PROP_TAG( PT_STRING8, pidProfileMin+0x08)
PR_PROFILE_BINDING_ORDER = PROP_TAG( PT_STRING8, pidProfileMin+0x09)
PR_PROFILE_MAX_RESTRICT = PROP_TAG( PT_LONG, pidProfileMin+0x0D)
PR_PROFILE_AB_FILES_PATH = PROP_TAG( PT_STRING8, pidProfileMin+0xE)
PR_PROFILE_OFFLINE_STORE_PATH = PROP_TAG( PT_STRING8, pidProfileMin+0x10)
PR_PROFILE_OFFLINE_INFO = PROP_TAG( PT_BINARY, pidProfileMin+0x11)
PR_PROFILE_ADDR_INFO = PROP_TAG( PT_BINARY, pidSpecialMin+0x17)
PR_PROFILE_OPTIONS_DATA = PROP_TAG( PT_BINARY, pidSpecialMin+0x19)
PR_PROFILE_SECURE_MAILBOX = PROP_TAG( PT_BINARY, pidSecureProfileMin + 0)
PR_DISABLE_WINSOCK = PROP_TAG( PT_LONG, pidProfileMin+0x18)
PR_PROFILE_AUTH_PACKAGE = PROP_TAG( PT_LONG, pidProfileMin+0x19)
PR_PROFILE_RECONNECT_INTERVAL = PROP_TAG( PT_LONG, pidProfileMin+0x1a)
PR_PROFILE_SERVER_VERSION = PROP_TAG( PT_LONG, pidProfileMin+0x1b)
PR_PROFILE_ABP_ALLOW_RECONNECT = PROP_TAG( PT_LONG, pidProfileMin+0x39)
PR_PROFILE_ABP_MTHREAD_TIMEOUT_SECS = PROP_TAG( PT_LONG, pidProfileMin+0x3A)
PR_OST_ENCRYPTION = PROP_TAG(PT_LONG, 0x6702)
PR_PROFILE_OPEN_FLAGS = PROP_TAG( PT_LONG, pidProfileMin+0x09)
PR_PROFILE_TYPE = PROP_TAG( PT_LONG, pidProfileMin+0x0A)
PR_PROFILE_MAILBOX = PROP_TAG( PT_STRING8, pidProfileMin+0x0B)
PR_PROFILE_SERVER = PROP_TAG( PT_STRING8, pidProfileMin+0x0C)
PR_PROFILE_SERVER_DN = PROP_TAG( PT_STRING8, pidProfileMin+0x14)
PR_PROFILE_FAVFLD_DISPLAY_NAME = PROP_TAG(PT_STRING8, pidProfileMin+0x0F)
PR_PROFILE_FAVFLD_COMMENT = PROP_TAG(PT_STRING8, pidProfileMin+0x15)
PR_PROFILE_ALLPUB_DISPLAY_NAME = PROP_TAG(PT_STRING8, pidProfileMin+0x16)
PR_PROFILE_ALLPUB_COMMENT = PROP_TAG(PT_STRING8, pidProfileMin+0x17)
PR_PROFILE_MOAB = PROP_TAG( PT_STRING8, pidSpecialMin + 0x0B )
PR_PROFILE_MOAB_GUID = PROP_TAG( PT_STRING8, pidSpecialMin + 0x0C )
PR_PROFILE_MOAB_SEQ = PROP_TAG( PT_LONG, pidSpecialMin + 0x0D )
PR_GET_PROPS_EXCLUDE_PROP_ID_LIST = PROP_TAG( PT_BINARY, pidSpecialMin + 0x0E )
PR_USER_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x01)
PR_USER_NAME = PROP_TAG( PT_STRING8, pidStoreMin+0x02)
PR_MAILBOX_OWNER_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x03)
PR_MAILBOX_OWNER_NAME = PROP_TAG( PT_STRING8, pidStoreMin+0x04)
PR_OOF_STATE = PROP_TAG( PT_BOOLEAN, pidStoreMin+0x05)
PR_HIERARCHY_SERVER = PROP_TAG( PT_TSTRING, pidStoreMin+0x1B)
PR_SCHEDULE_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x06)
PR_IPM_DAF_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x07)
PR_NON_IPM_SUBTREE_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x08)
PR_EFORMS_REGISTRY_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x09)
PR_SPLUS_FREE_BUSY_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x0A)
PR_OFFLINE_ADDRBOOK_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x0B)
PR_NNTP_CONTROL_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidSpecialMin+0x1B)
PR_EFORMS_FOR_LOCALE_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x0C)
PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x0D)
PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x0E)
PR_NEWSGROUP_ROOT_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidSpecialMin+0x1C)
PR_OFFLINE_MESSAGE_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x0F)
PR_IPM_FAVORITES_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x18)
PR_IPM_PUBLIC_FOLDERS_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x19)
PR_FAVORITES_DEFAULT_NAME = PROP_TAG( PT_STRING8, pidStoreMin+0x1D)
PR_SYS_CONFIG_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x1E)
PR_NNTP_ARTICLE_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidSpecialMin+0x1A)
PR_EVENTS_ROOT_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidSpecialMin+0xA)
PR_GW_MTSIN_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x10)
PR_GW_MTSOUT_ENTRYID = PROP_TAG( PT_BINARY, pidStoreMin+0x11)
PR_TRANSFER_ENABLED = PROP_TAG( PT_BOOLEAN, pidStoreMin+0x12)
PR_TEST_LINE_SPEED = PROP_TAG( PT_BINARY, pidStoreMin+0x13)
PR_HIERARCHY_SYNCHRONIZER = PROP_TAG( PT_OBJECT, pidStoreMin+0x14)
PR_CONTENTS_SYNCHRONIZER = PROP_TAG( PT_OBJECT, pidStoreMin+0x15)
PR_COLLECTOR = PROP_TAG( PT_OBJECT, pidStoreMin+0x16)
PR_FAST_TRANSFER = PROP_TAG( PT_OBJECT, pidStoreMin+0x17)
PR_CHANGE_ADVISOR = PROP_TAG( PT_OBJECT, pidStoreMin+0x1C)
PR_CHANGE_NOTIFICATION_GUID = PROP_TAG( PT_CLSID, pidStoreMin+0x1F)
PR_STORE_OFFLINE = PROP_TAG( PT_BOOLEAN, pidStoreMin+0x1A)
PR_IN_TRANSIT = PROP_TAG( PT_BOOLEAN, pidStoreMin)
PR_REPLICATION_STYLE = PROP_TAG( PT_LONG, pidAdminMin)
PR_REPLICATION_SCHEDULE = PROP_TAG( PT_BINARY, pidAdminMin+0x01)
PR_REPLICATION_MESSAGE_PRIORITY = PROP_TAG( PT_LONG, pidAdminMin+0x02)
PR_OVERALL_MSG_AGE_LIMIT = PROP_TAG( PT_LONG, pidAdminMin+0x03 )
PR_REPLICATION_ALWAYS_INTERVAL = PROP_TAG( PT_LONG, pidAdminMin+0x04 )
PR_REPLICATION_MSG_SIZE = PROP_TAG( PT_LONG, pidAdminMin+0x05 )
PR_SOURCE_KEY = PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x0)
PR_PARENT_SOURCE_KEY = PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x1)
PR_CHANGE_KEY = PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x2)
PR_PREDECESSOR_CHANGE_LIST = PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x3)
PR_SOURCE_FID = PROP_TAG(PT_I8, pidStoreNonTransMin+0x1F)
PR_CATALOG = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x1B)
PR_CI_SEARCH_ENABLED = PROP_TAG(PT_BOOLEAN, pidStoreNonTransMin+0x1C)
PR_CI_NOTIFICATION_ENABLED = PROP_TAG(PT_BOOLEAN, pidStoreNonTransMin+0x1D)
PR_MAX_CACHED_VIEWS = PROP_TAG(PT_LONG, pidStoreNonTransMin+0x28)
PR_MAX_INDICES = PROP_TAG(PT_LONG, pidStoreNonTransMin+0x1E)
PR_IMPLIED_RESTRICTIONS = PROP_TAG( PT_MV_BINARY, pidSpecialMin+0x0F)
PR_FOLDER_CHILD_COUNT = PROP_TAG( PT_LONG, pidFolderMin)
PR_RIGHTS = PROP_TAG( PT_LONG, pidFolderMin+0x01)
PR_ACL_TABLE = PROP_TAG( PT_OBJECT, pidExchangeXmitReservedMin)
PR_RULES_TABLE = PROP_TAG( PT_OBJECT, pidExchangeXmitReservedMin+0x1)
PR_HAS_RULES = PROP_TAG( PT_BOOLEAN, pidFolderMin+0x02)
PR_HAS_MODERATOR_RULES = PROP_TAG( PT_BOOLEAN, pidFolderMin+0x07 )
PR_ADDRESS_BOOK_ENTRYID = PROP_TAG( PT_BINARY, pidFolderMin+0x03)
PR_ACL_DATA = PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin)
PR_RULES_DATA = PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x1)
PR_EXTENDED_ACL_DATA = PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x1E)
PR_FOLDER_DESIGN_FLAGS = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x2)
PR_DESIGN_IN_PROGRESS = PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x4)
PR_SECURE_ORIGINATION = PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x5)
PR_PUBLISH_IN_ADDRESS_BOOK = PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x6)
PR_RESOLVE_METHOD = PROP_TAG( PT_LONG,	pidExchangeXmitReservedMin+0x7)
PR_ADDRESS_BOOK_DISPLAY_NAME = PROP_TAG( PT_TSTRING, pidExchangeXmitReservedMin+0x8)
PR_EFORMS_LOCALE_ID = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x9)
PR_REPLICA_LIST = PROP_TAG( PT_BINARY, pidAdminMin+0x8)
PR_OVERALL_AGE_LIMIT = PROP_TAG( PT_LONG, pidAdminMin+0x9)
PR_IS_NEWSGROUP_ANCHOR = PROP_TAG( PT_BOOLEAN, pidAdminMin+0x06)
PR_IS_NEWSGROUP = PROP_TAG( PT_BOOLEAN, pidAdminMin+0x07)
PR_NEWSGROUP_COMPONENT = PROP_TAG( PT_STRING8, pidAdminMin+0x15)
PR_INTERNET_NEWSGROUP_NAME = PROP_TAG( PT_STRING8, pidAdminMin+0x17)
PR_NEWSFEED_INFO = PROP_TAG( PT_BINARY,  pidAdminMin+0x16)
PR_PREVENT_MSG_CREATE = PROP_TAG( PT_BOOLEAN, pidExchangeNonXmitReservedMin+0x14)
PR_IMAP_INTERNAL_DATE = PROP_TAG( PT_SYSTIME, pidExchangeNonXmitReservedMin+0x15)
PR_INBOUND_NEWSFEED_DN = PROP_TAG( PT_STRING8, pidSpecialMin+0x1D)
PR_OUTBOUND_NEWSFEED_DN = PROP_TAG( PT_STRING8, pidSpecialMin+0x1E)
PR_INTERNET_CHARSET = PROP_TAG( PT_TSTRING, pidAdminMin+0xA)
PR_PUBLIC_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidFolderMin+0x04)
PR_HIERARCHY_CHANGE_NUM = PROP_TAG( PT_LONG, pidFolderMin+0x06)
#PR_USER_SID = PROP_TAG(PT_BINARY, PROP_ID(ptagSearchState))
PR_HAS_NAMED_PROPERTIES = PROP_TAG(PT_BOOLEAN, pidMessageReadOnlyMin+0x0A)
PR_CREATOR_NAME = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x18)
PR_CREATOR_ENTRYID = PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x19)
PR_LAST_MODIFIER_NAME = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x1A)
PR_LAST_MODIFIER_ENTRYID = PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x1B)
PR_REPLY_RECIPIENT_SMTP_PROXIES = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x1C)
PR_HAS_DAMS = PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x0A)
PR_RULE_TRIGGER_HISTORY = PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x12)
PR_MOVE_TO_STORE_ENTRYID = PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x13)
PR_MOVE_TO_FOLDER_ENTRYID = PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x14)
PR_REPLICA_SERVER = PROP_TAG(PT_TSTRING, pidMessageReadOnlyMin+0x04)
PR_REPLICA_VERSION = PROP_TAG(PT_I8, pidMessageReadOnlyMin+0x0B)
PR_CREATOR_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x18)
PR_LAST_MODIFIER_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x19)
PR_SENDER_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x0d)
PR_SENT_REPRESENTING_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x0e)
PR_ORIGINAL_SENDER_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x0f)
PR_ORIGINAL_SENT_REPRESENTING_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x10)
PR_READ_RECEIPT_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x11)
PR_REPORT_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x12)
PR_ORIGINATOR_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x13)
PR_REPORT_DESTINATION_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x14)
PR_ORIGINAL_AUTHOR_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x15)
PR_RECEIVED_BY_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x16)
PR_RCVD_REPRESENTING_SID = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x17)
PR_TRUST_SENDER = PROP_TAG(PT_LONG,	pidStoreNonTransMin+0x39)
PR_CREATOR_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x2C)
PR_LAST_MODIFIER_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x2D)
PR_SENDER_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x2E)
PR_SENT_REPRESENTING_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x2F)
PR_ORIGINAL_SENDER_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x30)
PR_ORIGINAL_SENT_REPRESENTING_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x31)
PR_READ_RECEIPT_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x32)
PR_REPORT_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x33)
PR_ORIGINATOR_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x34)
PR_REPORT_DESTINATION_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x35)
PR_ORIGINAL_AUTHOR_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x36)
PR_RECEIVED_BY_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x37)
PR_RCVD_REPRESENTING_SID_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x38)
PR_MERGE_MIDSET_DELETED = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x3a)
PR_RESERVE_RANGE_OF_IDS = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x3b)
PR_FID_VID = PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x0C)
PR_ORIGIN_ID = PROP_TAG( PT_BINARY, pidMessageReadOnlyMin+0x0D)
PR_RANK = PROP_TAG( PT_LONG, pidAdminMin+0x82 )
PR_MSG_FOLD_TIME = PROP_TAG( PT_SYSTIME, pidMessageReadOnlyMin+0x14)
PR_ICS_CHANGE_KEY = PROP_TAG( PT_BINARY, pidMessageReadOnlyMin+0x15)
PR_DEFERRED_SEND_NUMBER = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xB)
PR_DEFERRED_SEND_UNITS = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xC)
PR_EXPIRY_NUMBER = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xD)
PR_EXPIRY_UNITS = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xE)
PR_DEFERRED_SEND_TIME = PROP_TAG( PT_SYSTIME, pidExchangeXmitReservedMin+0xF)
PR_GW_ADMIN_OPERATIONS = PROP_TAG( PT_LONG, pidMessageWriteableMin)
PR_P1_CONTENT = PROP_TAG( PT_BINARY, 0x1100)
PR_P1_CONTENT_TYPE = PROP_TAG( PT_BINARY, 0x1101)
PR_CLIENT_ACTIONS = PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x5)
PR_DAM_ORIGINAL_ENTRYID = PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x6)
PR_DAM_BACK_PATCHED = PROP_TAG( PT_BOOLEAN, pidMessageReadOnlyMin+0x7)
PR_RULE_ERROR = PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x8)
PR_RULE_ACTION_TYPE = PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x9)
PR_RULE_ACTION_NUMBER = PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x10)
PR_RULE_FOLDER_ENTRYID = PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x11)
PR_INTERNET_CONTENT = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x1)
PR_INTERNET_CONTENT_HANDLE = PROP_TAG(PT_FILE_HANDLE, pidMessageWriteableMin+0x1)
PR_INTERNET_CONTENT_EA = PROP_TAG(PT_FILE_EA, pidMessageWriteableMin+0x1)
#PR_DOTSTUFF_STATE = PROP_TAG(PT_LONG, pidUserNonTransmitMin+0x1)
PR_MIME_SIZE = PROP_TAG(PT_LONG, 0x6746)
PR_MIME_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x6746)
PR_FILE_SIZE = PROP_TAG(PT_LONG, 0x6747)
PR_FILE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x6747)
PR_MSG_EDITOR_FORMAT = PROP_TAG( PT_LONG, 0x5909 )
#PR_CONVERSION_STATE = PROP_TAG(PT_LONG, PROP_ID(ptagAdminNickName))
PR_HTML = PROP_TAG( PT_BINARY, 0x1013 )			#PROP_TAG( PT_BINARY, PROP_ID( PR_BODY_HTML ) )
PR_ACTIVE_USER_ENTRYID = PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x12)
PR_CONFLICT_ENTRYID = PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x10)
PR_MESSAGE_LOCALE_ID = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x11)
PR_MESSAGE_CODEPAGE = PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x1D)
PR_STORAGE_QUOTA_LIMIT = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x15)
PR_EXCESS_STORAGE_USED = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x16)
PR_SVR_GENERATING_QUOTA_MSG = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x17)
PR_DELEGATED_BY_RULE = PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x3)
PR_X400_ENVELOPE_TYPE = PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x13)
PR_AUTO_RESPONSE_SUPPRESS = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin - 0x01)
PR_INTERNET_CPID = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin - 0x02)
PR_SYNCEVENT_FIRED = PROP_TAG(PT_BOOLEAN, pidMessageReadOnlyMin + 0x0F)
PR_IN_CONFLICT = PROP_TAG(PT_BOOLEAN, pidAttachReadOnlyMin)
PR_DELETED_ON = PROP_TAG(PT_SYSTIME, pidSpecialMin+0x1F)
PR_DELETED_MSG_COUNT = PROP_TAG(PT_LONG, pidFolderMin+0x08)
PR_DELETED_ASSOC_MSG_COUNT = PROP_TAG(PT_LONG, pidFolderMin+0x0B)
PR_DELETED_FOLDER_COUNT = PROP_TAG(PT_LONG, pidFolderMin + 0x09)
PR_OLDEST_DELETED_ON = PROP_TAG(PT_SYSTIME, pidFolderMin + 0x0A)
PR_DELETED_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, pidAdminMin+0xB)
PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, pidAdminMin+0xC)
PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, pidAdminMin+0xD)
PR_RETENTION_AGE_LIMIT = PROP_TAG(PT_LONG, pidAdminMin+0x34)
PR_DISABLE_PERUSER_READ = PROP_TAG(PT_BOOLEAN, pidAdminMin+0x35)
PR_LAST_FULL_BACKUP = PROP_TAG(PT_SYSTIME, pidSpecialMin+0x15)
PR_URL_NAME = PROP_TAG(PT_TSTRING, pidAdminMin+0x77)
PR_URL_NAME_A = PROP_TAG(PT_STRING8, pidAdminMin+0x77)
PR_URL_NAME_W = PROP_TAG(PT_UNICODE, pidAdminMin+0x77)
PR_URL_COMP_NAME = PROP_TAG(PT_TSTRING, pidRenMsgFldMin+0x73)
PR_URL_COMP_NAME_A = PROP_TAG(PT_STRING8, pidRenMsgFldMin+0x73)
PR_URL_COMP_NAME_W = PROP_TAG(PT_UNICODE, pidRenMsgFldMin+0x73)
PR_PARENT_URL_NAME = PROP_TAG(PT_TSTRING, pidAdminMin+0x7D)
PR_PARENT_URL_NAME_A = PROP_TAG(PT_STRING8, pidAdminMin+0x7D)
PR_PARENT_URL_NAME_W = PROP_TAG(PT_UNICODE, pidAdminMin+0x7D)
PR_FLAT_URL_NAME = PROP_TAG(PT_TSTRING, pidAdminMin+0x7E)
PR_FLAT_URL_NAME_A = PROP_TAG(PT_STRING8, pidAdminMin+0x7E)
PR_FLAT_URL_NAME_W = PROP_TAG(PT_UNICODE, pidAdminMin+0x7E)
PR_SRC_URL_NAME = PROP_TAG(PT_TSTRING, pidAdminMin+0x7F)
PR_SRC_URL_NAME_A = PROP_TAG(PT_STRING8, pidAdminMin+0x7F)
PR_SRC_URL_NAME_W = PROP_TAG(PT_UNICODE, pidAdminMin+0x7F)
PR_SECURE_IN_SITE = PROP_TAG(PT_BOOLEAN, pidAdminMin+0xE)
PR_LOCAL_COMMIT_TIME = PROP_TAG(PT_SYSTIME, pidAdminMin+0x79)
PR_LOCAL_COMMIT_TIME_MAX = PROP_TAG(PT_SYSTIME, pidAdminMin+0x7a)
PR_DELETED_COUNT_TOTAL = PROP_TAG(PT_LONG, pidAdminMin+0x7b)
PR_AUTO_RESET = PROP_TAG(PT_MV_CLSID, pidAdminMin+0x7c)
PR_LONGTERM_ENTRYID_FROM_TABLE = PROP_TAG(PT_BINARY, pidSpecialMin)
PR_SUBFOLDER = PROP_TAG(PT_BOOLEAN, pidAdminMin+0x78)
PR_ORIGINATOR_NAME = PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x3)
PR_ORIGINATOR_ADDR = PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x4)
PR_ORIGINATOR_ADDRTYPE = PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x5)
PR_ORIGINATOR_ENTRYID = PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x6)
PR_ARRIVAL_TIME = PROP_TAG( PT_SYSTIME, pidMessageWriteableMin+0x7)
PR_TRACE_INFO = PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x8)
PR_INTERNAL_TRACE_INFO = PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x12)
PR_SUBJECT_TRACE_INFO = PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x9)
PR_RECIPIENT_NUMBER = PROP_TAG( PT_LONG, pidMessageWriteableMin+0xA)
PR_MTS_SUBJECT_ID = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xB)
PR_REPORT_DESTINATION_NAME = PROP_TAG(PT_TSTRING, pidMessageWriteableMin+0xC)
PR_REPORT_DESTINATION_ENTRYID = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xD)
PR_CONTENT_SEARCH_KEY = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xE)
PR_FOREIGN_ID = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xF)
PR_FOREIGN_REPORT_ID = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x10)
PR_FOREIGN_SUBJECT_ID = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x11)
PR_PROMOTE_PROP_ID_LIST = PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x13)
PR_MEMBER_ID = PROP_TAG(PT_I8, pidSpecialMin+0x01)
PR_MEMBER_NAME = PROP_TAG(PT_TSTRING, pidSpecialMin+0x02)
PR_MEMBER_RIGHTS = PROP_TAG(PT_LONG, pidSpecialMin+0x03)
PR_MEMBER_ENTRYID = PR_ENTRYID
PR_XMT_SECURITY_ROLE_1 = PROP_TAG(PT_BINARY,0x3d25)
PR_XMT_SECURITY_ROLE_1_AS_XML = PROP_TAG(PT_TSTRING,0x3d25)
PR_XMT_SECURITY_ROLE_2 = PROP_TAG(PT_BINARY,0x3d26)
PR_XMT_SECURITY_ROLE_2_AS_XML = PROP_TAG(PT_TSTRING,0x3d26)
PR_XMT_SECURITY_ROLE_3 = PROP_TAG(PT_BINARY,0x3d27)
PR_XMT_SECURITY_ROLE_3_AS_XML = PROP_TAG(PT_TSTRING,0x3d27)
PR_XMT_SECURITY_ROLE_4 = PROP_TAG(PT_BINARY,0x3d28)
PR_XMT_SECURITY_ROLE_4_AS_XML = PROP_TAG(PT_TSTRING,0x3d28)
PR_XMT_SECURITY_ROLE_5 = PROP_TAG(PT_BINARY,0x3d29)
PR_XMT_SECURITY_ROLE_5_AS_XML = PROP_TAG(PT_TSTRING,0x3d29)
PR_XMT_SECURITY_ROLE_6 = PROP_TAG(PT_BINARY,0x3d2A)
PR_XMT_SECURITY_ROLE_6_AS_XML = PROP_TAG(PT_TSTRING,0x3d2A)
PR_XMT_SECURITY_ROLE_7 = PROP_TAG(PT_BINARY,0x3d2B)
PR_XMT_SECURITY_ROLE_7_AS_XML = PROP_TAG(PT_TSTRING,0x3d2B)
PR_XMT_SECURITY_ROLE_8 = PROP_TAG(PT_BINARY,0x3d2C)
PR_XMT_SECURITY_ROLE_8_AS_XML = PROP_TAG(PT_TSTRING,0x3d2C)
PR_NON_XMT_SECURITY_ROLE_1 = PROP_TAG(PT_BINARY,0x0E7C)
PR_NON_XMT_SECURITY_ROLE_1_AS_XML = PROP_TAG(PT_TSTRING,0x0E7C)
PR_NON_XMT_SECURITY_ROLE_2 = PROP_TAG(PT_BINARY,0x0E7D)
PR_NON_XMT_SECURITY_ROLE_2_AS_XML = PROP_TAG(PT_TSTRING,0x0E7D)
PR_NON_XMT_SECURITY_ROLE_3 = PROP_TAG(PT_BINARY,0x0E7E)
PR_NON_XMT_SECURITY_ROLE_3_AS_XML = PROP_TAG(PT_TSTRING,0x0E7E)
PR_NON_XMT_SECURITY_ROLE_4 = PROP_TAG(PT_BINARY,0x0E7F)
PR_NON_XMT_SECURITY_ROLE_4_AS_XML = PROP_TAG(PT_TSTRING,0x0E7F)
PR_NON_XMT_SECURITY_ROLE_5 = PROP_TAG(PT_BINARY,0x0E80)
PR_NON_XMT_SECURITY_ROLE_5_AS_XML = PROP_TAG(PT_TSTRING,0x0E80)
PR_NON_XMT_SECURITY_ROLE_6 = PROP_TAG(PT_BINARY,0x0E81)
PR_NON_XMT_SECURITY_ROLE_6_AS_XML = PROP_TAG(PT_TSTRING,0x0E81)
PR_NON_XMT_SECURITY_ROLE_7 = PROP_TAG(PT_BINARY,0x0E82)
PR_NON_XMT_SECURITY_ROLE_7_AS_XML = PROP_TAG(PT_TSTRING,0x0E82)
PR_NON_XMT_SECURITY_ROLE_8 = PROP_TAG(PT_BINARY,0x0E83)
PR_NON_XMT_SECURITY_ROLE_8_AS_XML = PROP_TAG(PT_TSTRING,0x0E83)
PR_RULE_ID = PROP_TAG(PT_I8, pidSpecialMin+0x04)
PR_RULE_IDS = PROP_TAG(PT_BINARY, pidSpecialMin+0x05)
PR_RULE_SEQUENCE = PROP_TAG(PT_LONG, pidSpecialMin+0x06)
PR_RULE_STATE = PROP_TAG(PT_LONG, pidSpecialMin+0x07)
PR_RULE_USER_FLAGS = PROP_TAG(PT_LONG, pidSpecialMin+0x08)
PR_RULE_CONDITION = PROP_TAG(PT_SRESTRICTION, pidSpecialMin+0x09)
PR_RULE_ACTIONS = PROP_TAG(PT_ACTIONS, pidSpecialMin+0x10)
PR_RULE_PROVIDER = PROP_TAG(PT_STRING8, pidSpecialMin+0x11)
PR_RULE_NAME = PROP_TAG(PT_TSTRING, pidSpecialMin+0x12)
PR_RULE_LEVEL = PROP_TAG(PT_LONG, pidSpecialMin+0x13)
PR_RULE_PROVIDER_DATA = PROP_TAG(PT_BINARY, pidSpecialMin+0x14)
PR_EXTENDED_RULE_ACTIONS = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x59)
PR_EXTENDED_RULE_CONDITION = PROP_TAG(PT_BINARY, pidStoreNonTransMin+0x5a)
PR_EXTENDED_RULE_SIZE_LIMIT = PROP_TAG(PT_LONG, pidStoreNonTransMin+0x5b)
PR_RULE_VERSION = PROP_TAG( PT_I2, pidSpecialMin+0x1D)
PR_NT_USER_NAME = PROP_TAG(PT_TSTRING, pidAdminMin+0x10)
PR_LOCALE_ID = PROP_TAG( PT_LONG, pidAdminMin+0x11 )
PR_LAST_LOGON_TIME = PROP_TAG(PT_SYSTIME, pidAdminMin+0x12 )
PR_LAST_LOGOFF_TIME = PROP_TAG(PT_SYSTIME, pidAdminMin+0x13 )
PR_STORAGE_LIMIT_INFORMATION = PROP_TAG(PT_LONG, pidAdminMin+0x14 )
PR_INTERNET_MDNS = PROP_TAG(PT_BOOLEAN, pidAdminMin+0x15)			#PROP_TAG(PT_BOOLEAN, PROP_ID(PR_NEWSGROUP_COMPONENT))
PR_QUOTA_WARNING_THRESHOLD = PROP_TAG(PT_LONG, pidAdminMin+0x91)
PR_QUOTA_SEND_THRESHOLD = PROP_TAG(PT_LONG, pidAdminMin+0x92)
PR_QUOTA_RECEIVE_THRESHOLD = PROP_TAG(PT_LONG, pidAdminMin+0x93)
PR_FOLDER_FLAGS = PROP_TAG(PT_LONG, pidAdminMin+0x18)
PR_LAST_ACCESS_TIME = PROP_TAG(PT_SYSTIME, pidAdminMin+0x19)
PR_RESTRICTION_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x1A)
PR_CATEG_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x1B)
PR_CACHED_COLUMN_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x1C)
PR_NORMAL_MSG_W_ATTACH_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x1D)
PR_ASSOC_MSG_W_ATTACH_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x1E)
PR_RECIPIENT_ON_NORMAL_MSG_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x1F)
PR_RECIPIENT_ON_ASSOC_MSG_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x20)
PR_ATTACH_ON_NORMAL_MSG_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x21)
PR_ATTACH_ON_ASSOC_MSG_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x22)
PR_NORMAL_MESSAGE_SIZE = PROP_TAG(PT_LONG, pidAdminMin+0x23)
PR_NORMAL_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, pidAdminMin+0x23)
PR_ASSOC_MESSAGE_SIZE = PROP_TAG(PT_LONG, pidAdminMin+0x24)
PR_ASSOC_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, pidAdminMin+0x24)
PR_FOLDER_PATHNAME = PROP_TAG(PT_TSTRING, pidAdminMin+0x25)
PR_OWNER_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x26)
PR_CONTACT_COUNT = PROP_TAG(PT_LONG, pidAdminMin+0x27)
PR_PF_OVER_HARD_QUOTA_LIMIT = PROP_TAG(PT_LONG, pidAdminMin+0x91)
PR_PF_MSG_SIZE_LIMIT = PROP_TAG(PT_LONG, pidAdminMin+0x92)
PR_PF_DISALLOW_MDB_WIDE_EXPIRY = PROP_TAG(PT_BOOLEAN, pidAdminMin+0x93)
PR_LOCALE_ID = PROP_TAG(PT_LONG, pidAdminMin+0x11)
PR_CODE_PAGE_ID = PROP_TAG(PT_LONG, pidAdminMin+0x33)
PR_SORT_LOCALE_ID = PROP_TAG(PT_LONG, pidAdminMin+0x75)
PR_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x0E08)		#PROP_TAG(PT_I8, PROP_ID(PR_MESSAGE_SIZE))
PR_AUTO_ADD_NEW_SUBS = PROP_TAG(PT_BOOLEAN, pidExchangeNonXmitReservedMin+0x5)
PR_NEW_SUBS_GET_AUTO_ADD = PROP_TAG(PT_BOOLEAN, pidExchangeNonXmitReservedMin+0x6)
PR_OFFLINE_FLAGS = PROP_TAG(PT_LONG, pidFolderMin+0x5)
PR_SYNCHRONIZE_FLAGS = PROP_TAG(PT_LONG, pidExchangeNonXmitReservedMin+0x4)
PR_MESSAGE_SITE_NAME = PROP_TAG(PT_TSTRING, pidExchangeNonXmitReservedMin+0x7)
PR_MESSAGE_SITE_NAME_A = PROP_TAG(PT_STRING8, pidExchangeNonXmitReservedMin+0x7)
PR_MESSAGE_SITE_NAME_W = PROP_TAG(PT_UNICODE, pidExchangeNonXmitReservedMin+0x7)
PR_MESSAGE_PROCESSED = PROP_TAG(PT_BOOLEAN, pidExchangeNonXmitReservedMin+0x8)
PR_MSG_BODY_ID = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin-0x03)
PR_BILATERAL_INFO = PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin-0x04)
PR_DL_REPORT_FLAGS = PROP_TAG(PT_LONG, pidExchangeXmitReservedMin-0x05)
PR_ABSTRACT = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin-0x06)
PR_ABSTRACT_A = PROP_TAG(PT_STRING8, pidExchangeXmitReservedMin-0x06)
PR_ABSTRACT_W = PROP_TAG(PT_UNICODE, pidExchangeXmitReservedMin-0x06)
PR_PREVIEW = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin-0x07)
PR_PREVIEW_A = PROP_TAG(PT_STRING8, pidExchangeXmitReservedMin-0x07)
PR_PREVIEW_W = PROP_TAG(PT_UNICODE, pidExchangeXmitReservedMin-0x07)
PR_PREVIEW_UNREAD = PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin-0x08)
PR_PREVIEW_UNREAD_A = PROP_TAG(PT_STRING8, pidExchangeXmitReservedMin-0x08)
PR_PREVIEW_UNREAD_W = PROP_TAG(PT_UNICODE, pidExchangeXmitReservedMin-0x08)
PR_DISABLE_FULL_FIDELITY = PROP_TAG(PT_BOOLEAN, pidRenMsgFldMin+0x72)
PR_ATTR_HIDDEN = PROP_TAG(PT_BOOLEAN, pidRenMsgFldMin+0x74)
PR_ATTR_SYSTEM = PROP_TAG(PT_BOOLEAN, pidRenMsgFldMin+0x75)
PR_ATTR_READONLY = PROP_TAG(PT_BOOLEAN, pidRenMsgFldMin+0x76)
PR_READ = PROP_TAG(PT_BOOLEAN, pidStoreNonTransMin+0x29)
PR_ADMIN_SECURITY_DESCRIPTOR = PROP_TAG(PT_BINARY, 0x3d21)
PR_WIN32_SECURITY_DESCRIPTOR = PROP_TAG(PT_BINARY, 0x3d22)
PR_NON_WIN32_ACL = PROP_TAG(PT_BOOLEAN, 0x3d23)
PR_ITEM_LEVEL_ACL = PROP_TAG(PT_BOOLEAN, 0x3d24)
PR_DAV_TRANSFER_SECURITY_DESCRIPTOR = PROP_TAG(PT_BINARY, 0x0E84)
PR_NT_SECURITY_DESCRIPTOR_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x2A)
PR_NT_SECURITY_DESCRIPTOR_AS_XML_A = PROP_TAG(PT_STRING8, pidStoreNonTransMin+0x2A)
PR_NT_SECURITY_DESCRIPTOR_AS_XML_W = PROP_TAG(PT_UNICODE, pidStoreNonTransMin+0x2A)
PR_ADMIN_SECURITY_DESCRIPTOR_AS_XML = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x2B)
PR_ADMIN_SECURITY_DESCRIPTOR_AS_XML_A = PROP_TAG(PT_STRING8, pidStoreNonTransMin+0x2B)
PR_ADMIN_SECURITY_DESCRIPTOR_AS_XML_W = PROP_TAG(PT_UNICODE, pidStoreNonTransMin+0x2B)
PR_STORE_SLOWLINK = PROP_TAG(PT_BOOLEAN, 0x7c0a)
PR_SYNCEVENT_SUPPRESS_GUID = PROP_TAG( PT_BINARY,	0x3880 )
PR_LOCK_BRANCH_ID = PROP_TAG( PT_I8,		0x3800 )
PR_LOCK_RESOURCE_FID = PROP_TAG( PT_I8,		0x3801 )
PR_LOCK_RESOURCE_DID = PROP_TAG( PT_I8,		0x3802 )
PR_LOCK_RESOURCE_VID = PROP_TAG( PT_I8,		0x3803 )
PR_LOCK_ENLISTMENT_CONTEXT = PROP_TAG( PT_BINARY,	0x3804 )
PR_LOCK_TYPE = PROP_TAG( PT_SHORT,		0x3805 )
PR_LOCK_SCOPE = PROP_TAG( PT_SHORT,		0x3806 )
PR_LOCK_TRANSIENT_ID = PROP_TAG( PT_BINARY,	0x3807 )
PR_LOCK_DEPTH = PROP_TAG( PT_LONG,		0x3808 )
PR_LOCK_TIMEOUT = PROP_TAG( PT_LONG,		0x3809 )
PR_LOCK_EXPIRY_TIME = PROP_TAG( PT_SYSTIME,	0x380a )
PR_LOCK_GLID = PROP_TAG( PT_BINARY,	0x380b )
PR_LOCK_NULL_URL_W = PROP_TAG( PT_UNICODE,	0x380c )
PR_RULE_SERVER_RULE_ID = PROP_TAG(PT_I8, pidLISMsgFolderPropMin+0x0)
PR_FORCE_CLIENT_REFRESH = PROP_TAG(PT_BOOLEAN, pidLISMsgFolderPropMin+0x1)
PR_ANTIVIRUS_VENDOR = PROP_TAG(PT_STRING8,	pidStoreNonTransMin+0x45)
PR_ANTIVIRUS_VERSION = PROP_TAG(PT_LONG,		pidStoreNonTransMin+0x46)
PR_ANTIVIRUS_SCAN_STATUS = PROP_TAG(PT_LONG,		pidStoreNonTransMin+0x47)
PR_ANTIVIRUS_SCAN_INFO = PROP_TAG(PT_STRING8,	pidStoreNonTransMin+0x48)
PR_ADDR_TO = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x57)
PR_ADDR_TO_A = PROP_TAG(PT_STRING8, pidStoreNonTransMin+0x57)
PR_ADDR_TO_W = PROP_TAG(PT_UNICODE, pidStoreNonTransMin+0x57)
PR_ADDR_CC = PROP_TAG(PT_TSTRING, pidStoreNonTransMin+0x58)
PR_ADDR_CC_A = PROP_TAG(PT_STRING8, pidStoreNonTransMin+0x58)
PR_ADDR_CC_W = PROP_TAG(PT_UNICODE, pidStoreNonTransMin+0x58)

PR_ATTACH_CONTENT_ID = PROP_TAG(PT_TSTRING,0x3712)
PR_ATTACH_CONTENT_LOCATION = PROP_TAG(PT_TSTRING,0x3713)
PR_USER_X509_CERTIFICATE = PROP_TAG(PT_MV_BINARY,0x3a70)
PR_EMS_AB_X509_CERT = PROP_TAG(PT_MV_BINARY, 0x8c6a)
PR_NT_SECURITY_DESCRIPTOR = PROP_TAG(PT_BINARY,0x0E27)
PR_BODY_HTML = PROP_TAG(PT_TSTRING,0x1013)
PR_INTERNET_MESSAGE_ID = PROP_TAG(PT_TSTRING, 0x1035)
PR_INTERNET_MESSAGE_ID_A = PROP_TAG(PT_STRING8, 0x1035)
PR_INTERNET_MESSAGE_ID_W = PROP_TAG(PT_UNICODE, 0x1035)
PR_SMTP_ADDRESS = PROP_TAG(PT_TSTRING,0x39FE)
PR_SMTP_ADDRESS_W = PROP_TAG(PT_UNICODE,0x39FE)
PR_DEF_POST_MSGCLASS = PROP_TAG(PT_STRING8, 0x36E5)
PR_DEF_POST_DISPLAYNAME = PROP_TAG(PT_TSTRING, 0x36E6)
PR_INTERNET_ARTICLE_NUMBER = PROP_TAG(PT_LONG, 0x0E23)
PR_FREEBUSY_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x36E4)
PR_SEND_INTERNET_ENCODING = PROP_TAG(PT_LONG, 0x3A71)
PR_RECIPIENT_TRACKSTATUS = PROP_TAG(PT_LONG, 0x5FFF)
PR_RECIPIENT_FLAGS = PROP_TAG(PT_LONG, 0x5FFD)
PR_RECIPIENT_ENTRYID = PROP_TAG(PT_BINARY, 0x5FF7)
PR_RECIPIENT_DISPLAY_NAME = PROP_TAG(PT_TSTRING, 0x5FF6)
PR_ICON_INDEX = PROP_TAG(PT_LONG, 0x1080)
PR_OST_OSTID = PROP_TAG(PT_BINARY, 0x7c04)
PR_OFFLINE_FOLDER = PROP_TAG(PT_BINARY, 0x7c05)
PR_FAV_DISPLAY_NAME = PROP_TAG(PT_TSTRING, 0x7C00)
PR_FAV_DISPLAY_ALIAS = PROP_TAG(PT_TSTRING, 0x7C01)
PR_FAV_PUBLIC_SOURCE_KEY = PROP_TAG(PT_BINARY, 0x7C02)
PR_FAV_AUTOSUBFOLDERS = PROP_TAG(PT_LONG, 0x7d01)
PR_FAV_PARENT_SOURCE_KEY = PROP_TAG(PT_BINARY, 0x7d02)
PR_FAV_LEVEL_MASK = PROP_TAG(PT_LONG, 0x7D03)
PR_FAV_KNOWN_SUBS = PROP_TAG(PT_BINARY, 0x7D04)
PR_FAV_GUID_MAP = PROP_TAG(PT_BINARY, 0x7D05)
PR_FAV_KNOWN_DELS_OLD = PROP_TAG(PT_BINARY, 0x7D06)
PR_FAV_INHERIT_AUTO = PROP_TAG(PT_LONG, 0x7d07)
PR_FAV_DEL_SUBS = PROP_TAG(PT_BINARY, 0x7D08)
PR_FAV_CONTAINER_CLASS = PROP_TAG(PT_TSTRING, 0x7D09)
PR_IN_REPLY_TO_ID = PROP_TAG(PT_TSTRING, 0x1042)
PR_ATTACH_FLAGS = PROP_TAG(PT_LONG, 0x3714)
PR_ATTACHMENT_LINKID = PROP_TAG(PT_LONG, 0x7FFA)
PR_EXCEPTION_STARTTIME = PROP_TAG(PT_SYSTIME, 0x7FFB)
PR_EXCEPTION_ENDTIME = PROP_TAG(PT_SYSTIME, 0x7FFC)
PR_ATTACHMENT_FLAGS = PROP_TAG(PT_LONG, 0x7FFD)
PR_ATTACHMENT_HIDDEN = PROP_TAG(PT_BOOLEAN, 0x7FFE)
PR_ATTACHMENT_CONTACTPHOTO = PROP_TAG(PT_BOOLEAN, 0x7FFF)
PR_CONFLICT_ITEMS = PROP_TAG(PT_MV_BINARY,0x1098)
PR_INTERNET_APPROVED = PROP_TAG(PT_TSTRING,0x1030)
PR_INTERNET_CONTROL = PROP_TAG(PT_TSTRING,0x1031)
PR_INTERNET_DISTRIBUTION = PROP_TAG(PT_TSTRING,0x1032)
PR_INTERNET_FOLLOWUP_TO = PROP_TAG(PT_TSTRING,0x1033)
PR_INTERNET_LINES = PROP_TAG(PT_LONG,0x1034)
PR_INTERNET_NEWSGROUPS = PROP_TAG(PT_TSTRING,0x1036)
PR_INTERNET_NNTP_PATH = PROP_TAG(PT_TSTRING,0x1038)
PR_INTERNET_ORGANIZATION = PROP_TAG(PT_TSTRING,0x1037)
PR_INTERNET_PRECEDENCE = PROP_TAG(PT_TSTRING,0x1041)
PR_INTERNET_REFERENCES = PROP_TAG(PT_TSTRING,0x1039)
PR_NEWSGROUP_NAME = PROP_TAG(PT_TSTRING,0x0E24)
PR_NNTP_XREF = PROP_TAG(PT_TSTRING,0x1040)
PR_POST_FOLDER_ENTRIES = PROP_TAG(PT_BINARY,0x103B)
PR_POST_FOLDER_NAMES = PROP_TAG(PT_TSTRING,0x103C)
PR_POST_REPLY_DENIED = PROP_TAG(PT_BINARY,0x103F)
PR_POST_REPLY_FOLDER_ENTRIES = PROP_TAG(PT_BINARY,0x103D)
PR_POST_REPLY_FOLDER_NAMES = PROP_TAG(PT_TSTRING,0x103E)
PR_SUPERSEDES = PROP_TAG(PT_TSTRING,0x103A)
PR_PACKED_NAME_PROPS = PROP_TAG(PT_BINARY, 0x361C)
PR_IPM_APPOINTMENT_ENTRYID = PROP_TAG(PT_BINARY, 0x36D0)
PR_IPM_CONTACT_ENTRYID = PROP_TAG(PT_BINARY, 0x36D1)
PR_IPM_JOURNAL_ENTRYID = PROP_TAG(PT_BINARY, 0x36D2)
PR_IPM_NOTE_ENTRYID = PROP_TAG(PT_BINARY, 0x36D3)
PR_IPM_TASK_ENTRYID = PROP_TAG(PT_BINARY, 0x36D4)
PR_REM_ONLINE_ENTRYID = PROP_TAG(PT_BINARY, 0x36D5)
PR_REM_OFFLINE_ENTRYID = PROP_TAG(PT_BINARY, 0x36D6)
PR_IPM_DRAFTS_ENTRYID = PROP_TAG(PT_BINARY, 0x36D7)
PR_IPM_OL2007_ENTRYIDS = PROP_TAG(PT_BINARY, 0x36D9)
PR_ADDITIONAL_REN_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x36D8)
PR_MDN_DISPOSITION_TYPE = PROP_TAG(PT_STRING8, 0x0080)
PR_MDN_DISPOSITION_SENDINGMODE = PROP_TAG(PT_STRING8, 0x0081)
PR_LAST_VERB_EXECUTED = PROP_TAG(PT_LONG, 0x1081)
PR_LAST_VERB_EXECUTION_TIME = PROP_TAG(PT_SYSTIME, 0x1082)
PR_SEARCH_ATTACHMENTS = PROP_TAG(PT_TSTRING, 0x0EA5)
PR_SEARCH_ATTACHMENTS_A = PROP_TAG(PT_STRING8, 0x0EA5)
PR_SEARCH_ATTACHMENTS_W = PROP_TAG(PT_UNICODE, 0x0EA5)
PR_SEARCH_RECIP_EMAIL_TO = PROP_TAG(PT_TSTRING, 0x0EA6)
PR_SEARCH_RECIP_EMAIL_TO_A = PROP_TAG(PT_STRING8, 0x0EA6)
PR_SEARCH_RECIP_EMAIL_TO_W = PROP_TAG(PT_UNICODE, 0x0EA6)
PR_SEARCH_RECIP_EMAIL_CC = PROP_TAG(PT_TSTRING, 0x0EA7)
PR_SEARCH_RECIP_EMAIL_CC_A = PROP_TAG(PT_STRING8, 0x0EA7)
PR_SEARCH_RECIP_EMAIL_CC_W = PROP_TAG(PT_UNICODE, 0x0EA7)
PR_SEARCH_RECIP_EMAIL_BCC = PROP_TAG(PT_TSTRING, 0x0EA8)
PR_SEARCH_RECIP_EMAIL_BCC_A = PROP_TAG(PT_STRING8, 0x0EA8)
PR_SEARCH_RECIP_EMAIL_BCC_W = PROP_TAG(PT_UNICODE, 0x0EA8)
PR_FOLDER_XVIEWINFO_E = PROP_TAG(PT_BINARY, 0x36E0)
PR_FOLDER_DISPLAY_FLAGS = PROP_TAG(PT_BINARY, 0x36DA)
PR_NET_FOLDER_FLAGS = PROP_TAG(PT_LONG, 0x36DE)
PR_FOLDER_WEBVIEWINFO = PROP_TAG(PT_BINARY, 0x36DF)
PR_FOLDER_VIEWS_ONLY = PROP_TAG(PT_LONG, 0x36E1)
PR_MANAGED_FOLDER_INFORMATION = PROP_TAG(PT_LONG, 0x672D)
PR_MANAGED_FOLDER_STORAGE_QUOTA = PROP_TAG(PT_LONG, 0x6731)
PR_SCHDINFO_DELEGATE_NAMES = PROP_TAG(PT_MV_STRING8, 0x6844)
PR_SCHDINFO_DELEGATE_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x6845)
PR_DELEGATE_FLAGS = PROP_TAG(PT_MV_LONG, 0x686B)
PR_TODO_ITEM_FLAGS = PROP_TAG(PT_LONG, 0x0E2B)
PR_FOLLOWUP_ICON = PROP_TAG(PT_LONG, 0x1095)
PR_FLAG_STATUS = PROP_TAG(PT_LONG, 0x1090)
PR_FLAG_COMPLETE_TIME = PROP_TAG(PT_SYSTIME, 0x1091)
PR_INETMAIL_OVERRIDE_FORMAT = PROP_TAG(PT_LONG, 0x5902)
PR_DISPLAY_TYPE_EX = PROP_TAG(PT_LONG, 0x3905)
PR_EMS_AB_ROOM_CAPACITY = PROP_TAG(PT_LONG, 0x0807)
PR_EMS_AB_ROOM_DESCRIPTION = PROP_TAG(PT_STRING8, 0x0809)
PR_EMS_AB_HOME_MDB = PROP_TAG(PT_STRING8, 0x8006)
PR_EMS_AB_HOME_MTA = PROP_TAG(PT_STRING8, 0x8007)

# MAPI IIDs
IID_IUnknown = DEFINE_OLEGUID(0,0,0)
IID_IStream = DEFINE_OLEGUID(0x0C,0,0)
IID_IStorage = DEFINE_OLEGUID(0x0B,0,0)
IID_IMAPISession = DEFINE_OLEGUID(    0x00020300, 0, 0)
IID_IMAPITable = DEFINE_OLEGUID(      0x00020301, 0, 0)
IID_IMAPIAdviseSink = DEFINE_OLEGUID( 0x00020302, 0, 0)
IID_IMAPIControl = DEFINE_OLEGUID(    0x0002031B, 0, 0)
IID_IProfAdmin = DEFINE_OLEGUID(      0x0002031C, 0, 0)
IID_IMsgServiceAdmin = DEFINE_OLEGUID(0x0002031D, 0, 0)
IID_IProviderAdmin = DEFINE_OLEGUID(  0x00020325, 0, 0)
IID_IMAPIProgress = DEFINE_OLEGUID(   0x0002031F, 0, 0)
IID_IMAPIProp = DEFINE_OLEGUID(       0x00020303, 0, 0)
IID_IProfSect = DEFINE_OLEGUID(       0x00020304, 0, 0)
IID_IMAPIStatus = DEFINE_OLEGUID(         0x00020305, 0, 0)
IID_IMsgStore = DEFINE_OLEGUID(       0x00020306, 0, 0)
IID_IMessage = DEFINE_OLEGUID(        0x00020307, 0, 0)
IID_IAttachment = DEFINE_OLEGUID(     0x00020308, 0, 0)
IID_IAddrBook = DEFINE_OLEGUID(       0x00020309, 0, 0)
IID_IMailUser = DEFINE_OLEGUID(       0x0002030A, 0, 0)
IID_IMAPIContainer = DEFINE_OLEGUID(  0x0002030B, 0, 0)
IID_IMAPIFolder = DEFINE_OLEGUID(     0x0002030C, 0, 0)
IID_IABContainer = DEFINE_OLEGUID(    0x0002030D, 0, 0)
IID_IDistList = DEFINE_OLEGUID(       0x0002030E, 0, 0)
IID_IMAPISup = DEFINE_OLEGUID(        0x0002030F, 0, 0)
IID_IMSProvider = DEFINE_OLEGUID(     0x00020310, 0, 0)
IID_IABProvider = DEFINE_OLEGUID(     0x00020311, 0, 0)
IID_IXPProvider = DEFINE_OLEGUID(     0x00020312, 0, 0)
IID_IMSLogon = DEFINE_OLEGUID(        0x00020313, 0, 0)
IID_IABLogon = DEFINE_OLEGUID(        0x00020314, 0, 0)
IID_IXPLogon = DEFINE_OLEGUID(        0x00020315, 0, 0)
IID_IMAPITableData = DEFINE_OLEGUID(  0x00020316, 0, 0)
IID_IMAPISpoolerInit = DEFINE_OLEGUID(    0x00020317, 0, 0)
IID_IMAPISpoolerSession = DEFINE_OLEGUID( 0x00020318, 0, 0)
IID_ITNEF = DEFINE_OLEGUID(           0x00020319, 0, 0)
IID_IMAPIPropData = DEFINE_OLEGUID(   0x0002031A, 0, 0)
IID_ISpoolerHook = DEFINE_OLEGUID(    0x00020320, 0, 0)
IID_IMAPISpoolerService = DEFINE_OLEGUID( 0x0002031E, 0, 0)
IID_IMAPIViewContext = DEFINE_OLEGUID(    0x00020321, 0, 0)
IID_IMAPIFormMgr = DEFINE_OLEGUID(    0x00020322, 0, 0)
IID_IEnumMAPIFormProp = DEFINE_OLEGUID(   0x00020323, 0, 0)
IID_IMAPIFormInfo = DEFINE_OLEGUID(   0x00020324, 0, 0)
IID_IMAPIForm = DEFINE_OLEGUID(   0x00020327, 0, 0)
PS_MAPI = DEFINE_OLEGUID( 0x00020328, 0, 0)
PS_PUBLIC_STRINGS = DEFINE_OLEGUID(   0x00020329, 0, 0)
IID_IPersistMessage = DEFINE_OLEGUID( 0x0002032A, 0, 0)
IID_IMAPIViewAdviseSink = DEFINE_OLEGUID( 0x0002032B, 0, 0)
IID_IStreamDocfile = DEFINE_OLEGUID( 0x0002032C, 0, 0)
IID_IMAPIFormProp = DEFINE_OLEGUID(   0x0002032D, 0, 0)
IID_IMAPIFormContainer = DEFINE_OLEGUID( 0x0002032E, 0, 0)
IID_IMAPIFormAdviseSink = DEFINE_OLEGUID( 0x0002032F, 0, 0)
IID_IStreamTnef = DEFINE_OLEGUID( 0x00020330, 0, 0)
IID_IMAPIFormFactory = DEFINE_OLEGUID( 0x00020350, 0, 0)
IID_IMAPIMessageSite = DEFINE_OLEGUID( 0x00020370, 0, 0)
PS_ROUTING_EMAIL_ADDRESSES = DEFINE_OLEGUID(  0x00020380, 0, 0)
PS_ROUTING_ADDRTYPE = DEFINE_OLEGUID( 0x00020381, 0, 0)
PS_ROUTING_DISPLAY_NAME = DEFINE_OLEGUID( 0x00020382, 0, 0)
PS_ROUTING_ENTRYID = DEFINE_OLEGUID(  0x00020383, 0, 0)
PS_ROUTING_SEARCH_KEY = DEFINE_OLEGUID(   0x00020384, 0, 0)
MUID_PROFILE_INSTANCE = DEFINE_OLEGUID( 0x00020385, 0, 0)
IID_IMessageRaw = DEFINE_OLEGUID( 0x0002038A, 0, 0)

# Zarafa Tags
PR_EC_BASE 				= 0x6700

PR_EC_PATH 				= PROP_TAG(PT_STRING8, PR_EC_BASE + 0x00)
PR_EC_USERNAME 			= PROP_TAG(PT_TSTRING, PR_EC_BASE + 0x01)
PR_EC_USERNAME_A 			= PROP_TAG(PT_STRING8, PR_EC_BASE + 0x01)
PR_EC_USERNAME_W 			= PROP_TAG(PT_UNICODE, PR_EC_BASE + 0x01)
PR_EC_USERPASSWORD		= PROP_TAG(PT_TSTRING, PR_EC_BASE + 0x02)
PR_EC_USERPASSWORD_A		= PROP_TAG(PT_STRING8, PR_EC_BASE + 0x02)
PR_EC_USERPASSWORD_W		= PROP_TAG(PT_UNICODE, PR_EC_BASE + 0x02)
PR_EC_PORT 				= PROP_TAG(PT_STRING8, PR_EC_BASE + 0x03)
PR_EC_FLAGS				= PROP_TAG(PT_LONG, PR_EC_BASE + 0x04)
PR_EC_SSLKEY_FILE		= PROP_TAG(PT_STRING8, PR_EC_BASE + 0x05)
PR_EC_SSLKEY_PASS		= PROP_TAG(PT_STRING8, PR_EC_BASE + 0x06)

PR_EC_CHANGE_ADVISOR	= PROP_TAG(PT_OBJECT, PR_EC_BASE+0x89)

PR_EC_STATSTABLE_SYSTEM		= PROP_TAG(PT_OBJECT,		PR_EC_BASE+0x30)
PR_EC_STATSTABLE_SESSIONS	= PROP_TAG(PT_OBJECT,		PR_EC_BASE+0x31)
PR_EC_STATSTABLE_USERS		= PROP_TAG(PT_OBJECT,		PR_EC_BASE+0x32)
PR_EC_STATSTABLE_COMPANY	= PROP_TAG(PT_OBJECT,		PR_EC_BASE+0x33)

# system stats
PR_EC_STATS_SYSTEM_DESCRIPTION	= PROP_TAG(PT_TSTRING,		PR_EC_BASE+0x40)
PR_EC_STATS_SYSTEM_VALUE	= PROP_TAG(PT_TSTRING,		PR_EC_BASE+0x41)

# session stats
PR_EC_STATS_SESSION_ID		= PROP_TAG(PT_LONGLONG,		PR_EC_BASE+0x42)
PR_EC_STATS_SESSION_IPADDRESS	= PROP_TAG(PT_TSTRING,		PR_EC_BASE+0x43)
PR_EC_STATS_SESSION_IDLETIME	= PROP_TAG(PT_LONG,		PR_EC_BASE+0x44)
PR_EC_STATS_SESSION_CAPABILITY	= PROP_TAG(PT_LONG,		PR_EC_BASE+0x45)
PR_EC_STATS_SESSION_LOCKED	= PROP_TAG(PT_BOOLEAN,		PR_EC_BASE+0x46)
PR_EC_STATS_SESSION_BUSYSTATES	= PROP_TAG(PT_MV_TSTRING,	PR_EC_BASE+0x47)

# IMAP Gateway special props
PR_EC_IMAP_ID = 				PROP_TAG(PT_LONG,	PR_EC_BASE+0x82)
PR_EC_IMAP_SUBSCRIBED = 		PROP_TAG(PT_BINARY,	PR_EC_BASE+0x84)
PR_EC_IMAP_MAX_ID = 			PROP_TAG(PT_LONG, 	PR_EC_BASE+0x85)
PR_EC_CLIENT_SUBMIT_DATE = 		PROP_TAG(PT_SYSTIME, PR_EC_BASE+0x86)
PR_EC_MESSAGE_DELIVERY_DATE =	PROP_TAG(PT_SYSTIME, PR_EC_BASE+0x87)
PR_EC_IMAP_EMAIL = 				PROP_TAG(PT_BINARY,	PR_EC_BASE+0x8C)
PR_EC_IMAP_EMAIL_SIZE = 		PROP_TAG(PT_LONG,	PR_EC_BASE+0x8D)
PR_EC_IMAP_BODY = 				PROP_TAG(PT_STRING8,	PR_EC_BASE+0x8E)
PR_EC_IMAP_BODYSTRUCTURE =		PROP_TAG(PT_STRING8,	PR_EC_BASE+0x8F)

PR_EC_PUBLIC_IPM_SUBTREE_ENTRYID =	PROP_TAG(PT_BINARY,	PR_EC_BASE+0xD0)

# IMAP named properties
PS_EC_IMAP = DEFINE_GUID(0x00f5f108, 0x8e3f, 0x46c7, 0xaf, 0x72, 0x5e, 0x20, 0x1c, 0x23, 0x49, 0xe7)

PR_EC_ENABLED_FEATURES    = PROP_TAG(PT_MV_TSTRING, PR_EC_BASE+0xB3)
PR_EC_ENABLED_FEATURES_A  = PROP_TAG(PT_MV_STRING8, PR_EC_BASE+0xB3)
PR_EC_ENABLED_FEATURES_W  = PROP_TAG(PT_MV_UNICODE, PR_EC_BASE+0xB3)
PR_EC_DISABLED_FEATURES   = PROP_TAG(PT_MV_TSTRING, PR_EC_BASE+0xB4)
PR_EC_DISABLED_FEATURES_A = PROP_TAG(PT_MV_STRING8, PR_EC_BASE+0xB4)
PR_EC_DISABLED_FEATURES_W = PROP_TAG(PT_MV_UNICODE, PR_EC_BASE+0xB4)

# Flags for PR_EC_FLAGS
EC_PROFILE_FLAGS_NO_NOTIFICATIONS		= 0x0000001
EC_PROFILE_FLAGS_NO_COMPRESSION			= 0x0000002
EC_PROFILE_FLAGS_NO_PUBLIC_STORE		= 0x0000004
EC_PROFILE_FLAGS_OFFLINE				= 0x0000080
EC_PROFILE_FLAGS_CACHE_PRIVATE			= 0x0000100
EC_PROFILE_FLAGS_CACHE_PUBLIC			= 0x0000400

# Flags for PurgeCache
PURGE_CACHE_QUOTA			= 0x0001
PURGE_CACHE_QUOTADEFAULT	= 0x0002
PURGE_CACHE_OBJECTS			= 0x0004
PURGE_CACHE_STORES			= 0x0008
PURGE_CACHE_ACL				= 0x0010
PURGE_CACHE_CELL			= 0x0020
PURGE_CACHE_INDEX1			= 0x0040
PURGE_CACHE_INDEX2			= 0x0080
PURGE_CACHE_INDEXEDPROPERTIES = 0x0100
PURGE_CACHE_USEROBJECT		= 0x0200
PURGE_CACHE_EXTERNID		= 0x0400
PURGE_CACHE_USERDETAILS		= 0x0800
PURGE_CACHE_SERVER			= 0x1000
PURGE_CACHE_ALL				= 0xFFFFFFFF

# Exchange IIDs.
IID_IExchangeManageStore = DEFINE_GUID(0x559d10b0,0xa772,0x11cd,0x9b,0xc8,0x00,0xaa,0x00,0x2f,0xc4,0x5a)
IID_IExchangeManageStore2 = DEFINE_GUID(0xb6dca470,0xff3,0x11d0,0xa4,0x9,0x0,0xc0,0x4f,0xd7,0xbd,0x87)
IID_IExchangeManageStore3 = DEFINE_GUID(0x166d9bc2,0xdb75,0x44a9,0x8a,0x93,0x9f,0x3f,0xfc,0x99,0x4d,0x76)
IID_IExchangeManageStore4 = DEFINE_GUID(0x2590ff87,0xc431,0x4f9c,0xb1,0xa8,0xcd,0x69,0xd7,0x60,0xcd,0x10)
IID_IExchangeManageStore5 = DEFINE_GUID(0x7907dd18,0xf141,0x4676,0xb1,0x02,0x37,0xc9,0xd9,0x36,0x34,0x30)
IID_IExchangeModifyTable = DEFINE_GUID(0x2d734cb0,0x53fd,0x101b,0xb1,0x9d,0x08,0x00,0x2b,0x30,0x56,0xe3)
IID_IExchangeRuleAction = DEFINE_GUID(0x74bba840,0xc93a,0x11ce,0x95,0x81,0x00,0xaa,0x00,0x57,0x42,0xf7)
IID_IExchangeFastTransfer = DEFINE_GUID(0xff7db070,0xa88a,0x11cd,0x9b,0xc8,0x00,0xaa,0x00,0x2f,0xc4,0x5a)
IID_IExchangeExportChanges = DEFINE_GUID(0xa3ea9cc0,0xd1b2,0x11cd,0x80,0xfc,0x00,0xaa,0x00,0x4b,0xba,0x0b)
IID_IExchangeExportChanges2 = DEFINE_GUID(0x387cebe0,0xf53f,0x11cf,0xa4,0x8f,0x00,0xc0,0x4f,0xd6,0x55,0x95)
IID_IExchangeExportChanges3 = DEFINE_GUID(0x702e7f86,0x50a6,0x11d1,0xab,0xd6,0x00,0xa0,0xc9,0x05,0x66,0x0a)
IID_IExchangeImportHierarchyChanges = DEFINE_GUID(0x85a66cf0,0xd0e0,0x11cd,0x80,0xfc,0x00,0xaa,0x00,0x4b,0xba,0x0b)
IID_IExchangeImportContentsChanges = DEFINE_GUID(0xf75abfa0,0xd0e0,0x11cd,0x80,0xfc,0x00,0xaa,0x00,0x4b,0xba,0x0b)
IID_IExchangeChangeAdvisor = DEFINE_GUID(0x1e300720,0xa839,0x11cf,0xbd,0xe0,0x0,0x0,0x4c,0x75,0x31,0xe3)
IID_IExchangeMessageConversion = DEFINE_GUID(0x3532b360,0xd114,0x11cf,0xa8,0x3b,0x0,0xc0,0x4f,0xd6,0x55,0x97)
IID_IExchangeFavorites = DEFINE_GUID(0xcf4f3bc0,0xec66,0x11ce,0xb3,0x1c,0x00,0xaa,0x00,0x57,0x4c,0xc6)
IID_IExchangeNntpNewsfeed = DEFINE_GUID(0x380f41c0,0x3cdc,0x11d0,0x97,0x92,0x00,0xc0,0x4f,0xd6,0x55,0x1d)
IID_IExchangeBadItemCallback = DEFINE_GUID(0x1df85ab7,0x4d20,0x4a57,0xb1,0x70,0x2f,0x06,0x21,0x36,0xc1,0xd6)
IID_IExchangeMoveUserProgress = DEFINE_GUID(0xef2fb44a,0x8dac,0x4e4e,0xb1,0xe3,0xa3,0xb9,0x26,0x35,0x56,0x17)
# DEFINE_GUID(IID_IExchangeMessageCpid0,0x0,0x1ae9,0x11cf,0x84,0xe0,0x00,0xaa,0x00,0x6b,0x4f,0xae);  
IID_IExchangeServer = DEFINE_GUID(0x25150F47,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IStorageGroup = DEFINE_GUID(0x25150F46,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IPublicStoreDB = DEFINE_GUID(0x25150F44,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IPublicStoreDB2 = DEFINE_GUID(0x25150F49,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IMailboxStoreDB = DEFINE_GUID(0x25150F45,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IMailboxStoreDB2 = DEFINE_GUID(0x25150F4A,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IFolderTree = DEFINE_GUID(0x25150F43,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
IID_IDataSource2 = DEFINE_GUID(0x25150F48,0x5734,0x11d2,0xA5,0x93,0x00,0xC0,0x4F,0x99,0x0D,0x8A)
# DEFINE_GUID(name,0x00020D00 | (b)0,0,0xC0,0,0,0,0,0,0,0x46)
IID_IConverterSession = DEFINE_GUID(0x4b401570,0xb77b,0x11d0,0x9d,0xa5,0x0,0xc0,0x4f,0xd6,0x56,0x85)
GUID_GlobalState  = DEFINE_GUID(0xfbeffd93,0xb11f,0x4094,0x84,0x2b,0x96,0xdc,0xd3,0x1e,0x63,0xd1)
IID_IMAPIOffline = DEFINE_GUID(0x000672B5,0x0000,0x0000,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x46)
IID_IMAPIOfflineNotify = DEFINE_GUID(0x0317bde5,0xfc29,0x44cd,0x8d,0xcd,0x36,0x12,0x5a,0x3b,0xe9,0xec)
IID_IMAPIOfflineMgr = DEFINE_GUID(0x42175607,0xFF3E,0x4790,0xbc,0x18,0x66,0xc8,0x64,0x3e,0x64,0x24)
IID_IPSTX = DEFINE_GUID(0x4FDEEFF0,0x0319,0x11CF,0xB4,0xCF,0x00,0xAA,0x0D,0xBB,0xB6,0xE6)
IID_IPSTX2 = DEFINE_GUID(0x2067A790,0x2A45,0x11D1,0xEB,0x86,0x00,0xA0,0xC9,0x0D,0xCA,0x6D)
IID_IPSTX3 = DEFINE_GUID(0x55f15320,0x111b,0x11d2,0xa9,0x99,0x00,0x60,0x08,0xb0,0x5a,0xa7)
IID_IPSTX4 = DEFINE_GUID(0xaa2e2092,0xac08,0x11d2,0xa2,0xf9,0x00,0x60,0xb0,0xec,0x3d,0x4f)
IID_IPSTX5 = DEFINE_GUID(0x55f15322,0x111b,0x11d2,0xa9,0x99,0x00,0x60,0x08,0xb0,0x5a,0xa7)
IID_IPSTX6 = DEFINE_GUID(0x55f15323,0x111b,0x11d2,0xa9,0x99,0x00,0x60,0x08,0xb0,0x5a,0xa7)
IID_IOSTX = DEFINE_GUID(0xd2d85db4,0x840f,0x49b8,0x99,0x82,0x07,0xd2,0x40,0x5e,0xc6,0xb7)
IID_IMAPIFolderNoProvChk = DEFINE_GUID(0x57D333A0,0xF589,0x4b23,0xA3,0xF9,0x85,0xF8,0x2F,0xEC,0x15,0x3C)
IID_IMessageNoProvChk = DEFINE_GUID(0xC3505457,0x7B2E,0x4c3b,0xA8,0xD6,0x6D,0xD9,0x49,0xBB,0x97,0xA1)
IID_IOlkErrorUnknown = DEFINE_GUID(0x9240a6c0,0xaf41,0x11d2,0x8c,0x3b,0x0,0x10,0x4b,0x2a,0x66,0x76)
IID_IOlkEnum = DEFINE_GUID(0x9240a6c0,0xaf41,0x11d2,0x8c,0x3b,0x0,0x10,0x4b,0x2a,0x66,0x76)
IID_IOlkAccountNotify = DEFINE_GUID(0x9240a6c3,0xaf41,0x11d2,0x8c,0x3b,0x0,0x10,0x4b,0x2a,0x66,0x76)
IID_IOlkAccountHelper = DEFINE_GUID(0x9240a6cb,0xaf41,0x11d2,0x8c,0x3b,0x0,0x10,0x4b,0x2a,0x66,0x76)
IID_IOlkAccountManager = DEFINE_GUID(0x9240a6cd,0xaf41,0x11d2,0x8c,0x3b,0x0,0x10,0x4b,0x2a,0x66,0x76)
IID_IOlkAccount = DEFINE_GUID(0x9240a6d2,0xaf41,0x11d2,0x8c,0x3b,0x0,0x10,0x4b,0x2a,0x66,0x76)
# DEFINE_GUID(name,0x00020E00 | (b)0,0,0xC0,0,0,0,0,0,0,0x46)
LIBID_aclcls = DEFINE_GUID(0xad2495a3,0xa76c,0x11ce,0xb9,0x67,0x0,0x20,0xaf,0x52,0x52,0x44)
IID_IExchangeFolderACLs = DEFINE_GUID(0xad2495a6,0xa76c,0x11ce,0xb9,0x67,0x0,0x20,0xaf,0x52,0x52,0x44)
LIBID_rulecls = DEFINE_GUID(0xF111A8E6,0x4462,0x11CE,0xA8,0xDE,0x00,0xAA,0x00,0x4A,0xC5,0xC1)
IID_IExchangeFolderRules = DEFINE_GUID(0xF111A8E7,0x4462,0x11CE,0xA8,0xDE,0x00,0xAA,0x00,0x4A,0xC5,0xC1)
GUID_ExchangeFormExts = DEFINE_GUID(0x77f69534,0x6b7d,0x101b,0x9f,0x0d,0x00,0xaa,0x00,0x3b,0xa9,0x05)
IID_IOutlookExtCallback = DEFINE_GUID(0x0006720d,0x0000,0x0000,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46)
# DEFINE_GUID(_name,(0x29F3AB10 + _l)0x554D,0x11D0,0xA9,\
# DEFINE_GUID(IID_IAttachmentSecurity,
IID_IFolderSupport = DEFINE_GUID(0x00375ac3,0xecaf,0x4ef8,0xa5,0x27,0x34,0xf4,0x52,0xfa,0x9c,0x67)
IID_ISelectUnicode = DEFINE_GUID(0x05EB1EB9,0xE334,0x4EB7,0xAC,0x4D,0x0B,0xCE,0xC7,0xC6,0xE0,0xC1)

ZARAFA_SERVICE_GUID = DEFINE_GUID(0x3c253dca,0xd227,0x443c,0x94,0xfe,0x42,0x5f,0xab,0x95,0x8c,0x19)
ZARAFA_STORE_PUBLIC_GUID = DEFINE_GUID(0xd47f4a09,0xd3bd,0x493c,0xb2,0xfc,0x3c,0x90,0xbb,0xcb,0x48,0xd4)
ZARAFA_STORE_DELEGATE_GUID = DEFINE_GUID(0x7c7c1085,0xbc6d,0x4e53,0x9d,0xab,0x8a,0x53,0xf8,0xde,0xf8,0x8)
ZARAFA_SAB_GUID = DEFINE_GUID(0x5abae40e,0x1df7,0x4f3d,0x96,0x4d,0x65,0x8a,0x79,0x92,0x4e,0x9d)
IID_IECSingleInstance = DEFINE_GUID(0xa7d80ed6,0xd027,0x11dd,0xb0,0xb6,0x64,0x50,0x55,0xd8,0x95,0x93)
IID_IECSpooler = DEFINE_GUID(0x20c5963f,0xe0b,0x4d7f,0xb7,0x5d,0x8a,0xcd,0x88,0x72,0x71,0x19)
IID_IECServiceAdmin = DEFINE_GUID(0xa4445398,0x6996,0x4a29,0x8c,0x45,0x50,0xc8,0x3e,0x3d,0xe2,0x70)
IID_IECSecurity = DEFINE_GUID(0x6d4fe98e,0x9df,0x4d85,0xa1,0x91,0x89,0x6b,0x1f,0x89,0xf9,0x11)
IID_IECMultiStoreTable = DEFINE_GUID(0xb1514d30,0xd8bf,0x48a3,0x95,0x60,0x6f,0x78,0xe7,0xa5,0x00,0x5b)
IID_IECLicense = DEFINE_GUID(0xa9a55c9a,0xd2bb,0x461e,0x9f,0xf5,0xfd,0x4e,0xd9,0x84,0x4c,0x2e)
IID_IECTestProtocol = DEFINE_GUID(0x8f6cb9b3, 0x406, 0x4a7a, 0xb8, 0xba, 0x95, 0x37, 0x20, 0x1, 0xd4, 0x13)

IID_ECMemBlock = DEFINE_GUID(0x49941ea5,0xe4bc,0x46c5,0xbf,0x61,0xe9,0x4c,0x15,0x43,0xb6,0x12)
IID_ECMemStream = DEFINE_GUID(0x6c5377b7,0xb5ca,0x4e14,0xbc,0x94,0xe1,0x60,0x48,0xba,0x2b,0x10)
IID_ECUnknown = DEFINE_GUID(0x1a2038d1,0x4152,0x42b5,0x90,0xc5,0xd4,0xd6,0x12,0x6b,0x93,0x14)
IID_ECMemTable = DEFINE_GUID(0x707e2dc8,0xcf4d,0x438e,0xb2,0x20,0x2f,0x17,0xaa,0x79,0x2d,0xd1)
IID_ECMemTablePublic = DEFINE_GUID(0x75c99339,0x15b4,0x4d9a,0xb3,0x84,0x69,0xed,0x7a,0xd5,0x47,0x9e)
IID_ECMemTableView = DEFINE_GUID(0x68e696c9,0xf905,0x4ff4,0xb6,0x77,0x2c,0x95,0x10,0x47,0xd0,0xee)
IID_ECExchangeModifyTable = DEFINE_GUID(0xbd574d55,0x174e,0x4873,0x98,0x73,0x57,0x9e,0xb1,0x92,0x24,0x3c)
IID_ECFreeBusySupport = DEFINE_GUID(0x6603936a,0x3afc,0x4276,0xbd,0x91,0xc,0x54,0x36,0x15,0xc8,0xff)
IID_ECFreeBusyData = DEFINE_GUID(0xee4e17e9,0x22ca,0x47e1,0x8a,0x60,0x6,0x7,0x4b,0xad,0x1f,0xd3)
IID_ECEnumFBBlock = DEFINE_GUID(0xf1e1ca2c,0x4fb9,0x48fa,0x9d,0x3c,0xb2,0x2a,0xfd,0x51,0x87,0x9f)
IID_ECFreeBusyUpdate = DEFINE_GUID(0xc60b88a3,0x17c8,0x4206,0xb8,0xa0,0xc6,0x8c,0x9,0x84,0x13,0x30)
IID_IECExportChanges = DEFINE_GUID(0xa2656166,0xeaee,0x4cf7,0x8c,0x55,0x4c,0x05,0xb6,0x6b,0x81,0xbb)
IID_ECMsgStoreOffline = DEFINE_GUID(0x13cc44f2,0xb516,0x4a03,0xb2,0xc0,0xf3,0x3b,0x47,0xca,0xdf,0x89)
IID_ECMsgStoreOnline = DEFINE_GUID(0x13e8536,0x131e,0x44e5,0xa4,0x6a,0xf3,0x99,0xb9,0xc0,0x53,0x91)
IID_IECExportAddressbookChanges = DEFINE_GUID(0x09f33e65,0x6886,0x4bf2,0xa2,0x6f,0xfa,0x0e,0xc4,0xe9,0x42,0x16)
IID_IECImportAddressbookChanges = DEFINE_GUID(0x1843c89e,0x2411,0x11de,0xbe,0x6e,0x7c,0x32,0x56,0xd8,0x95,0x93)
IID_IECServerBehavior = DEFINE_GUID(0x1c2d9897,0xf459,0x4a55,0x9d,0x11,0xcd,0x9e,0x7c,0x75,0x51,0xee)
IID_IECServerMimic = DEFINE_GUID(0x7175de83,0x33a2,0x4d69,0x8d,0x9a,0x17,0x72,0x6e,0xb2,0xfc,0xdd)
IID_IDispatch = DEFINE_GUID(0x00020400,0x0000,0x0000,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46)
IID_ISensNetwork = DEFINE_GUID(0xd597bab1,0x5b9f,0x11d1,0x8d,0xd2,0x00,0xaa,0x00,0x4a,0xbd,0x5e)
IID_ECStreamOps = DEFINE_GUID(0xb55b1ca3,0x53c0,0x491e,0xae,0x76,0xd,0x6a,0x2b,0x32,0x1b,0xc3)
IID_IECChangeAdvisor = DEFINE_GUID(0x49a1ce2f,0xde5a,0x40ec,0xbb,0xaf,0x7e,0xd6,0x4b,0xdf,0x88,0x89)
IID_ECChangeAdvisor = DEFINE_GUID(0xb767bd7c,0xebf1,0x4d86,0x91,0x12,0x60,0x1c,0x8d,0x9d,0x7d,0x9f)
IID_IECChangeAdviseSink = DEFINE_GUID(0xc71de317,0x16e4,0x43a8,0x96,0x3e,0x6f,0x6,0xf4,0x46,0x21,0x8)
IID_ECChangeAdviseSink = DEFINE_GUID(0xc6937b5a,0x48d7,0x4017,0xa0,0x41,0x25,0x63,0x59,0xb,0x1f,0x5f)
IID_IECImportContentsChanges = DEFINE_GUID(0x2458600a,0xf010,0x4ee4,0xb8,0xe1,0xbf,0xd7,0xc1,0xaa,0x1e,0xc5)
IID_IECMessageRaw = DEFINE_GUID(0x54cd0028, 0x46e7, 0x4555, 0xb6, 0x8f, 0x1a, 0xe7, 0x9d, 0x61, 0x71, 0xc1)
IID_IECLicense = DEFINE_GUID(0xa9a55c9a, 0xd2bb, 0x461e, 0x9f, 0xf5, 0xfd, 0x4e, 0xd9, 0x84, 0x4c, 0x2e)
