/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class TimeType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 3;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            block28: {
                char c;
                block27: {
                    c = string.charAt(n4);
                    if (c != '-' || n2 != 0) break block27;
                    ++n3;
                    break block28;
                }
                if (c >= '0' && c <= '9') break block28;
                switch (n2) {
                    case 3: {
                        if (c != ':') throw new DatatypeException(n4, "invalid time value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid time value");
                        }
                        n2 = 4;
                        n3 = n4 + 1;
                        break;
                    }
                    case 4: {
                        if (c != ':') throw new DatatypeException(n4, "invalid time value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid time value");
                        }
                        n2 = 5;
                        n3 = n4 + 1;
                        break;
                    }
                    case 5: {
                        if (c == '.') {
                            if (n4 - n3 != 2) {
                                throw new DatatypeException(n4, "invalid time value");
                            }
                            n2 = 6;
                            n3 = n4 + 1;
                            break;
                        }
                        if (c != ' ') throw new DatatypeException(n4, "invalid time value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid time value");
                        }
                        n2 = 7;
                        n3 = n4 + 1;
                        break;
                    }
                    case 6: {
                        if (c != ' ') throw new DatatypeException(n4, "invalid time value");
                        n2 = 7;
                        n3 = n4 + 1;
                        break;
                    }
                    case 7: {
                        if (n3 == n4) {
                            if (c == '+' || c == '-') break;
                            if (c == 'Z') {
                                n2 = 9;
                                n3 = n4 + 1;
                                break;
                            }
                        }
                        if (c != ':') throw new DatatypeException(n4, "invalid time value");
                        if (n4 - n3 != 2) {
                            throw new DatatypeException(n4, "invalid time value");
                        }
                        n2 = 8;
                        n3 = n4 + 1;
                        break;
                    }
                    default: {
                        throw new DatatypeException(n4, "invalid time value");
                    }
                }
            }
            ++n4;
        }
        switch (n2) {
            case 5: {
                if (n - n3 == 2) return;
                throw new DatatypeException(n, "invalid time value");
            }
            case 6: {
                return;
            }
            case 8: {
                if (n - n3 == 2) return;
                throw new DatatypeException(n, "invalid time value");
            }
            case 9: {
                return;
            }
            default: {
                throw new DatatypeException(n, "invalid time value");
            }
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        int n = string.length();
        int n2 = 3;
        int n3 = 0;
        Time time = new Time();
        try {
            int n4;
            int n5 = 0;
            while (n5 < n) {
                n4 = string.charAt(n5);
                if (n4 < 48 || n4 > 57) {
                    switch (n2) {
                        case 3: {
                            if (n4 != 58) break;
                            time.minutes = Integer.parseInt(string.substring(n3, n5)) * 60;
                            n2 = 4;
                            n3 = n5 + 1;
                            break;
                        }
                        case 4: {
                            if (n4 != 58) break;
                            time.minutes += Integer.parseInt(string.substring(n3, n5));
                            n2 = 5;
                            n3 = n5 + 1;
                            break;
                        }
                        case 5: {
                            if (n4 != 32) break;
                            time.seconds = Float.parseFloat(string.substring(n3, n5));
                            n2 = 7;
                            n3 = n5 + 1;
                            break;
                        }
                    }
                }
                ++n5;
            }
            if (n - n3 > 0 && n2 == 7) {
                String string2 = string.substring(n - n3);
                n4 = string2.indexOf(58);
                if (n4 == -1) {
                    TimeZone timeZone;
                    if ("Z".equals(string2)) {
                        string2 = "UTC";
                    }
                    if ((timeZone = TimeZone.getTimeZone(string2)) == null) {
                        return null;
                    }
                    time.minutes += timeZone.getRawOffset();
                } else {
                    String string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    int n6 = Integer.parseInt(string3) * 60;
                    n6 = n6 < 0 ? (n6 -= Integer.parseInt(string4)) : (n6 += Integer.parseInt(string4));
                    time.minutes += n6;
                }
            }
            return time;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    TimeType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "time"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    static class Time
    implements Comparable {
        int minutes;
        float seconds;

        public int hashCode() {
            return this.minutes * 31 + new Float(this.seconds).hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Time) {
                Time time = (Time)object;
                boolean bl = false;
                if (time.minutes == this.minutes && time.seconds == this.seconds) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof Time) {
                Time time = (Time)object;
                if (time.minutes != this.minutes) {
                    return this.minutes - time.minutes;
                }
                if (time.seconds == this.seconds) {
                    return 0;
                }
                return this.seconds < time.seconds ? -1 : 1;
            }
            return 0;
        }

        Time() {
        }
    }
}

