/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import javax.sound.sampled.AudioFormat;
import org.tritonus.share.sampled.Encodings;

public class WaveTool {
    public static final int WAVE_RIFF_MAGIC = 1380533830;
    public static final int WAVE_WAVE_MAGIC = 1463899717;
    public static final int WAVE_FMT_MAGIC = 1718449184;
    public static final int WAVE_DATA_MAGIC = 1684108385;
    public static final int WAVE_FACT_MAGIC = 1717658484;
    public static final short WAVE_FORMAT_UNSPECIFIED = 0;
    public static final short WAVE_FORMAT_PCM = 1;
    public static final short WAVE_FORMAT_MS_ADPCM = 2;
    public static final short WAVE_FORMAT_ALAW = 6;
    public static final short WAVE_FORMAT_ULAW = 7;
    public static final short WAVE_FORMAT_IMA_ADPCM = 17;
    public static final short WAVE_FORMAT_G723_ADPCM = 20;
    public static final short WAVE_FORMAT_GSM610 = 49;
    public static final short WAVE_FORMAT_G721_ADPCM = 64;
    public static final short WAVE_FORMAT_MPEG = 80;
    public static final int MIN_FMT_CHUNK_LENGTH = 14;
    public static final int MIN_DATA_OFFSET = 42;
    public static final int MIN_FACT_CHUNK_LENGTH = 4;
    public static final int FMT_CHUNK_SIZE = 18;
    public static final int RIFF_CONTAINER_CHUNK_SIZE = 12;
    public static final int CHUNK_HEADER_SIZE = 8;
    public static final int DATA_OFFSET = 46;
    public static AudioFormat.Encoding GSM0610 = Encodings.getEncoding("GSM0610");
    public static AudioFormat.Encoding IMA_ADPCM = Encodings.getEncoding("IMA_ADPCM");

    public static short getFormatCode(AudioFormat audioFormat) {
        boolean bl;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int n = audioFormat.getSampleSizeInBits();
        boolean bl2 = audioFormat.isBigEndian() ^ true;
        boolean bl3 = false;
        if (audioFormat.getFrameSize() == -1 || audioFormat.getChannels() != -1 || audioFormat.getFrameSize() == n / 8 * audioFormat.getChannels()) {
            bl3 = bl = true;
        }
        if ((encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && bl2 && n > 8 || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) && n == 8) && bl) {
            return 1;
        }
        if (encoding.equals(AudioFormat.Encoding.ULAW) && (n == -1 || n == 8) && bl) {
            return 7;
        }
        if (encoding.equals(AudioFormat.Encoding.ALAW) && (n == -1 || n == 8) && bl) {
            return 6;
        }
        if (encoding.equals(Encodings.getEncoding("IMA_ADPCM")) && n == 4) {
            return 17;
        }
        if (encoding.equals(GSM0610)) {
            return 49;
        }
        return 0;
    }
}

