//@line 39 "/usr/ports/pobj/thunderbird-5.0/comm-miramar/mail/base/content/aboutDialog.js"

// Services = object with smart getters for common XPCOM services
Components.utils.import("resource://gre/modules/Services.jsm");
Components.utils.import("resource:///modules/iteratorUtils.jsm");

function init(aEvent)
{
  if (aEvent.target != document)
    return;

  try {
    var distroId = Services.prefs.getCharPref("distribution.id");
    if (distroId) {
      var distroVersion = Services.prefs.getCharPref("distribution.version");
      var distroAbout = Services.prefs.getComplexValue("distribution.about",
        Components.interfaces.nsISupportsString);

      var distroField = document.getElementById("distribution");
      distroField.value = distroAbout;
      distroField.style.display = "block";

      var distroIdField = document.getElementById("distributionId");
      distroIdField.value = distroId + " - " + distroVersion;
      distroIdField.style.display = "block";
    }
  }
  catch (e) {
    // Pref is unset
  }

  // XXX FIXME
  // Include the build ID if this is an "a#" (nightly or aurora) build
  let version = Services.appinfo.version;
  if (/a\d+(pre)?$/.test(version)) {
    let buildID = Services.appinfo.appBuildID;
    let buildDate = buildID.slice(0,4) + "-" + buildID.slice(4,6) + "-" + buildID.slice(6,8);
    document.getElementById("version").value += " (" + buildDate + ")";
  }

//@line 81 "/usr/ports/pobj/thunderbird-5.0/comm-miramar/mail/base/content/aboutDialog.js"

//@line 87 "/usr/ports/pobj/thunderbird-5.0/comm-miramar/mail/base/content/aboutDialog.js"
}

// This function is used to open about: tabs. The caller should ensure the url
// is only an about: url.
function openAboutTab(url)
{
  let tabmail;
  // Check existing windows
  let mailWindow = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                             .getService(Components.interfaces.nsIWindowMediator)
                             .getMostRecentWindow("mail:3pane");
  if (mailWindow) {
    mailWindow.focus();
    mailWindow.document.getElementById("tabmail")
              .openTab("contentTab", {contentPage: url,
                                      clickHandler: "specialTabs.aboutClickHandler(event);"});
    return;
  }

  // No existing windows.
  window.openDialog("chrome://messenger/content/", "_blank",
                    "chrome,dialog=no,all", null,
                    { tabType: "contentTab",
                      tabParams: {contentPage: url, clickHandler: "specialTabs.aboutClickHandler(event);"} });
}

function openUILink(url, event)
{
  if (!event.button) {
    Cc["@mozilla.org/uriloader/external-protocol-service;1"]
      .getService(Ci.nsIExternalProtocolService)
      .loadUri(Services.io.newURI(url, null, null));
    event.preventDefault();
  }
}

