#------------------------------------------------------------------------------
# File:         ko.pm
#
# Description:  ExifTool Korean language translations
#
# Notes:        This file generated automatically by Image::ExifTool::TagInfoXML
#------------------------------------------------------------------------------

package Image::ExifTool::Lang::ko;

use strict;
use vars qw($VERSION);

$VERSION = '1.04';

%Image::ExifTool::Lang::ko::Translate = (
   'AELock' => {
      Description => 'AE 고정',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AELockButton' => {
      Description => 'AE-L/AF-L',
      PrintConv => {
        'AE Lock (hold)' => 'AE 고정(유지)',
        'AE Lock Only' => 'AE 고정',
        'AE/AF Lock' => 'AE/AF 고정',
        'AF Lock Only' => 'AF 고정',
      },
    },
   'AF-CPrioritySelection' => {
      Description => 'AF-C 선택 우선',
      PrintConv => {
        'Focus' => '포커스',
        'Release' => '릴리즈',
        'Release + Focus' => '릴리즈 + 포커스',
      },
    },
   'AF-OnForMB-D10' => {
      Description => 'MB-D10에서 AF-On',
      PrintConv => {
        'AE Lock (hold)' => 'AE 고정 (유지)',
        'AE Lock (reset on release)' => 'AE 고정 (릴리즈때 리셋)',
        'AE Lock Only' => 'AE 고정',
        'AE/AF Lock' => 'AE/AF 고정',
        'AF Lock Only' => 'AF 고정',
        'AF-On' => 'AF-ON',
        'Same as FUNC Button' => 'FUNC 버튼과 같음',
      },
    },
   'AF-SPrioritySelection' => {
      Description => 'AF-S 선택 우선',
      PrintConv => {
        'Focus' => '포커스',
        'Release' => '릴리즈',
      },
    },
   'AFActivation' => {
      Description => 'AF 작동',
      PrintConv => {
        'AF-On Only' => 'AF-ON 고정',
        'Shutter/AF-On' => '셔터/AF-ON',
      },
    },
   'AFAperture' => 'AF 조리개',
   'AFAreaIllumination' => {
      Description => 'AF 포인트 조명',
      PrintConv => {
        'Auto' => '자동',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AFAreaMode' => {
      Description => 'AF 영역 모드',
      PrintConv => {
        'Auto-area' => '자동 영역 AF',
        'Dynamic Area' => '다이내믹 영역',
        'Dynamic Area (closest subject)' => '다이내믹 영역 (지근거리 우선)',
        'Dynamic Area (wide)' => '다이내믹 영역 (와이드)',
        'Group Dynamic' => '그룹 다이내믹',
        'Single Area' => '싱글 영역',
        'Single Area (wide)' => '싱글 영역 (와이드)',
      },
    },
   'AFAreaModeSetting' => {
      Description => 'AF 영역 모드',
      PrintConv => {
        'Closest Subject' => '접사',
        'Dynamic Area' => '다이내믹 영역',
        'Single Area' => '싱글 영역',
      },
    },
   'AFAssist' => {
      Description => '내장 AF 보조광',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AFFineTune' => 'AF 미세 조정',
   'AFFineTuneAdj' => 'AF 미세 조정',
   'AFInfo' => 'AF 모드',
   'AFInfo2' => 'AF 정보',
   'AFInfo2Version' => 'AF 정보 버전',
   'AFPoint' => {
      Description => 'AF 포인트',
      PrintConv => {
        'Bottom' => '하단',
        'Center' => '중앙',
        'Far Left' => '맨 좌측',
        'Far Right' => '맨 우측',
        'Left' => '왼쪽',
        'Lower-left' => '좌하단',
        'Lower-right' => '우하단',
        'Mid-left' => '왼쪽',
        'Mid-right' => '오른쪽',
        'Right' => '오른쪽',
        'Top' => '상단',
        'Upper-left' => '좌상단',
        'Upper-right' => '우상단',
      },
    },
   'AFPointIllumination' => {
      Description => 'AF 포인트 조명',
      PrintConv => {
        'Auto' => '자동',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AFPointMode' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'AFPointSelected' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'AFPointSelected2' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'AFPointSelection' => {
      Description => 'AF 포인트 선택',
      PrintConv => {
        '11 Points' => '11 포인트',
        '51 Points' => '51 포인트',
      },
    },
   'AFPointsInFocus' => {
      Description => '초점에서의 AF 포인트',
      PrintConv => {
        'Far Left' => '맨 좌측',
        'Far Right' => '맨 우측',
        'Lower-left' => '좌하단',
        'Lower-right' => '우하단',
        'Upper-left' => '좌상단',
        'Upper-right' => '우상단',
      },
    },
   'AFPointsUnknown2' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'AFPointsUsed' => {
      Description => '사용된 AF 포인트',
      PrintConv => {
        'Bottom' => '하단',
        'Center' => '중앙',
        'Far Left' => '맨 좌측',
        'Far Right' => '맨 우측',
        'Lower-left' => '좌하단',
        'Lower-right' => '우하단',
        'Top' => '상단',
        'Upper-left' => '좌상단',
        'Upper-right' => '우상단',
      },
    },
   'AFResponse' => 'AF 반응',
   'ActiveD-Lighting' => {
      Description => '액티브 D-Lighting',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ActiveD-LightingMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'AddAspectRatioInfo' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'AddOriginalDecisionData' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AdvancedRaw' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Album' => '앨범',
   'Anti-Blur' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'Aperture' => '조리개',
   'ApertureValue' => '조리개',
   'ApplicationRecordVersion' => '어플리케이션 기록 버전',
   'Artist' => '이미지를 만든 사람',
   'Author' => '작성자',
   'AuthorsPosition' => '직책',
   'AutoAperture' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AutoBracketModeM' => {
      Description => '자동 브라케팅 (모드 M)',
      PrintConv => {
        'Flash Only' => '플래시',
        'Flash/Aperture' => '플래시/조리개',
        'Flash/Speed' => '플래시/스피드',
        'Flash/Speed/Aperture' => '플래시/스피드/조리개',
      },
    },
   'AutoBracketOrder' => '브라케팅 순서',
   'AutoBracketSet' => {
      Description => '자동 브라케팅 설정',
      PrintConv => {
        'AE & Flash' => 'AE & 플래시',
        'AE Only' => 'AE 브라케팅',
        'Flash Only' => '플래시 브라케팅',
        'WB Bracketing' => 'WB 브라케팅',
      },
    },
   'AutoBracketing' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'AutoExposureBracketing' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AutoFP' => {
      Description => '자동 FP',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AutoFocus' => {
      Description => '오토포커스',
      PrintConv => {
        'Off' => '비활성',
        'On' => '활성',
      },
    },
   'AutoISO' => {
      Description => '자동 ISO',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AutoISOMax' => '자동 ISO 최대 감도',
   'AutoISOMinShutterSpeed' => '자동 ISO 최소 셔터 속도',
   'AutoLightingOptimizer' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'AutoRedEye' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'AuxiliaryLens' => '보조 렌즈',
   'BWMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'BatteryLevel' => '베터리 레벨',
   'BatteryOrder' => {
      Description => '배터리 순서',
      PrintConv => {
        'Camera Battery First' => '카메라 배터리 우선',
        'MB-D10 First' => 'MB-D10 배터리 우선',
      },
    },
   'Beep' => {
      Description => '전자음',
      PrintConv => {
        'High' => '크게',
        'Low' => '작게',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'BitsPerSample' => '성분에 따른 비트 수',
   'BracketMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'Brightness' => '밝기',
   'BrightnessValue' => '밝기',
   'BurstMode' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'By-line' => '제작자',
   'CFAPattern' => 'CFA 패턴',
   'CLModeShootingSpeed' => 'CL 모드 촬영 속도',
   'CanonExposureMode' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'CanonFlashMode' => {
      PrintConv => {
        'Auto' => '자동',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Caption-Abstract' => '제목/설명',
   'CaptionWriter' => '캡션 작성자',
   'Categories' => '범주',
   'Category' => '범주',
   'CenterAFArea' => {
      Description => '중앙 초점 영역',
      PrintConv => {
        'Normal Zone' => '일반 영역',
        'Wide Zone' => '와이드 영역',
      },
    },
   'CenterWeightedAreaSize' => '중앙 중점 영역',
   'ChrominanceNR_TIFF_JPEG' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'ChrominanceNoiseReduction' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'City' => '도시',
   'CalibrationIlluminant1' => {
      PrintConv => {
        'Cloudy' => '흐린 날씨',
        'Cool White Fluorescent' => '냉백색 형광등 (W 3800 - 4500K)',
        'Day White Fluorescent' => '주백색 형광등 (N 4600 - 5500K)',
        'Daylight' => '주광',
        'Daylight Fluorescent' => '주광색 형광등 (D 5700 - 7100K)',
        'Fine Weather' => '맑은 날씨',
        'Flash' => '플래시',
        'Fluorescent' => '형광등',
        'ISO Studio Tungsten' => 'ISO 스튜디오 텅스텐',
        'Other' => '기타 광원',
        'Shade' => '그늘',
        'Standard Light A' => '표준 광원 A',
        'Standard Light B' => '표준 광원 B',
        'Standard Light C' => '표준 광원 C',
        'Tungsten (Incandescent)' => '텅스텐 (백열등)',
        'Unknown' => '알 수 없음',
        'Warm White Fluorescent' => '따뜻한 흰색 형광 (L 2600 - 3250K)',
        'White Fluorescent' => '백색 형광등 (WW 3250 - 3800K)',
      },
    },
   'CalibrationIlluminant2' => {
      PrintConv => {
        'Cloudy' => '흐린 날씨',
        'Cool White Fluorescent' => '냉백색 형광등 (W 3800 - 4500K)',
        'Day White Fluorescent' => '주백색 형광등 (N 4600 - 5500K)',
        'Daylight' => '주광',
        'Daylight Fluorescent' => '주광색 형광등 (D 5700 - 7100K)',
        'Fine Weather' => '맑은 날씨',
        'Flash' => '플래시',
        'Fluorescent' => '형광등',
        'ISO Studio Tungsten' => 'ISO 스튜디오 텅스텐',
        'Other' => '기타 광원',
        'Shade' => '그늘',
        'Standard Light A' => '표준 광원 A',
        'Standard Light B' => '표준 광원 B',
        'Standard Light C' => '표준 광원 C',
        'Tungsten (Incandescent)' => '텅스텐 (백열등)',
        'Unknown' => '알 수 없음',
        'Warm White Fluorescent' => '따뜻한 흰색 형광 (L 2600 - 3250K)',
        'White Fluorescent' => '백색 형광등 (WW 3250 - 3800K)',
      },
    },
   'CodedCharacterSet' => '코드된 캐릭터 세트',
   'ColorAberrationControl' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ColorBalance' => '컬러 밸런스',
   'ColorBalanceAdj' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ColorBooster' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ColorEffect' => {
      PrintConv => {
        'Off' => '꺼짐',
        'Sepia' => '세피아',
      },
    },
   'ColorFilter' => {
      Description => '색 필터',
      PrintConv => {
        'Green' => '녹색',
        'Off' => '꺼짐',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'ColorHue' => '색상 형식',
   'ColorMode' => {
      Description => '컬러 모드',
      PrintConv => {
        'Autumn Leaves' => '단풍',
        'B&W' => '흑백',
        'Clear' => '반투명',
        'Deep' => '진한',
        'Landscape' => '풍경',
        'Light' => '라이트',
        'Neutral' => '뉴트럴',
        'Night View' => '야경',
        'Night View/Portrait' => '야경 인물',
        'Off' => '꺼짐',
        'Portrait' => '인물',
        'Standard' => '표준',
        'Sunset' => '일몰',
        'Vivid' => '생생한',
      },
    },
   'ColorMoireReduction' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ColorMoireReductionMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'ColorSpace' => {
      Description => '색공간',
      PrintConv => {
        'ICC Profile' => 'ICC 프로필',
        'Uncalibrated' => '조정되지 않음',
      },
    },
   'ColorTemperature' => '색 온도',
   'CommandDials' => {
      Description => '커맨드 다이얼',
      PrintConv => {
        'Reversed (Main Aperture, Sub Shutter)' => '역방향',
        'Standard (Main Shutter, Sub Aperture)' => '기본',
      },
    },
   'CommandDialsApertureSetting' => {
      Description => '커맨드 다이얼 수정 조리개 설정',
      PrintConv => {
        'Aperture Ring' => '조리개 링',
        'Sub-command Dial' => '서브 커맨드 다이얼',
      },
    },
   'CommandDialsChangeMainSub' => {
      Description => '커맨드 다이얼 수정 매인/서브 교체',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'CommandDialsMenuAndPlayback' => {
      Description => '커맨드 다이얼 수정 매뉴와 재생',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'CommandDialsReverseRotation' => {
      Description => '커맨드 다이얼 수정 방향 전환',
      PrintConv => {
        'No' => '아니오',
        'Yes' => '예',
      },
    },
   'CommanderChannel' => '커맨드모드 채널',
   'CommanderGroupAManualOutput' => '커맨드모드 그룹 A M Comp',
   'CommanderGroupAMode' => {
      Description => '커맨드모드 그룹 A 모드',
      PrintConv => {
        'Auto Aperture' => '자동 조리개 (AA)',
        'Manual' => '수동',
        'Off' => '꺼짐',
      },
    },
   'CommanderGroupA_TTL-AAComp' => '커맨드모드 그룹 A TTL/AA Comp',
   'CommanderGroupBManualOutput' => '커맨드모드 그룹 B M Comp',
   'CommanderGroupBMode' => {
      Description => '커맨드모드 그룹 B 모드',
      PrintConv => {
        'Auto Aperture' => '자동 조리개 (AA)',
        'Manual' => '수동',
        'Off' => '꺼짐',
      },
    },
   'CommanderGroupB_TTL-AAComp' => '커맨드모드 그룹 B TTL/AA Comp',
   'CommanderInternalFlash' => {
      Description => '커맨드모드 내장 플래시 모드',
      PrintConv => {
        'Manual' => '수동',
        'Off' => '꺼짐',
      },
    },
   'CommanderInternalManualOutput' => '커맨드모드 내장플래시 M Comp.',
   'CommanderInternalTTLComp' => '커맨드모드 내장플래시 TTL Comp',
   'Comment' => '코멘트',
   'ComponentsConfiguration' => '각 구성 요소의 의미',
   'CompressedBitsPerPixel' => '이미지 압축 모드',
   'Compression' => {
      Description => '압축 설계',
      PrintConv => {
        'JPEG' => 'JPEG 압축',
        'JPEG (old-style)' => 'JPEG (예전 스타일)',
        'Kodak DCR Compressed' => 'Kodak DCR 압축',
        'Kodak KDC Compressed' => 'Kodak KDC 압축',
        'Next' => 'NeXT 2-bit 인코딩',
        'Nikon NEF Compressed' => 'Nikon NEF 압축',
        'Pentax PEF Compressed' => 'Pentax PEF 압축',
        'SGILog' => 'SGI 32-bit Log 휘도 인코딩',
        'SGILog24' => 'SGI 24-bit Log 휘도 인코딩',
        'Sony ARW Compressed' => 'Sony ARW 압축',
        'Thunderscan' => 'ThunderScan 4-bit 인코딩',
        'Uncompressed' => '무압축',
      },
    },
   'Contact' => '연락처',
   'Contrast' => {
      Description => '대비',
      PrintConv => {
        'High' => '강하게',
        'Low' => '약하게',
        'Normal' => '표준',
      },
    },
   'ContrastCurve' => '대비 커브',
   'ConversionLens' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'Copyright' => '저작권 소유자',
   'CopyrightNotice' => '저작권 공고',
   'Country' => '국명',
   'Country-PrimaryLocationName' => '국가',
   'CreateDate' => '디지털 데이터 생성 일시',
   'CreationDate' => '촬영 날짜',
   'Credit' => '정보',
   'Curves' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'CustomRendered' => {
      Description => '사용자 이미지 처리',
      PrintConv => {
        'Custom' => '사용자 처리',
        'Normal' => '표준 처리',
      },
    },
   'D-LightingHQ' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'D-LightingHS' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'DataDump' => '데이터 덤프',
   'DateCreated' => '만들어진 날짜',
   'DateDisplayFormat' => {
      Description => '날짜 형식',
      PrintConv => {
        'D/M/Y' => '일/월/년',
        'M/D/Y' => '월/일/년',
        'Y/M/D' => '년/월/일',
      },
    },
   'DateStampMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'DateTimeOriginal' => '원본 데이터 생성 일시',
   'DaylightSavings' => {
      Description => '일광 시간 절약',
      PrintConv => {
        'No' => '꺼짐',
        'Yes' => '켜짐',
      },
    },
   'DeletedImageCount' => '삭제된 이미지 카운트',
   'DeviceSettingDescription' => '장비 설정 설명',
   'DigitalZoom' => {
      Description => '디지털 줌',
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'DigitalZoomRatio' => '디지털 줌 비율',
   'Directory' => '파일위치',
   'DirectoryNumber' => '디렉토리 숫자',
   'DistortionCorrection' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'DistortionCorrection2' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'DriveMode' => {
      Description => '드라이브 모드',
      PrintConv => {
        'Multiple Exposure' => '다중 노출',
        'Off' => '꺼짐',
      },
    },
   'DynamicAFArea' => {
      Description => '다이내믹 AF 영역',
      PrintConv => {
        '21 Points' => '21 포인트',
        '51 Points' => '51 포인트',
        '51 Points (3D-tracking)' => '51포인트 (3D-트래킹)',
        '9 Points' => '9 포인트',
      },
    },
   'DynamicRangeExpansion' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'DynamicRangeOptimizer' => {
      Description => 'D-레인지 최적화',
      PrintConv => {
        'Advanced Auto' => '고급 자동',
        'Advanced Lv1' => '고급 레벨1',
        'Advanced Lv2' => '고급 레벨2',
        'Advanced Lv3' => '고급 레벨3',
        'Advanced Lv4' => '고급 레벨4',
        'Advanced Lv5' => '고급 레벨5',
        'Auto' => '자동',
        'Off' => '꺼짐',
        'Standard' => '표준',
      },
    },
   'EVStepSize' => {
      Description => '노출 설정 간격',
      PrintConv => {
        '1/2 EV' => '1/2 스텝',
        '1/3 EV' => '1/3 스텝',
      },
    },
   'EasyExposureCompensation' => {
      Description => '쉬운 노출 보정',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
        'On (auto reset)' => '켜짐 (자동 리셋)',
      },
    },
   'EasyMode' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'EdgeNoiseReduction' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'EffectiveMaxAperture' => '유효 최대 조리개',
   'EnhanceDarkTones' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Enhancement' => {
      PrintConv => {
        'Green' => '녹색',
        'Off' => '꺼짐',
        'Red' => '빨강',
      },
    },
   'EnvelopeRecordVersion' => '압축 기록 버전',
   'ExifImageHeight' => '이미지 높이',
   'ExifImageWidth' => '이미지 넓이',
   'ExifOffset' => 'Exif IFD Pointer',
   'ExifVersion' => 'Exif 버전',
   'ExitPupilPosition' => '출구공 위치',
   'ExposureBracketValue' => '노출 브라케팅 값',
   'ExposureCompStepSize' => '노출보정/미세조정',
   'ExposureCompensation' => '노출 보정',
   'ExposureControlStepSize' => '노출 조정 EV 스텝',
   'ExposureDelayMode' => {
      Description => '노출 대기 모드',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ExposureDifference' => '노출 보정',
   'ExposureIndex' => '노출 인덱스',
   'ExposureMode' => {
      Description => '노출 모드',
      PrintConv => {
        'Auto' => '자동 노출',
        'Auto bracket' => '오토 브라케스팅',
        'Manual' => '수동 노출',
      },
    },
   'ExposureProgram' => {
      Description => '노출 프로그램',
      PrintConv => {
        'Action (High speed)' => '스포츠 모드 (빠른 셔터 스피드에 편향됨)',
        'Aperture-priority AE' => '조리개 우선',
        'Bulb' => '벌브',
        'Creative (Slow speed)' => '독창적 프로그램 (피사계심도에 편향됨)',
        'Landscape' => '풍경 모드 (배경의 인포커스가 있는 풍경 사진)',
        'Manual' => '수동',
        'Not Defined' => '정의되지 않음',
        'Portrait' => '인물 모드 (배경의 아웃포커스가 있는 근접 사진)',
        'Program AE' => '보통 프로그램',
        'Shutter speed priority AE' => '셔터 우선',
      },
    },
   'ExposureTime' => '노출 시간',
   'ExtendedWBDetect' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ExternalFlash' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ExternalFlashFlags' => '외장 플래시 플래그',
   'ExternalFlashMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'FNumber' => 'F 숫자',
   'FileFormat' => '형식',
   'FileInfo' => '파일 정보',
   'FileInfoVersion' => '파일 정보 버전',
   'FileModifyDate' => '갱신 일자',
   'FileName' => '파일명',
   'FileNumber' => '파일 숫자',
   'FileNumberMemory' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'FileNumberSequence' => {
      Description => '파일명 연속 번호',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'FileSize' => '파일크기',
   'FileSource' => {
      Description => '파일 출처',
      PrintConv => {
        'Digital Camera' => '디지털 카메라',
        'Film Scanner' => '필름 스캐너',
        'Reflection Print Scanner' => '반사 프린트 스캐너',
      },
    },
   'FileType' => '파일형식',
   'FilmType' => '필름 형식',
   'Filter' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'FilterEffect' => {
      Description => '필터 효과',
      PrintConv => {
        'Green' => '녹색',
        'Off' => '꺼짐',
        'Orange' => '주황',
        'Red' => '빨강',
        'Yellow' => '노랑',
        'n/a' => '설정 안됨',
      },
    },
   'FilterEffectMonochrome' => {
      PrintConv => {
        'Green' => '녹색',
        'Orange' => '주황',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'FinderDisplayDuringExposure' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'FineTuneOptCenterWeighted' => '최적 노출 조정 중앙 중점',
   'FineTuneOptMatrixMetering' => '최적 노출 조정 평가 측광',
   'FineTuneOptSpotMetering' => '최적 노출 조정 스팟',
   'Flash' => {
      Description => '플래시',
      PrintConv => {
        'Auto, Did not fire' => '플래시 발광 안됨, 자동모드',
        'Auto, Did not fire, Red-eye reduction' => '자동, 발광안됨, 적목감소',
        'Auto, Fired' => '플래시 발광, 자동모드',
        'Auto, Fired, Red-eye reduction' => '플래시 발광, 자동모드, 적목감소모드',
        'Auto, Fired, Red-eye reduction, Return detected' => '플래시 발광, 자동모드, 복귀광 감지됨, 적목감소모드',
        'Auto, Fired, Red-eye reduction, Return not detected' => '플래시 발광, 자동모드, 복귀광 감지안됨, 적목감소모드',
        'Auto, Fired, Return detected' => '플래시 발광, 자동모드, 복귀광 감지됨',
        'Auto, Fired, Return not detected' => '플래시 발광, 자동모드, 복귀광 감지 안됨',
        'Did not fire' => '플래시가 점등하지 않았습니다',
        'Fired' => '플래시 발광',
        'Fired, Red-eye reduction' => '플래시 발광, 적목감소모드',
        'Fired, Red-eye reduction, Return detected' => '플래시 발광, 적목감소모드, 복귀광 감지됨',
        'Fired, Red-eye reduction, Return not detected' => '플래시 발광, 적목감소모드, 복귀광 감지 안됨',
        'Fired, Return detected' => '스트로브 복귀광 감지됨',
        'Fired, Return not detected' => '스트로브 복귀광 감지 안됨',
        'No Flash' => '플래시 발광 안됨',
        'No flash function' => '플래시 작동 없음',
        'Off, Did not fire' => '플래시 발광 안됨, 강제발광모드',
        'Off, Did not fire, Return not detected' => '꺼짐, 발광 안됨, 복귀광 감지 안됨',
        'Off, No flash function' => '꺼짐, 플래시 작동 없음',
        'Off, Red-eye reduction' => '꺼짐, 적목감소',
        'On, Did not fire' => '켜짐, 플래시 발광 안됨',
        'On, Fired' => '플래시 발광, 강제발광모드',
        'On, Red-eye reduction' => '플래시 발광, 강제발광모드, 적목감소모드',
        'On, Red-eye reduction, Return detected' => '플래시 발광, 강제발광모드, 적목감소모드, 복귀광 감지됨',
        'On, Red-eye reduction, Return not detected' => '플래시 발광, 강제발광모드, 적목감소모드, 복귀광 감지 안됨',
        'On, Return detected' => '플래시 발광, 강제발광모드, 복귀광 감지됨',
        'On, Return not detected' => '플래시 발광, 강제발광모드, 복귀광 감지 안됨',
      },
    },
   'FlashCommanderMode' => {
      Description => '커맨더 모드',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'FlashCompensation' => '플래시 보정',
   'FlashControlMode' => {
      Description => '플래시 컨트롤 모드',
      PrintConv => {
        'Auto Aperture' => '자동 조리개 (AA)',
        'Manual' => '수동',
        'Off' => '꺼짐',
        'Repeating Flash' => '리피팅 플래시',
      },
    },
   'FlashEnergy' => '플래시 에너지',
   'FlashExposureBracketValue' => '플래시 노출 브라케팅 값',
   'FlashExposureComp' => '플래시 노출 보정',
   'FlashExposureLock' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'FlashFired' => '플래시 발광됨',
   'FlashFocalLength' => '플래시 초점 길이',
   'FlashGroupACompensation' => '그룹 A 플래시 보정',
   'FlashGroupAControlMode' => {
      Description => '그룹 A 플래시 모드',
      PrintConv => {
        'Auto Aperture' => '자동 조리개 (AA)',
        'Manual' => '수동',
        'Off' => '꺼짐',
        'Repeating Flash' => '리피팅 플래시',
      },
    },
   'FlashGroupAOutput' => '그룹 A 플래시 출력',
   'FlashGroupBCompensation' => '그룹 B 플래시 보정',
   'FlashGroupBControlMode' => {
      Description => '그룹 B 플래시 모드',
      PrintConv => {
        'Auto Aperture' => '자동 조리개 (AA)',
        'Manual' => '수동',
        'Off' => '꺼짐',
        'Repeating Flash' => '리피팅 플래시',
      },
    },
   'FlashGroupBOutput' => '그룹 B 플래시 출력',
   'FlashGroupCCompensation' => '그룹 C 플래시 보정',
   'FlashGroupCControlMode' => {
      Description => '그룹 C 플래시 컨트롤 모드',
      PrintConv => {
        'Auto Aperture' => '자동 조리개 (AA)',
        'Manual' => '수동',
        'Off' => '꺼짐',
        'Repeating Flash' => '리피팅 플래시',
      },
    },
   'FlashGroupCOutput' => '그룹 C 플래시 출력',
   'FlashInfoVersion' => '플래시 정보 버전',
   'FlashLevel' => '플래시 보정',
   'FlashMode' => {
      Description => '플래시 모드',
      PrintConv => {
        'Did Not Fire' => '발광 안됨',
        'Fired, Commander Mode' => '발광됨, 커맨더 모드',
        'Fired, External' => '발광됨, 외장',
        'Fired, Manual' => '발광됨, 수동',
        'Fired, TTL Mode' => '발광됨, TTL 모드',
      },
    },
   'FlashModel' => '플래시 모델',
   'FlashOptions' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'FlashOptions2' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'FlashOutput' => '플래시 출력',
   'FlashSetting' => '플래시 설정',
   'FlashShutterSpeed' => '플래시 셔터 스피드',
   'FlashStatus' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'FlashSyncSpeed' => '플래시 동조 속도',
   'FlashSyncSpeedAv' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'FlashType' => '플래시 형식',
   'FlashWarning' => {
      Description => '플래시 경고',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'FlashpixVersion' => '지원되는 Flashpix 버전',
   'FocalLength' => '초점 길이',
   'FocalLength35efl' => '초점거리 (35mm 변환)',
   'FocalLengthIn35mmFormat' => '35 mm 필름 환산 초점길이',
   'FocalPlaneResolutionUnit' => {
      Description => '초점면 해상도 단위',
      PrintConv => {
        'None' => '없음',
        'inches' => '인치',
        'um' => 'µm (마이크로미터)',
      },
    },
   'FocalPlaneXResolution' => '수평 해상도 초점면',
   'FocalPlaneYResolution' => '수직 해상도 초점면',
   'Focus' => {
      Description => '포커스',
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'FocusArea' => 'AF 포인트 순환',
   'FocusAreaSelection' => {
      Description => 'AF 포인트 순환',
      PrintConv => {
        'No Wrap' => '꺼짐',
        'Wrap' => '켜짐',
      },
    },
   'FocusContinuous' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'FocusDistance' => '초점 거리',
   'FocusMode' => {
      Description => '초점모드',
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'FocusMode2' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'FocusModeSetting' => {
      Description => '초점 모드',
      PrintConv => {
        'AF-A' => '자동 AF 서보',
        'AF-C' => '컨티뉴어스 AF 서보',
        'AF-S' => '싱글 AF 서보',
        'Manual' => '수동',
      },
    },
   'FocusPointWrap' => {
      Description => '초점 포인트 순환',
      PrintConv => {
        'No Wrap' => '순환 안함',
        'Wrap' => '순환',
      },
    },
   'FocusPosition' => '초점 위치',
   'FocusRange' => {
      PrintConv => {
        'Auto' => '자동',
        'Manual' => '수동',
      },
    },
   'FocusTrackingLockOn' => {
      Description => '초점 트래킹 Lock-On',
      PrintConv => {
        'Long' => '길게',
        'Normal' => '표준',
        'Off' => '꺼짐',
        'Short' => '짧게',
      },
    },
   'FrameRate' => '프레임 비율',
   'FrameSize' => '프레임 크기',
   'FujiFlashMode' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'FunctionButton' => {
      Description => '펑션 버튼',
      PrintConv => {
        'AF-area Mode' => 'AF 영역 모드 설정',
        'Center AF Area' => '중앙 초점 영역',
        'Center-weighted' => '중앙부 중점 측광',
        'FV Lock' => 'FV 고정',
        'Flash Off' => '플래시 OFF',
        'Framing Grid' => '격자선 표시',
        'ISO Display' => 'ISO 표시',
        'Matrix Metering' => '멀티 패턴 측광',
        'Spot Metering' => '스팟 측광',
      },
    },
   'GPSAltitude' => '고도',
   'GPSAltitudeRef' => {
      Description => '고도 참조',
      PrintConv => {
        'Above Sea Level' => '해면',
        'Below Sea Level' => '해면 참조(음수 값)',
      },
    },
   'GPSAreaInformation' => 'GPS 영역 이름',
   'GPSDOP' => '측정 정밀도',
   'GPSDateStamp' => 'GPS 날짜',
   'GPSDestBearing' => '목적지의 방위',
   'GPSDestBearingRef' => '목적지 방위의 기준',
   'GPSDestDistance' => '목적지까지의 거리',
   'GPSDestDistanceRef' => '목적지까지의 거리 단위',
   'GPSDestLatitude' => '목적지의 위도',
   'GPSDestLatitudeRef' => '목적지 위도의 기준',
   'GPSDestLongitude' => '목적지의 경도',
   'GPSDestLongitudeRef' => '목적지 경도의 기준',
   'GPSDifferential' => {
      Description => 'GPS 편차 보정',
      PrintConv => {
        'Differential Corrected' => '편차 보정 적용',
        'No Correction' => '편차 보정 없이 측정',
      },
    },
   'GPSImgDirection' => '이미지 방향',
   'GPSImgDirectionRef' => '이미지 방향의 기준',
   'GPSInfo' => 'GPS Info IFD Pointer',
   'GPSLatitude' => '위도',
   'GPSLatitudeRef' => {
      Description => '북위 또는 남위',
      PrintConv => {
        'North' => '북위',
        'South' => '남위',
      },
    },
   'GPSLongitude' => '경도',
   'GPSLongitudeRef' => {
      Description => '동경 또는 서경',
      PrintConv => {
        'East' => '동경',
        'West' => '서경',
      },
    },
   'GPSMapDatum' => '사용된 측지 데이터',
   'GPSMeasureMode' => {
      Description => 'GPS 측정 모드',
      PrintConv => {
        '3-Dimensional Measurement' => '3차원 측정',
      },
    },
   'GPSProcessingMethod' => 'GPS 처리 방식 이름',
   'GPSSatellites' => '측정에 사용된 GPS 위성',
   'GPSSpeed' => 'GPS 수신기 속도',
   'GPSSpeedRef' => {
      Description => '속도 단위',
      PrintConv => {
        'km/h' => '시간당 킬로미터',
        'knots' => '노트',
        'mph' => '시간당 마일',
      },
    },
   'GPSStatus' => {
      Description => 'GPS 수신기 상태',
      PrintConv => {
        'Measurement Active' => '진행 중인 측정',
        'Measurement Void' => '측정 상호 운용성',
      },
    },
   'GPSTimeStamp' => 'GPS 시간(원자 시계)',
   'GPSTrack' => '이동 방향',
   'GPSTrackRef' => {
      Description => '이동 방향의 기준',
      PrintConv => {
        'Magnetic North' => '자기 방향',
        'True North' => '실제 방향',
      },
    },
   'GPSVersionID' => 'GPS 태그 버전',
   'GainControl' => {
      Description => '이득 제어',
      PrintConv => {
        'High gain down' => '높은 이득 감소',
        'High gain up' => '높은 이득 증가',
        'Low gain down' => '적은 이득 감소',
        'Low gain up' => '적은 이득 증가',
        'None' => '없음',
      },
    },
   'Gamma' => '감마',
   'Gradation' => '계조',
   'GridDisplay' => {
      Description => '격자 표시',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'HDR' => {
      Description => '자동 HDR',
      PrintConv => {
        'Off' => '없음',
      },
    },
   'Headline' => '헤드라인',
   'HighISONoiseReduction' => {
      Description => '고ISO에서 노이즈제거',
      PrintConv => {
        'Auto' => '자동',
        'High' => '강함',
        'Low' => '약함',
        'Minimal' => '최소',
        'Normal' => '표준',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'HighlightTonePriority' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Hue' => '색상',
   'HueAdjustment' => '색조',
   'ISO' => 'ISO 속도',
   'ISODisplay' => 'ISO 표시',
   'ISOExpansion' => {
      Description => 'ISO 확장',
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'ISOExpansion2' => {
      Description => 'ISO 확장 (2)',
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'ISOInfo' => 'ISO 정보',
   'ISOSelection' => 'ISO 선택',
   'ISOSetting' => {
      Description => 'ISO 설정',
      PrintConv => {
        'Auto' => '자동',
        'Manual' => '수동',
      },
    },
   'ISOStepSize' => 'ISO 감도 스텝 수치',
   'Illumination' => {
      Description => '조명',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ImageAdjustment' => '이미지 조정',
   'ImageAuthentication' => {
      Description => '이미지 인증',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ImageBoundary' => '이미지 경계',
   'ImageCount' => '이미지 카운트',
   'ImageDataSize' => '이미지 데이터 크기',
   'ImageDustOff' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ImageHeight' => '이미지 높이',
   'ImageHistory' => '이미지 이력',
   'ImageNumber' => '이미지 숫자',
   'ImageOptimization' => '이미지 최적화',
   'ImageProcessing' => '이미지 처리',
   'ImageQuality' => '이미지 화질',
   'ImageReview' => {
      Description => '이미지 미리보기',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ImageReviewTime' => '이미지 재생 시간',
   'ImageSize' => '이미지 크기',
   'ImageStabilization' => {
      Description => '손떨림 보정',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ImageUniqueID' => '고유 이미지 ID',
   'ImageWidth' => '이미지 넓이',
   'Index' => '색인',
   'InitialZoomSetting' => {
      Description => '이니셜 줌 설정',
      PrintConv => {
        'High Magnification' => '큰 확대',
        'Low Magnification' => '작은 확대',
        'Medium Magnification' => '중간 확대',
      },
    },
   'Instructions' => '안내',
   'IntensityStereo' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'InternalFlash' => {
      Description => '내장플래시 컨트롤',
      PrintConv => {
        'Commander Mode' => '커맨더 모드',
        'Manual' => '수동',
        'Off' => '꺼짐',
        'On' => '켜짐',
        'Repeating Flash' => '리피팅 플래시',
      },
    },
   'InternalFlashMode' => {
      PrintConv => {
        'On' => '켜짐',
      },
    },
   'InteropIndex' => '상호운용성 증명',
   'InteropOffset' => '상호 운용성 태그',
   'InteropVersion' => '상호 운용성 버전',
   'Keyword' => '키워드',
   'Keywords' => '키워드',
   'LCDIllumination' => {
      Description => 'LCD 조명',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'LCDIlluminationDuringBulb' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'LCHEditor' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Lens' => '렌즈',
   'LensDataVersion' => '렌즈 데이터 버전',
   'LensFStops' => '렌즈 F-숫자',
   'LensID' => '사용된 렌즈',
   'LensIDNumber' => '렌즈 ID 숫자',
   'LensInfo' => '렌즈 정보',
   'LensType' => '렌즈 형식',
   'LightSource' => {
      Description => '광원 종류',
      PrintConv => {
        'Cloudy' => '흐린 날씨',
        'Cool White Fluorescent' => '냉백색 형광등 (W 3800 - 4500K)',
        'Day White Fluorescent' => '주백색 형광등 (N 4600 - 5500K)',
        'Daylight' => '주광',
        'Daylight Fluorescent' => '주광색 형광등 (D 5700 - 7100K)',
        'Fine Weather' => '맑은 날씨',
        'Flash' => '플래시',
        'Fluorescent' => '형광등',
        'ISO Studio Tungsten' => 'ISO 스튜디오 텅스텐',
        'Other' => '기타 광원',
        'Shade' => '그늘',
        'Standard Light A' => '표준 광원 A',
        'Standard Light B' => '표준 광원 B',
        'Standard Light C' => '표준 광원 C',
        'Tungsten (Incandescent)' => '텅스텐 (백열등)',
        'Unknown' => '알 수 없음',
        'Warm White Fluorescent' => '따뜻한 흰색 형광 (L 2600 - 3250K)',
        'White Fluorescent' => '백색 형광등 (WW 3250 - 3800K)',
      },
    },
   'Lightness' => '명도',
   'LinearizationTable' => '선형도표',
   'LiveViewShooting' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Location' => '위치',
   'LongExposureNoiseReduction' => {
      Description => '장시간 노출 NR',
      PrintConv => {
        'Auto' => '자동',
        'Off' => '없음',
        'On' => '있음',
      },
    },
   'LuminanceNoiseReduction' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'MB-D10Batteries' => 'MB-D10 배터리 형식',
   'MB-D80Batteries' => {
      Description => 'MB-D80 배터리',
      PrintConv => {
        'FR6 (AA Lithium)' => 'FR6 (AA 리튬)',
        'LR6 (AA Alkaline)' => 'LR6 (AA 알카라인)',
      },
    },
   'MCUVersion' => 'MCU 버전',
   'MSStereo' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Macro' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'MacroMode' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'MainDialExposureComp' => {
      Description => '노출 보정',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Make' => '메이커',
   'MakerNote' => '제조사 노트',
   'MakerNoteVersion' => '제조사노트 버전',
   'MakerNotes' => '제조업체 정보',
   'ManualFlashOutput' => '내장 플래시 수동 출력',
   'ManualFocusDistance' => '수동 초점 거리',
   'MaxAperture' => '최대 렌즈 조리개',
   'MaxApertureAtMaxFocal' => '최대 초점길이에서 최대 조리개',
   'MaxApertureAtMinFocal' => '최소 초점길이에서 최대 조리개',
   'MaxApertureValue' => '최대 렌즈 조리개',
   'MaxContinuousRelease' => '최대 연사 릴리즈',
   'MaxFocalLength' => '최대 초점길이',
   'Metering' => {
      Description => '측광',
      PrintConv => {
        'Center-weighted' => '중앙부 중점',
        'Matrix' => '멀티패턴',
        'Spot' => '스팟',
      },
    },
   'MeteringMode' => {
      Description => '측광 모드',
      PrintConv => {
        'Average' => '평균',
        'Center-weighted average' => '중앙중점 평균',
        'Multi-segment' => '멀티 패턴',
        'Multi-spot' => '멀티 스팟',
        'Other' => '기타',
        'Partial' => '부분',
        'Spot' => '스팟',
        'Unknown' => '알 수 없음',
      },
    },
   'MeteringTime' => {
      Description => '자동 측광 꺼짐 시간',
      PrintConv => {
        'No Limit' => '무제한',
      },
    },
   'MinFocalLength' => '최소 초점길이',
   'Model' => '카메라 모델',
   'ModelingFlash' => {
      Description => '최대',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ModifiedSaturation' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'ModifiedToneCurve' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'ModifiedWhiteBalance' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'ModifyDate' => '파일 변경 날짜 및 시간',
   'MoireFilter' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'MonitorOffTime' => '모니터 꺼짐 시간',
   'MonochromeFilterEffect' => {
      PrintConv => {
        'Green' => '녹색',
        'Orange' => '주황',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'MonochromeToningEffect' => {
      PrintConv => {
        'Green' => '녹색',
      },
    },
   'MultiExposure' => '다중 노출 데이터',
   'MultiExposureAutoGain' => {
      Description => '다중 노출 자동 게인',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'MultiExposureMode' => {
      Description => '다중노출 모드',
      PrintConv => {
        'Image Overlay' => '이미지 오버레이',
        'Multiple Exposure' => '다중 노출',
        'Off' => '꺼짐',
      },
    },
   'MultiExposureShots' => '다중 노출 촬영',
   'MultiExposureVersion' => '다중 노출 데이터 버전',
   'MultiFrameNoiseReduction' => {
      Description => '다중 프레임 노이즈 감쇄',
      PrintConv => {
        'Off' => '없음',
        'On' => '있음',
      },
    },
   'MultiSelector' => {
      Description => '멀티셀렉터',
      PrintConv => {
        'Do Nothing' => '아무것도 안함',
        'Reset Meter-off Delay' => '노출계 꺼짐 시간 초기화',
      },
    },
   'MultiSelectorPlaybackMode' => {
      Description => '멀티셀렉터 재생 모드',
      PrintConv => {
        'Choose Folder' => '폴더 선택',
        'Thumbnail On/Off' => '섬네일 on/off',
        'View Histograms' => '히스토그램 표시',
        'Zoom On/Off' => '줌 on/off',
      },
    },
   'MultiSelectorShootMode' => {
      Description => '멀티셀렉터 촬영 모드',
      PrintConv => {
        'Highlight Active Focus Point' => '활성 초점 포인트 하이라이트',
        'Not Used' => '사용 안됨',
        'Select Center Focus Point' => '중앙 초점 포인트 선택',
      },
    },
   'MultipleExposureSet' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Mute' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'MyColorMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'NDFilter' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'NEFCompression' => {
      Description => 'RAW 압축',
      PrintConv => {
        'Lossless' => '손실 없음',
        'Lossy (type 1)' => '손실됨 (타입 1)',
        'Lossy (type 2)' => '손실됨 (타입 2)',
        'Uncompressed' => '압축되지 않음',
      },
    },
   'NikonCaptureData' => 'Nikon Capture 데이터',
   'NikonCaptureVersion' => 'Nikon Capture 버전',
   'NikonImageSize' => {
      Description => '이미지 크기',
      PrintConv => {
        'Large (10.0 M)' => '큰 (10.0M)',
        'Medium (5.6 M)' => '중간 (5.6M)',
        'Small (2.5 M)' => '작은 (2.5M)',
      },
    },
   'NoMemoryCard' => {
      Description => '메모리카드 없을 경우',
      PrintConv => {
        'Enable Release' => '릴리즈 허용',
        'Release Locked' => '릴리즈 잠금',
      },
    },
   'Noise' => '노이즈',
   'NoiseFilter' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'NoiseReduction' => {
      Description => '노이즈 제거',
      PrintConv => {
        'Auto' => '자동',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'OneTouchWB' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'Opto-ElectricConvFactor' => '광전자 변환 계수',
   'Orientation' => {
      Description => '이미지 위치',
      PrintConv => {
        'Horizontal (normal)' => '0° (위쪽/좌측)',
        'Mirror horizontal' => '0° (위쪽/우측)',
        'Mirror horizontal and rotate 270 CW' => '90° 시계방향 (좌측/위쪽)',
        'Mirror horizontal and rotate 90 CW' => '90° 반시계방향 (우측/아래)',
        'Mirror vertical' => '180° (아래/좌측)',
        'Rotate 180' => '180° (아래/우측)',
        'Rotate 270 CW' => '90° 시계방향 (좌측/아래)',
        'Rotate 90 CW' => '90° 반시계방향 (우측/위쪽)',
      },
    },
   'PhaseDetectAF' => {
      Description => '오토포커스',
      PrintConv => {
        'Off' => '비활성',
        'On (51-point)' => '활성',
      },
    },
   'PhotoEffect' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'PhotoEffects' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'PhotoInfoPlayback' => {
      Description => '사진 정보/재생',
      PrintConv => {
        'Info Left-right, Playback Up-down' => '정보 <> / 재생',
        'Info Up-down, Playback Left-right' => '정보 / 재생 <>',
      },
    },
   'PhotometricInterpretation' => {
      Description => '픽셀 형식',
      PrintConv => {
        'BlackIsZero' => '블랙은 제로임',
        'RGB Palette' => '팔렛트 컬러',
        'Transparency Mask' => '투명 마스크',
        'WhiteIsZero' => '화이트는 제로임',
      },
    },
   'PictureControl' => {
      Description => '픽쳐컨트롤',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'PictureControlActive' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'PictureControlAdjust' => {
      Description => '픽쳐컨트롤 조정',
      PrintConv => {
        'Default Settings' => '기본 설정',
        'Full Control' => '전체 제어',
        'Quick Adjust' => '빠른 조정',
      },
    },
   'PictureControlBase' => '픽쳐컨트롤 기초',
   'PictureControlName' => '픽쳐컨트롤 이름',
   'PictureControlQuickAdjust' => '픽쳐컨트롤 빠른 조정',
   'PictureControlVersion' => '픽쳐컨트롤 버전',
   'PictureMode' => {
      PrintConv => {
        'Auto' => '자동',
        'Manual' => '수동',
      },
    },
   'PictureMode2' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'PictureModeBWFilter' => {
      PrintConv => {
        'Green' => '녹색',
        'Orange' => '주황',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'PictureModeTone' => {
      PrintConv => {
        'Green' => '녹색',
      },
    },
   'PlanarConfiguration' => {
      Description => '이미지 데이터 정렬',
      PrintConv => {
        'Chunky' => '청키 형식',
        'Planar' => '평면 형식',
      },
    },
   'PreviewIFD' => 'IFD 포인터 미리보기',
   'PrimaryAFPoint' => {
      PrintConv => {
        'Bottom' => '하단',
        'C6 (Center)' => 'C6 (중앙)',
        'Center' => '중앙',
        'Far Left' => '맨 좌측',
        'Far Right' => '맨 우측',
        'Lower-left' => '좌하단',
        'Lower-right' => '우하단',
        'Mid-left' => '왼쪽',
        'Mid-right' => '오른쪽',
        'Top' => '상단',
        'Upper-left' => '좌상단',
        'Upper-right' => '우상단',
      },
    },
   'PrimaryChromaticities' => '기본 색도',
   'ProgramShift' => '프로그램 쉬프트',
   'Province-State' => '도',
   'Quality' => {
      Description => '화질',
      PrintConv => {
        'Compressed RAW' => 'cRAW',
        'Compressed RAW + JPEG' => 'cRAW+JPEG',
        'Extra Fine' => '엑스트라 파인',
        'Fine' => '파인',
        'Low' => '저화질',
        'Normal' => '표준화질',
        'RAW + JPEG' => 'RAW+JPEG',
        'Standard' => '표준',
      },
    },
   'RawDevAutoGradation' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'RawDevPMPictureTone' => {
      PrintConv => {
        'Green' => '녹색',
      },
    },
   'RawDevPM_BWFilter' => {
      PrintConv => {
        'Green' => '녹색',
        'Orange' => '주황',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'RawImageCenter' => 'RAW 이미지 중앙',
   'RecordMode' => {
      Description => '이미지 화질 모드',
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'RecordingMode' => {
      PrintConv => {
        'Auto' => '자동',
        'Manual' => '수동',
      },
    },
   'RedEyeCorrection' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'RedEyeReduction' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ReferenceBlackWhite' => '흑백 참조 값의 쌍',
   'RelatedImageFileFormat' => '관련 이미지 파일 형식',
   'RelatedImageHeight' => '관련 이미지 길이',
   'RelatedImageWidth' => '관련 이미지 너비',
   'RelatedSoundFile' => '연관된 오디오 파일',
   'ReleaseButtonToUseDial' => {
      Description => '다이얼로 릴리즈 버튼 사용',
      PrintConv => {
        'No' => '아니오',
        'Yes' => '예',
      },
    },
   'RemoteOnDuration' => '리모컨 지속 시간',
   'RepeatingFlashCount' => '리피팅 플래시 시간',
   'RepeatingFlashOutput' => '리피팅 플래시 출력',
   'RepeatingFlashRate' => '리피팅 플래시  간격',
   'ResolutionUnit' => {
      Description => 'X 와 Y 해상도 단위',
      PrintConv => {
        'None' => '없음',
        'cm' => '센티미터',
        'inches' => '인치',
      },
    },
   'RetouchHistory' => {
      Description => '리터치 이력',
      PrintConv => {
        'B & W' => '흑백',
        'Color Custom' => '커스텀 컬러',
        'Cyanotype' => '청사진',
        'Image Overlay' => '이미지 오버레이',
        'None' => '없음',
        'Sepia' => '세피아',
        'Sky Light' => '스카이 라이트',
        'Small Picture' => '스몰',
        'Trim' => '트리밍',
        'Warm Tone' => '따뜻한 톤',
      },
    },
   'ReverseIndicators' => '인디케이터 전환',
   'Rotation' => {
      Description => '카메라 회전 방향',
      PrintConv => {
        'Horizontal' => '0° (수평)',
        'Rotated 180' => '180° (상하반전)',
        'Rotated 270 CW' => '90° 좌회전',
        'Rotated 90 CW' => '90° 우회전',
      },
    },
   'RowsPerStrip' => '스트립 당 행의 수',
   'SamplesPerPixel' => '구성 요소 수',
   'Saturation' => {
      Description => '채도',
      PrintConv => {
        'High' => '고채도',
        'Low' => '저채도',
        'Normal' => '표준',
      },
    },
   'ScanImageEnhancer' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'SceneAssist' => '보조 센서',
   'SceneCaptureType' => {
      Description => '장면 기록 형식',
      PrintConv => {
        'Landscape' => '풍경',
        'Night' => '야경',
        'Portrait' => '인물',
        'Standard' => '표준',
      },
    },
   'SceneMode' => {
      Description => '장면 모드',
      PrintConv => {
        '3D Sweep Panorama' => '3D',
        'Anti Motion Blur' => '인물 흔들림 방지',
        'Auto' => '자동',
        'Cont. Priority AE' => '연속 촬영 우선 AE',
        'Handheld Night Shot' => '손으로 야간 촬영',
        'Landscape' => '풍경',
        'Macro' => '매크로',
        'Manual' => '수동',
        'Night Portrait' => '야경 인물',
        'Night Scene' => '야경',
        'Night View/Portrait' => '야경/인물',
        'Off' => '꺼짐',
        'Portrait' => '인물',
        'Sports' => '스포츠 액션',
        'Standard' => '',
        'Sunset' => '석양촬영',
        'Sweep Panorama' => '스위프 파노라마',
      },
    },
   'SceneModeUsed' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'SceneType' => {
      Description => '장면 형식',
      PrintConv => {
        'Directly photographed' => '직접 촬영된 이미지',
      },
    },
   'SecurityClassification' => {
      Description => '보안 분류',
      PrintConv => {
        'Confidential' => '기밀',
        'Restricted' => '제한',
        'Secret' => '비밀',
        'Top Secret' => '1급비밀',
        'Unclassified' => '분류안됨',
      },
    },
   'SelfTimerMode' => '셀프 타이머 모드',
   'SelfTimerTime' => '셀프타이머',
   'SensingMethod' => {
      Description => '검출 방식',
      PrintConv => {
        'Color sequential area' => '색상 순차 영역 센서',
        'Color sequential linear' => '색상 순차 선형 센서',
        'Monochrome area' => '모노크롬 영역 센서',
        'Monochrome linear' => '모노크롬 선형 센서',
        'Not defined' => '정의되지 않음',
        'One-chip color area' => 'One-chip 색상 영역 센서',
        'Three-chip color area' => 'Three-chip 색상 영역 센서',
        'Trilinear' => 'Trilinear 센서',
        'Two-chip color area' => 'Two-chip 색상 영역 센서',
      },
    },
   'SensorPixelSize' => '센서 픽셀 크기',
   'SerialNumber' => '시리얼번호',
   'ShadingCompensation' => {
      Description => '주변광량 보정',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ShadingCompensation2' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ShakeReduction' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Sharpness' => {
      Description => '선명도',
      PrintConv => {
        'Hard' => '강하게',
        'Normal' => '표준',
        'Soft' => '약하게',
      },
    },
   'ShootingInfoDisplay' => {
      Description => '촬영 정보 표시',
      PrintConv => {
        'Auto' => '자동',
        'Manual (dark on light)' => '수동 - 밝은배경에 어두움',
        'Manual (light on dark)' => '수동 - 어두운 배경에 밝음',
      },
    },
   'ShootingMode' => {
      Description => '원격 리모컨',
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'ShootingModeSetting' => {
      Description => '촬영 모드',
      PrintConv => {
        'Continuous' => '연사',
        'Delayed Remote' => '촬영대기 리모컨',
        'Quick-response Remote' => '즉시촬영 리모컨',
        'Self-timer' => '셀프타이머',
        'Single Frame' => '싱글 프레임',
      },
    },
   'ShotInfoVersion' => '촬영 정보 버전',
   'ShutterCount' => '셔터 카운트',
   'ShutterMode' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'ShutterReleaseButtonAE-L' => {
      Description => '셔터 릴리즈 버튼 AE-L',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ShutterSpeed' => '노출 시간',
   'ShutterSpeedValue' => '셔터 속도',
   'SlowShutter' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'SlowSync' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'Software' => '소프트웨어',
   'Source' => '소스',
   'SpatialFrequencyResponse' => '공간 주파수 응답',
   'SpectralSensitivity' => '분광 감도',
   'State' => '도',
   'StripByteCounts' => '압축된 스트립 당 바이트',
   'StripOffsets' => '이미지 데이터 위치',
   'SubSecTime' => '일시 1/100 초',
   'SubSecTimeDigitized' => '디지털화 일시 1/100 초',
   'SubSecTimeOriginal' => '원본일시 1/100 초',
   'SubfileType' => '새로운 서브파일 형식',
   'SubjectArea' => '피사체 영역',
   'SubjectDistance' => '피사체의 거리',
   'SubjectDistanceRange' => {
      Description => '피사체 거리 한계',
      PrintConv => {
        'Close' => '근경',
        'Distant' => '원경',
        'Macro' => '매크로',
        'Unknown' => '알 수 없음',
      },
    },
   'SubjectLocation' => '피사체 위치',
   'SuperMacro' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'SuperimposedDisplay' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'SupplementalCategories' => '보충 범주',
   'TextStamp' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ThumbnailImage' => '축소 그림',
   'ThumbnailImageSize' => '갤러리 크기',
   'TimerFunctionButton' => {
      Description => 'Fn 버튼',
      PrintConv => {
        'ISO' => 'ISO 감도',
        'Image Quality/Size' => '이미지 화질/크기',
        'Self-timer' => '셀프타이머',
        'Shooting Mode' => '촬영 모드',
        'White Balance' => '화이트 밸런스',
      },
    },
   'Timezone' => '표준 시간대',
   'Title' => '제목',
   'ToneComp' => '계조 보정',
   'ToneCurve' => {
      PrintConv => {
        'Manual' => '수동',
      },
    },
   'ToningEffect' => {
      Description => '조색 효과',
      PrintConv => {
        'B&W' => '흑백',
        'Blue' => '블루',
        'Blue-green' => '블루-그린',
        'Green' => '녹색',
        'Purple-blue' => '퍼플-블루',
        'Red' => '빨강',
        'Red-purple' => '레드-퍼플',
        'Yellow' => '노랑',
        'n/a' => '설정 안됨',
      },
    },
   'ToningEffectMonochrome' => {
      PrintConv => {
        'Green' => '녹색',
      },
    },
   'ToningSaturation' => '채도 조정',
   'TransferFunction' => '전송 기능',
   'TransmissionReference' => '전송 참조',
   'Uncompressed' => '압축되지 않음',
   'Unsharp1Color' => {
      PrintConv => {
        'Green' => '녹색',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'Unsharp2Color' => {
      PrintConv => {
        'Green' => '녹색',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'Unsharp3Color' => {
      PrintConv => {
        'Green' => '녹색',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'Unsharp4Color' => {
      PrintConv => {
        'Green' => '녹색',
        'Red' => '빨강',
        'Yellow' => '노랑',
      },
    },
   'UnsharpMask' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'Urgency' => '중요도',
   'UserComment' => '사용자 코멘트',
   'VRInfo' => '손떨림 보정 정보',
   'VRInfoVersion' => 'VR 정보 버전',
   'VR_0x66' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'VariProgram' => '다중 프로그램',
   'VibrationReduction' => {
      Description => '손떨림 보정',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'ViewfinderWarning' => {
      Description => '뷰파일더 경고',
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'VignetteControl' => {
      Description => '비네팅 컨트롤',
      PrintConv => {
        'High' => '높음',
        'Low' => '낮음',
        'Normal' => '표준',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'WBBracketMode' => {
      PrintConv => {
        'Off' => '꺼짐',
      },
    },
   'WBMode' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'WhiteBalance' => {
      Description => '화이트밸런스',
      PrintConv => {
        'Auto' => '자동',
        'Black & White' => '흑백',
        'Cloudy' => '흐린날',
        'Color Temperature/Color Filter' => '색 온도 / 컬러 필터',
        'Cool White Fluorescent' => '차가운 백색 형광',
        'Custom' => '사용자 정의',
        'Custom 1' => '개인설정1',
        'Custom 2' => '개인설정2',
        'Custom 3' => '개인설정3',
        'Custom 4' => '개인설정4',
        'Day White Fluorescent' => '중성 백색 형광',
        'Daylight' => '맑은날',
        'Daylight Fluorescent' => '일광 형광',
        'Flash' => '플래시',
        'Fluorescent' => '형광등',
        'Manual' => '수동',
        'Shade' => '그늘',
        'Tungsten' => '백열등',
        'Unknown' => '알 수 없음',
        'Warm White Fluorescent' => '따뜻한 흰색 형광',
        'White Fluorescent' => '백색 형광등',
      },
    },
   'WhiteBalance2' => {
      PrintConv => {
        'Auto' => '자동',
      },
    },
   'WhiteBalanceAdj' => {
      PrintConv => {
        'Auto' => '자동',
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
   'WhiteBalanceFineTune' => '화이트밸런스 조정',
   'WhiteBalanceSet' => {
      PrintConv => {
        'Auto' => '자동',
        'Manual' => '수동',
      },
    },
   'WhitePoint' => '흰색 점 색도',
   'WorldTime' => '표준 시간대',
   'Writer-Editor' => '캡션 작성자',
   'XResolution' => '수평 해상도',
   'YCbCrCoefficients' => '색상 공간 변환 매트릭스 계수',
   'YCbCrPositioning' => {
      Description => 'Y and C 위치',
      PrintConv => {
        'Centered' => '중앙',
        'Co-sited' => '주변',
      },
    },
   'YCbCrSubSampling' => 'Y->C 서브샘플링 비율',
   'YResolution' => '수직 해상도',
   'ZoneMatching' => {
      Description => '영역 전환',
      PrintConv => {
        'High Key' => 'Hi',
        'ISO Setting Used' => '없음',
        'Low Key' => 'Lo',
      },
    },
   'ZoneMatchingOn' => {
      PrintConv => {
        'Off' => '꺼짐',
        'On' => '켜짐',
      },
    },
);

1;  # end


__END__

=head1 NAME

Image::ExifTool::Lang::ko.pm - ExifTool Korean language translations

=head1 DESCRIPTION

This file is used by Image::ExifTool to generate localized tag descriptions
and values.

=head1 AUTHOR

Copyright 2003-2011, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 ACKNOWLEDGEMENTS

Thanks to Jens Duttke and Jeong Beom Kim for providing this translation.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::TagInfoXML(3pm)|Image::ExifTool::TagInfoXML>

=cut
