##
# $Id: files_dir.rb 10377 2010-09-19 22:25:56Z egypt $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'rex/proto/http'
require 'msf/core'


class Metasploit3 < Msf::Auxiliary

	include Msf::Exploit::Remote::HttpClient
	include Msf::Auxiliary::WMAPScanDir
	include Msf::Auxiliary::Scanner
	include Msf::Auxiliary::Report

	def initialize(info = {})
		super(update_info(info,
			'Name'   		=> 'HTTP Interesting File Scanner',
			'Description'	=> %q{
				This module identifies the existence of interesting files
				in a given directory path.
			},
			'Author' 		=> [ 'et' ],
			'License'		=> BSD_LICENSE,
			'Version'		=> '$Revision: 10377 $'))

		register_options(
			[
				OptString.new('PATH', [ true,  "The path  to identify files", '/']),
				OptString.new('EXT', [ false, "Append file extension to use", '']),
				OptPath.new('DICTIONARY',   [ false, "Path of word dictionary to use",
						File.join(Msf::Config.install_root, "data", "wmap", "wmap_files.txt")
					]
				)
			], self.class)

		register_advanced_options(
			[
				OptInt.new('ErrorCode', [ true,  "The expected http code for non existant files", 404]),
				OptPath.new('HTTP404Sigs',   [ false, "Path of 404 signatures to use",
						File.join(Msf::Config.install_root, "data", "wmap", "wmap_404s.txt")
					]
				),
				OptBool.new('NoDetailMessages', [ false, "Do not display detailed test messages", true ]),
				OptInt.new('TestThreads', [ true, "Number of test threads", 25])
			], self.class)

	end

	def run_host(ip)
		conn = false

		tpath = datastore['PATH']
		if tpath[-1,1] != '/'
			tpath += '/'
		end

		nt = datastore['TestThreads'].to_i
		nt = 1 if nt == 0

		dm = datastore['NoDetailMessages']

		queue = []

		File.open(datastore['DICTIONARY'], 'rb').each do |testf|
			queue << testf.strip
		end

		#
		# Detect error code
		#
		ecode = datastore['ErrorCode'].to_i
		begin
			randfile = Rex::Text.rand_text_alpha(5).chomp

			res = send_request_cgi({
				'uri'  		=>  tpath+randfile+ datastore['EXT'],
				'method'   	=> 'GET',
				'ctype'		=> 'text/html'
			}, 20)

			return if not res

			tcode = res.code.to_i

			# Look for a string we can signature on as well
			if(tcode >= 200 and tcode <= 299)
				File.open(datastore['HTTP404Sigs'], 'rb').each do |str|
					if(res.body.index(str))
						emesg = str
						break
					end
				end

				if(not emesg)
					print_status("Using first 256 bytes of the response as 404 string")
					emesg = res.body[0,256]
				else
					print_status("Using custom 404 string of '#{emesg}'")
				end
			else
				ecode = tcode
				print_status("Using code '#{ecode}' as not found.")
			end

		rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout
			conn = false
		rescue ::Timeout::Error, ::Errno::EPIPE
		end


		while(not queue.empty?)
			t = []
			1.upto(nt) do
				t << Thread.new(queue.shift) do |testf|
					Thread.current.kill if not testf

					testfext = testf.chomp + datastore['EXT']
					res = send_request_cgi({
						'uri'  		=>  tpath+testfext,
						'method'   	=> 'GET',
						'ctype'		=> 'text/plain'
					}, 20)

					if(not res or ((res.code.to_i == ecode) or (emesg and res.body.index(emesg))))
						if dm == false
							print_status("NOT Found #{wmap_base_url}#{tpath}#{testfext}  #{res.code.to_i}")
							#blah
						end
					else
						if res.code.to_i == 400  and ecode != 400
							print_error("Server returned an error code. #{wmap_base_url}#{tpath}#{testfext} #{res.code.to_i}")
						else
							print_status("Found #{wmap_base_url}#{tpath}#{testfext} #{res.code.to_i}")

							report_note(
								:host	=> ip,
								:proto	=> (ssl ? 'https' : 'http'),
								:port	=> rport,
								:type	=> 'FILE',
								:data	=> "#{tpath}#{testfext} Code: #{res.code}",
								:update => :unique_data
							)

						end
					end
				end
			end
			t.map{|x| x.join }
		end
	end
end
